/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

public class ContentProviderResult
implements Parcelable {
    public final Uri uri;
    public final Integer count;
    public final String failure;
    public static final Parcelable.Creator<ContentProviderResult> CREATOR = new Parcelable.Creator<ContentProviderResult>(){

        @Override
        public ContentProviderResult createFromParcel(Parcel source) {
            return new ContentProviderResult(source);
        }

        public ContentProviderResult[] newArray(int size) {
            return new ContentProviderResult[size];
        }
    };

    public ContentProviderResult(Uri uri) {
        this(Preconditions.checkNotNull(uri), null, null);
    }

    public ContentProviderResult(int count) {
        this(null, count, null);
    }

    public ContentProviderResult(String failure) {
        this(null, null, failure);
    }

    public ContentProviderResult(Uri uri, Integer count, String failure) {
        this.uri = uri;
        this.count = count;
        this.failure = failure;
    }

    public ContentProviderResult(Parcel source) {
        this.uri = source.readInt() != 0 ? Uri.CREATOR.createFromParcel(source) : null;
        this.count = source.readInt() != 0 ? Integer.valueOf(source.readInt()) : null;
        this.failure = source.readInt() != 0 ? source.readString() : null;
    }

    public ContentProviderResult(ContentProviderResult cpr, int userId) {
        this.uri = ContentProvider.maybeAddUserId(cpr.uri, userId);
        this.count = cpr.count;
        this.failure = cpr.failure;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.uri != null) {
            dest.writeInt(1);
            this.uri.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        if (this.count != null) {
            dest.writeInt(1);
            dest.writeInt(this.count);
        } else {
            dest.writeInt(0);
        }
        if (this.failure != null) {
            dest.writeInt(1);
            dest.writeString(this.failure);
        } else {
            dest.writeInt(0);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ContentProviderResult(");
        if (this.uri != null) {
            sb.append("uri=" + this.uri + " ");
        }
        if (this.count != null) {
            sb.append("count=" + this.count + " ");
        }
        if (this.uri != null) {
            sb.append("failure=" + this.failure + " ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }
}

