/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.UnsupportedAppUsage;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Annotation;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.LineHeightSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.create.OverrideMethod;

class StringBlock {
    private static final String TAG = "AssetManager";
    private static final boolean localLOGV = false;
    private final long mNative;
    private final boolean mUseSparse;
    private final boolean mOwnsNative;
    private CharSequence[] mStrings;
    private SparseArray<CharSequence> mSparseStrings;
    @GuardedBy(value={"this"})
    private boolean mOpen = true;
    StyleIDs mStyleIDs = null;

    public StringBlock(byte[] data, boolean useSparse) {
        this.mNative = StringBlock.nativeCreate(data, 0, data.length);
        this.mUseSparse = useSparse;
        this.mOwnsNative = true;
    }

    public StringBlock(byte[] data, int offset, int size, boolean useSparse) {
        this.mNative = StringBlock.nativeCreate(data, offset, size);
        this.mUseSparse = useSparse;
        this.mOwnsNative = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public CharSequence get(int idx) {
        StringBlock stringBlock = this;
        synchronized (stringBlock) {
            String str;
            if (this.mStrings != null) {
                CharSequence res = this.mStrings[idx];
                if (res != null) {
                    return res;
                }
            } else if (this.mSparseStrings != null) {
                CharSequence res = this.mSparseStrings.get(idx);
                if (res != null) {
                    return res;
                }
            } else {
                int num = StringBlock.nativeGetSize(this.mNative);
                if (this.mUseSparse && num > 250) {
                    this.mSparseStrings = new SparseArray();
                } else {
                    this.mStrings = new CharSequence[num];
                }
            }
            CharSequence res = str = StringBlock.nativeGetString(this.mNative, idx);
            int[] style2 = StringBlock.nativeGetStyle(this.mNative, idx);
            if (style2 != null) {
                if (this.mStyleIDs == null) {
                    this.mStyleIDs = new StyleIDs();
                }
                for (int styleIndex = 0; styleIndex < style2.length; styleIndex += 3) {
                    int styleId = style2[styleIndex];
                    if (styleId == this.mStyleIDs.boldId || styleId == this.mStyleIDs.italicId || styleId == this.mStyleIDs.underlineId || styleId == this.mStyleIDs.ttId || styleId == this.mStyleIDs.bigId || styleId == this.mStyleIDs.smallId || styleId == this.mStyleIDs.subId || styleId == this.mStyleIDs.supId || styleId == this.mStyleIDs.strikeId || styleId == this.mStyleIDs.listItemId || styleId == this.mStyleIDs.marqueeId) continue;
                    String styleTag = StringBlock.nativeGetString(this.mNative, styleId);
                    if (styleTag.equals("b")) {
                        this.mStyleIDs.boldId = styleId;
                        continue;
                    }
                    if (styleTag.equals("i")) {
                        this.mStyleIDs.italicId = styleId;
                        continue;
                    }
                    if (styleTag.equals("u")) {
                        this.mStyleIDs.underlineId = styleId;
                        continue;
                    }
                    if (styleTag.equals("tt")) {
                        this.mStyleIDs.ttId = styleId;
                        continue;
                    }
                    if (styleTag.equals("big")) {
                        this.mStyleIDs.bigId = styleId;
                        continue;
                    }
                    if (styleTag.equals("small")) {
                        this.mStyleIDs.smallId = styleId;
                        continue;
                    }
                    if (styleTag.equals("sup")) {
                        this.mStyleIDs.supId = styleId;
                        continue;
                    }
                    if (styleTag.equals("sub")) {
                        this.mStyleIDs.subId = styleId;
                        continue;
                    }
                    if (styleTag.equals("strike")) {
                        this.mStyleIDs.strikeId = styleId;
                        continue;
                    }
                    if (styleTag.equals("li")) {
                        this.mStyleIDs.listItemId = styleId;
                        continue;
                    }
                    if (!styleTag.equals("marquee")) continue;
                    this.mStyleIDs.marqueeId = styleId;
                }
                res = this.applyStyles(str, style2, this.mStyleIDs);
            }
            if (this.mStrings != null) {
                this.mStrings[idx] = res;
            } else {
                this.mSparseStrings.put(idx, res);
            }
            return res;
        }
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Throwable {
        StringBlock stringBlock = this;
        synchronized (stringBlock) {
            if (this.mOpen) {
                this.mOpen = false;
                if (this.mOwnsNative) {
                    StringBlock.nativeDestroy(this.mNative);
                }
            }
        }
    }

    private CharSequence applyStyles(String str, int[] style2, StyleIDs ids) {
        if (style2.length == 0) {
            return str;
        }
        SpannableString buffer = new SpannableString(str);
        for (int i = 0; i < style2.length; i += 3) {
            int eq;
            int type = style2[i];
            if (type == ids.boldId) {
                buffer.setSpan(new StyleSpan(1), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.italicId) {
                buffer.setSpan(new StyleSpan(2), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.underlineId) {
                buffer.setSpan(new UnderlineSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.ttId) {
                buffer.setSpan(new TypefaceSpan("monospace"), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.bigId) {
                buffer.setSpan(new RelativeSizeSpan(1.25f), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.smallId) {
                buffer.setSpan(new RelativeSizeSpan(0.8f), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.subId) {
                buffer.setSpan(new SubscriptSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.supId) {
                buffer.setSpan(new SuperscriptSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.strikeId) {
                buffer.setSpan(new StrikethroughSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.listItemId) {
                StringBlock.addParagraphSpan(buffer, new BulletSpan(10), style2[i + 1], style2[i + 2] + 1);
                continue;
            }
            if (type == ids.marqueeId) {
                buffer.setSpan((Object)TextUtils.TruncateAt.MARQUEE, style2[i + 1], style2[i + 2] + 1, 18);
                continue;
            }
            String tag = StringBlock.nativeGetString(this.mNative, type);
            if (tag.startsWith("font;")) {
                int size;
                String sub = StringBlock.subtag(tag, ";height=");
                if (sub != null) {
                    size = Integer.parseInt(sub);
                    StringBlock.addParagraphSpan(buffer, new Height(size), style2[i + 1], style2[i + 2] + 1);
                }
                if ((sub = StringBlock.subtag(tag, ";size=")) != null) {
                    size = Integer.parseInt(sub);
                    buffer.setSpan(new AbsoluteSizeSpan(size, true), style2[i + 1], style2[i + 2] + 1, 33);
                }
                if ((sub = StringBlock.subtag(tag, ";fgcolor=")) != null) {
                    buffer.setSpan(StringBlock.getColor(sub, true), style2[i + 1], style2[i + 2] + 1, 33);
                }
                if ((sub = StringBlock.subtag(tag, ";color=")) != null) {
                    buffer.setSpan(StringBlock.getColor(sub, true), style2[i + 1], style2[i + 2] + 1, 33);
                }
                if ((sub = StringBlock.subtag(tag, ";bgcolor=")) != null) {
                    buffer.setSpan(StringBlock.getColor(sub, false), style2[i + 1], style2[i + 2] + 1, 33);
                }
                if ((sub = StringBlock.subtag(tag, ";face=")) == null) continue;
                buffer.setSpan(new TypefaceSpan(sub), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (tag.startsWith("a;")) {
                String sub = StringBlock.subtag(tag, ";href=");
                if (sub == null) continue;
                buffer.setSpan(new URLSpan(sub), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (!tag.startsWith("annotation;")) continue;
            int len = tag.length();
            int t = tag.indexOf(59);
            while (t < len && (eq = tag.indexOf(61, t)) >= 0) {
                int next = tag.indexOf(59, eq);
                if (next < 0) {
                    next = len;
                }
                String key = tag.substring(t + 1, eq);
                String value = tag.substring(eq + 1, next);
                buffer.setSpan(new Annotation(key, value), style2[i + 1], style2[i + 2] + 1, 33);
                t = next;
            }
        }
        return new SpannedString(buffer);
    }

    private static CharacterStyle getColor(String color2, boolean foreground) {
        int c = -16777216;
        if (!TextUtils.isEmpty(color2)) {
            if (color2.startsWith("@")) {
                String name;
                Resources res = Resources.getSystem();
                int colorRes = res.getIdentifier(name = color2.substring(1), "color", "android");
                if (colorRes != 0) {
                    ColorStateList colors = res.getColorStateList(colorRes, null);
                    if (foreground) {
                        return new TextAppearanceSpan(null, 0, 0, colors, null);
                    }
                    c = colors.getDefaultColor();
                }
            } else {
                try {
                    c = Color.parseColor(color2);
                }
                catch (IllegalArgumentException e) {
                    c = -16777216;
                }
            }
        }
        if (foreground) {
            return new ForegroundColorSpan(c);
        }
        return new BackgroundColorSpan(c);
    }

    private static void addParagraphSpan(Spannable buffer, Object what, int start, int end) {
        int len = buffer.length();
        if (start != 0 && start != len && buffer.charAt(start - 1) != '\n') {
            --start;
            while (start > 0 && buffer.charAt(start - 1) != '\n') {
                --start;
            }
        }
        if (end != 0 && end != len && buffer.charAt(end - 1) != '\n') {
            ++end;
            while (end < len && buffer.charAt(end - 1) != '\n') {
                ++end;
            }
        }
        buffer.setSpan(what, start, end, 51);
    }

    private static String subtag(String full, String attribute) {
        int start = full.indexOf(attribute);
        if (start < 0) {
            return null;
        }
        int end = full.indexOf(59, start += attribute.length());
        if (end < 0) {
            return full.substring(start);
        }
        return full.substring(start, end);
    }

    @UnsupportedAppUsage
    StringBlock(long obj, boolean useSparse) {
        this.mNative = obj;
        this.mUseSparse = useSparse;
        this.mOwnsNative = false;
    }

    private static long nativeCreate(byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeL("android.content.res.StringBlock#nativeCreate([BII)J", true, null);
    }

    private static int nativeGetSize(long l) {
        return OverrideMethod.invokeI("android.content.res.StringBlock#nativeGetSize(J)I", true, null);
    }

    private static String nativeGetString(long l, int n) {
        return (String)OverrideMethod.invokeA("android.content.res.StringBlock#nativeGetString(JI)Ljava/lang/String;", true, null);
    }

    private static int[] nativeGetStyle(long l, int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.StringBlock#nativeGetStyle(JI)[I", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.content.res.StringBlock#nativeDestroy(J)V", true, null);
    }

    private static class Height
    implements LineHeightSpan.WithDensity {
        private int mSize;
        private static float sProportion = 0.0f;

        public Height(int size) {
            this.mSize = size;
        }

        @Override
        public void chooseHeight(CharSequence text, int start, int end, int spanstartv, int v, Paint.FontMetricsInt fm) {
            this.chooseHeight(text, start, end, spanstartv, v, fm, null);
        }

        @Override
        public void chooseHeight(CharSequence text, int start, int end, int spanstartv, int v, Paint.FontMetricsInt fm, TextPaint paint) {
            int size = this.mSize;
            if (paint != null) {
                size = (int)((float)size * paint.density);
            }
            if (fm.bottom - fm.top < size) {
                fm.top = fm.bottom - size;
                fm.ascent -= size;
            } else {
                int need;
                if (sProportion == 0.0f) {
                    Paint p = new Paint();
                    p.setTextSize(100.0f);
                    Rect r = new Rect();
                    p.getTextBounds("ABCDEFG", 0, 7, r);
                    sProportion = (float)r.top / p.ascent();
                }
                if (size - fm.descent >= (need = (int)Math.ceil((float)(-fm.top) * sProportion))) {
                    fm.top = fm.bottom - size;
                    fm.ascent = fm.descent - size;
                } else if (size >= need) {
                    fm.top = fm.ascent = -need;
                    fm.bottom = fm.descent = fm.top + size;
                } else {
                    fm.top = fm.ascent = -size;
                    fm.descent = 0;
                    fm.bottom = 0;
                }
            }
        }
    }

    static class StyleIDs {
        private int boldId = -1;
        private int italicId = -1;
        private int underlineId = -1;
        private int ttId = -1;
        private int bigId = -1;
        private int smallId = -1;
        private int subId = -1;
        private int supId = -1;
        private int strikeId = -1;
        private int listItemId = -1;
        private int marqueeId = -1;

        StyleIDs() {
        }
    }
}

