/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.UnsupportedAppUsage;
import android.content.res.Resources;
import android.util.ArrayMap;
import android.util.LongSparseArray;
import java.lang.ref.WeakReference;

abstract class ThemedResourceCache<T> {
    @UnsupportedAppUsage
    private ArrayMap<Resources.ThemeKey, LongSparseArray<WeakReference<T>>> mThemedEntries;
    private LongSparseArray<WeakReference<T>> mUnthemedEntries;
    private LongSparseArray<WeakReference<T>> mNullThemedEntries;

    ThemedResourceCache() {
    }

    public void put(long key, Resources.Theme theme, T entry) {
        this.put(key, theme, entry, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long key, Resources.Theme theme, T entry, boolean usesTheme) {
        if (entry == null) {
            return;
        }
        ThemedResourceCache themedResourceCache = this;
        synchronized (themedResourceCache) {
            LongSparseArray<WeakReference<T>> entries = !usesTheme ? this.getUnthemedLocked(true) : this.getThemedLocked(theme, true);
            if (entries != null) {
                entries.put(key, new WeakReference<T>(entry));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long key, Resources.Theme theme) {
        ThemedResourceCache themedResourceCache = this;
        synchronized (themedResourceCache) {
            WeakReference<T> unthemedEntry;
            WeakReference<T> themedEntry;
            LongSparseArray<WeakReference<T>> themedEntries = this.getThemedLocked(theme, false);
            if (themedEntries != null && (themedEntry = themedEntries.get(key)) != null) {
                return themedEntry.get();
            }
            LongSparseArray<WeakReference<T>> unthemedEntries = this.getUnthemedLocked(false);
            if (unthemedEntries != null && (unthemedEntry = unthemedEntries.get(key)) != null) {
                return unthemedEntry.get();
            }
        }
        return null;
    }

    @UnsupportedAppUsage
    public void onConfigurationChange(int configChanges) {
        this.prune(configChanges);
    }

    protected abstract boolean shouldInvalidateEntry(T var1, int var2);

    private LongSparseArray<WeakReference<T>> getThemedLocked(Resources.Theme t, boolean create) {
        Resources.ThemeKey key;
        LongSparseArray<WeakReference<Object>> cache;
        if (t == null) {
            if (this.mNullThemedEntries == null && create) {
                this.mNullThemedEntries = new LongSparseArray(1);
            }
            return this.mNullThemedEntries;
        }
        if (this.mThemedEntries == null) {
            if (create) {
                this.mThemedEntries = new ArrayMap(1);
            } else {
                return null;
            }
        }
        if ((cache = this.mThemedEntries.get(key = t.getKey())) == null && create) {
            cache = new LongSparseArray(1);
            Resources.ThemeKey keyClone = key.clone();
            this.mThemedEntries.put(keyClone, cache);
        }
        return cache;
    }

    private LongSparseArray<WeakReference<T>> getUnthemedLocked(boolean create) {
        if (this.mUnthemedEntries == null && create) {
            this.mUnthemedEntries = new LongSparseArray(1);
        }
        return this.mUnthemedEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prune(int configChanges) {
        ThemedResourceCache themedResourceCache = this;
        synchronized (themedResourceCache) {
            if (this.mThemedEntries != null) {
                for (int i = this.mThemedEntries.size() - 1; i >= 0; --i) {
                    if (!this.pruneEntriesLocked(this.mThemedEntries.valueAt(i), configChanges)) continue;
                    this.mThemedEntries.removeAt(i);
                }
            }
            this.pruneEntriesLocked(this.mNullThemedEntries, configChanges);
            this.pruneEntriesLocked(this.mUnthemedEntries, configChanges);
            return this.mThemedEntries == null && this.mNullThemedEntries == null && this.mUnthemedEntries == null;
        }
    }

    private boolean pruneEntriesLocked(LongSparseArray<WeakReference<T>> entries, int configChanges) {
        if (entries == null) {
            return true;
        }
        for (int i = entries.size() - 1; i >= 0; --i) {
            WeakReference<T> ref = entries.valueAt(i);
            if (ref != null && !this.pruneEntryLocked(ref.get(), configChanges)) continue;
            entries.removeAt(i);
        }
        return entries.size() == 0;
    }

    private boolean pruneEntryLocked(T entry, int configChanges) {
        return entry == null || configChanges != 0 && this.shouldInvalidateEntry(entry, configChanges);
    }
}

