/*
 * Decompiled with CFR 0.152.
 */
package android.content.rollback;

import android.annotation.SystemApi;
import android.content.pm.VersionedPackage;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.IntArray;
import android.util.SparseLongArray;
import java.util.ArrayList;

@SystemApi
public class PackageRollbackInfo
implements Parcelable {
    private final VersionedPackage mVersionRolledBackFrom;
    private final VersionedPackage mVersionRolledBackTo;
    private final IntArray mPendingBackups;
    private final ArrayList<RestoreInfo> mPendingRestores;
    private final boolean mIsApex;
    private final IntArray mInstalledUsers;
    private final SparseLongArray mCeSnapshotInodes;
    public static final Parcelable.Creator<PackageRollbackInfo> CREATOR = new Parcelable.Creator<PackageRollbackInfo>(){

        @Override
        public PackageRollbackInfo createFromParcel(Parcel in) {
            return new PackageRollbackInfo(in);
        }

        public PackageRollbackInfo[] newArray(int size) {
            return new PackageRollbackInfo[size];
        }
    };

    public String getPackageName() {
        return this.mVersionRolledBackFrom.getPackageName();
    }

    public VersionedPackage getVersionRolledBackFrom() {
        return this.mVersionRolledBackFrom;
    }

    public VersionedPackage getVersionRolledBackTo() {
        return this.mVersionRolledBackTo;
    }

    public void addPendingBackup(int userId) {
        this.mPendingBackups.add(userId);
    }

    public IntArray getPendingBackups() {
        return this.mPendingBackups;
    }

    public ArrayList<RestoreInfo> getPendingRestores() {
        return this.mPendingRestores;
    }

    public RestoreInfo getRestoreInfo(int userId) {
        for (RestoreInfo ri : this.mPendingRestores) {
            if (ri.userId != userId) continue;
            return ri;
        }
        return null;
    }

    public void removeRestoreInfo(RestoreInfo ri) {
        this.mPendingRestores.remove(ri);
    }

    public boolean isApex() {
        return this.mIsApex;
    }

    public IntArray getInstalledUsers() {
        return this.mInstalledUsers;
    }

    public SparseLongArray getCeSnapshotInodes() {
        return this.mCeSnapshotInodes;
    }

    public void putCeSnapshotInode(int userId, long ceSnapshotInode) {
        this.mCeSnapshotInodes.put(userId, ceSnapshotInode);
    }

    public void removePendingBackup(int userId) {
        int idx = this.mPendingBackups.indexOf(userId);
        if (idx != -1) {
            this.mPendingBackups.remove(idx);
        }
    }

    public void removePendingRestoreInfo(int userId) {
        this.removeRestoreInfo(this.getRestoreInfo(userId));
    }

    public PackageRollbackInfo(VersionedPackage packageRolledBackFrom, VersionedPackage packageRolledBackTo, IntArray pendingBackups, ArrayList<RestoreInfo> pendingRestores, boolean isApex, IntArray installedUsers, SparseLongArray ceSnapshotInodes) {
        this.mVersionRolledBackFrom = packageRolledBackFrom;
        this.mVersionRolledBackTo = packageRolledBackTo;
        this.mPendingBackups = pendingBackups;
        this.mPendingRestores = pendingRestores;
        this.mIsApex = isApex;
        this.mInstalledUsers = installedUsers;
        this.mCeSnapshotInodes = ceSnapshotInodes;
    }

    private PackageRollbackInfo(Parcel in) {
        this.mVersionRolledBackFrom = VersionedPackage.CREATOR.createFromParcel(in);
        this.mVersionRolledBackTo = VersionedPackage.CREATOR.createFromParcel(in);
        this.mIsApex = in.readBoolean();
        this.mPendingRestores = null;
        this.mPendingBackups = null;
        this.mInstalledUsers = null;
        this.mCeSnapshotInodes = null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.mVersionRolledBackFrom.writeToParcel(out, flags);
        this.mVersionRolledBackTo.writeToParcel(out, flags);
        out.writeBoolean(this.mIsApex);
    }

    public static class RestoreInfo {
        public final int userId;
        public final int appId;
        public final String seInfo;

        public RestoreInfo(int userId, int appId, String seInfo) {
            this.userId = userId;
            this.appId = appId;
            this.seInfo = seInfo;
        }
    }
}

