/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Bitmap_Delegate;
import android.graphics.NinePatch_Delegate;
import android.graphics.Rect;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.util.NinePatchInputStream;
import com.android.ninepatch.NinePatch;
import com.android.ninepatch.NinePatchChunk;
import com.android.resources.Density;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;

class BitmapFactory_Delegate {
    BitmapFactory_Delegate() {
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeStream(InputStream is, byte[] storage, Rect padding, BitmapFactory.Options opts, long inBitmapHandle, long colorSpaceHandle) {
        Bitmap bm = null;
        Density density = Density.MEDIUM;
        EnumSet<Bitmap_Delegate.BitmapCreateFlags> bitmapCreateFlags = EnumSet.of(Bitmap_Delegate.BitmapCreateFlags.MUTABLE);
        if (opts != null) {
            density = Density.getEnum((int)opts.inDensity);
            if (opts.inPremultiplied) {
                bitmapCreateFlags.add(Bitmap_Delegate.BitmapCreateFlags.PREMULTIPLIED);
            }
            opts.inScaled = false;
        }
        try {
            if (is instanceof NinePatchInputStream) {
                NinePatchInputStream npis = (NinePatchInputStream)is;
                npis.disableFakeMarkSupport();
                NinePatch ninePatch = NinePatch.load(npis, true, false);
                bm = Bitmap_Delegate.createBitmap(ninePatch.getImage(), bitmapCreateFlags, density);
                NinePatchChunk chunk = ninePatch.getChunk();
                bm.setNinePatchChunk(NinePatch_Delegate.serialize(chunk));
                if (padding != null) {
                    int[] paddingArray = chunk.getPadding();
                    padding.left = paddingArray[0];
                    padding.top = paddingArray[1];
                    padding.right = paddingArray[2];
                    padding.bottom = paddingArray[3];
                }
            } else {
                bm = Bitmap_Delegate.createBitmap(is, bitmapCreateFlags, density);
            }
        }
        catch (IOException e) {
            Bridge.getLog().error(null, "Failed to load image", (Throwable)e, null);
        }
        return bm;
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeFileDescriptor(FileDescriptor fd, Rect padding, BitmapFactory.Options opts, long inBitmapHandle, long colorSpaceHandle) {
        if (opts != null) {
            opts.inBitmap = null;
        }
        return null;
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeAsset(long asset, Rect padding, BitmapFactory.Options opts, long inBitmapHandle, long colorSpaceHandle) {
        if (opts != null) {
            opts.inBitmap = null;
        }
        return null;
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeByteArray(byte[] data, int offset, int length, BitmapFactory.Options opts, long inBitmapHandle, long colorSpaceHandle) {
        if (opts != null) {
            opts.inBitmap = null;
        }
        return null;
    }

    @LayoutlibDelegate
    static boolean nativeIsSeekable(FileDescriptor fd) {
        return true;
    }

    @LayoutlibDelegate
    static void setDensityFromOptions(Bitmap outputBitmap, BitmapFactory.Options opts) {
        if (outputBitmap == null || opts == null) {
            return;
        }
        int density = opts.inDensity;
        if (density != 0) {
            outputBitmap.setDensity(density);
            int targetDensity = opts.inTargetDensity;
            if (targetDensity == 0 || density == targetDensity || density == opts.inScreenDensity) {
                return;
            }
            if (opts.inScaled) {
                outputBitmap.setDensity(targetDensity);
            }
        } else if (opts.inBitmap != null) {
            outputBitmap.setDensity(Bitmap.getDefaultDensity());
        }
    }
}

