/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.graphics.text.LineWidth;
import android.graphics.text.Primitive;
import android.graphics.text.TabStops;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseLineBreaker {
    protected static final int TAB_MASK = 0x20000000;
    protected final List<Primitive> mPrimitives;
    protected final LineWidth mLineWidth;
    protected final TabStops mTabStops;

    public BaseLineBreaker(List<Primitive> primitives, LineWidth lineWidth, TabStops tabStops) {
        this.mPrimitives = Collections.unmodifiableList(primitives);
        this.mLineWidth = lineWidth;
        this.mTabStops = tabStops;
    }

    public abstract Result computeBreaks();

    public static class Result {
        List<Integer> mLineBreakOffset = new ArrayList<Integer>();
        List<Float> mLineWidths = new ArrayList<Float>();
        List<Float> mLineAscents = new ArrayList<Float>();
        List<Float> mLineDescents = new ArrayList<Float>();
        List<Integer> mLineFlags = new ArrayList<Integer>();
    }
}

