/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.graphics.text.BaseLineBreaker;
import android.graphics.text.LineWidth;
import android.graphics.text.Primitive;
import android.graphics.text.TabStops;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class OptimizingLineBreaker
extends BaseLineBreaker {
    public OptimizingLineBreaker(List<Primitive> primitives, LineWidth lineWidth, TabStops tabStops) {
        super(primitives, lineWidth, tabStops);
    }

    @Override
    public BaseLineBreaker.Result computeBreaks() {
        BaseLineBreaker.Result result = new BaseLineBreaker.Result();
        int numBreaks = this.mPrimitives.size();
        assert (numBreaks > 0);
        if (numBreaks == 1) {
            Primitive p = (Primitive)this.mPrimitives.get(0);
            assert (p.type == Primitive.PrimitiveType.PENALTY);
            result.mLineBreakOffset.add(0);
            result.mLineWidths.add(Float.valueOf(p.width));
            result.mLineAscents.add(Float.valueOf(0.0f));
            result.mLineDescents.add(Float.valueOf(0.0f));
            result.mLineFlags.add(0);
            return result;
        }
        Node[] opt = new Node[numBreaks];
        opt[0] = new Node(-1, 0, 0.0f, 0.0f, false);
        opt[numBreaks - 1] = new Node(-1, 0, 0.0f, 0.0f, false);
        ArrayList<Integer> active = new ArrayList<Integer>();
        active.add(0);
        int lastBreak = 0;
        for (int i = 0; i < numBreaks; ++i) {
            Primitive p = (Primitive)this.mPrimitives.get(i);
            if (p.type != Primitive.PrimitiveType.PENALTY) continue;
            boolean finalBreak = i + 1 == numBreaks;
            Node bestBreak = null;
            ListIterator it = active.listIterator();
            while (it.hasNext()) {
                int pos = (Integer)it.next();
                int lines = opt[pos].mPrevCount;
                float maxWidth = this.mLineWidth.getLineWidth(lines);
                LineMetrics lineMetrics = this.computeMetrics(pos, i);
                if (lineMetrics.mPrintedWidth <= maxWidth) {
                    float demerits = OptimizingLineBreaker.computeDemerits(maxWidth, lineMetrics.mPrintedWidth, finalBreak, p.penalty) + opt[pos].mDemerits;
                    if (bestBreak != null && !(demerits < bestBreak.mDemerits)) continue;
                    if (bestBreak == null) {
                        bestBreak = new Node(pos, opt[pos].mPrevCount + 1, demerits, lineMetrics.mPrintedWidth, lineMetrics.mHasTabs);
                        continue;
                    }
                    bestBreak.mPrev = pos;
                    bestBreak.mPrevCount = opt[pos].mPrevCount + 1;
                    bestBreak.mDemerits = demerits;
                    bestBreak.mWidth = lineMetrics.mPrintedWidth;
                    bestBreak.mHasTabs = lineMetrics.mHasTabs;
                    continue;
                }
                it.remove();
            }
            if (p.penalty == -1.0E7f) {
                active.clear();
            }
            if (bestBreak != null) {
                opt[i] = bestBreak;
                active.add(i);
                lastBreak = i;
            }
            if (!active.isEmpty()) continue;
            LineMetrics lineMetrics = new LineMetrics();
            int lines = opt[lastBreak].mPrevCount;
            float maxWidth = this.mLineWidth.getLineWidth(lines);
            int breakIndex = this.desperateBreak(lastBreak, numBreaks, maxWidth, lineMetrics);
            opt[breakIndex] = new Node(lastBreak, lines + 1, 0.0f, lineMetrics.mWidth, lineMetrics.mHasTabs);
            active.add(breakIndex);
            lastBreak = breakIndex;
            i = breakIndex;
        }
        int idx = numBreaks - 1;
        while (opt[idx].mPrev != -1) {
            result.mLineBreakOffset.add(((Primitive)this.mPrimitives.get((int)idx)).location);
            result.mLineWidths.add(Float.valueOf(opt[idx].mWidth));
            result.mLineAscents.add(Float.valueOf(0.0f));
            result.mLineDescents.add(Float.valueOf(0.0f));
            result.mLineFlags.add(opt[idx].mHasTabs ? 0x20000000 : 0);
            idx = opt[idx].mPrev;
        }
        Collections.reverse(result.mLineBreakOffset);
        Collections.reverse(result.mLineWidths);
        Collections.reverse(result.mLineAscents);
        Collections.reverse(result.mLineDescents);
        Collections.reverse(result.mLineFlags);
        return result;
    }

    private LineMetrics computeMetrics(int start, int end) {
        boolean f = false;
        float w = 0.0f;
        float pw = 0.0f;
        for (int i = start; i < end; ++i) {
            Primitive p = (Primitive)this.mPrimitives.get(i);
            if (p.type == Primitive.PrimitiveType.BOX || p.type == Primitive.PrimitiveType.GLUE) {
                w += p.width;
                if (p.type != Primitive.PrimitiveType.BOX) continue;
                pw = w;
                continue;
            }
            if (p.type != Primitive.PrimitiveType.VARIABLE) continue;
            w = this.mTabStops.width(w);
            f = true;
        }
        return new LineMetrics(w, pw, f);
    }

    private static float computeDemerits(float maxWidth, float width, boolean finalBreak, float penalty) {
        float deviation = finalBreak ? 0.0f : maxWidth - width;
        return deviation * deviation + penalty;
    }

    private int desperateBreak(int start, int limit, float maxWidth, LineMetrics lineMetrics) {
        float w = 0.0f;
        float pw = 0.0f;
        boolean breakFound = false;
        int breakIndex = 0;
        int firstTabIndex = Integer.MAX_VALUE;
        for (int i = start; i < limit; ++i) {
            Primitive p = (Primitive)this.mPrimitives.get(i);
            if (p.type == Primitive.PrimitiveType.BOX || p.type == Primitive.PrimitiveType.GLUE) {
                w += p.width;
                if (p.type == Primitive.PrimitiveType.BOX) {
                    pw = w;
                }
            } else if (p.type == Primitive.PrimitiveType.VARIABLE) {
                w = this.mTabStops.width(w);
                firstTabIndex = Math.min(firstTabIndex, i);
            }
            if (pw > maxWidth && breakFound) break;
            if (i <= start || p.type != Primitive.PrimitiveType.PENALTY && p.type != Primitive.PrimitiveType.WORD_BREAK) continue;
            breakFound = true;
            breakIndex = i;
        }
        if (breakFound) {
            lineMetrics.mWidth = w;
            lineMetrics.mPrintedWidth = pw;
            lineMetrics.mHasTabs = start <= firstTabIndex && firstTabIndex < breakIndex;
            return breakIndex;
        }
        return -1;
    }

    private static class Node {
        int mPrev;
        int mPrevCount;
        float mDemerits;
        float mWidth;
        boolean mHasTabs;

        public Node(int prev, int prevCount, float demerits, float width, boolean hasTabs) {
            this.mPrev = prev;
            this.mPrevCount = prevCount;
            this.mDemerits = demerits;
            this.mWidth = width;
            this.mHasTabs = hasTabs;
        }
    }

    private static class LineMetrics {
        float mWidth;
        float mPrintedWidth;
        boolean mHasTabs;

        public LineMetrics() {
        }

        public LineMetrics(float width, float printedWidth, boolean hasTabs) {
            this.mWidth = width;
            this.mPrintedWidth = printedWidth;
            this.mHasTabs = hasTabs;
        }
    }
}

