/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.annotation.UnsupportedAppUsage;
import android.graphics.GraphicBuffer;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;

public class HardwareBuffer
implements Parcelable,
AutoCloseable {
    public static final int RGBA_8888 = 1;
    public static final int RGBX_8888 = 2;
    public static final int RGB_888 = 3;
    public static final int RGB_565 = 4;
    public static final int RGBA_FP16 = 22;
    public static final int RGBA_1010102 = 43;
    public static final int BLOB = 33;
    public static final int D_16 = 48;
    public static final int D_24 = 49;
    public static final int DS_24UI8 = 50;
    public static final int D_FP32 = 51;
    public static final int DS_FP32UI8 = 52;
    public static final int S_UI8 = 53;
    @UnsupportedAppUsage
    private long mNativeObject;
    private Runnable mCleaner;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    public static final long USAGE_CPU_READ_RARELY = 2L;
    public static final long USAGE_CPU_READ_OFTEN = 3L;
    public static final long USAGE_CPU_WRITE_RARELY = 32L;
    public static final long USAGE_CPU_WRITE_OFTEN = 48L;
    public static final long USAGE_GPU_SAMPLED_IMAGE = 256L;
    public static final long USAGE_GPU_COLOR_OUTPUT = 512L;
    public static final long USAGE_PROTECTED_CONTENT = 16384L;
    public static final long USAGE_VIDEO_ENCODE = 65536L;
    public static final long USAGE_SENSOR_DIRECT_DATA = 0x800000L;
    public static final long USAGE_GPU_DATA_BUFFER = 0x1000000L;
    public static final long USAGE_GPU_CUBE_MAP = 0x2000000L;
    public static final long USAGE_GPU_MIPMAP_COMPLETE = 0x4000000L;
    private static final long NATIVE_HARDWARE_BUFFER_SIZE = 232L;
    public static final Parcelable.Creator<HardwareBuffer> CREATOR = new Parcelable.Creator<HardwareBuffer>(){

        @Override
        public HardwareBuffer createFromParcel(Parcel in) {
            long nativeObject = HardwareBuffer.nReadHardwareBufferFromParcel(in);
            if (nativeObject != 0L) {
                return new HardwareBuffer(nativeObject);
            }
            return null;
        }

        public HardwareBuffer[] newArray(int size) {
            return new HardwareBuffer[size];
        }
    };

    public static HardwareBuffer create(int width, int height, int format, int layers, long usage) {
        if (!HardwareBuffer.isSupportedFormat(format)) {
            throw new IllegalArgumentException("Invalid pixel format " + format);
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Invalid width " + width);
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Invalid height " + height);
        }
        if (layers <= 0) {
            throw new IllegalArgumentException("Invalid layer count " + layers);
        }
        if (format == 33 && height != 1) {
            throw new IllegalArgumentException("Height must be 1 when using the BLOB format");
        }
        long nativeObject = HardwareBuffer.nCreateHardwareBuffer(width, height, format, layers, usage);
        if (nativeObject == 0L) {
            throw new IllegalArgumentException("Unable to create a HardwareBuffer, either the dimensions passed were too large, too many image layers were requested, or an invalid set of usage flags or invalid format was passed");
        }
        return new HardwareBuffer(nativeObject);
    }

    public static boolean isSupported(int width, int height, int format, int layers, long usage) {
        if (!HardwareBuffer.isSupportedFormat(format)) {
            throw new IllegalArgumentException("Invalid pixel format " + format);
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Invalid width " + width);
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Invalid height " + height);
        }
        if (layers <= 0) {
            throw new IllegalArgumentException("Invalid layer count " + layers);
        }
        if (format == 33 && height != 1) {
            throw new IllegalArgumentException("Height must be 1 when using the BLOB format");
        }
        return HardwareBuffer.nIsSupported(width, height, format, layers, usage);
    }

    public static HardwareBuffer createFromGraphicBuffer(GraphicBuffer graphicBuffer) {
        long nativeObject = HardwareBuffer.nCreateFromGraphicBuffer(graphicBuffer);
        return new HardwareBuffer(nativeObject);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private HardwareBuffer(long nativeObject) {
        this.mNativeObject = nativeObject;
        ClassLoader loader = HardwareBuffer.class.getClassLoader();
        NativeAllocationRegistry registry = new NativeAllocationRegistry(loader, HardwareBuffer.nGetNativeFinalizer(), 232L);
        this.mCleaner = registry.registerNativeAllocation(this, this.mNativeObject);
        this.mCloseGuard.open("close");
    }

    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public int getWidth() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and its width cannot be obtained.");
        }
        return HardwareBuffer.nGetWidth(this.mNativeObject);
    }

    public int getHeight() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and its height cannot be obtained.");
        }
        return HardwareBuffer.nGetHeight(this.mNativeObject);
    }

    public int getFormat() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and its format cannot be obtained.");
        }
        return HardwareBuffer.nGetFormat(this.mNativeObject);
    }

    public int getLayers() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and its layer count cannot be obtained.");
        }
        return HardwareBuffer.nGetLayers(this.mNativeObject);
    }

    public long getUsage() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and its usage cannot be obtained.");
        }
        return HardwareBuffer.nGetUsage(this.mNativeObject);
    }

    @Deprecated
    public void destroy() {
        this.close();
    }

    @Deprecated
    public boolean isDestroyed() {
        return this.isClosed();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.mCloseGuard.close();
            this.mNativeObject = 0L;
            this.mCleaner.run();
            this.mCleaner = null;
        }
    }

    public boolean isClosed() {
        return this.mNativeObject == 0L;
    }

    @Override
    public int describeContents() {
        return 1;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and cannot be written to a parcel.");
        }
        HardwareBuffer.nWriteHardwareBufferToParcel(this.mNativeObject, dest);
    }

    private static boolean isSupportedFormat(int format) {
        switch (format) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 22: 
            case 33: 
            case 43: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    private static long nCreateHardwareBuffer(int n, int n2, int n3, int n4, long l) {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nCreateHardwareBuffer(IIIIJ)J", true, null);
    }

    private static long nCreateFromGraphicBuffer(GraphicBuffer graphicBuffer) {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nCreateFromGraphicBuffer(Landroid/graphics/GraphicBuffer;)J", true, null);
    }

    private static long nGetNativeFinalizer() {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nGetNativeFinalizer()J", true, null);
    }

    private static void nWriteHardwareBufferToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.hardware.HardwareBuffer#nWriteHardwareBufferToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static long nReadHardwareBufferFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nReadHardwareBufferFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    @FastNative
    private static int nGetWidth(long l) {
        return OverrideMethod.invokeI("android.hardware.HardwareBuffer#nGetWidth(J)I", true, null);
    }

    @FastNative
    private static int nGetHeight(long l) {
        return OverrideMethod.invokeI("android.hardware.HardwareBuffer#nGetHeight(J)I", true, null);
    }

    @FastNative
    private static int nGetFormat(long l) {
        return OverrideMethod.invokeI("android.hardware.HardwareBuffer#nGetFormat(J)I", true, null);
    }

    @FastNative
    private static int nGetLayers(long l) {
        return OverrideMethod.invokeI("android.hardware.HardwareBuffer#nGetLayers(J)I", true, null);
    }

    @FastNative
    private static long nGetUsage(long l) {
        return OverrideMethod.invokeL("android.hardware.HardwareBuffer#nGetUsage(J)J", true, null);
    }

    private static boolean nIsSupported(int n, int n2, int n3, int n4, long l) {
        return OverrideMethod.invokeI("android.hardware.HardwareBuffer#nIsSupported(IIIIJ)Z", true, null) != 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Usage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Format {
    }
}

