/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.annotation.SystemApi;
import android.hardware.hdmi.HdmiClient;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.IHdmiControlCallback;
import android.hardware.hdmi.IHdmiControlService;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

@SystemApi
public class HdmiSwitchClient
extends HdmiClient {
    private static final String TAG = "HdmiSwitchClient";

    HdmiSwitchClient(IHdmiControlService service) {
        super(service);
    }

    private static IHdmiControlCallback getCallbackWrapper(final OnSelectListener listener) {
        return new IHdmiControlCallback.Stub(){

            @Override
            public void onComplete(int result) {
                listener.onSelect(result);
            }
        };
    }

    @Override
    public int getDeviceType() {
        return 6;
    }

    public void selectDevice(int logicalAddress, OnSelectListener listener) {
        Preconditions.checkNotNull(listener);
        try {
            this.mService.deviceSelect(logicalAddress, HdmiSwitchClient.getCallbackWrapper(listener));
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to select device: ", e);
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void selectPort(int portId, OnSelectListener listener) {
        Preconditions.checkNotNull(listener);
        try {
            this.mService.portSelect(portId, HdmiSwitchClient.getCallbackWrapper(listener));
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to select port: ", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void selectDevice(int logicalAddress, final Executor executor, final OnSelectListener listener) {
        Preconditions.checkNotNull(listener);
        try {
            this.mService.deviceSelect(logicalAddress, new IHdmiControlCallback.Stub(){

                @Override
                public void onComplete(int result) {
                    Binder.withCleanCallingIdentity(() -> executor.execute(() -> listener.onSelect(result)));
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to select device: ", e);
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void selectPort(int portId, final Executor executor, final OnSelectListener listener) {
        Preconditions.checkNotNull(listener);
        try {
            this.mService.portSelect(portId, new IHdmiControlCallback.Stub(){

                @Override
                public void onComplete(int result) {
                    Binder.withCleanCallingIdentity(() -> executor.execute(() -> listener.onSelect(result)));
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to select port: ", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public List<HdmiDeviceInfo> getDeviceList() {
        try {
            return this.mService.getDeviceList();
        }
        catch (RemoteException e) {
            Log.e("TAG", "Failed to call getDeviceList():", e);
            return Collections.emptyList();
        }
    }

    @SystemApi
    public static interface OnSelectListener {
        public void onSelect(@HdmiControlManager.ControlCallbackResult int var1);
    }
}

