/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SystemApi
public class AudioVolumeGroup
implements Parcelable {
    private static final String TAG = "AudioVolumeGroup";
    public static final int DEFAULT_VOLUME_GROUP = -1;
    private int mId;
    private final String mName;
    private final AudioAttributes[] mAudioAttributes;
    private int[] mLegacyStreamTypes;
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static List<AudioVolumeGroup> sAudioVolumeGroups;
    public static final Parcelable.Creator<AudioVolumeGroup> CREATOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AudioVolumeGroup> getAudioVolumeGroups() {
        if (sAudioVolumeGroups == null) {
            Object object = sLock;
            synchronized (object) {
                if (sAudioVolumeGroups == null) {
                    sAudioVolumeGroups = AudioVolumeGroup.initializeAudioVolumeGroups();
                }
            }
        }
        return sAudioVolumeGroups;
    }

    private static List<AudioVolumeGroup> initializeAudioVolumeGroups() {
        ArrayList<AudioVolumeGroup> avgList = new ArrayList<AudioVolumeGroup>();
        int status = AudioVolumeGroup.native_list_audio_volume_groups(avgList);
        if (status != 0) {
            Log.w(TAG, ": listAudioVolumeGroups failed");
        }
        return avgList;
    }

    private static int native_list_audio_volume_groups(ArrayList<AudioVolumeGroup> arrayList) {
        return OverrideMethod.invokeI("android.media.audiopolicy.AudioVolumeGroup#native_list_audio_volume_groups(Ljava/util/ArrayList;)I", true, null);
    }

    AudioVolumeGroup(String name, int id2, AudioAttributes[] audioAttributes, int[] legacyStreamTypes) {
        Preconditions.checkNotNull(name, "name must not be null");
        Preconditions.checkNotNull(audioAttributes, "audioAttributes must not be null");
        Preconditions.checkNotNull(legacyStreamTypes, "legacyStreamTypes must not be null");
        this.mName = name;
        this.mId = id2;
        this.mAudioAttributes = audioAttributes;
        this.mLegacyStreamTypes = legacyStreamTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioVolumeGroup thatAvg = (AudioVolumeGroup)o;
        return this.mName == thatAvg.mName && this.mId == thatAvg.mId && this.mAudioAttributes.equals(thatAvg.mAudioAttributes);
    }

    public List<AudioAttributes> getAudioAttributes() {
        return Arrays.asList(this.mAudioAttributes);
    }

    public int[] getLegacyStreamTypes() {
        return this.mLegacyStreamTypes;
    }

    public String name() {
        return this.mName;
    }

    public int getId() {
        return this.mId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeInt(this.mId);
        dest.writeInt(this.mAudioAttributes.length);
        for (AudioAttributes attributes : this.mAudioAttributes) {
            attributes.writeToParcel(dest, flags | 1);
        }
        dest.writeInt(this.mLegacyStreamTypes.length);
        for (int streamType : this.mLegacyStreamTypes) {
            dest.writeInt(streamType);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("\n Name: ");
        s.append(this.mName);
        s.append(" Id: ");
        s.append(Integer.toString(this.mId));
        s.append("\n     Supported Audio Attributes:");
        for (AudioAttributes attribute : this.mAudioAttributes) {
            s.append("\n       -");
            s.append(attribute.toString());
        }
        s.append("\n     Supported Legacy Stream Types: { ");
        for (int legacyStreamType : this.mLegacyStreamTypes) {
            s.append(Integer.toString(legacyStreamType));
            s.append(" ");
        }
        s.append("}");
        return s.toString();
    }

    static {
        CREATOR = new Parcelable.Creator<AudioVolumeGroup>(){

            @Override
            public AudioVolumeGroup createFromParcel(Parcel in) {
                Preconditions.checkNotNull(in, "in Parcel must not be null");
                String name = in.readString();
                int id2 = in.readInt();
                int nbAttributes = in.readInt();
                AudioAttributes[] audioAttributes = new AudioAttributes[nbAttributes];
                for (int index = 0; index < nbAttributes; ++index) {
                    audioAttributes[index] = AudioAttributes.CREATOR.createFromParcel(in);
                }
                int nbStreamTypes = in.readInt();
                int[] streamTypes = new int[nbStreamTypes];
                for (int index = 0; index < nbStreamTypes; ++index) {
                    streamTypes[index] = in.readInt();
                }
                return new AudioVolumeGroup(name, id2, audioAttributes, streamTypes);
            }

            public AudioVolumeGroup[] newArray(int size) {
                return new AudioVolumeGroup[size];
            }
        };
    }
}

