/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import com.android.tools.layoutlib.java.System_Delegate;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SynchronousResultReceiver
extends ResultReceiver {
    private final CompletableFuture<Result> mFuture = new CompletableFuture();
    private final String mName;

    public SynchronousResultReceiver() {
        super((Handler)null);
        this.mName = null;
    }

    public SynchronousResultReceiver(String name) {
        super((Handler)null);
        this.mName = name;
    }

    @Override
    protected void onReceiveResult(int resultCode, Bundle resultData) {
        super.onReceiveResult(resultCode, resultData);
        this.mFuture.complete(new Result(resultCode, resultData));
    }

    public String getName() {
        return this.mName;
    }

    public Result awaitResult(long timeoutMillis) throws TimeoutException {
        long deadline = System_Delegate.currentTimeMillis() + timeoutMillis;
        while (timeoutMillis >= 0L) {
            try {
                return this.mFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                throw new AssertionError("Error receiving response", e);
            }
            catch (InterruptedException e) {
                timeoutMillis -= deadline - System_Delegate.currentTimeMillis();
            }
        }
        throw new TimeoutException();
    }

    public static class Result {
        public int resultCode;
        public Bundle bundle;

        public Result(int resultCode, Bundle bundle) {
            this.resultCode = resultCode;
            this.bundle = bundle;
        }
    }
}

