/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.provider.DocumentsContract;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import java.io.CharArrayWriter;
import java.io.File;
import java.util.Locale;

public class StorageVolume
implements Parcelable {
    @UnsupportedAppUsage
    private final String mId;
    @UnsupportedAppUsage
    private final File mPath;
    private final File mInternalPath;
    @UnsupportedAppUsage
    private final String mDescription;
    @UnsupportedAppUsage
    private final boolean mPrimary;
    @UnsupportedAppUsage
    private final boolean mRemovable;
    private final boolean mEmulated;
    private final boolean mAllowMassStorage;
    private final long mMaxFileSize;
    private final UserHandle mOwner;
    private final String mFsUuid;
    private final String mState;
    public static final String EXTRA_STORAGE_VOLUME = "android.os.storage.extra.STORAGE_VOLUME";
    public static final String EXTRA_DIRECTORY_NAME = "android.os.storage.extra.DIRECTORY_NAME";
    private static final String ACTION_OPEN_EXTERNAL_DIRECTORY = "android.os.storage.action.OPEN_EXTERNAL_DIRECTORY";
    public static final int STORAGE_ID_INVALID = 0;
    public static final int STORAGE_ID_PRIMARY = 65537;
    public static final Parcelable.Creator<StorageVolume> CREATOR = new Parcelable.Creator<StorageVolume>(){

        @Override
        public StorageVolume createFromParcel(Parcel in) {
            return new StorageVolume(in);
        }

        public StorageVolume[] newArray(int size) {
            return new StorageVolume[size];
        }
    };

    public StorageVolume(String id2, File path, File internalPath, String description, boolean primary, boolean removable, boolean emulated, boolean allowMassStorage, long maxFileSize, UserHandle owner, String fsUuid, String state) {
        this.mId = Preconditions.checkNotNull(id2);
        this.mPath = Preconditions.checkNotNull(path);
        this.mInternalPath = Preconditions.checkNotNull(internalPath);
        this.mDescription = Preconditions.checkNotNull(description);
        this.mPrimary = primary;
        this.mRemovable = removable;
        this.mEmulated = emulated;
        this.mAllowMassStorage = allowMassStorage;
        this.mMaxFileSize = maxFileSize;
        this.mOwner = Preconditions.checkNotNull(owner);
        this.mFsUuid = fsUuid;
        this.mState = Preconditions.checkNotNull(state);
    }

    private StorageVolume(Parcel in) {
        this.mId = in.readString();
        this.mPath = new File(in.readString());
        this.mInternalPath = new File(in.readString());
        this.mDescription = in.readString();
        this.mPrimary = in.readInt() != 0;
        this.mRemovable = in.readInt() != 0;
        this.mEmulated = in.readInt() != 0;
        this.mAllowMassStorage = in.readInt() != 0;
        this.mMaxFileSize = in.readLong();
        this.mOwner = (UserHandle)in.readParcelable(null);
        this.mFsUuid = in.readString();
        this.mState = in.readString();
    }

    @UnsupportedAppUsage
    public String getId() {
        return this.mId;
    }

    public String getPath() {
        return this.mPath.toString();
    }

    public String getInternalPath() {
        return this.mInternalPath.toString();
    }

    @UnsupportedAppUsage
    public File getPathFile() {
        return this.mPath;
    }

    public String getDescription(Context context) {
        return this.mDescription;
    }

    public boolean isPrimary() {
        return this.mPrimary;
    }

    public boolean isRemovable() {
        return this.mRemovable;
    }

    public boolean isEmulated() {
        return this.mEmulated;
    }

    @UnsupportedAppUsage
    public boolean allowMassStorage() {
        return this.mAllowMassStorage;
    }

    @UnsupportedAppUsage
    public long getMaxFileSize() {
        return this.mMaxFileSize;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public UserHandle getOwner() {
        return this.mOwner;
    }

    public String getUuid() {
        return this.mFsUuid;
    }

    public static String normalizeUuid(String fsUuid) {
        return fsUuid != null ? fsUuid.toLowerCase(Locale.US) : null;
    }

    public String getNormalizedUuid() {
        return StorageVolume.normalizeUuid(this.mFsUuid);
    }

    @UnsupportedAppUsage
    public int getFatVolumeId() {
        if (this.mFsUuid == null || this.mFsUuid.length() != 9) {
            return -1;
        }
        try {
            return (int)Long.parseLong(this.mFsUuid.replace("-", ""), 16);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @UnsupportedAppUsage
    public String getUserLabel() {
        return this.mDescription;
    }

    public String getState() {
        return this.mState;
    }

    @Deprecated
    public Intent createAccessIntent(String directoryName) {
        if (this.isPrimary() && directoryName == null || directoryName != null && !Environment.isStandardDirectory(directoryName)) {
            return null;
        }
        Intent intent = new Intent(ACTION_OPEN_EXTERNAL_DIRECTORY);
        intent.putExtra(EXTRA_STORAGE_VOLUME, this);
        intent.putExtra(EXTRA_DIRECTORY_NAME, directoryName);
        return intent;
    }

    public Intent createOpenDocumentTreeIntent() {
        String rootId = this.isEmulated() ? "primary" : this.mFsUuid;
        Uri rootUri = DocumentsContract.buildRootUri("com.android.externalstorage.documents", rootId);
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT_TREE").putExtra("android.provider.extra.INITIAL_URI", rootUri).putExtra("android.provider.extra.SHOW_ADVANCED", true);
        return intent;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageVolume && this.mPath != null) {
            StorageVolume volume = (StorageVolume)obj;
            return this.mPath.equals(volume.mPath);
        }
        return false;
    }

    public int hashCode() {
        return this.mPath.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("StorageVolume: ").append(this.mDescription);
        if (this.mFsUuid != null) {
            buffer.append(" (").append(this.mFsUuid).append(")");
        }
        return buffer.toString();
    }

    public String dump() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump(new IndentingPrintWriter(writer, "    ", 80));
        return writer.toString();
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("StorageVolume:");
        pw.increaseIndent();
        pw.printPair("mId", this.mId);
        pw.printPair("mPath", this.mPath);
        pw.printPair("mInternalPath", this.mInternalPath);
        pw.printPair("mDescription", this.mDescription);
        pw.printPair("mPrimary", this.mPrimary);
        pw.printPair("mRemovable", this.mRemovable);
        pw.printPair("mEmulated", this.mEmulated);
        pw.printPair("mAllowMassStorage", this.mAllowMassStorage);
        pw.printPair("mMaxFileSize", this.mMaxFileSize);
        pw.printPair("mOwner", this.mOwner);
        pw.printPair("mFsUuid", this.mFsUuid);
        pw.printPair("mState", this.mState);
        pw.decreaseIndent();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mId);
        parcel.writeString(this.mPath.toString());
        parcel.writeString(this.mInternalPath.toString());
        parcel.writeString(this.mDescription);
        parcel.writeInt(this.mPrimary ? 1 : 0);
        parcel.writeInt(this.mRemovable ? 1 : 0);
        parcel.writeInt(this.mEmulated ? 1 : 0);
        parcel.writeInt(this.mAllowMassStorage ? 1 : 0);
        parcel.writeLong(this.mMaxFileSize);
        parcel.writeParcelable(this.mOwner, flags);
        parcel.writeString(this.mFsUuid);
        parcel.writeString(this.mState);
    }
}

