/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.proto.ProtoOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public class ZenPolicy
implements Parcelable {
    private ArrayList<Integer> mPriorityCategories = new ArrayList<Integer>(Collections.nCopies(8, 0));
    private ArrayList<Integer> mVisualEffects = new ArrayList<Integer>(Collections.nCopies(7, 0));
    private int mPriorityMessages = 0;
    private int mPriorityCalls = 0;
    public static final int PRIORITY_CATEGORY_REMINDERS = 0;
    public static final int PRIORITY_CATEGORY_EVENTS = 1;
    public static final int PRIORITY_CATEGORY_MESSAGES = 2;
    public static final int PRIORITY_CATEGORY_CALLS = 3;
    public static final int PRIORITY_CATEGORY_REPEAT_CALLERS = 4;
    public static final int PRIORITY_CATEGORY_ALARMS = 5;
    public static final int PRIORITY_CATEGORY_MEDIA = 6;
    public static final int PRIORITY_CATEGORY_SYSTEM = 7;
    public static final int VISUAL_EFFECT_FULL_SCREEN_INTENT = 0;
    public static final int VISUAL_EFFECT_LIGHTS = 1;
    public static final int VISUAL_EFFECT_PEEK = 2;
    public static final int VISUAL_EFFECT_STATUS_BAR = 3;
    public static final int VISUAL_EFFECT_BADGE = 4;
    public static final int VISUAL_EFFECT_AMBIENT = 5;
    public static final int VISUAL_EFFECT_NOTIFICATION_LIST = 6;
    public static final int PEOPLE_TYPE_UNSET = 0;
    public static final int PEOPLE_TYPE_ANYONE = 1;
    public static final int PEOPLE_TYPE_CONTACTS = 2;
    public static final int PEOPLE_TYPE_STARRED = 3;
    public static final int PEOPLE_TYPE_NONE = 4;
    public static final int STATE_UNSET = 0;
    public static final int STATE_ALLOW = 1;
    public static final int STATE_DISALLOW = 2;
    public static final Parcelable.Creator<ZenPolicy> CREATOR = new Parcelable.Creator<ZenPolicy>(){

        @Override
        public ZenPolicy createFromParcel(Parcel source) {
            ZenPolicy policy = new ZenPolicy();
            policy.mPriorityCategories = source.readArrayList(Integer.class.getClassLoader());
            policy.mVisualEffects = source.readArrayList(Integer.class.getClassLoader());
            policy.mPriorityCalls = source.readInt();
            policy.mPriorityMessages = source.readInt();
            return policy;
        }

        public ZenPolicy[] newArray(int size) {
            return new ZenPolicy[size];
        }
    };

    public int getPriorityMessageSenders() {
        return this.mPriorityMessages;
    }

    public int getPriorityCallSenders() {
        return this.mPriorityCalls;
    }

    public int getPriorityCategoryReminders() {
        return this.mPriorityCategories.get(0);
    }

    public int getPriorityCategoryEvents() {
        return this.mPriorityCategories.get(1);
    }

    public int getPriorityCategoryMessages() {
        return this.mPriorityCategories.get(2);
    }

    public int getPriorityCategoryCalls() {
        return this.mPriorityCategories.get(3);
    }

    public int getPriorityCategoryRepeatCallers() {
        return this.mPriorityCategories.get(4);
    }

    public int getPriorityCategoryAlarms() {
        return this.mPriorityCategories.get(5);
    }

    public int getPriorityCategoryMedia() {
        return this.mPriorityCategories.get(6);
    }

    public int getPriorityCategorySystem() {
        return this.mPriorityCategories.get(7);
    }

    public int getVisualEffectFullScreenIntent() {
        return this.mVisualEffects.get(0);
    }

    public int getVisualEffectLights() {
        return this.mVisualEffects.get(1);
    }

    public int getVisualEffectPeek() {
        return this.mVisualEffects.get(2);
    }

    public int getVisualEffectStatusBar() {
        return this.mVisualEffects.get(3);
    }

    public int getVisualEffectBadge() {
        return this.mVisualEffects.get(4);
    }

    public int getVisualEffectAmbient() {
        return this.mVisualEffects.get(5);
    }

    public int getVisualEffectNotificationList() {
        return this.mVisualEffects.get(6);
    }

    public boolean shouldHideAllVisualEffects() {
        for (int i = 0; i < this.mVisualEffects.size(); ++i) {
            if (this.mVisualEffects.get(i) == 2) continue;
            return false;
        }
        return true;
    }

    public boolean shouldShowAllVisualEffects() {
        for (int i = 0; i < this.mVisualEffects.size(); ++i) {
            if (this.mVisualEffects.get(i) == 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.mPriorityCategories);
        dest.writeList(this.mVisualEffects);
        dest.writeInt(this.mPriorityCalls);
        dest.writeInt(this.mPriorityMessages);
    }

    public String toString() {
        return ZenPolicy.class.getSimpleName() + '{' + "priorityCategories=[" + this.priorityCategoriesToString() + "], visualEffects=[" + this.visualEffectsToString() + "], priorityCalls=" + this.peopleTypeToString(this.mPriorityCalls) + ", priorityMessages=" + this.peopleTypeToString(this.mPriorityMessages) + '}';
    }

    private String priorityCategoriesToString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.mPriorityCategories.size(); ++i) {
            if (this.mPriorityCategories.get(i) == 0) continue;
            builder.append(this.indexToCategory(i)).append("=").append(this.stateToString(this.mPriorityCategories.get(i))).append(" ");
        }
        return builder.toString();
    }

    private String visualEffectsToString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.mVisualEffects.size(); ++i) {
            if (this.mVisualEffects.get(i) == 0) continue;
            builder.append(this.indexToVisualEffect(i)).append("=").append(this.stateToString(this.mVisualEffects.get(i))).append(" ");
        }
        return builder.toString();
    }

    private String indexToVisualEffect(int visualEffectIndex) {
        switch (visualEffectIndex) {
            case 0: {
                return "fullScreenIntent";
            }
            case 1: {
                return "lights";
            }
            case 2: {
                return "peek";
            }
            case 3: {
                return "statusBar";
            }
            case 4: {
                return "badge";
            }
            case 5: {
                return "ambient";
            }
            case 6: {
                return "notificationList";
            }
        }
        return null;
    }

    private String indexToCategory(int categoryIndex) {
        switch (categoryIndex) {
            case 0: {
                return "reminders";
            }
            case 1: {
                return "events";
            }
            case 2: {
                return "messages";
            }
            case 3: {
                return "calls";
            }
            case 4: {
                return "repeatCallers";
            }
            case 5: {
                return "alarms";
            }
            case 6: {
                return "media";
            }
            case 7: {
                return "system";
            }
        }
        return null;
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "unset";
            }
            case 2: {
                return "disallow";
            }
            case 1: {
                return "allow";
            }
        }
        return "invalidState{" + state + "}";
    }

    private String peopleTypeToString(int peopleType) {
        switch (peopleType) {
            case 1: {
                return "anyone";
            }
            case 2: {
                return "contacts";
            }
            case 4: {
                return "none";
            }
            case 3: {
                return "starred_contacts";
            }
            case 0: {
                return "unset";
            }
        }
        return "invalidPeopleType{" + peopleType + "}";
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZenPolicy)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ZenPolicy other = (ZenPolicy)o;
        return Objects.equals(other.mPriorityCategories, this.mPriorityCategories) && Objects.equals(other.mVisualEffects, this.mVisualEffects) && other.mPriorityCalls == this.mPriorityCalls && other.mPriorityMessages == this.mPriorityMessages;
    }

    public int hashCode() {
        return Objects.hash(this.mPriorityCategories, this.mVisualEffects, this.mPriorityCalls, this.mPriorityMessages);
    }

    private int getZenPolicyPriorityCategoryState(int category) {
        switch (category) {
            case 0: {
                return this.getPriorityCategoryReminders();
            }
            case 1: {
                return this.getPriorityCategoryEvents();
            }
            case 2: {
                return this.getPriorityCategoryMessages();
            }
            case 3: {
                return this.getPriorityCategoryCalls();
            }
            case 4: {
                return this.getPriorityCategoryRepeatCallers();
            }
            case 5: {
                return this.getPriorityCategoryAlarms();
            }
            case 6: {
                return this.getPriorityCategoryMedia();
            }
            case 7: {
                return this.getPriorityCategorySystem();
            }
        }
        return -1;
    }

    private int getZenPolicyVisualEffectState(int effect) {
        switch (effect) {
            case 0: {
                return this.getVisualEffectFullScreenIntent();
            }
            case 1: {
                return this.getVisualEffectLights();
            }
            case 2: {
                return this.getVisualEffectPeek();
            }
            case 3: {
                return this.getVisualEffectStatusBar();
            }
            case 4: {
                return this.getVisualEffectBadge();
            }
            case 5: {
                return this.getVisualEffectAmbient();
            }
            case 6: {
                return this.getVisualEffectNotificationList();
            }
        }
        return -1;
    }

    public boolean isCategoryAllowed(int category, boolean defaultVal) {
        switch (this.getZenPolicyPriorityCategoryState(category)) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return defaultVal;
    }

    public boolean isVisualEffectAllowed(int effect, boolean defaultVal) {
        switch (this.getZenPolicyVisualEffectState(effect)) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return defaultVal;
    }

    public void apply(ZenPolicy policyToApply) {
        if (policyToApply == null) {
            return;
        }
        for (int category = 0; category < this.mPriorityCategories.size(); ++category) {
            int newState;
            if (this.mPriorityCategories.get(category) == 2 || (newState = policyToApply.mPriorityCategories.get(category).intValue()) == 0) continue;
            this.mPriorityCategories.set(category, newState);
            if (category == 2 && this.mPriorityMessages < policyToApply.mPriorityMessages) {
                this.mPriorityMessages = policyToApply.mPriorityMessages;
                continue;
            }
            if (category != 3 || this.mPriorityCalls >= policyToApply.mPriorityCalls) continue;
            this.mPriorityCalls = policyToApply.mPriorityCalls;
        }
        for (int visualEffect = 0; visualEffect < this.mVisualEffects.size(); ++visualEffect) {
            if (this.mVisualEffects.get(visualEffect) == 2 || policyToApply.mVisualEffects.get(visualEffect) == 0) continue;
            this.mVisualEffects.set(visualEffect, policyToApply.mVisualEffects.get(visualEffect));
        }
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10E00000001L, this.getPriorityCategoryReminders());
        proto.write(1159641169922L, this.getPriorityCategoryEvents());
        proto.write(1159641169923L, this.getPriorityCategoryMessages());
        proto.write(1159641169924L, this.getPriorityCategoryCalls());
        proto.write(1159641169925L, this.getPriorityCategoryRepeatCallers());
        proto.write(1159641169926L, this.getPriorityCategoryAlarms());
        proto.write(1159641169927L, this.getPriorityCategoryMedia());
        proto.write(1159641169928L, this.getPriorityCategorySystem());
        proto.write(1159641169929L, this.getVisualEffectFullScreenIntent());
        proto.write(1159641169930L, this.getVisualEffectLights());
        proto.write(1159641169931L, this.getVisualEffectPeek());
        proto.write(1159641169932L, this.getVisualEffectStatusBar());
        proto.write(1159641169933L, this.getVisualEffectBadge());
        proto.write(0x10E0000000EL, this.getVisualEffectAmbient());
        proto.write(1159641169935L, this.getVisualEffectNotificationList());
        proto.write(0x10E00000011L, this.getPriorityMessageSenders());
        proto.write(0x10E00000010L, this.getPriorityCallSenders());
        proto.end(token);
    }

    public ZenPolicy copy() {
        Parcel parcel = Parcel.obtain();
        try {
            this.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            ZenPolicy zenPolicy = CREATOR.createFromParcel(parcel);
            return zenPolicy;
        }
        finally {
            parcel.recycle();
        }
    }

    public static class Builder {
        private ZenPolicy mZenPolicy;

        public Builder() {
            this.mZenPolicy = new ZenPolicy();
        }

        public Builder(ZenPolicy policy) {
            this.mZenPolicy = policy != null ? policy.copy() : new ZenPolicy();
        }

        public ZenPolicy build() {
            return this.mZenPolicy.copy();
        }

        public Builder allowAllSounds() {
            for (int i = 0; i < this.mZenPolicy.mPriorityCategories.size(); ++i) {
                this.mZenPolicy.mPriorityCategories.set(i, 1);
            }
            this.mZenPolicy.mPriorityMessages = 1;
            this.mZenPolicy.mPriorityCalls = 1;
            return this;
        }

        public Builder disallowAllSounds() {
            for (int i = 0; i < this.mZenPolicy.mPriorityCategories.size(); ++i) {
                this.mZenPolicy.mPriorityCategories.set(i, 2);
            }
            this.mZenPolicy.mPriorityMessages = 4;
            this.mZenPolicy.mPriorityCalls = 4;
            return this;
        }

        public Builder showAllVisualEffects() {
            for (int i = 0; i < this.mZenPolicy.mVisualEffects.size(); ++i) {
                this.mZenPolicy.mVisualEffects.set(i, 1);
            }
            return this;
        }

        public Builder hideAllVisualEffects() {
            for (int i = 0; i < this.mZenPolicy.mVisualEffects.size(); ++i) {
                this.mZenPolicy.mVisualEffects.set(i, 2);
            }
            return this;
        }

        public Builder unsetPriorityCategory(int category) {
            this.mZenPolicy.mPriorityCategories.set(category, 0);
            if (category == 2) {
                this.mZenPolicy.mPriorityMessages = 0;
            } else if (category == 3) {
                this.mZenPolicy.mPriorityCalls = 0;
            }
            return this;
        }

        public Builder unsetVisualEffect(int effect) {
            this.mZenPolicy.mVisualEffects.set(effect, 0);
            return this;
        }

        public Builder allowReminders(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(0, allow ? 1 : 2);
            return this;
        }

        public Builder allowEvents(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(1, allow ? 1 : 2);
            return this;
        }

        public Builder allowMessages(int audienceType) {
            if (audienceType == 0) {
                return this.unsetPriorityCategory(2);
            }
            if (audienceType == 4) {
                this.mZenPolicy.mPriorityCategories.set(2, 2);
            } else if (audienceType == 1 || audienceType == 2 || audienceType == 3) {
                this.mZenPolicy.mPriorityCategories.set(2, 1);
            } else {
                return this;
            }
            this.mZenPolicy.mPriorityMessages = audienceType;
            return this;
        }

        public Builder allowCalls(int audienceType) {
            if (audienceType == 0) {
                return this.unsetPriorityCategory(3);
            }
            if (audienceType == 4) {
                this.mZenPolicy.mPriorityCategories.set(3, 2);
            } else if (audienceType == 1 || audienceType == 2 || audienceType == 3) {
                this.mZenPolicy.mPriorityCategories.set(3, 1);
            } else {
                return this;
            }
            this.mZenPolicy.mPriorityCalls = audienceType;
            return this;
        }

        public Builder allowRepeatCallers(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(4, allow ? 1 : 2);
            return this;
        }

        public Builder allowAlarms(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(5, allow ? 1 : 2);
            return this;
        }

        public Builder allowMedia(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(6, allow ? 1 : 2);
            return this;
        }

        public Builder allowSystem(boolean allow) {
            this.mZenPolicy.mPriorityCategories.set(7, allow ? 1 : 2);
            return this;
        }

        public Builder allowCategory(int category, boolean allow) {
            switch (category) {
                case 5: {
                    this.allowAlarms(allow);
                    break;
                }
                case 6: {
                    this.allowMedia(allow);
                    break;
                }
                case 7: {
                    this.allowSystem(allow);
                    break;
                }
                case 0: {
                    this.allowReminders(allow);
                    break;
                }
                case 1: {
                    this.allowEvents(allow);
                    break;
                }
                case 4: {
                    this.allowRepeatCallers(allow);
                }
            }
            return this;
        }

        public Builder showFullScreenIntent(boolean show) {
            this.mZenPolicy.mVisualEffects.set(0, show ? 1 : 2);
            return this;
        }

        public Builder showLights(boolean show) {
            this.mZenPolicy.mVisualEffects.set(1, show ? 1 : 2);
            return this;
        }

        public Builder showPeeking(boolean show) {
            this.mZenPolicy.mVisualEffects.set(2, show ? 1 : 2);
            return this;
        }

        public Builder showStatusBarIcons(boolean show) {
            this.mZenPolicy.mVisualEffects.set(3, show ? 1 : 2);
            return this;
        }

        public Builder showBadges(boolean show) {
            this.mZenPolicy.mVisualEffects.set(4, show ? 1 : 2);
            return this;
        }

        public Builder showInAmbientDisplay(boolean show) {
            this.mZenPolicy.mVisualEffects.set(5, show ? 1 : 2);
            return this;
        }

        public Builder showInNotificationList(boolean show) {
            this.mZenPolicy.mVisualEffects.set(6, show ? 1 : 2);
            return this;
        }

        public Builder showVisualEffect(int effect, boolean show) {
            switch (effect) {
                case 0: {
                    this.showFullScreenIntent(show);
                    break;
                }
                case 1: {
                    this.showLights(show);
                    break;
                }
                case 2: {
                    this.showPeeking(show);
                    break;
                }
                case 3: {
                    this.showStatusBarIcons(show);
                    break;
                }
                case 4: {
                    this.showBadges(show);
                    break;
                }
                case 5: {
                    this.showInAmbientDisplay(show);
                    break;
                }
                case 6: {
                    this.showInNotificationList(show);
                }
            }
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PeopleType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VisualEffect {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PriorityCategory {
    }
}

