/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.hardware.radio.V1_4.NrSignalStrength;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.telephony.CellSignalStrength;
import android.telephony.ServiceState;
import java.util.Objects;

public class CellSignalStrengthNr
extends CellSignalStrength
implements Parcelable {
    public static final int UNKNOWN_ASU_LEVEL = 99;
    private static final String TAG = "CellSignalStrengthNr";
    private static final int SIGNAL_GREAT_THRESHOLD = -95;
    private static final int SIGNAL_GOOD_THRESHOLD = -105;
    private static final int SIGNAL_MODERATE_THRESHOLD = -115;
    private int mCsiRsrp;
    private int mCsiRsrq;
    private int mCsiSinr;
    private int mSsRsrp;
    private int mSsRsrq;
    private int mSsSinr;
    private int mLevel;
    private static final CellSignalStrengthNr sInvalid = new CellSignalStrengthNr();
    public static final Parcelable.Creator<CellSignalStrengthNr> CREATOR = new Parcelable.Creator<CellSignalStrengthNr>(){

        @Override
        public CellSignalStrengthNr createFromParcel(Parcel in) {
            return new CellSignalStrengthNr(in);
        }

        public CellSignalStrengthNr[] newArray(int size) {
            return new CellSignalStrengthNr[size];
        }
    };

    public CellSignalStrengthNr() {
        this.setDefaultValues();
    }

    public CellSignalStrengthNr(int csiRsrp, int csiRsrq, int csiSinr, int ssRsrp, int ssRsrq, int ssSinr) {
        this.mCsiRsrp = CellSignalStrengthNr.inRangeOrUnavailable(csiRsrp, -140, -44);
        this.mCsiRsrq = CellSignalStrengthNr.inRangeOrUnavailable(csiRsrq, -20, -3);
        this.mCsiSinr = CellSignalStrengthNr.inRangeOrUnavailable(csiSinr, -23, 23);
        this.mSsRsrp = CellSignalStrengthNr.inRangeOrUnavailable(ssRsrp, -140, -44);
        this.mSsRsrq = CellSignalStrengthNr.inRangeOrUnavailable(ssRsrq, -20, -3);
        this.mSsSinr = CellSignalStrengthNr.inRangeOrUnavailable(ssSinr, -23, 40);
        this.updateLevel(null, null);
    }

    public CellSignalStrengthNr(NrSignalStrength ss) {
        this(ss.csiRsrp, ss.csiRsrq, ss.csiSinr, ss.ssRsrp, ss.ssRsrq, ss.ssSinr);
    }

    public int getSsRsrp() {
        return this.mSsRsrp;
    }

    public int getSsRsrq() {
        return this.mSsRsrq;
    }

    public int getSsSinr() {
        return this.mSsSinr;
    }

    public int getCsiRsrp() {
        return this.mCsiRsrp;
    }

    public int getCsiRsrq() {
        return this.mCsiRsrq;
    }

    public int getCsiSinr() {
        return this.mCsiSinr;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mCsiRsrp);
        dest.writeInt(this.mCsiRsrq);
        dest.writeInt(this.mCsiSinr);
        dest.writeInt(this.mSsRsrp);
        dest.writeInt(this.mSsRsrq);
        dest.writeInt(this.mSsSinr);
        dest.writeInt(this.mLevel);
    }

    private CellSignalStrengthNr(Parcel in) {
        this.mCsiRsrp = in.readInt();
        this.mCsiRsrq = in.readInt();
        this.mCsiSinr = in.readInt();
        this.mSsRsrp = in.readInt();
        this.mSsRsrq = in.readInt();
        this.mSsSinr = in.readInt();
        this.mLevel = in.readInt();
    }

    @Override
    public void setDefaultValues() {
        this.mCsiRsrp = Integer.MAX_VALUE;
        this.mCsiRsrq = Integer.MAX_VALUE;
        this.mCsiSinr = Integer.MAX_VALUE;
        this.mSsRsrp = Integer.MAX_VALUE;
        this.mSsRsrq = Integer.MAX_VALUE;
        this.mSsSinr = Integer.MAX_VALUE;
        this.mLevel = 0;
    }

    @Override
    public int getLevel() {
        return this.mLevel;
    }

    @Override
    public void updateLevel(PersistableBundle cc, ServiceState ss) {
        this.mLevel = this.mCsiRsrp == Integer.MAX_VALUE ? 0 : (this.mCsiRsrp >= -95 ? 4 : (this.mCsiRsrp >= -105 ? 3 : (this.mCsiRsrp >= -115 ? 2 : 1)));
    }

    @Override
    public int getAsuLevel() {
        int nrDbm = this.getDbm();
        int asuLevel = nrDbm == Integer.MAX_VALUE ? 99 : (nrDbm <= -140 ? 0 : (nrDbm >= -43 ? 97 : nrDbm + 140));
        return asuLevel;
    }

    @Override
    public int getDbm() {
        return this.mCsiRsrp;
    }

    public CellSignalStrengthNr(CellSignalStrengthNr s) {
        this.mCsiRsrp = s.mCsiRsrp;
        this.mCsiRsrq = s.mCsiRsrq;
        this.mCsiSinr = s.mCsiSinr;
        this.mSsRsrp = s.mSsRsrp;
        this.mSsRsrq = s.mSsRsrq;
        this.mSsSinr = s.mSsSinr;
        this.mLevel = s.mLevel;
    }

    @Override
    public CellSignalStrengthNr copy() {
        return new CellSignalStrengthNr(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mCsiRsrp, this.mCsiRsrq, this.mCsiSinr, this.mSsRsrp, this.mSsRsrq, this.mSsSinr, this.mLevel);
    }

    @Override
    public boolean isValid() {
        return !this.equals(sInvalid);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CellSignalStrengthNr) {
            CellSignalStrengthNr o = (CellSignalStrengthNr)obj;
            return this.mCsiRsrp == o.mCsiRsrp && this.mCsiRsrq == o.mCsiRsrq && this.mCsiSinr == o.mCsiSinr && this.mSsRsrp == o.mSsRsrp && this.mSsRsrq == o.mSsRsrq && this.mSsSinr == o.mSsSinr && this.mLevel == o.mLevel;
        }
        return false;
    }

    public String toString() {
        return "CellSignalStrengthNr:{" + (" csiRsrp = " + this.mCsiRsrp) + (" csiRsrq = " + this.mCsiRsrq) + (" csiSinr = " + this.mCsiSinr) + (" ssRsrp = " + this.mSsRsrp) + (" ssRsrq = " + this.mSsRsrq) + (" ssSinr = " + this.mSsSinr) + (" level = " + this.mLevel) + " }";
    }
}

