/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class UiccCardInfo
implements Parcelable {
    private final boolean mIsEuicc;
    private final int mCardId;
    private final String mEid;
    private final String mIccId;
    private final int mSlotIndex;
    private final boolean mIsRemovable;
    public static final Parcelable.Creator<UiccCardInfo> CREATOR = new Parcelable.Creator<UiccCardInfo>(){

        @Override
        public UiccCardInfo createFromParcel(Parcel in) {
            return new UiccCardInfo(in);
        }

        public UiccCardInfo[] newArray(int size) {
            return new UiccCardInfo[size];
        }
    };

    private UiccCardInfo(Parcel in) {
        this.mIsEuicc = in.readByte() != 0;
        this.mCardId = in.readInt();
        this.mEid = in.readString();
        this.mIccId = in.readString();
        this.mSlotIndex = in.readInt();
        this.mIsRemovable = in.readByte() != 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.mIsEuicc ? 1 : 0));
        dest.writeInt(this.mCardId);
        dest.writeString(this.mEid);
        dest.writeString(this.mIccId);
        dest.writeInt(this.mSlotIndex);
        dest.writeByte((byte)(this.mIsRemovable ? 1 : 0));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public UiccCardInfo(boolean isEuicc, int cardId, String eid, String iccId, int slotIndex, boolean isRemovable) {
        this.mIsEuicc = isEuicc;
        this.mCardId = cardId;
        this.mEid = eid;
        this.mIccId = iccId;
        this.mSlotIndex = slotIndex;
        this.mIsRemovable = isRemovable;
    }

    public boolean isEuicc() {
        return this.mIsEuicc;
    }

    public int getCardId() {
        return this.mCardId;
    }

    public String getEid() {
        if (!this.mIsEuicc) {
            return null;
        }
        return this.mEid;
    }

    public String getIccId() {
        return this.mIccId;
    }

    public int getSlotIndex() {
        return this.mSlotIndex;
    }

    public UiccCardInfo getUnprivileged() {
        return new UiccCardInfo(this.mIsEuicc, this.mCardId, null, null, this.mSlotIndex, this.mIsRemovable);
    }

    public boolean isRemovable() {
        return this.mIsRemovable;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UiccCardInfo that = (UiccCardInfo)obj;
        return this.mIsEuicc == that.mIsEuicc && this.mCardId == that.mCardId && Objects.equals(this.mEid, that.mEid) && Objects.equals(this.mIccId, that.mIccId) && this.mSlotIndex == that.mSlotIndex && this.mIsRemovable == that.mIsRemovable;
    }

    public int hashCode() {
        return Objects.hash(this.mIsEuicc, this.mCardId, this.mEid, this.mIccId, this.mSlotIndex, this.mIsRemovable);
    }

    public String toString() {
        return "UiccCardInfo (mIsEuicc=" + this.mIsEuicc + ", mCardId=" + this.mCardId + ", mEid=" + this.mEid + ", mIccId=" + this.mIccId + ", mSlotIndex=" + this.mSlotIndex + ", mIsRemovable=" + this.mIsRemovable + ")";
    }
}

