/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.annotation.UnsupportedAppUsage;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.util.Locale;

public interface InputFilter {
    public CharSequence filter(CharSequence var1, int var2, int var3, Spanned var4, int var5, int var6);

    public static class LengthFilter
    implements InputFilter {
        @UnsupportedAppUsage
        private final int mMax;

        public LengthFilter(int max) {
            this.mMax = max;
        }

        @Override
        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            int keep = this.mMax - (dest.length() - (dend - dstart));
            if (keep <= 0) {
                return "";
            }
            if (keep >= end - start) {
                return null;
            }
            if (Character.isHighSurrogate(source.charAt((keep += start) - 1)) && --keep == start) {
                return "";
            }
            return source.subSequence(start, keep);
        }

        public int getMax() {
            return this.mMax;
        }
    }

    public static class AllCaps
    implements InputFilter {
        private final Locale mLocale;

        public AllCaps() {
            this.mLocale = null;
        }

        public AllCaps(Locale locale) {
            Preconditions.checkNotNull(locale);
            this.mLocale = locale;
        }

        @Override
        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            int cp;
            CharSequenceWrapper wrapper = new CharSequenceWrapper(source, start, end);
            boolean lowerOrTitleFound = false;
            int length = end - start;
            for (int i = 0; i < length; i += Character.charCount(cp)) {
                cp = Character.codePointAt(wrapper, i);
                if (!Character.isLowerCase(cp) && !Character.isTitleCase(cp)) continue;
                lowerOrTitleFound = true;
                break;
            }
            if (!lowerOrTitleFound) {
                return null;
            }
            boolean copySpans = source instanceof Spanned;
            CharSequence upper = TextUtils.toUpperCase(this.mLocale, wrapper, copySpans);
            if (upper == wrapper) {
                return null;
            }
            return copySpans ? new SpannableString(upper) : upper.toString();
        }

        private static class CharSequenceWrapper
        implements CharSequence,
        Spanned {
            private final CharSequence mSource;
            private final int mStart;
            private final int mEnd;
            private final int mLength;

            CharSequenceWrapper(CharSequence source, int start, int end) {
                this.mSource = source;
                this.mStart = start;
                this.mEnd = end;
                this.mLength = end - start;
            }

            @Override
            public int length() {
                return this.mLength;
            }

            @Override
            public char charAt(int index) {
                if (index < 0 || index >= this.mLength) {
                    throw new IndexOutOfBoundsException();
                }
                return this.mSource.charAt(this.mStart + index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                if (start < 0 || end < 0 || end > this.mLength || start > end) {
                    throw new IndexOutOfBoundsException();
                }
                return new CharSequenceWrapper(this.mSource, this.mStart + start, this.mStart + end);
            }

            @Override
            public String toString() {
                return this.mSource.subSequence(this.mStart, this.mEnd).toString();
            }

            @Override
            public <T> T[] getSpans(int start, int end, Class<T> type) {
                return ((Spanned)this.mSource).getSpans(this.mStart + start, this.mStart + end, type);
            }

            @Override
            public int getSpanStart(Object tag) {
                return ((Spanned)this.mSource).getSpanStart(tag) - this.mStart;
            }

            @Override
            public int getSpanEnd(Object tag) {
                return ((Spanned)this.mSource).getSpanEnd(tag) - this.mStart;
            }

            @Override
            public int getSpanFlags(Object tag) {
                return ((Spanned)this.mSource).getSpanFlags(tag);
            }

            @Override
            public int nextSpanTransition(int start, int limit, Class type) {
                return ((Spanned)this.mSource).nextSpanTransition(this.mStart + start, this.mStart + limit, type) - this.mStart;
            }
        }
    }
}

