/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.UnsupportedAppUsage;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;

public class BulletSpan
implements LeadingMarginSpan,
ParcelableSpan {
    private static final int STANDARD_BULLET_RADIUS = 4;
    public static final int STANDARD_GAP_WIDTH = 2;
    private static final int STANDARD_COLOR = 0;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final int mGapWidth;
    private final int mBulletRadius;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final int mColor;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final boolean mWantColor;

    public BulletSpan() {
        this(2, 0, false, 4);
    }

    public BulletSpan(int gapWidth) {
        this(gapWidth, 0, false, 4);
    }

    public BulletSpan(int gapWidth, int color2) {
        this(gapWidth, color2, true, 4);
    }

    public BulletSpan(int gapWidth, int color2, int bulletRadius) {
        this(gapWidth, color2, true, bulletRadius);
    }

    private BulletSpan(int gapWidth, int color2, boolean wantColor, int bulletRadius) {
        this.mGapWidth = gapWidth;
        this.mBulletRadius = bulletRadius;
        this.mColor = color2;
        this.mWantColor = wantColor;
    }

    public BulletSpan(Parcel src) {
        this.mGapWidth = src.readInt();
        this.mWantColor = src.readInt() != 0;
        this.mColor = src.readInt();
        this.mBulletRadius = src.readInt();
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 8;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public void writeToParcelInternal(Parcel dest, int flags) {
        dest.writeInt(this.mGapWidth);
        dest.writeInt(this.mWantColor ? 1 : 0);
        dest.writeInt(this.mColor);
        dest.writeInt(this.mBulletRadius);
    }

    @Override
    public int getLeadingMargin(boolean first) {
        return 2 * this.mBulletRadius + this.mGapWidth;
    }

    public int getGapWidth() {
        return this.mGapWidth;
    }

    public int getBulletRadius() {
        return this.mBulletRadius;
    }

    public int getColor() {
        return this.mColor;
    }

    @Override
    public void drawLeadingMargin(Canvas canvas, Paint paint, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout2) {
        if (((Spanned)text).getSpanStart(this) == start) {
            Paint.Style style2 = paint.getStyle();
            int oldcolor = 0;
            if (this.mWantColor) {
                oldcolor = paint.getColor();
                paint.setColor(this.mColor);
            }
            paint.setStyle(Paint.Style.FILL);
            if (layout2 != null) {
                int line = layout2.getLineForOffset(start);
                bottom -= layout2.getLineExtra(line);
            }
            float yPosition = (float)(top + bottom) / 2.0f;
            float xPosition = x + dir * this.mBulletRadius;
            canvas.drawCircle(xPosition, yPosition, this.mBulletRadius, paint);
            if (this.mWantColor) {
                paint.setColor(oldcolor);
            }
            paint.setStyle(style2);
        }
    }
}

