/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.SntpClient;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.TrustedTime;

public class NtpTrustedTime
implements TrustedTime {
    private static final String TAG = "NtpTrustedTime";
    private static final boolean LOGD = false;
    private static NtpTrustedTime sSingleton;
    private static Context sContext;
    private final String mServer;
    private final long mTimeout;
    private ConnectivityManager mCM;
    private boolean mHasCache;
    private long mCachedNtpTime;
    private long mCachedNtpElapsedRealtime;
    private long mCachedNtpCertainty;

    private NtpTrustedTime(String server, long timeout) {
        this.mServer = server;
        this.mTimeout = timeout;
    }

    @UnsupportedAppUsage
    public static synchronized NtpTrustedTime getInstance(Context context) {
        if (sSingleton == null) {
            Resources res = context.getResources();
            ContentResolver resolver = context.getContentResolver();
            String defaultServer = res.getString(17039762);
            long defaultTimeout = res.getInteger(17694870);
            String secureServer = Settings.Global.getString(resolver, "ntp_server");
            long timeout = Settings.Global.getLong(resolver, "ntp_timeout", defaultTimeout);
            String server = secureServer != null ? secureServer : defaultServer;
            sSingleton = new NtpTrustedTime(server, timeout);
            sContext = context;
        }
        return sSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage
    public boolean forceRefresh() {
        NtpTrustedTime ntpTrustedTime = this;
        synchronized (ntpTrustedTime) {
            if (this.mCM == null) {
                this.mCM = sContext.getSystemService(ConnectivityManager.class);
            }
        }
        Network network = this.mCM == null ? null : this.mCM.getActiveNetwork();
        return this.forceRefresh(network);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceRefresh(Network network) {
        NetworkInfo ni;
        if (TextUtils.isEmpty(this.mServer)) {
            return false;
        }
        NtpTrustedTime ntpTrustedTime = this;
        synchronized (ntpTrustedTime) {
            if (this.mCM == null) {
                this.mCM = sContext.getSystemService(ConnectivityManager.class);
            }
        }
        NetworkInfo networkInfo = ni = this.mCM == null ? null : this.mCM.getNetworkInfo(network);
        if (ni == null || !ni.isConnected()) {
            return false;
        }
        SntpClient client = new SntpClient();
        if (client.requestTime(this.mServer, (int)this.mTimeout, network)) {
            this.mHasCache = true;
            this.mCachedNtpTime = client.getNtpTime();
            this.mCachedNtpElapsedRealtime = client.getNtpTimeReference();
            this.mCachedNtpCertainty = client.getRoundTripTime() / 2L;
            return true;
        }
        return false;
    }

    @Override
    @UnsupportedAppUsage
    public boolean hasCache() {
        return this.mHasCache;
    }

    @Override
    public long getCacheAge() {
        if (this.mHasCache) {
            return SystemClock.elapsedRealtime() - this.mCachedNtpElapsedRealtime;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long getCacheCertainty() {
        if (this.mHasCache) {
            return this.mCachedNtpCertainty;
        }
        return Long.MAX_VALUE;
    }

    @Override
    @UnsupportedAppUsage
    public long currentTimeMillis() {
        if (!this.mHasCache) {
            throw new IllegalStateException("Missing authoritative time source");
        }
        return this.mCachedNtpTime + this.getCacheAge();
    }

    @UnsupportedAppUsage
    public long getCachedNtpTime() {
        return this.mCachedNtpTime;
    }

    @UnsupportedAppUsage
    public long getCachedNtpTimeReference() {
        return this.mCachedNtpElapsedRealtime;
    }
}

