/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import com.android.internal.util.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class GestureExclusionTracker {
    private boolean mGestureExclusionViewsChanged = false;
    private boolean mRootGestureExclusionRectsChanged = false;
    private List<Rect> mRootGestureExclusionRects = Collections.emptyList();
    private List<GestureExclusionViewInfo> mGestureExclusionViewInfos = new ArrayList<GestureExclusionViewInfo>();
    private List<Rect> mGestureExclusionRects = Collections.emptyList();

    GestureExclusionTracker() {
    }

    public void updateRectsForView(View view) {
        boolean found = false;
        Iterator<GestureExclusionViewInfo> i = this.mGestureExclusionViewInfos.iterator();
        while (i.hasNext()) {
            GestureExclusionViewInfo info = i.next();
            View v = info.getView();
            if (v == null || !v.isAttachedToWindow()) {
                this.mGestureExclusionViewsChanged = true;
                i.remove();
                continue;
            }
            if (v != view) continue;
            found = true;
            info.mDirty = true;
            break;
        }
        if (!found && view.isAttachedToWindow()) {
            this.mGestureExclusionViewInfos.add(new GestureExclusionViewInfo(view));
            this.mGestureExclusionViewsChanged = true;
        }
    }

    public List<Rect> computeChangedRects() {
        boolean changed = this.mRootGestureExclusionRectsChanged;
        Iterator<GestureExclusionViewInfo> i = this.mGestureExclusionViewInfos.iterator();
        ArrayList<Rect> rects = new ArrayList<Rect>(this.mRootGestureExclusionRects);
        while (i.hasNext()) {
            GestureExclusionViewInfo info = i.next();
            switch (info.update()) {
                case 0: {
                    changed = true;
                }
                case 1: {
                    rects.addAll(info.mExclusionRects);
                    break;
                }
                case 2: {
                    this.mGestureExclusionViewsChanged = true;
                    i.remove();
                }
            }
        }
        if (changed || this.mGestureExclusionViewsChanged) {
            this.mGestureExclusionViewsChanged = false;
            this.mRootGestureExclusionRectsChanged = false;
            if (!this.mGestureExclusionRects.equals(rects)) {
                this.mGestureExclusionRects = rects;
                return rects;
            }
        }
        return null;
    }

    public void setRootSystemGestureExclusionRects(List<Rect> rects) {
        Preconditions.checkNotNull(rects, "rects must not be null");
        this.mRootGestureExclusionRects = rects;
        this.mRootGestureExclusionRectsChanged = true;
    }

    public List<Rect> getRootSystemGestureExclusionRects() {
        return this.mRootGestureExclusionRects;
    }

    private static class GestureExclusionViewInfo {
        public static final int CHANGED = 0;
        public static final int UNCHANGED = 1;
        public static final int GONE = 2;
        private final WeakReference<View> mView;
        boolean mDirty = true;
        List<Rect> mExclusionRects = Collections.emptyList();

        GestureExclusionViewInfo(View view) {
            this.mView = new WeakReference<View>(view);
        }

        public View getView() {
            return (View)this.mView.get();
        }

        public int update() {
            View excludedView = this.getView();
            if (excludedView == null || !excludedView.isAttachedToWindow()) {
                return 2;
            }
            List<Rect> localRects = excludedView.getSystemGestureExclusionRects();
            ArrayList<Rect> newRects = new ArrayList<Rect>(localRects.size());
            for (Rect src : localRects) {
                Rect mappedRect = new Rect(src);
                ViewParent p = excludedView.getParent();
                if (p == null || !p.getChildVisibleRect(excludedView, mappedRect, null)) continue;
                newRects.add(mappedRect);
            }
            if (this.mExclusionRects.equals(localRects)) {
                return 1;
            }
            this.mExclusionRects = newRects;
            return 0;
        }
    }
}

