/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.UnsupportedAppUsage;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;

public class IndentingPrintWriter
extends PrintWriter {
    private final String mSingleIndent;
    private final int mWrapLength;
    private StringBuilder mIndentBuilder = new StringBuilder();
    private char[] mCurrentIndent;
    private int mCurrentLength;
    private boolean mEmptyLine = true;
    private char[] mSingleChar = new char[1];

    @UnsupportedAppUsage
    public IndentingPrintWriter(Writer writer, String singleIndent) {
        this(writer, singleIndent, -1);
    }

    public IndentingPrintWriter(Writer writer, String singleIndent, int wrapLength) {
        super(writer);
        this.mSingleIndent = singleIndent;
        this.mWrapLength = wrapLength;
    }

    public IndentingPrintWriter setIndent(String indent) {
        this.mIndentBuilder.setLength(0);
        this.mIndentBuilder.append(indent);
        this.mCurrentIndent = null;
        return this;
    }

    public IndentingPrintWriter setIndent(int indent) {
        this.mIndentBuilder.setLength(0);
        for (int i = 0; i < indent; ++i) {
            this.increaseIndent();
        }
        return this;
    }

    @UnsupportedAppUsage
    public IndentingPrintWriter increaseIndent() {
        this.mIndentBuilder.append(this.mSingleIndent);
        this.mCurrentIndent = null;
        return this;
    }

    @UnsupportedAppUsage
    public IndentingPrintWriter decreaseIndent() {
        this.mIndentBuilder.delete(0, this.mSingleIndent.length());
        this.mCurrentIndent = null;
        return this;
    }

    public IndentingPrintWriter printPair(String key, Object value) {
        this.print(key + "=" + String.valueOf(value) + " ");
        return this;
    }

    public IndentingPrintWriter printPair(String key, Object[] value) {
        this.print(key + "=" + Arrays.toString(value) + " ");
        return this;
    }

    public IndentingPrintWriter printHexPair(String key, int value) {
        this.print(key + "=0x" + Integer.toHexString(value) + " ");
        return this;
    }

    @Override
    public void println() {
        this.write(10);
    }

    @Override
    public void write(int c) {
        this.mSingleChar[0] = (char)c;
        this.write(this.mSingleChar, 0, 1);
    }

    @Override
    public void write(String s, int off, int len) {
        char[] buf = new char[len];
        s.getChars(off, len - off, buf, 0);
        this.write(buf, 0, len);
    }

    @Override
    public void write(char[] buf, int offset, int count) {
        int indentLength = this.mIndentBuilder.length();
        int bufferEnd = offset + count;
        int lineStart = offset;
        int lineEnd = offset;
        while (lineEnd < bufferEnd) {
            char ch = buf[lineEnd++];
            ++this.mCurrentLength;
            if (ch == '\n') {
                this.maybeWriteIndent();
                super.write(buf, lineStart, lineEnd - lineStart);
                lineStart = lineEnd;
                this.mEmptyLine = true;
                this.mCurrentLength = 0;
            }
            if (this.mWrapLength <= 0 || this.mCurrentLength < this.mWrapLength - indentLength) continue;
            if (!this.mEmptyLine) {
                super.write(10);
                this.mEmptyLine = true;
                this.mCurrentLength = lineEnd - lineStart;
                continue;
            }
            this.maybeWriteIndent();
            super.write(buf, lineStart, lineEnd - lineStart);
            super.write(10);
            this.mEmptyLine = true;
            lineStart = lineEnd;
            this.mCurrentLength = 0;
        }
        if (lineStart != lineEnd) {
            this.maybeWriteIndent();
            super.write(buf, lineStart, lineEnd - lineStart);
        }
    }

    private void maybeWriteIndent() {
        if (this.mEmptyLine) {
            this.mEmptyLine = false;
            if (this.mIndentBuilder.length() != 0) {
                if (this.mCurrentIndent == null) {
                    this.mCurrentIndent = this.mIndentBuilder.toString().toCharArray();
                }
                super.write(this.mCurrentIndent, 0, this.mCurrentIndent.length);
            }
        }
    }
}

