/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.analysis;

import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.analysis.ComputationProgress;
import com.android.tools.perflib.heap.analysis.DominatorsBase;
import com.google.common.collect.Lists;
import gnu.trove.TIntStack;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public final class LinkEvalDominators
extends DominatorsBase {
    private ArrayList<LinkEvalNode> mNodes;
    private LinkEval mLinkEval;
    private volatile int mSemiDominatorProgress = 0;
    private volatile int mDominatorProgress = 0;

    public LinkEvalDominators(Snapshot snapshot) {
        super(snapshot);
        final HashMap<Instance, LinkEvalNode> instanceNodeMap = new HashMap<Instance, LinkEvalNode>();
        TObjectProcedure<Instance> mapProcedure = new TObjectProcedure<Instance>(){

            public boolean execute(Instance instance) {
                LinkEvalNode node = new LinkEvalNode(instance);
                instanceNodeMap.put(instance, node);
                return true;
            }
        };
        for (Heap heap : this.mSnapshot.getHeaps()) {
            for (Instance instance : heap.getClasses()) {
                mapProcedure.execute((Object)instance);
            }
            heap.forEachInstance(mapProcedure);
        }
        for (LinkEvalNode node : instanceNodeMap.values()) {
            node.finalize(instanceNodeMap);
        }
        Collection<RootObj> roots = snapshot.getGCRoots();
        HashSet<Instance> filteredRootInstances = new HashSet<Instance>(roots.size());
        for (RootObj rootObj : roots) {
            Instance referredInstance = rootObj.getReferredInstance();
            if (referredInstance == null) continue;
            filteredRootInstances.add(referredInstance);
        }
        Instance[] gcRootInstances = filteredRootInstances.toArray(new Instance[filteredRootInstances.size()]);
        LinkEvalNode[] linkEvalNodeArray = new LinkEvalNode[gcRootInstances.length];
        for (int i = 0; i < linkEvalNodeArray.length; ++i) {
            linkEvalNodeArray[i] = (LinkEvalNode)instanceNodeMap.get(gcRootInstances[i]);
        }
        SentinelNode sentinelRootNode = new SentinelNode(Snapshot.SENTINEL_ROOT, instanceNodeMap, linkEvalNodeArray);
        instanceNodeMap.put(Snapshot.SENTINEL_ROOT, sentinelRootNode);
        for (LinkEvalNode rootNode : linkEvalNodeArray) {
            rootNode.setParent(sentinelRootNode);
            LinkEvalNode[] backReferences = rootNode.getBackReferences();
            LinkEvalNode[] augmentedBackReferences = new LinkEvalNode[backReferences.length + 1];
            System.arraycopy(backReferences, 0, augmentedBackReferences, 1, backReferences.length);
            augmentedBackReferences[0] = sentinelRootNode;
            rootNode.setBackReferences(augmentedBackReferences);
        }
        this.mNodes = new ArrayList();
        this.depthFirstSearch(sentinelRootNode);
        this.mNodes.trimToSize();
        this.mLinkEval = new LinkEval();
    }

    @Override
    public ComputationProgress getComputationProgress() {
        double progress;
        String progressMessage;
        if (this.mSemiDominatorProgress < this.mNodes.size()) {
            progressMessage = String.format("Calculating semi-dominators %d/%d", this.mSemiDominatorProgress, this.mNodes.size());
            progress = 0.5 * (double)this.mSemiDominatorProgress / (double)this.mNodes.size();
        } else {
            progressMessage = String.format("Calculating immediate dominators %d/%d", this.mDominatorProgress, this.mNodes.size());
            progress = 0.5 + 0.5 * (double)this.mDominatorProgress / (double)this.mNodes.size();
        }
        this.mCurrentProgress.setMessage(progressMessage);
        this.mCurrentProgress.setProgress(progress);
        return this.mCurrentProgress;
    }

    @Override
    public void computeDominators() {
        LinkEvalNode currentNode;
        int i = this.mNodes.size() - 1;
        while (i > 0) {
            currentNode = this.mNodes.get(i);
            for (LinkEvalNode predecessor : currentNode.getBackReferences()) {
                LinkEvalNode u = this.mLinkEval.eval(predecessor);
                if (u.getSemiDominator().getTopologicalOrder() >= currentNode.getSemiDominator().getTopologicalOrder()) continue;
                currentNode.setSemiDominator(u.getSemiDominator());
            }
            currentNode.getSemiDominator().getDominates().add(currentNode);
            LinkEvalNode parent = currentNode.getParent();
            assert (parent != null);
            LinkEval.link(parent, currentNode);
            Iterator<LinkEvalNode> iterator = parent.getDominates().iterator();
            while (iterator.hasNext()) {
                LinkEvalNode node;
                LinkEvalNode u = this.mLinkEval.eval(node = iterator.next());
                node.setImmediateDominator(u.getSemiDominator().getTopologicalOrder() < node.getSemiDominator().getTopologicalOrder() ? u : parent);
            }
            parent.getDominates().clear();
            parent.getDominates().trimToSize();
            this.mSemiDominatorProgress = this.mNodes.size() - --i;
        }
        i = 1;
        while (i < this.mNodes.size()) {
            currentNode = this.mNodes.get(i);
            if (currentNode.getImmediateDominator() != currentNode.getSemiDominator()) {
                LinkEvalNode dominator = currentNode.getImmediateDominator();
                assert (dominator != null);
                assert (dominator.getImmediateDominator() != null);
                currentNode.setImmediateDominator(dominator.getImmediateDominator());
            }
            this.mDominatorProgress = i++;
        }
    }

    private void depthFirstSearch(LinkEvalNode root) {
        Stack<LinkEvalNode> nodeStack = new Stack<LinkEvalNode>();
        TIntStack childOffsetStack = new TIntStack();
        int topologicalOrder = 0;
        nodeStack.push(root);
        childOffsetStack.push(0);
        block0: while (!nodeStack.empty()) {
            LinkEvalNode currentNode = (LinkEvalNode)nodeStack.pop();
            int currentChildOffset = childOffsetStack.pop();
            if (currentNode.getSemiDominator() == null) {
                currentNode.setTopologicalOrder(topologicalOrder++);
                currentNode.setSemiDominator(currentNode);
                this.mNodes.add(currentNode);
            }
            LinkEvalNode[] forwardReferences = currentNode.getForwardReferences();
            while (currentChildOffset < forwardReferences.length) {
                LinkEvalNode successor = forwardReferences[currentChildOffset];
                if (successor.getSemiDominator() == null) {
                    successor.setParent(currentNode);
                    nodeStack.push(currentNode);
                    childOffsetStack.push(currentChildOffset + 1);
                    nodeStack.push(successor);
                    childOffsetStack.push(0);
                    continue block0;
                }
                ++currentChildOffset;
            }
        }
    }

    protected static class SentinelNode
    extends LinkEvalNode {
        public SentinelNode(Instance instance, Map<Instance, LinkEvalNode> instanceLookup, LinkEvalNode[] roots) {
            super(instance);
            this.mInstanceLookup = instanceLookup;
            this.mForwardReferences = roots;
            this.mBackReferences = new LinkEvalNode[0];
        }

        @Override
        public final void finalize(Map<Instance, LinkEvalNode> instanceLookup) {
            throw new RuntimeException("This method should not be called.");
        }
    }

    protected static class LinkEvalNode {
        protected Map<Instance, LinkEvalNode> mInstanceLookup;
        protected Instance mInstance;
        protected LinkEvalNode[] mForwardReferences;
        protected LinkEvalNode[] mBackReferences;
        protected LinkEvalNode mSemiDominator;
        protected LinkEvalNode mParent;
        protected LinkEvalNode mAncestor;
        protected LinkEvalNode mLabel;
        protected ArrayList<LinkEvalNode> mSemisDominated;

        public LinkEvalNode(Instance instance) {
            this.mInstance = instance;
            this.mInstance.setTopologicalOrder(0);
            this.mSemiDominator = null;
            this.mParent = null;
            this.mAncestor = null;
            this.mLabel = this;
            this.mSemisDominated = new ArrayList(1);
        }

        public final Instance getInstance() {
            return this.mInstance;
        }

        public LinkEvalNode[] getForwardReferences() {
            return this.mForwardReferences;
        }

        public LinkEvalNode[] getBackReferences() {
            return this.mBackReferences;
        }

        public void setBackReferences(LinkEvalNode[] backReferences) {
            this.mBackReferences = backReferences;
        }

        public void finalize(Map<Instance, LinkEvalNode> instanceLookup) {
            this.mInstanceLookup = instanceLookup;
            this.mForwardReferences = new LinkEvalNode[this.mInstance.getHardForwardReferences().size()];
            int i = 0;
            for (Instance instance : this.mInstance.getHardForwardReferences()) {
                this.mForwardReferences[i++] = instanceLookup.get(instance);
            }
            ArrayList<LinkEvalNode> backReferenceInstances = new ArrayList<LinkEvalNode>(this.mInstance.getHardReverseReferences().size());
            for (Instance instance : this.mInstance.getHardReverseReferences()) {
                if (!instance.isReachable()) continue;
                backReferenceInstances.add(instanceLookup.get(instance));
            }
            this.mBackReferences = backReferenceInstances.toArray(new LinkEvalNode[backReferenceInstances.size()]);
        }

        public final void setImmediateDominator(LinkEvalNode node) {
            this.mInstance.setImmediateDominator(node.getInstance());
        }

        public final LinkEvalNode getImmediateDominator() {
            return this.mInstanceLookup.get(this.mInstance.getImmediateDominator());
        }

        public final int getTopologicalOrder() {
            return this.mInstance.getTopologicalOrder();
        }

        public void setSemiDominator(LinkEvalNode node) {
            this.mSemiDominator = node;
        }

        public LinkEvalNode getSemiDominator() {
            return this.mSemiDominator;
        }

        public LinkEvalNode getParent() {
            return this.mParent;
        }

        public void setParent(LinkEvalNode parent) {
            this.mParent = parent;
        }

        public LinkEvalNode getAncestor() {
            return this.mAncestor;
        }

        public void setAncestor(LinkEvalNode ancestor) {
            this.mAncestor = ancestor;
        }

        public LinkEvalNode getLabel() {
            return this.mLabel;
        }

        public void setLabel(LinkEvalNode node) {
            this.mLabel = node;
        }

        public void setTopologicalOrder(int order) {
            this.mInstance.setTopologicalOrder(order);
            this.mSemiDominator = this;
        }

        public ArrayList<LinkEvalNode> getDominates() {
            return this.mSemisDominated;
        }
    }

    protected static class LinkEval {
        private List<LinkEvalNode> mCompressArray = new ArrayList<LinkEvalNode>();

        protected LinkEval() {
        }

        public static void link(LinkEvalNode ancestor, LinkEvalNode child) {
            child.setAncestor(ancestor);
        }

        private void compress(LinkEvalNode node) {
            assert (this.mCompressArray.isEmpty());
            assert (node.getAncestor() != null);
            while (node.getAncestor().getAncestor() != null) {
                this.mCompressArray.add(node);
                node = node.getAncestor();
                assert (node.getAncestor() != null);
            }
            for (LinkEvalNode toCompress : Lists.reverse(this.mCompressArray)) {
                LinkEvalNode ancestor = toCompress.getAncestor();
                assert (ancestor != null);
                if (ancestor.getLabel().getSemiDominator().getTopologicalOrder() < toCompress.getLabel().getSemiDominator().getTopologicalOrder()) {
                    toCompress.setLabel(ancestor.getLabel());
                }
                toCompress.setAncestor(ancestor.getAncestor());
            }
            this.mCompressArray.clear();
        }

        public LinkEvalNode eval(LinkEvalNode node) {
            if (node.getAncestor() == null) {
                return node;
            }
            this.compress(node);
            return node.getLabel();
        }
    }
}

