/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.caches.project.CacheUtilKt;
import org.jetbrains.kotlin.caches.resolve.IdePlatformKindResolutionKt;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfoWithExpectedBy;
import org.jetbrains.kotlin.idea.caches.project.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.caches.project.PlatformModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.framework.LibraryEffectiveKindProviderKt;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;
import org.jetbrains.kotlin.idea.klib.AbstractKlibLibraryInfo;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.platform.DefaultIdeTargetPlatformKindProvider;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatforms;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\f\u001a&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u001a&\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0\r2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0014\u0010%\u001a\u00020\u001f*\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u001c\u0010&\u001a\u00020\u001f*\u00020!2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001fH\u0002\u001a\u0012\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140\r*\u00020\u001dH\u0000\u001a\f\u0010*\u001a\u00020\u001f*\u00020\u001dH\u0002\u001a\u0018\u0010+\u001a\u00020\u001f*\u00020\u001d2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-H\u0002\u001a\f\u0010.\u001a\u00020\u001f*\u00020\u001dH\u0002\u001a\n\u0010/\u001a\u00020\u001f*\u00020\u001b\u001a\f\u00100\u001a\u0004\u0018\u000101*\u00020\u001d\u001a\u0012\u00102\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\r*\u00020\u001b\u001a\f\u00103\u001a\u0004\u0018\u000104*\u00020\u001d\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"*\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00065"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "OriginCapability", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "getOriginCapability", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "libraryInfoCache", "", "Lcom/intellij/openapi/roots/libraries/Library;", "", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "Lcom/intellij/openapi/project/Project;", "getLibraryInfoCache", "(Lcom/intellij/openapi/project/Project;)Ljava/util/Map;", "sourceType", "Lorg/jetbrains/kotlin/idea/caches/project/SourceType;", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "getSourceType", "(Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;)Lorg/jetbrains/kotlin/idea/caches/project/SourceType;", "createLibraryInfo", "project", "library", "ideaModelDependencies", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "module", "Lcom/intellij/openapi/module/Module;", "forProduction", "", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "orderEntryToModuleInfo", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "acceptAsDependency", "canDependOn", "other", "isHmppEnabled", "correspondingModuleInfos", "hasProductionRoots", "hasRootsOfType", "sourceRootType", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "hasTestRoots", "isLibraryClasses", "productionSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleProductionSourceInfo;", "projectSourceModules", "testSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleTestSourceInfo;", "kotlin.core"})
public final class IdeaModuleInfosKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ModuleDescriptor.Capability<ModuleOrigin> OriginCapability;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final List<IdeaModuleInfo> orderEntryToModuleInfo(Project project, OrderEntry orderEntry, boolean forProduction) {
        List<Object> list;
        Function1<Module, List<? extends ModuleSourceInfo>> $fun$toInfos$1 = new Function1<Module, List<? extends ModuleSourceInfo>>(forProduction){
            final /* synthetic */ boolean $forProduction;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ModuleSourceInfo> invoke(@NotNull Module $this$toInfos) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$toInfos, (String)"$this$toInfos");
                Iterable $this$filter$iv = IdeaModuleInfosKt.correspondingModuleInfos($this$toInfos);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ModuleSourceInfo it = (ModuleSourceInfo)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.$forProduction || it instanceof ModuleProductionSourceInfo)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$forProduction = bl;
                super(1);
            }
        };
        if (!orderEntry.isValid()) {
            return CollectionsKt.emptyList();
        }
        OrderEntry orderEntry2 = orderEntry;
        if (orderEntry2 instanceof ModuleSourceOrderEntry) {
            Module module = orderEntry.getOwnerModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"orderEntry.getOwnerModule()");
            list = $fun$toInfos$1.invoke(module);
        } else if (orderEntry2 instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)orderEntry).getModule();
            if (module == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"orderEntry.module ?: return emptyList()");
            Module module2 = module;
            list = forProduction && ((ModuleOrderEntry)orderEntry).isProductionOnTestDependency() ? CollectionsKt.listOfNotNull((Object)IdeaModuleInfosKt.testSourceInfo(module2)) : $fun$toInfos$1.invoke(module2);
        } else if (orderEntry2 instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library == null) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)library, (String)"orderEntry.library ?: return listOf()");
            Library library2 = library;
            list = IdeaModuleInfosKt.createLibraryInfo(project, library2);
        } else if (orderEntry2 instanceof JdkOrderEntry) {
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"orderEntry.jdk ?: return listOf()");
            Sdk sdk2 = sdk;
            list = CollectionsKt.listOfNotNull((Object)new SdkInfo(project, sdk2));
        } else {
            throw (Throwable)new IllegalStateException("Unexpected order entry " + orderEntry);
        }
        return list;
    }

    private static final Map<Library, List<LibraryInfo>> getLibraryInfoCache(Project $this$libraryInfoCache) {
        Object object = CacheUtilKt.cacheInvalidatingOnRootModifications((Project)$this$libraryInfoCache, (Function0)libraryInfoCache.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cacheInvalidatingOnRootM\u2026eateConcurrentWeakMap() }");
        return (Map)object;
    }

    @NotNull
    public static final List<LibraryInfo> createLibraryInfo(@NotNull Project project, @NotNull Library library) {
        List<LibraryInfo> list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Map<Library, List<LibraryInfo>> $this$getOrPut$iv = IdeaModuleInfosKt.getLibraryInfoCache(project);
        boolean $i$f$getOrPut = false;
        List<LibraryInfo> value$iv = $this$getOrPut$iv.get(library);
        if (value$iv == null) {
            boolean bl = false;
            TargetPlatform approximatePlatform = library instanceof LibraryEx && !((LibraryEx)library).isDisposed() ? LibraryKindsKt.getPlatform(LibraryEffectiveKindProviderKt.effectiveKind((LibraryEx)library, project)) : DefaultIdeTargetPlatformKindProvider.Companion.getDefaultPlatform();
            List<LibraryInfo> answer$iv = IdePlatformKindResolutionKt.getResolution(IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)approximatePlatform)).createLibraryInfo(project, library);
            $this$getOrPut$iv.put(library, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean acceptAsDependency(OrderEntry $this$acceptAsDependency, boolean forProduction) {
        if (!($this$acceptAsDependency instanceof ExportableOrderEntry)) return true;
        if (!forProduction) return true;
        if ($this$acceptAsDependency instanceof ModuleOrderEntry) {
            if (((ModuleOrderEntry)$this$acceptAsDependency).isProductionOnTestDependency()) return true;
        }
        DependencyScope dependencyScope = ((ExportableOrderEntry)$this$acceptAsDependency).getScope();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyScope, (String)"scope");
        if (!dependencyScope.isForProductionCompile()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IdeaModuleInfo> ideaModelDependencies(Module module, boolean forProduction, TargetPlatform platform) {
        StringBuilder stringBuilder;
        void $this$filterNotTo$iv$iv;
        StringBuilder stringBuilder2;
        Object object;
        StringBuilder stringBuilder3;
        boolean bl;
        CharSequence charSequence;
        StringBuilder debugString;
        StringBuilder stringBuilder4 = debugString = LOG.isDebugEnabled() ? new StringBuilder() : null;
        if (stringBuilder4 != null) {
            StringBuilder stringBuilder5 = stringBuilder4;
            String string = "Building idea model dependencies for module " + module + ", platform=" + platform + ", forProduction=" + forProduction;
            boolean bl2 = false;
            StringBuilder stringBuilder6 = stringBuilder5.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            charSequence = stringBuilder6;
            bl = false;
            StringBuilder stringBuilder7 = ((StringBuilder)charSequence).append('\n');
            stringBuilder3 = stringBuilder7;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append('\\n')");
        } else {
            stringBuilder3 = null;
        }
        LinkedHashSet result = new LinkedHashSet();
        OrderEnumerator orderEnumerator = ModuleRootManager.getInstance((Module)module).orderEntries().compileOnly().recursively().exportedOnly();
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"ModuleRootManager.getIns\u2026ursively().exportedOnly()");
        OrderEnumerator dependencyEnumerator = orderEnumerator;
        if (forProduction && Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType(module), (Object)BuildSystemType.JPS.INSTANCE)) {
            dependencyEnumerator.productionOnly();
        }
        StringBuilder stringBuilder8 = debugString;
        if (stringBuilder8 != null) {
            stringBuilder8.append("    IDEA dependencies: [");
        }
        dependencyEnumerator.forEach((Processor)new Processor<OrderEntry>(debugString, forProduction, result, module){
            final /* synthetic */ StringBuilder $debugString;
            final /* synthetic */ boolean $forProduction;
            final /* synthetic */ LinkedHashSet $result;
            final /* synthetic */ Module $module;

            public final boolean process(OrderEntry orderEntry) {
                block2: {
                    block1: {
                        StringBuilder stringBuilder = this.$debugString;
                        if (stringBuilder != null) {
                            StringBuilder stringBuilder2 = new StringBuilder();
                            OrderEntry orderEntry2 = orderEntry;
                            Intrinsics.checkNotNullExpressionValue((Object)orderEntry2, (String)"orderEntry");
                            stringBuilder.append(stringBuilder2.append(orderEntry2.getPresentableName()).append(' ').toString());
                        }
                        OrderEntry orderEntry3 = orderEntry;
                        Intrinsics.checkNotNullExpressionValue((Object)orderEntry3, (String)"orderEntry");
                        if (!IdeaModuleInfosKt.access$acceptAsDependency(orderEntry3, this.$forProduction)) break block1;
                        Project project = this.$module.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                        this.$result.addAll(IdeaModuleInfosKt.access$orderEntryToModuleInfo(project, orderEntry, this.$forProduction));
                        StringBuilder stringBuilder3 = this.$debugString;
                        if (stringBuilder3 == null) break block2;
                        stringBuilder3.append("OK; ");
                        break block2;
                    }
                    StringBuilder stringBuilder = this.$debugString;
                    if (stringBuilder == null) break block2;
                    stringBuilder.append("SKIP; ");
                }
                return true;
            }
            {
                this.$debugString = stringBuilder;
                this.$forProduction = bl;
                this.$result = linkedHashSet;
                this.$module = module;
            }
        });
        StringBuilder stringBuilder9 = debugString;
        if (stringBuilder9 != null) {
            StringBuilder stringBuilder10 = stringBuilder9;
            charSequence = "]";
            bl = false;
            StringBuilder stringBuilder11 = stringBuilder10.append((String)charSequence);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
            object = stringBuilder11;
            boolean bl3 = false;
            StringBuilder stringBuilder12 = ((StringBuilder)object).append('\n');
            stringBuilder2 = stringBuilder12;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append('\\n')");
        } else {
            stringBuilder2 = null;
        }
        Iterable $this$filterNot$iv = result;
        boolean $i$f$filterNot = false;
        object = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IdeaModuleInfo it = (IdeaModuleInfo)element$iv$iv;
            boolean bl4 = false;
            if (it instanceof LibraryInfo && !IdeaModuleInfosKt.canDependOn(platform, it, PlatformKt.isHMPPEnabled(module))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List correctedResult = (List)destination$iv$iv;
        StringBuilder stringBuilder13 = debugString;
        if (stringBuilder13 != null) {
            charSequence = stringBuilder13;
            Object object2 = ideaModelDependencies.2.INSTANCE;
            object = null;
            int n = 0;
            CharSequence charSequence2 = ";";
            CharSequence charSequence3 = "]";
            CharSequence charSequence4 = "[";
            object2 = "    Corrected result: " + CollectionsKt.joinToString$default((Iterable)correctedResult, (CharSequence)charSequence2, (CharSequence)charSequence4, (CharSequence)charSequence3, (int)n, (CharSequence)object, (Function1)object2, (int)24, null);
            boolean bl5 = false;
            StringBuilder stringBuilder14 = ((StringBuilder)charSequence).append((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(value)");
            StringBuilder stringBuilder15 = stringBuilder14;
            boolean bl6 = false;
            StringBuilder stringBuilder16 = stringBuilder15.append('\n');
            stringBuilder = stringBuilder16;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append('\\n')");
        } else {
            stringBuilder = null;
        }
        StringBuilder stringBuilder17 = debugString;
        LOG.debug(stringBuilder17 != null ? stringBuilder17.toString() : null);
        return correctedResult;
    }

    private static final boolean canDependOn(TargetPlatform $this$canDependOn, IdeaModuleInfo other, boolean isHmppEnabled) {
        if (isHmppEnabled) {
            boolean bl;
            block6: {
                if (NativePlatformKt.isNative((TargetPlatform)$this$canDependOn) && other instanceof AbstractKlibLibraryInfo && StringsKt.endsWith$default((String)((AbstractKlibLibraryInfo)other).getLibraryRoot(), (String)"stdlib", (boolean)false, (int)2, null)) {
                    return true;
                }
                Set platformsWhichAreNotContainedInOther = SetsKt.minus((Set)$this$canDependOn.getComponentPlatforms(), (Iterable)other.getPlatform().getComponentPlatforms());
                if (platformsWhichAreNotContainedInOther.isEmpty()) {
                    return true;
                }
                Iterable $this$all$iv = platformsWhichAreNotContainedInOther;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        SimplePlatform it = (SimplePlatform)element$iv;
                        boolean bl2 = false;
                        if (it instanceof NativePlatform) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            return bl && other.getPlatform().getComponentPlatforms().contains(CollectionsKt.single((Iterable)NativePlatforms.INSTANCE.getUnspecifiedNativePlatform().getComponentPlatforms()));
        }
        return JvmPlatformKt.isJvm((TargetPlatform)$this$canDependOn) && JvmPlatformKt.isJvm((TargetPlatform)other.getPlatform()) || JsPlatformKt.isJs((TargetPlatform)$this$canDependOn) && JsPlatformKt.isJs((TargetPlatform)other.getPlatform()) || NativePlatformKt.isNative((TargetPlatform)$this$canDependOn) && NativePlatformKt.isNative((TargetPlatform)other.getPlatform()) || TargetPlatformKt.isCommon((TargetPlatform)$this$canDependOn) && TargetPlatformKt.isCommon((TargetPlatform)other.getPlatform());
    }

    @Nullable
    public static final ModuleProductionSourceInfo productionSourceInfo(@NotNull Module $this$productionSourceInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$productionSourceInfo, (String)"$this$productionSourceInfo");
        return IdeaModuleInfosKt.hasProductionRoots($this$productionSourceInfo) ? new ModuleProductionSourceInfo($this$productionSourceInfo) : null;
    }

    @Nullable
    public static final ModuleTestSourceInfo testSourceInfo(@NotNull Module $this$testSourceInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$testSourceInfo, (String)"$this$testSourceInfo");
        return IdeaModuleInfosKt.hasTestRoots($this$testSourceInfo) ? new ModuleTestSourceInfo($this$testSourceInfo) : null;
    }

    @NotNull
    public static final List<ModuleSourceInfo> correspondingModuleInfos(@NotNull Module $this$correspondingModuleInfos) {
        Intrinsics.checkNotNullParameter((Object)$this$correspondingModuleInfos, (String)"$this$correspondingModuleInfos");
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new ModuleSourceInfoWithExpectedBy[]{IdeaModuleInfosKt.testSourceInfo($this$correspondingModuleInfos), IdeaModuleInfosKt.productionSourceInfo($this$correspondingModuleInfos)}));
    }

    private static final boolean hasProductionRoots(Module $this$hasProductionRoots) {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"JavaSourceRootType.SOURCE");
        return IdeaModuleInfosKt.hasRootsOfType($this$hasProductionRoots, (JpsModuleSourceRootType)javaSourceRootType) || IdeaModuleInfosKt.hasRootsOfType($this$hasProductionRoots, (JpsModuleSourceRootType)SourceKotlinRootType.INSTANCE) || MultiplatformUtilKt.isNewMPPModule($this$hasProductionRoots) && MultiplatformUtilKt.getSourceType($this$hasProductionRoots) == SourceType.PRODUCTION;
    }

    private static final boolean hasTestRoots(Module $this$hasTestRoots) {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.TEST_SOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"JavaSourceRootType.TEST_SOURCE");
        return IdeaModuleInfosKt.hasRootsOfType($this$hasTestRoots, (JpsModuleSourceRootType)javaSourceRootType) || IdeaModuleInfosKt.hasRootsOfType($this$hasTestRoots, (JpsModuleSourceRootType)TestSourceKotlinRootType.INSTANCE) || MultiplatformUtilKt.isNewMPPModule($this$hasTestRoots) && MultiplatformUtilKt.getSourceType($this$hasTestRoots) == SourceType.TEST;
    }

    private static final boolean hasRootsOfType(Module $this$hasRootsOfType, JpsModuleSourceRootType<?> sourceRootType) {
        boolean bl;
        block1: {
            ContentEntry[] contentEntryArray = ProjectRootsUtilKt.getRootManager($this$hasRootsOfType).getContentEntries();
            Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"rootManager.contentEntries");
            ContentEntry[] $this$any$iv = contentEntryArray;
            boolean $i$f$any = false;
            ContentEntry[] contentEntryArray2 = $this$any$iv;
            int n = contentEntryArray2.length;
            for (int i = 0; i < n; ++i) {
                ContentEntry element$iv;
                ContentEntry it = element$iv = contentEntryArray2[i];
                boolean bl2 = false;
                List list = it.getSourceFolders(sourceRootType);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.getSourceFolders(sourceRootType)");
                Collection collection = list;
                boolean bl3 = false;
                if (!(!collection.isEmpty())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isLibraryClasses(@NotNull IdeaModuleInfo $this$isLibraryClasses) {
        Intrinsics.checkNotNullParameter((Object)$this$isLibraryClasses, (String)"$this$isLibraryClasses");
        return $this$isLibraryClasses instanceof SdkInfo || $this$isLibraryClasses instanceof LibraryInfo;
    }

    @NotNull
    public static final ModuleDescriptor.Capability<ModuleOrigin> getOriginCapability() {
        return OriginCapability;
    }

    @Nullable
    public static final List<ModuleSourceInfo> projectSourceModules(@NotNull IdeaModuleInfo $this$projectSourceModules) {
        List<ModuleSourceInfo> list;
        block6: {
            IdeaModuleInfo ideaModuleInfo;
            block5: {
                Intrinsics.checkNotNullParameter((Object)$this$projectSourceModules, (String)"$this$projectSourceModules");
                IdeaModuleInfo ideaModuleInfo2 = $this$projectSourceModules;
                if (!(ideaModuleInfo2 instanceof ModuleSourceInfo)) {
                    ideaModuleInfo2 = null;
                }
                if ((list = (ModuleSourceInfo)ideaModuleInfo2) == null) break block5;
                ModuleSourceInfo moduleSourceInfo = list;
                boolean bl = false;
                boolean bl2 = false;
                ModuleSourceInfo p1 = moduleSourceInfo;
                boolean bl3 = false;
                list = CollectionsKt.listOf((Object)p1);
                if (list != null) break block6;
            }
            if (!((ideaModuleInfo = $this$projectSourceModules) instanceof PlatformModuleInfo)) {
                ideaModuleInfo = null;
            }
            PlatformModuleInfo platformModuleInfo = (PlatformModuleInfo)ideaModuleInfo;
            list = platformModuleInfo != null ? platformModuleInfo.getContainedModules() : null;
        }
        return list;
    }

    @NotNull
    public static final SourceType getSourceType(@NotNull ModuleSourceInfo $this$sourceType) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceType, (String)"$this$sourceType");
        return $this$sourceType instanceof ModuleTestSourceInfo ? SourceType.TEST : SourceType.PRODUCTION;
    }

    static {
        Logger logger = Logger.getInstance(IdeaModuleInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(IdeaModuleInfo::class.java)");
        LOG = logger;
        OriginCapability = new ModuleDescriptor.Capability("MODULE_ORIGIN");
    }

    public static final /* synthetic */ List access$ideaModelDependencies(Module module, boolean forProduction, TargetPlatform platform) {
        return IdeaModuleInfosKt.ideaModelDependencies(module, forProduction, platform);
    }

    public static final /* synthetic */ boolean access$acceptAsDependency(OrderEntry $this$access_u24acceptAsDependency, boolean forProduction) {
        return IdeaModuleInfosKt.acceptAsDependency($this$access_u24acceptAsDependency, forProduction);
    }

    public static final /* synthetic */ List access$orderEntryToModuleInfo(Project project, OrderEntry orderEntry, boolean forProduction) {
        return IdeaModuleInfosKt.orderEntryToModuleInfo(project, orderEntry, forProduction);
    }
}

