/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.listener;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.DefaultScriptChangeListener;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangeListener;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangesNotifier;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangesNotifier;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultListener", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/DefaultScriptChangeListener;", "listeners", "", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangeListener;", "scriptChangesListenerDelay", "", "scriptsQueue", "Lcom/intellij/util/Alarm;", "areListenersDisabled", "", "getListener", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "listenForChangesInScripts", "", "kotlin.core"})
public final class ScriptChangesNotifier {
    private final Alarm scriptsQueue;
    private final int scriptChangesListenerDelay;
    private final DefaultScriptChangeListener defaultListener;
    private final Collection<ScriptChangeListener> listeners;
    private final Project project;

    private final void listenForChangesInScripts() {
        this.project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ ScriptChangesNotifier this$0;

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.runScriptDependenciesUpdateIfNeeded(file);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    VirtualFile virtualFile = event.getNewFile();
                    if (virtualFile == null) break block0;
                    VirtualFile virtualFile2 = virtualFile;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile it = virtualFile2;
                    boolean bl3 = false;
                    this.runScriptDependenciesUpdateIfNeeded(it);
                }
            }

            private final void runScriptDependenciesUpdateIfNeeded(VirtualFile file) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    ScriptChangeListener scriptChangeListener = ScriptChangesNotifier.access$getListener(this.this$0, ScriptChangesNotifier.access$getProject$p(this.this$0), file);
                    if (scriptChangeListener != null) {
                        scriptChangeListener.editorActivated(file);
                    }
                } else {
                    AppExecutorUtil.getAppExecutorService().submit(new Runnable(this, file){
                        final /* synthetic */ listenForChangesInScripts.1 this$0;
                        final /* synthetic */ VirtualFile $file;

                        public final void run() {
                            block0: {
                                ScriptChangeListener scriptChangeListener = ScriptChangesNotifier.access$getListener(this.this$0.this$0, ScriptChangesNotifier.access$getProject$p(this.this$0.this$0), this.$file);
                                if (scriptChangeListener == null) break block0;
                                scriptChangeListener.editorActivated(this.$file);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$file = virtualFile;
                        }
                    });
                }
            }
            {
                this.this$0 = this$0;
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ ScriptChangesNotifier this$0;

            public void documentChanged(@NotNull DocumentEvent event) {
                Object object;
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Document document = event.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.document");
                        Document document2 = document;
                        object = FileDocumentManager.getInstance().getFile(document2);
                        if (object == null) break block8;
                        VirtualFile virtualFile = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        VirtualFile it = virtualFile;
                        boolean bl3 = false;
                        VirtualFile virtualFile2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                        object = virtualFile2.isInLocalFileSystem() ? virtualFile : null;
                        if (object != null) break block9;
                    }
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"FileDocumentManager.getI\u2026calFileSystem } ?: return");
                VirtualFile file = object;
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)ScriptChangesNotifier.access$getProject$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
                Object[] objectArray = fileEditorManager.getOpenFiles();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FileEditorManager.getInstance(project).openFiles");
                if (!ArraysKt.contains((Object[])objectArray, (Object)file)) {
                    return;
                }
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    ScriptChangeListener scriptChangeListener = ScriptChangesNotifier.access$getListener(this.this$0, ScriptChangesNotifier.access$getProject$p(this.this$0), file);
                    if (scriptChangeListener != null) {
                        scriptChangeListener.documentChanged(file);
                    }
                } else {
                    ScriptChangesNotifier.access$getScriptsQueue$p(this.this$0).cancelAllRequests();
                    ScriptChangesNotifier.access$getScriptsQueue$p(this.this$0).addRequest(new Runnable(this, file){
                        final /* synthetic */ listenForChangesInScripts.2 this$0;
                        final /* synthetic */ VirtualFile $file;

                        public final void run() {
                            block0: {
                                ScriptChangeListener scriptChangeListener = ScriptChangesNotifier.access$getListener(this.this$0.this$0, ScriptChangesNotifier.access$getProject$p(this.this$0.this$0), this.$file);
                                if (scriptChangeListener == null) break block0;
                                scriptChangeListener.documentChanged(this.$file);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$file = virtualFile;
                        }
                    }, ScriptChangesNotifier.access$getScriptChangesListenerDelay$p(this.this$0), true);
                }
            }
            {
                this.this$0 = this$0;
            }
        }, (Disposable)this.project.getMessageBus().connect());
    }

    private final ScriptChangeListener getListener(Project project, VirtualFile file) {
        Object v0;
        block2: {
            if (project.isDisposed() || this.areListenersDisabled()) {
                return null;
            }
            Iterable $this$firstOrNull$iv = this.listeners;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ScriptChangeListener it = (ScriptChangeListener)element$iv;
                boolean bl = false;
                if (!it.isApplicable(file)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean areListenersDisabled() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) return false;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        if (!Intrinsics.areEqual((Object)ScriptUtilsKt.isScriptChangesNotifierDisabled(application2), (Object)true)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public ScriptChangesNotifier(@NotNull Project project) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.scriptsQueue = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.project);
        this.scriptChangesListenerDelay = 1400;
        this.listenForChangesInScripts();
        this.defaultListener = new DefaultScriptChangeListener(this.project);
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List list2 = list;
        ScriptChangesNotifier scriptChangesNotifier = this;
        boolean bl4 = false;
        ExtensionPoint extensionPoint = ScriptChangeListener.Companion.getLISTENER().getPoint((AreaInstance)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"LISTENER.getPoint(project)");
        List list3 = extensionPoint.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"LISTENER.getPoint(project).extensionList");
        $this$apply.addAll(list3);
        $this$apply.add(this.defaultListener);
        Unit unit = Unit.INSTANCE;
        scriptChangesNotifier.listeners = list;
    }

    public static final /* synthetic */ ScriptChangeListener access$getListener(ScriptChangesNotifier $this, Project project, VirtualFile file) {
        return $this.getListener(project, file);
    }

    public static final /* synthetic */ Project access$getProject$p(ScriptChangesNotifier $this) {
        return $this.project;
    }

    public static final /* synthetic */ Alarm access$getScriptsQueue$p(ScriptChangesNotifier $this) {
        return $this.scriptsQueue;
    }

    public static final /* synthetic */ int access$getScriptChangesListenerDelay$p(ScriptChangesNotifier $this) {
        return $this.scriptChangesListenerDelay;
    }
}

