/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.classFile.AnnotationLoaderForClassFileStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.classFile.ClassFileDecompilerUtilKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedDataFinder;
import org.jetbrains.kotlin.idea.decompiler.classFile.KotlinClsStubBuilder$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationAndConstantLoader;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/KotlinClsStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "createStubBuilderComponents", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderComponents;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "fileContent", "", "doBuildFileStub", "Lorg/jetbrains/kotlin/psi/KtFile;", "getStubVersion", "", "Companion", "kotlin.core"})
public class KotlinClsStubBuilder
extends ClsStubBuilder {
    @NotNull
    private static final Logger LOG;
    private static final String VERSIONED_PATH_MARKER;
    public static final Companion Companion;

    public int getStubVersion() {
        return 97;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        VirtualFile virtualFile = content2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"content.file");
        VirtualFile virtualFile2 = virtualFile;
        if (ClassFileDecompilerUtilKt.isKotlinInternalCompiledFile(virtualFile2, content2.getContent())) {
            return null;
        }
        if (Companion.isVersioned(virtualFile2)) {
            return null;
        }
        byte[] byArray = content2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"content.content");
        return this.doBuildFileStub(virtualFile2, byArray);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final PsiFileStub<KtFile> doBuildFileStub(VirtualFile file, byte[] fileContent) {
        v0 = IDEKotlinBinaryClassCache.Companion.getInstance().getKotlinBinaryClass(file, fileContent);
        if (v0 == null) {
            var4_3 = "Can't find binary class for Kotlin file: " + file;
            var5_5 = false;
            throw (Throwable)new IllegalStateException(var4_3.toString());
        }
        kotlinClass = v0;
        header = kotlinClass.getClassHeader();
        classId = kotlinClass.getClassId();
        v1 = header.getPackageName();
        if (v1 != null) {
            var7_8 = v1;
            var8_9 = false;
            var9_12 = false;
            it = var7_8;
            $i$a$-let-KotlinClsStubBuilder$doBuildFileStub$packageFqName$1 = false;
            v2 = new FqName(it);
        } else {
            v3 = classId.getPackageFqName();
            v2 = v3;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"classId.packageFqName");
        }
        packageFqName = v2;
        if (!header.getMetadataVersion().isCompatible()) {
            return (PsiFileStub)ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        components = this.createStubBuilderComponents(file, packageFqName, fileContent);
        if (header.getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS) {
            partFiles = ClassFileDecompilerUtilKt.findMultifileClassParts(file, classId, header.getMultifilePartNames());
            v4 = classId.asSingleFqName();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"classId.asSingleFqName()");
            return (PsiFileStub)ClsStubBuildingKt.createMultifileClassStub(header, partFiles, v4, components);
        }
        annotationData = header.getData();
        if (annotationData == null) {
            KotlinClsStubBuilder.LOG.error("Corrupted kotlin header for file " + file.getName());
            return null;
        }
        strings = header.getStrings();
        if (strings == null) {
            KotlinClsStubBuilder.LOG.error("String table not found in file " + file.getName());
            return null;
        }
        switch (KotlinClsStubBuilder$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                if (classId.isLocal()) {
                    return null;
                }
                var12_19 = JvmProtoBufUtil.readClassDataFrom((String[])annotationData, (String[])strings);
                it = (JvmNameResolver)var12_19.component1();
                classProto = (ProtoBuf.Class)var12_19.component2();
                if ((ProtoBuf.Visibility)Flags.VISIBILITY.get(classProto.getFlags()) == ProtoBuf.Visibility.LOCAL) {
                    return null;
                }
                v5 = (NameResolver)nameResolver;
                v6 = classProto.getTypeTable();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"classProto.typeTable");
                context = components.createContext(v5, packageFqName, new TypeTable(v6));
                v7 = (PsiFileStub)ClsStubBuildingKt.createTopLevelClassStub(classId, classProto, (SourceElement)new KotlinJvmBinarySourceElement(kotlinClass, null, false, false, 14, null), context, header.isScript());
                break;
            }
            case 2: {
                context /* !! */  = JvmProtoBufUtil.readPackageDataFrom((String[])annotationData, (String[])strings);
                nameResolver = (JvmNameResolver)context /* !! */ .component1();
                packageProto = (ProtoBuf.Package)context /* !! */ .component2();
                v8 = (NameResolver)nameResolver;
                v9 = packageProto.getTypeTable();
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"packageProto.typeTable");
                context /* !! */  = components.createContext(v8, packageFqName, new TypeTable(v9));
                v10 = header.getPackageName();
                if (v10 == null) ** GOTO lbl70
                var14_21 = v10;
                var15_22 = false;
                var16_23 = false;
                it = var14_21;
                $i$a$-let-KotlinClsStubBuilder$doBuildFileStub$fqName$1 = false;
                v10 = new ClassId(new FqName(it), classId.getRelativeClassName(), classId.isLocal()).asSingleFqName();
                if (v10 != null) ** GOTO lbl71
lbl70:
                // 2 sources

                v10 = classId.asSingleFqName();
lbl71:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"header.packageName?.let \u2026 classId.asSingleFqName()");
                fqName = v10;
                v7 = (PsiFileStub)ClsStubBuildingKt.createFileFacadeStub(packageProto, (FqName)fqName, (ClsStubBuilderContext)context /* !! */ );
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Should have processed " + file.getPath() + " with header " + header);
            }
        }
        return v7;
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(VirtualFile file, FqName packageFqName, byte[] fileContent) {
        VirtualFile virtualFile = file.getParent();
        Intrinsics.checkNotNull((Object)virtualFile);
        DirectoryBasedClassFinder classFinder = new DirectoryBasedClassFinder(virtualFile, packageFqName);
        DirectoryBasedDataFinder classDataFinder = new DirectoryBasedDataFinder(classFinder, LOG);
        AnnotationLoaderForClassFileStubBuilder annotationLoader = new AnnotationLoaderForClassFileStubBuilder(classFinder, file, fileContent);
        return new ClsStubBuilderComponents(classDataFinder, (AnnotationAndConstantLoader<ClassId, Unit>)((AnnotationAndConstantLoader)annotationLoader), file);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinClsStubBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Kotli\u2026sStubBuilder::class.java)");
        LOG = logger;
        VERSIONED_PATH_MARKER = "!/META-INF/versions/";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/KotlinClsStubBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "VERSIONED_PATH_MARKER", "", "isVersioned", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.core"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public final boolean isVersioned(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            String string = virtualFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.path");
            return StringsKt.contains$default((CharSequence)string, (CharSequence)VERSIONED_PATH_MARKER, (boolean)false, (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

