/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.DuplicateJvmSignatureUtilKt;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiChecker;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DuplicateJvmSignatureAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "kotlin.core"})
public final class DuplicateJvmSignatureAnnotator
implements Annotator {
    /*
     * WARNING - void declaration
     */
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        BindingContext bindingContext;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element2 instanceof KtFile) && !(element2 instanceof KtDeclaration)) {
            return;
        }
        if (!ProjectRootsUtil.isInProjectSource$default(element2, false, 2, null)) {
            return;
        }
        PsiFile file = element2.getContainingFile();
        if (!(file instanceof KtFile) || !JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetector.getPlatform((KtFile)file))) {
            return;
        }
        PsiElement psiElement = element2;
        if (psiElement instanceof KtDeclaration) {
            bindingContext = ResolutionUtils.analyzeWithContent((KtDeclaration)((KtDeclaration)element2));
        } else if (psiElement instanceof KtFile) {
            void $this$analyzeWithContent$iv$iv;
            KtDeclarationContainer $this$analyzeWithContent$iv = (KtDeclarationContainer)element2;
            boolean $i$f$analyzeWithContent = false;
            KtDeclarationContainer ktDeclarationContainer = $this$analyzeWithContent$iv;
            ResolutionFacade resolutionFacade$iv$iv = ResolutionUtils.getResolutionFacade((KtElement)((KtElement)$this$analyzeWithContent$iv));
            boolean $i$f$analyzeWithContent2 = false;
            bindingContext = resolutionFacade$iv$iv.analyzeWithAllCompilerChecks((Collection)CollectionsKt.listOf((Object)$this$analyzeWithContent$iv$iv)).getBindingContext();
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("DuplicateJvmSignatureAnnotator: should not get here! Element: " + element2.getText())));
        }
        Diagnostics diagnostics = bindingContext.getDiagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"when (element) {\n       \u2026}\")\n        }.diagnostics");
        Diagnostics otherDiagnostics = diagnostics;
        GlobalSearchScope moduleScope = GetModuleInfoKt.getModuleInfo(element2).contentScope();
        Diagnostics diagnostics2 = DuplicateJvmSignatureUtilKt.getJvmSignatureDiagnostics((PsiElement)element2, (Diagnostics)otherDiagnostics, (GlobalSearchScope)moduleScope);
        if (diagnostics2 == null) {
            return;
        }
        Diagnostics diagnostics3 = diagnostics2;
        new KotlinPsiChecker().annotateElement(element2, holder, diagnostics3);
    }
}

