/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTabbedPane;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.ObjectArrayAssert;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.data.Index;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTabbedPaneLocation;
import org.fest.swing.driver.JTabbedPaneSelectTabTask;
import org.fest.swing.driver.JTabbedPaneTabTitlesQuery;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.InternalApi;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

@InternalApi
public class JTabbedPaneDriver
extends JComponentDriver {
    private final JTabbedPaneLocation location;

    public JTabbedPaneDriver(@Nonnull Robot robot) {
        this(robot, new JTabbedPaneLocation());
    }

    @VisibleForTesting
    JTabbedPaneDriver(@Nonnull Robot robot, @Nonnull JTabbedPaneLocation location) {
        super(robot);
        this.location = location;
    }

    @Nonnull
    @RunsInEDT
    public String[] tabTitles(@Nonnull JTabbedPane tabbedPane) {
        return JTabbedPaneTabTitlesQuery.tabTitlesOf(tabbedPane);
    }

    @RunsInEDT
    public void selectTab(@Nonnull JTabbedPane tabbedPane, @Nullable String title) {
        this.selectTab(tabbedPane, new StringTextMatcher(title));
    }

    @RunsInEDT
    public void selectTab(@Nonnull JTabbedPane tabbedPane, @Nonnull Pattern pattern) {
        this.selectTab(tabbedPane, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectTab(@Nonnull JTabbedPane tabbedPane, @Nonnull TextMatcher matcher) {
        Pair<Integer, Point> tabToSelectInfo = JTabbedPaneDriver.tabToSelectInfo(this.location(), tabbedPane, matcher);
        Point target = (Point)tabToSelectInfo.second;
        if (target != null) {
            try {
                this.click(tabbedPane, target);
            }
            catch (ActionFailedException e) {
                this.setTabDirectly(tabbedPane, (Integer)tabToSelectInfo.first);
            }
            return;
        }
        this.setTabDirectly(tabbedPane, (Integer)tabToSelectInfo.first);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Integer, Point> tabToSelectInfo(final @Nonnull JTabbedPaneLocation location, final @Nonnull JTabbedPane tabbedPane, final @Nonnull TextMatcher matcher) {
        Pair<Integer, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tabbedPane);
                int index = location.indexOf(tabbedPane, matcher);
                location.checkIndexInBounds(tabbedPane, index);
                Point point = null;
                try {
                    point = location.pointAt(tabbedPane, index);
                }
                catch (LocationUnavailableException locationUnavailableException) {
                    // empty catch block
                }
                return Pair.of(index, point);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    public void selectTab(@Nonnull JTabbedPane tabbedPane, int index) {
        try {
            Point p = JTabbedPaneDriver.pointAtTabWhenShowing(this.location(), tabbedPane, index);
            this.click(tabbedPane, p);
        }
        catch (LocationUnavailableException e) {
            this.setTabDirectly(tabbedPane, index);
        }
        catch (ActionFailedException e) {
            this.setTabDirectly(tabbedPane, index);
        }
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtTabWhenShowing(final @Nonnull JTabbedPaneLocation location, final @Nonnull JTabbedPane tabbedPane, final int index) {
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                location.checkIndexInBounds(tabbedPane, index);
                ComponentPreconditions.checkEnabledAndShowing(tabbedPane);
                return location.pointAt(tabbedPane, index);
            }
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @RunsInEDT
    @VisibleForTesting
    void setTabDirectly(@Nonnull JTabbedPane tabbedPane, int index) {
        JTabbedPaneSelectTabTask.setSelectedTab(tabbedPane, index);
        this.robot.waitForIdle();
        this.moveMouseToTab(tabbedPane, index);
    }

    private void moveMouseToTab(@Nonnull JTabbedPane tabbedPane, int index) {
        try {
            Point p = JTabbedPaneDriver.pointAtTab(this.location(), tabbedPane, index);
            this.robot.moveMouse(tabbedPane, p);
            this.robot.waitForIdle();
        }
        catch (LocationUnavailableException locationUnavailableException) {
            // empty catch block
        }
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtTab(final @Nonnull JTabbedPaneLocation location, final @Nonnull JTabbedPane tabbedPane, final int index) {
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                return location.pointAt(tabbedPane, index);
            }
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @Nullable
    @RunsInEDT
    public Component selectedComponentOf(@Nonnull JTabbedPane tabbedPane) {
        return JTabbedPaneDriver.selectedComponent(tabbedPane);
    }

    @Nullable
    @RunsInEDT
    private static Component selectedComponent(final JTabbedPane tabbedPane) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                return tabbedPane.getSelectedComponent();
            }
        });
    }

    @RunsInEDT
    public void requireTabTitle(@Nonnull JTabbedPane tabbedPane, @Nullable String title, @Nonnull Index index) {
        String actualTitle = JTabbedPaneDriver.titleAt(tabbedPane, index);
        TextAssert.verifyThat(actualTitle).as(this.titleAtProperty(tabbedPane)).isEqualOrMatches(title);
    }

    @RunsInEDT
    public void requireTabTitle(@Nonnull JTabbedPane tabbedPane, @Nonnull Pattern pattern, @Nonnull Index index) {
        String actualTitle = JTabbedPaneDriver.titleAt(tabbedPane, index);
        TextAssert.verifyThat(actualTitle).as(this.titleAtProperty(tabbedPane)).matches(pattern);
    }

    @RunsInEDT
    private Description titleAtProperty(@Nonnull JTabbedPane tabbedPane) {
        return JTabbedPaneDriver.propertyName(tabbedPane, "titleAt");
    }

    @Nullable
    @RunsInEDT
    private static String titleAt(final @Nonnull JTabbedPane tabbedPane, final @Nonnull Index index) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                return tabbedPane.getTitleAt(index.value);
            }
        });
    }

    @RunsInEDT
    public void requireTabTitles(@Nonnull JTabbedPane tabbedPane, @Nonnull String[] titles) {
        Object[] actualTitles = JTabbedPaneDriver.allTabTitlesIn(tabbedPane);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])actualTitles).as(JTabbedPaneDriver.propertyName(tabbedPane, "tabTitles"))).isEqualTo((Object[])titles);
    }

    @Nonnull
    @RunsInEDT
    private static String[] allTabTitlesIn(final @Nonnull JTabbedPane tabbedPane) {
        String[] result = GuiActionRunner.execute(new GuiQuery<String[]>(){

            @Override
            protected String[] executeInEDT() {
                ArrayList allTitles = Lists.newArrayList();
                int tabCount = tabbedPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    allTitles.add(tabbedPane.getTitleAt(i));
                }
                return allTitles.toArray(new String[allTitles.size()]);
            }
        });
        return (String[])Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    private JTabbedPaneLocation location() {
        return this.location;
    }
}

