/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.monitor.WindowMetrics;
import org.fest.swing.monitor.Windows;
import org.fest.swing.query.ComponentSizeQuery;
import org.fest.swing.util.RobotFactory;

class WindowStatus {
    private static final Dimension MINIMUM_WINDOW_SIZE = new Dimension(50, 30);
    private static Logger logger = Logger.getLogger(WindowStatus.class.getCanonicalName());
    private static int sign = 1;
    private final Windows windows;
    final Robot robot;

    WindowStatus(@Nonnull Windows windows) {
        this(windows, new RobotFactory());
    }

    WindowStatus(@Nonnull Windows windows, @Nonnull RobotFactory robotFactory) {
        this.windows = windows;
        Robot r = null;
        try {
            r = robotFactory.newRobotInPrimaryScreen();
        }
        catch (AWTException ignored) {
            logger.log(Level.WARNING, "Error ocurred when creating a new Robot", ignored);
        }
        this.robot = r;
    }

    @Nonnull
    Windows windows() {
        return this.windows;
    }

    @RunsInEDT
    void checkIfReady(@Nonnull Window w) {
        if (this.robot == null) {
            return;
        }
        try {
            this.checkSafelyIfReady(w);
        }
        catch (Exception ignored) {
            logger.log(Level.WARNING, "Error ocurred when checking if window is ready", ignored);
        }
    }

    @RunsInEDT
    private void checkSafelyIfReady(final @Nonnull Window w) {
        if (!this.windows.isShowingButNotReady(w)) {
            return;
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                WindowStatus.this.makeLargeEnoughToReceiveEvents(w);
            }
        });
        this.mouseMove(w, WindowStatus.centerOf(w));
    }

    @RunsInEDT
    private static Point centerOf(final @Nonnull Window w) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                return WindowMetrics.absoluteCenterOf(w);
            }
        });
    }

    @RunsInEDT
    private void mouseMove(@Nonnull Window w, @Nonnull Point point) {
        int x = point.x;
        int y = point.y;
        if (x == 0 || y == 0) {
            return;
        }
        this.robot.mouseMove(x, y);
        Dimension windowSize = ComponentSizeQuery.sizeOf(w);
        if (windowSize.width > windowSize.height) {
            this.robot.mouseMove(x + sign, y);
        } else {
            this.robot.mouseMove(x, y + sign);
        }
        sign = -sign;
    }

    @RunsInCurrentThread
    private void makeLargeEnoughToReceiveEvents(@Nonnull Window window) {
        if (!this.shouldResize(window)) {
            return;
        }
        window.setSize(MINIMUM_WINDOW_SIZE);
    }

    @RunsInCurrentThread
    private boolean shouldResize(@Nonnull Window window) {
        Insets insets = window.getInsets();
        int w = window.getWidth() - (insets.left + insets.right);
        if (w < WindowStatus.MINIMUM_WINDOW_SIZE.width) {
            return true;
        }
        int h = window.getHeight() - (insets.top + insets.bottom);
        return h < WindowStatus.MINIMUM_WINDOW_SIZE.height;
    }

    static int sign() {
        return sign;
    }
}

