/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.lifecycle.internal;

import java.util.List;
import org.gradle.internal.impldep.org.apache.maven.execution.MavenSession;
import org.gradle.internal.impldep.org.apache.maven.execution.ProjectDependencyGraph;
import org.gradle.internal.impldep.org.apache.maven.lifecycle.internal.TaskSegment;
import org.gradle.internal.impldep.org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectSegment {
    private final MavenProject project;
    private final TaskSegment taskSegment;
    private final MavenSession session;
    private final List<MavenProject> nonTransitiveUpstreamProjects;
    private final List<MavenProject> transitiveUpstreamProjects;

    public ProjectSegment(MavenProject project, TaskSegment taskSegment, MavenSession copiedSession) {
        this.project = project;
        this.taskSegment = taskSegment;
        this.session = copiedSession;
        ProjectDependencyGraph dependencyGraph = this.getSession().getProjectDependencyGraph();
        this.nonTransitiveUpstreamProjects = dependencyGraph.getUpstreamProjects(this.getProject(), false);
        this.transitiveUpstreamProjects = dependencyGraph.getUpstreamProjects(this.getProject(), true);
    }

    public MavenSession getSession() {
        return this.session;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public TaskSegment getTaskSegment() {
        return this.taskSegment;
    }

    public List<MavenProject> getImmediateUpstreamProjects() {
        return this.nonTransitiveUpstreamProjects;
    }

    public List<MavenProject> getTransitiveUpstreamProjects() {
        return this.transitiveUpstreamProjects;
    }

    public String toString() {
        return this.getProject().getId() + " -> " + this.getTaskSegment();
    }
}

