/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.maven.plugin.ExtensionRealmCache;
import org.gradle.internal.impldep.org.apache.maven.project.ExtensionDescriptor;
import org.gradle.internal.impldep.org.apache.maven.project.MavenProject;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ExtensionRealmCache.class)
public class DefaultExtensionRealmCache
implements ExtensionRealmCache {
    private final Map<CacheKey, ExtensionRealmCache.CacheRecord> cache = new HashMap<CacheKey, ExtensionRealmCache.CacheRecord>();

    @Override
    public ExtensionRealmCache.CacheRecord get(List<? extends Artifact> extensionArtifacts) {
        return this.cache.get(new CacheKey(extensionArtifacts));
    }

    @Override
    public ExtensionRealmCache.CacheRecord put(List<? extends Artifact> extensionArtifacts, ClassRealm extensionRealm, ExtensionDescriptor extensionDescriptor) {
        if (extensionRealm == null) {
            throw new NullPointerException();
        }
        CacheKey key = new CacheKey(extensionArtifacts);
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate extension realm for extension " + extensionArtifacts);
        }
        ExtensionRealmCache.CacheRecord record = new ExtensionRealmCache.CacheRecord(extensionRealm, extensionDescriptor);
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    @Override
    public void register(MavenProject project, ExtensionRealmCache.CacheRecord record) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheKey {
        private final List<File> files;
        private final List<Long> timestamps;
        private final List<Long> sizes;
        private final List<String> ids;
        private final int hashCode;

        public CacheKey(List<? extends Artifact> extensionArtifacts) {
            this.files = new ArrayList<File>(extensionArtifacts.size());
            this.timestamps = new ArrayList<Long>(extensionArtifacts.size());
            this.sizes = new ArrayList<Long>(extensionArtifacts.size());
            this.ids = new ArrayList<String>(extensionArtifacts.size());
            for (Artifact artifact : extensionArtifacts) {
                File file = artifact.getFile();
                this.files.add(file);
                this.timestamps.add(file != null ? Long.valueOf(file.lastModified()) : Long.valueOf(0L));
                this.sizes.add(file != null ? Long.valueOf(file.length()) : Long.valueOf(0L));
                this.ids.add(artifact.getVersion());
            }
            this.hashCode = 31 * ((Object)this.files).hashCode() + 31 * ((Object)this.ids).hashCode() + 31 * ((Object)this.timestamps).hashCode() + 31 * ((Object)this.sizes).hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return ((Object)this.ids).equals(other.ids) && ((Object)this.files).equals(other.files) && ((Object)this.timestamps).equals(other.timestamps) && ((Object)this.sizes).equals(other.sizes);
        }
    }
}

