/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.internal.impldep.org.sonatype.aether.impl.LocalRepositoryProvider;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalRepository;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalRepositoryManager;
import org.gradle.internal.impldep.org.sonatype.aether.repository.NoLocalRepositoryManagerException;
import org.gradle.internal.impldep.org.sonatype.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.gradle.internal.impldep.org.sonatype.aether.spi.locator.Service;
import org.gradle.internal.impldep.org.sonatype.aether.spi.locator.ServiceLocator;
import org.gradle.internal.impldep.org.sonatype.aether.spi.log.Logger;
import org.gradle.internal.impldep.org.sonatype.aether.spi.log.NullLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=LocalRepositoryProvider.class)
public class DefaultLocalRepositoryProvider
implements LocalRepositoryProvider,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement(role=LocalRepositoryManagerFactory.class)
    private List<LocalRepositoryManagerFactory> managerFactories = new ArrayList<LocalRepositoryManagerFactory>();
    private static final Comparator<LocalRepositoryManagerFactory> COMPARATOR = new Comparator<LocalRepositoryManagerFactory>(){

        @Override
        public int compare(LocalRepositoryManagerFactory o1, LocalRepositoryManagerFactory o2) {
            return o2.getPriority() - o1.getPriority();
        }
    };

    @Override
    public void initService(ServiceLocator locator) {
        this.setLogger(locator.getService(Logger.class));
        this.setLocalRepositoryManagerFactories(locator.getServices(LocalRepositoryManagerFactory.class));
    }

    public DefaultLocalRepositoryProvider setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public DefaultLocalRepositoryProvider setLocalRepositoryManagerFactories(List<LocalRepositoryManagerFactory> factories) {
        this.managerFactories = factories == null ? new ArrayList<LocalRepositoryManagerFactory>(2) : factories;
        return this;
    }

    public DefaultLocalRepositoryProvider addLocalRepositoryManagerFactory(LocalRepositoryManagerFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Local repository manager factory has not been specified.");
        }
        this.managerFactories.add(factory);
        return this;
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(LocalRepository localRepository) throws NoLocalRepositoryManagerException {
        ArrayList<LocalRepositoryManagerFactory> factories = new ArrayList<LocalRepositoryManagerFactory>(this.managerFactories);
        Collections.sort(factories, COMPARATOR);
        for (LocalRepositoryManagerFactory factory : factories) {
            try {
                LocalRepositoryManager manager = factory.newInstance(localRepository);
                if (this.logger.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using manager ").append(manager.getClass().getSimpleName());
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(localRepository.getBasedir());
                    this.logger.debug(buffer.toString());
                }
                return manager;
            }
            catch (NoLocalRepositoryManagerException e) {
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("No manager available for local repository ");
        buffer.append(localRepository.getBasedir());
        buffer.append(" of type ").append(localRepository.getContentType());
        buffer.append(" using the available factories ");
        ListIterator it = factories.listIterator();
        while (it.hasNext()) {
            LocalRepositoryManagerFactory factory = (LocalRepositoryManagerFactory)it.next();
            buffer.append(factory.getClass().getSimpleName());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        throw new NoLocalRepositoryManagerException(localRepository, buffer.toString());
    }
}

