/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.action;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.EncapsulatableClassMember;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import java.util.List;

public abstract class BaseRefactorHandler
implements Runnable {
    protected final Project project;
    protected final Editor editor;
    private final MemberChooser<ClassMember> chooser;

    public BaseRefactorHandler(DataContext dataContext, Project project) {
        this.project = project;
        this.editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiClass psiClass = OverrideImplementUtil.getContextClass((Project)project, (Editor)this.editor, (PsiFile)psiFile, (boolean)false);
        List<EncapsulatableClassMember> classMembers = this.getEncapsulatableClassMembers(psiClass);
        this.chooser = new MemberChooser(classMembers.toArray(ClassMember.EMPTY_ARRAY), true, true, project);
        this.chooser.setTitle(this.getChooserTitle());
        this.chooser.setCopyJavadocVisible(false);
    }

    public boolean processChooser() {
        this.chooser.show();
        List selectedElements = this.chooser.getSelectedElements();
        if (selectedElements == null) {
            HintManager.getInstance().showErrorHint(this.editor, this.getNothingFoundMessage());
            return false;
        }
        if (selectedElements.isEmpty()) {
            HintManager.getInstance().showErrorHint(this.editor, this.getNothingAcceptedMessage());
            return false;
        }
        return true;
    }

    protected abstract String getChooserTitle();

    protected abstract String getNothingFoundMessage();

    protected abstract String getNothingAcceptedMessage();

    protected abstract List<EncapsulatableClassMember> getEncapsulatableClassMembers(PsiClass var1);

    @Override
    public void run() {
        if (!EditorModificationUtil.checkModificationAllowed((Editor)this.editor)) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(this.editor.getDocument(), this.project)) {
            return;
        }
        this.process(this.chooser.getSelectedElements());
    }

    protected abstract void process(List<ClassMember> var1);
}

