/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.handler;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.InitializationUtils;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import org.jetbrains.annotations.NotNull;

public final class LazyGetterHandler {
    public static boolean isLazyGetterHandled(@NotNull PsiElement element) {
        if (element == null) {
            LazyGetterHandler.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (field == null) {
            return false;
        }
        PsiAnnotation getterAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)field, "lombok.Getter");
        return null != getterAnnotation && PsiAnnotationUtil.getBooleanAnnotationValue(getterAnnotation, "lazy", false);
    }

    public static boolean isInitializedInConstructors(@NotNull PsiElement element) {
        if (element == null) {
            LazyGetterHandler.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement qualifier = ((PsiReferenceExpression)parent).getQualifier();
        if (qualifier == null) {
            return false;
        }
        PsiReference reference = qualifier.getReference();
        if (reference == null) {
            return false;
        }
        PsiElement field = reference.resolve();
        if (!(field instanceof PsiField)) {
            return false;
        }
        PsiClass containingClass = ((PsiField)field).getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return LazyGetterHandler.isInitializedInConstructors((PsiField)field, containingClass);
    }

    private static boolean isInitializedInConstructors(@NotNull PsiField field, @NotNull PsiClass aClass) {
        PsiMethod[] constructors;
        if (field == null) {
            LazyGetterHandler.$$$reportNull$$$0(2);
        }
        if (aClass == null) {
            LazyGetterHandler.$$$reportNull$$$0(3);
        }
        if ((constructors = aClass.getConstructors()).length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            if (InitializationUtils.methodAssignsVariableOrFails((PsiMethod)constructor, (PsiVariable)field)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/handler/LazyGetterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLazyGetterHandled";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInitializedInConstructors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

