/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection;

import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.inspection.LombokJavaInspectionBase;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DeprecatedLombokAnnotationInspection
extends LombokJavaInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DeprecatedLombokAnnotationInspection.$$$reportNull$$$0(0);
        }
        return new LombokElementVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "de/plushnikov/intellij/plugin/inspection/DeprecatedLombokAnnotationInspection", "createVisitor"));
    }

    private static class LombokElementVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder holder;

        LombokElementVisitor(ProblemsHolder holder) {
            this.holder = holder;
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            this.checkFor("lombok.experimental.Builder", "lombok.Builder", annotation);
            this.checkFor("lombok.experimental.Value", "lombok.Value", annotation);
            this.checkFor("lombok.experimental.Wither", "lombok.With", annotation);
        }

        private void checkFor(String deprecatedAnnotationFQN, String newAnnotationFQN, PsiAnnotation psiAnnotation) {
            PsiModifierListOwner listOwner;
            String annotationQualifiedName = psiAnnotation.getQualifiedName();
            if (Objects.equals(deprecatedAnnotationFQN, annotationQualifiedName) && null != (listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiModifierListOwner.class, (boolean)false))) {
                this.holder.registerProblem((PsiElement)psiAnnotation, LombokBundle.message("inspection.message.lombok.annotation.deprecated.not.supported", deprecatedAnnotationFQN, newAnnotationFQN), ProblemHighlightType.ERROR, new LocalQuickFix[]{new AddAnnotationFix(newAnnotationFQN, listOwner, psiAnnotation.getParameterList().getAttributes(), new String[]{deprecatedAnnotationFQN})});
            }
        }
    }
}

