/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.intention;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.intention.AbstractLombokIntentionAction;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithLombokAnnotationAction
extends AbstractLombokIntentionAction {
    public ReplaceWithLombokAnnotationAction() {
        this.setText(LombokBundle.message("intention.name.replace.with.lombok", new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        boolean parentAvailable;
        if (project == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(1);
        }
        if (!(parentAvailable = super.isAvailable(project, editor, element)) || !(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiField.class, PsiMethod.class});
        if (parent instanceof PsiField) {
            return Stream.of(this.findGetterMethodToReplace((PsiField)parent), this.findSetterMethodToReplace((PsiField)parent)).anyMatch(Optional::isPresent);
        }
        if (parent instanceof PsiMethod) {
            return Stream.of(this.findAnchorFieldForGetter((PsiMethod)parent), this.findAnchorFieldForSetter((PsiMethod)parent)).anyMatch(Optional::isPresent);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement parent;
        if (project == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(3);
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiVariable.class, PsiClass.class, PsiMethod.class})) instanceof PsiField) {
            this.handleField((PsiField)parent);
        } else if (parent instanceof PsiMethod) {
            this.handleMethod((PsiMethod)parent);
        }
    }

    private void handleMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(4);
        }
        this.findAnchorFieldForGetter(psiMethod).map(PsiModifierListOwner::getModifierList).ifPresent(modifierList -> this.replaceWithAnnotation((PsiModifierList)modifierList, psiMethod, "lombok.Getter"));
        this.findAnchorFieldForSetter(psiMethod).map(PsiModifierListOwner::getModifierList).ifPresent(modifierList -> this.replaceWithAnnotation((PsiModifierList)modifierList, psiMethod, "lombok.Setter"));
    }

    private Optional<PsiMethod> findGetterMethodToReplace(@NotNull PsiField psiField) {
        PsiMethod getterForField;
        if (psiField == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(5);
        }
        if (null != (getterForField = PropertyUtilBase.findGetterForField((PsiField)psiField)) && !(getterForField instanceof LombokLightMethodBuilder)) {
            if (this.findAnchorFieldForGetter(getterForField).filter(psiField::equals).isPresent()) {
                return Optional.of(getterForField);
            }
        }
        return Optional.empty();
    }

    private Optional<PsiMethod> findSetterMethodToReplace(@NotNull PsiField psiField) {
        PsiMethod setterForField;
        if (psiField == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(6);
        }
        if (null != (setterForField = PropertyUtilBase.findSetterForField((PsiField)psiField)) && !(setterForField instanceof LombokLightMethodBuilder)) {
            if (this.findAnchorFieldForSetter(setterForField).filter(psiField::equals).isPresent()) {
                return Optional.of(setterForField);
            }
        }
        return Optional.empty();
    }

    private void handleField(@NotNull PsiField psiField) {
        PsiModifierList psiFieldModifierList;
        if (psiField == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(7);
        }
        if (null == (psiFieldModifierList = psiField.getModifierList())) {
            return;
        }
        this.findGetterMethodToReplace(psiField).ifPresent(psiMethod -> this.replaceWithAnnotation(psiFieldModifierList, (PsiMethod)psiMethod, "lombok.Getter"));
        this.findSetterMethodToReplace(psiField).ifPresent(psiMethod -> this.replaceWithAnnotation(psiFieldModifierList, (PsiMethod)psiMethod, "lombok.Setter"));
    }

    private Optional<PsiField> findAnchorFieldForSetter(@NotNull PsiMethod method) {
        if (method == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(8);
        }
        if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) || method.hasModifierProperty("abstract")) {
            return Optional.empty();
        }
        if (Optional.of(method.getParameterList()).filter(paramList -> paramList.getParametersCount() == 1).map(paramList -> paramList.getParameter(0)).map(PsiParameter::getType).filter(expectedType -> ((Collection)Optional.ofNullable(method.getContainingClass()).map(PsiClassUtil::collectClassFieldsIntern).orElse(Collections.emptyList())).stream().filter(field -> method.getName().equals(LombokUtils.getSetterName(field))).noneMatch(field -> expectedType.equals(field.getType()))).isPresent()) {
            return Optional.empty();
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return ((Collection)Optional.ofNullable(method.getContainingClass()).map(PsiClassUtil::collectClassFieldsIntern).orElse(Collections.emptyList())).stream().filter(field -> method.getName().equals(LombokUtils.getSetterName(field))).findAny();
        }
        if (body.getStatementCount() == 1) {
            Optional<PsiAssignmentExpression> assignmentExpression = Optional.of(body.getStatements()[0]).filter(PsiExpressionStatement.class::isInstance).map(PsiExpressionStatement.class::cast).map(PsiExpressionStatement::getExpression).filter(PsiAssignmentExpression.class::isInstance).map(PsiAssignmentExpression.class::cast);
            if (assignmentExpression.map(PsiAssignmentExpression::getRExpression).filter(PsiReferenceExpression.class::isInstance).map(PsiReferenceExpression.class::cast).map(PsiReference::resolve).filter(PsiParameter.class::isInstance).isPresent()) {
                return assignmentExpression.map(PsiAssignmentExpression::getLExpression).filter(PsiReferenceExpression.class::isInstance).map(PsiReferenceExpression.class::cast).map(PsiReference::resolve).filter(PsiField.class::isInstance).map(PsiField.class::cast);
            }
        }
        return Optional.empty();
    }

    private Optional<PsiField> findAnchorFieldForGetter(@NotNull PsiMethod method) {
        if (method == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(9);
        }
        if (!PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method) || method.hasModifierProperty("abstract")) {
            return Optional.empty();
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return ((Collection)Optional.ofNullable(method.getContainingClass()).map(PsiClassUtil::collectClassFieldsIntern).orElse(Collections.emptyList())).stream().filter(field -> method.getName().equals(LombokUtils.getGetterName(field))).findAny();
        }
        if (body.getStatementCount() == 1) {
            return Optional.of(body.getStatements()[0]).filter(PsiReturnStatement.class::isInstance).map(PsiReturnStatement.class::cast).map(PsiReturnStatement::getReturnValue).map(PsiUtil::deparenthesizeExpression).filter(PsiReferenceExpression.class::isInstance).map(PsiReferenceExpression.class::cast).map(PsiReference::resolve).filter(PsiField.class::isInstance).map(PsiField.class::cast);
        }
        return Optional.empty();
    }

    private void replaceWithAnnotation(@NotNull PsiModifierList modifierList, @NotNull PsiMethod method, @NotNull String annotationName) {
        if (modifierList == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(10);
        }
        if (method == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(11);
        }
        if (annotationName == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(12);
        }
        method.delete();
        modifierList.addAnnotation(annotationName);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = LombokBundle.message("replace.with.annotations.lombok", new Object[0]);
        if (string == null) {
            ReplaceWithLombokAnnotationAction.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/intention/ReplaceWithLombokAnnotationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/intention/ReplaceWithLombokAnnotationAction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findGetterMethodToReplace";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findSetterMethodToReplace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAnchorFieldForSetter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAnchorFieldForGetter";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithAnnotation";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

