/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.lombokconfig;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.FileBasedIndex;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigValue;
import de.plushnikov.intellij.plugin.lombokconfig.LombokConfigIndex;
import de.plushnikov.intellij.plugin.psi.LombokLightClassBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigDiscovery {
    @NotNull
    public static ConfigDiscovery getInstance() {
        ConfigDiscovery configDiscovery = (ConfigDiscovery)ApplicationManager.getApplication().getService(ConfigDiscovery.class);
        if (configDiscovery == null) {
            ConfigDiscovery.$$$reportNull$$$0(0);
        }
        return configDiscovery;
    }

    @NotNull
    public String getStringLombokConfigProperty(@NotNull ConfigKey configKey, @NotNull PsiClass psiClass) {
        VirtualFile file;
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(2);
        }
        if (null != (file = ConfigDiscovery.calculateDirectory(psiClass))) {
            return this.discoverProperty(configKey, file, psiClass.getProject());
        }
        String string = configKey.getConfigDefaultValue();
        if (string == null) {
            ConfigDiscovery.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean getBooleanLombokConfigProperty(@NotNull ConfigKey configKey, @NotNull PsiClass psiClass) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(4);
        }
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(5);
        }
        String configProperty = this.getStringLombokConfigProperty(configKey, psiClass);
        return Boolean.parseBoolean(configProperty);
    }

    public String @NotNull [] getMultipleValueLombokConfigProperty(@NotNull ConfigKey configKey, @NotNull PsiClass psiClass) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(7);
        }
        HashSet<String> result = new HashSet<String>();
        @Nullable VirtualFile file = ConfigDiscovery.calculateDirectory(psiClass);
        if (file != null) {
            List<String> properties = this.discoverProperties(configKey, file, psiClass.getProject());
            Collections.reverse(properties);
            for (String configProperty : properties) {
                String[] values;
                if (!StringUtil.isNotEmpty((String)configProperty)) continue;
                for (String value : values = configProperty.split(";")) {
                    if (value.startsWith("+")) {
                        result.add(value.substring(1));
                        continue;
                    }
                    if (!value.startsWith("-")) continue;
                    result.remove(value.substring(1));
                }
            }
        } else {
            result.add(configKey.getConfigDefaultValue());
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            ConfigDiscovery.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @Nullable
    private static VirtualFile calculateDirectory(@NotNull PsiClass psiClass) {
        PsiFile originalFile;
        PsiClass containingClass;
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(9);
        }
        Object psiFile = psiClass instanceof LombokLightClassBuilder ? (null != (containingClass = psiClass.getContainingClass()) ? containingClass.getContainingFile() : null) : psiClass.getContainingFile();
        if (psiFile != null && (originalFile = psiFile.getOriginalFile()) != null) {
            psiFile = originalFile;
        }
        return psiFile != null ? psiFile.getVirtualFile() : null;
    }

    @NotNull
    private String discoverProperty(@NotNull ConfigKey configKey, @Nullable VirtualFile file, @NotNull Project project) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ConfigDiscovery.$$$reportNull$$$0(11);
        }
        for (VirtualFile currentFile = file; currentFile != null; currentFile = currentFile.getParent()) {
            ConfigValue configValue = this.readProperty(configKey, project, currentFile);
            if (null == configValue) continue;
            if (null == configValue.getValue()) {
                if (!configValue.isStopBubbling()) continue;
                break;
            }
            String string = configValue.getValue();
            if (string == null) {
                ConfigDiscovery.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = configKey.getConfigDefaultValue();
        if (string == null) {
            ConfigDiscovery.$$$reportNull$$$0(13);
        }
        return string;
    }

    @VisibleForTesting
    protected FileBasedIndex getFileBasedIndex() {
        return FileBasedIndex.getInstance();
    }

    @Nullable
    private ConfigValue readProperty(@NotNull ConfigKey configKey, @NotNull Project project, @NotNull VirtualFile directory) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(14);
        }
        if (project == null) {
            ConfigDiscovery.$$$reportNull$$$0(15);
        }
        if (directory == null) {
            ConfigDiscovery.$$$reportNull$$$0(16);
        }
        GlobalSearchScope directoryScope = GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)directory, (boolean)false);
        List values = this.getFileBasedIndex().getValues(LombokConfigIndex.NAME, (Object)configKey, directoryScope);
        if (!values.isEmpty()) {
            return (ConfigValue)values.iterator().next();
        }
        return null;
    }

    @NotNull
    private List<String> discoverProperties(@NotNull ConfigKey configKey, @Nullable VirtualFile file, @NotNull Project project) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(17);
        }
        if (project == null) {
            ConfigDiscovery.$$$reportNull$$$0(18);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (VirtualFile currentFile = file; currentFile != null; currentFile = currentFile.getParent()) {
            ConfigValue configValue = this.readProperty(configKey, project, currentFile);
            if (null == configValue) continue;
            if (null == configValue.getValue()) {
                if (!configValue.isStopBubbling()) continue;
                break;
            }
            result.add(configValue.getValue());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            ConfigDiscovery.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/lombokconfig/ConfigDiscovery";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/lombokconfig/ConfigDiscovery";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLombokConfigProperty";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultipleValueLombokConfigProperty";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverProperty";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStringLombokConfigProperty";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanLombokConfigProperty";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMultipleValueLombokConfigProperty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculateDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "discoverProperty";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readProperty";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "discoverProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

