/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.psi.LombokEnumConstantBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightClassBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldNameConstantsHandler {
    public static String getTypeName(@NotNull PsiClass containingClass, @NotNull PsiAnnotation fieldNameConstants) {
        String typeName;
        if (containingClass == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(0);
        }
        if (fieldNameConstants == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmptyOrSpaces((String)(typeName = PsiAnnotationUtil.getStringAnnotationValue(fieldNameConstants, "innerTypeName", "")))) {
            ConfigDiscovery configDiscovery = ConfigDiscovery.getInstance();
            typeName = configDiscovery.getStringLombokConfigProperty(ConfigKey.FIELD_NAME_CONSTANTS_TYPENAME, containingClass);
        }
        return typeName;
    }

    @Nullable
    public static LombokLightClassBuilder createInnerClassOrEnum(@NotNull String name, @NotNull PsiClass containingClass, @NotNull PsiAnnotation psiAnnotation) {
        String accessLevel;
        if (name == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(2);
        }
        if (containingClass == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(4);
        }
        if ((accessLevel = LombokProcessorUtil.getLevelVisibility(psiAnnotation)) == null) {
            return null;
        }
        boolean asEnum = PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "asEnum", false);
        if (asEnum) {
            return FieldNameConstantsHandler.createEnum(name, containingClass, accessLevel, (PsiElement)psiAnnotation);
        }
        return FieldNameConstantsHandler.createInnerClass(name, containingClass, accessLevel, (PsiElement)psiAnnotation);
    }

    private static boolean useUppercasedConstants(@NotNull PsiClass containingClass) {
        if (containingClass == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(5);
        }
        ConfigDiscovery configDiscovery = ConfigDiscovery.getInstance();
        return configDiscovery.getBooleanLombokConfigProperty(ConfigKey.FIELD_NAME_CONSTANTS_UPPERCASE, containingClass);
    }

    public static List<PsiField> createFields(@NotNull PsiClass containingClass, @NotNull Collection<PsiField> psiFields) {
        if (containingClass == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(6);
        }
        if (psiFields == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(7);
        }
        Set existingFieldNames = PsiClassUtil.collectClassFieldsIntern(containingClass).stream().map(PsiField::getName).collect(Collectors.toSet());
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)containingClass.getProject());
        PsiClassType classType = psiElementFactory.createType(containingClass);
        boolean makeUppercased = FieldNameConstantsHandler.useUppercasedConstants(containingClass);
        return psiFields.stream().filter(psiField -> !existingFieldNames.contains(FieldNameConstantsHandler.makeFieldNameConstant(psiField, makeUppercased))).map(psiField -> {
            if (containingClass.isEnum()) {
                return FieldNameConstantsHandler.createEnumConstant(psiField, makeUppercased, containingClass, classType);
            }
            return FieldNameConstantsHandler.createFieldNameConstant(psiField, makeUppercased, containingClass);
        }).collect(Collectors.toList());
    }

    @NotNull
    private static LombokLightClassBuilder createEnum(@NotNull String name, @NotNull PsiClass containingClass, @NotNull String accessLevel, @NotNull PsiElement navigationElement) {
        if (name == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(8);
        }
        if (containingClass == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(9);
        }
        if (accessLevel == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(10);
        }
        if (navigationElement == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(11);
        }
        String innerClassQualifiedName = containingClass.getQualifiedName() + "." + name;
        LombokLightClassBuilder lazyClassBuilder = new LombokLightClassBuilder((PsiElement)containingClass, name, innerClassQualifiedName);
        lazyClassBuilder.withContainingClass(containingClass).withNavigationElement(navigationElement).withEnum(true).withModifier(accessLevel).withImplicitModifier("static").withImplicitModifier("final");
        lazyClassBuilder.withMethodSupplier(() -> {
            PsiManager psiManager = containingClass.getManager();
            PsiClassType enumClassType = PsiClassUtil.getTypeWithGenerics((PsiClass)lazyClassBuilder);
            LombokLightMethodBuilder valuesEnumMethod = new LombokLightMethodBuilder(psiManager, "values").withModifier("public").withModifier("static").withContainingClass(containingClass).withNavigationElement(navigationElement).withMethodReturnType((PsiType)new PsiArrayType((PsiType)enumClassType));
            valuesEnumMethod.withBody(PsiMethodUtil.createCodeBlockFromText("", (PsiElement)valuesEnumMethod));
            LombokLightMethodBuilder valueOfEnumMethod = new LombokLightMethodBuilder(psiManager, "valueOf").withModifier("public").withModifier("static").withContainingClass(containingClass).withNavigationElement(navigationElement).withParameter("name", (PsiType)PsiType.getJavaLangString((PsiManager)psiManager, (GlobalSearchScope)containingClass.getResolveScope())).withException(PsiType.getTypeByName((String)"java.lang.IllegalArgumentException", (Project)containingClass.getProject(), (GlobalSearchScope)containingClass.getResolveScope())).withMethodReturnType((PsiType)enumClassType);
            valueOfEnumMethod.withBody(PsiMethodUtil.createCodeBlockFromText("", (PsiElement)valueOfEnumMethod));
            return Arrays.asList(new PsiMethod[]{valuesEnumMethod, valueOfEnumMethod});
        });
        LombokLightClassBuilder lombokLightClassBuilder = lazyClassBuilder;
        if (lombokLightClassBuilder == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(12);
        }
        return lombokLightClassBuilder;
    }

    private static PsiField createEnumConstant(@NotNull PsiField field, boolean makeUppercased, @NotNull PsiClass containingClass, PsiClassType classType) {
        if (field == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(13);
        }
        if (containingClass == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(14);
        }
        return new LombokEnumConstantBuilder(containingClass.getManager(), FieldNameConstantsHandler.makeFieldNameConstant(field, makeUppercased), (PsiType)classType).withContainingClass(containingClass).withModifier("public").withImplicitModifier("static").withImplicitModifier("final").withNavigationElement((PsiElement)field);
    }

    private static String makeFieldNameConstant(@NotNull PsiField field, boolean makeUppercased1) {
        if (field == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(15);
        }
        String fieldName = field.getName();
        return makeUppercased1 ? LombokUtils.camelCaseToConstant(fieldName) : fieldName;
    }

    @NotNull
    private static LombokLightClassBuilder createInnerClass(@NotNull String name, @NotNull PsiClass containingClass, @NotNull String accessLevel, @NotNull PsiElement navigationElement) {
        if (name == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(16);
        }
        if (containingClass == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(17);
        }
        if (accessLevel == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(18);
        }
        if (navigationElement == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(19);
        }
        String innerClassQualifiedName = containingClass.getQualifiedName() + "." + name;
        LombokLightClassBuilder lazyClassBuilder = new LombokLightClassBuilder((PsiElement)containingClass, name, innerClassQualifiedName);
        lazyClassBuilder.withContainingClass(containingClass).withNavigationElement(navigationElement).withModifier(accessLevel).withModifier("static").withModifier("final");
        LombokLightClassBuilder lombokLightClassBuilder = lazyClassBuilder;
        if (lombokLightClassBuilder == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(20);
        }
        return lombokLightClassBuilder;
    }

    @NotNull
    private static PsiField createFieldNameConstant(@NotNull PsiField psiField, boolean makeUppercased, @NotNull PsiClass containingClass) {
        if (psiField == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(21);
        }
        if (containingClass == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(22);
        }
        PsiManager manager = containingClass.getContainingFile().getManager();
        PsiClassType fieldNameConstType = PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)containingClass.getProject()));
        LombokLightFieldBuilder fieldNameConstant = new LombokLightFieldBuilder(manager, FieldNameConstantsHandler.makeFieldNameConstant(psiField, makeUppercased), (PsiType)fieldNameConstType).withContainingClass(containingClass).withNavigationElement((PsiElement)psiField).withModifier("public").withModifier("static").withModifier("final");
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)containingClass.getProject());
        PsiExpression initializer = psiElementFactory.createExpressionFromText("\"" + psiField.getName() + "\"", (PsiElement)containingClass);
        fieldNameConstant.setInitializer(initializer);
        LombokLightFieldBuilder lombokLightFieldBuilder = fieldNameConstant;
        if (lombokLightFieldBuilder == null) {
            FieldNameConstantsHandler.$$$reportNull$$$0(23);
        }
        return lombokLightFieldBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldNameConstants";
                break;
            }
            case 2: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFields";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessLevel";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationElement";
                break;
            }
            case 12: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/FieldNameConstantsHandler";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/FieldNameConstantsHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnum";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createInnerClass";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldNameConstant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInnerClassOrEnum";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "useUppercasedConstants";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFields";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEnum";
                break;
            }
            case 12: 
            case 20: 
            case 23: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createEnumConstant";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "makeFieldNameConstant";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createInnerClass";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createFieldNameConstant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

