/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.provider;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.Processor;
import de.plushnikov.intellij.plugin.provider.LombokProcessorData;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class LombokProcessorProvider
implements Disposable {
    private final Map<Class, Collection<Processor>> lombokTypeProcessors;
    private final Map<String, Collection<Processor>> lombokProcessors = new ConcurrentHashMap<String, Collection<Processor>>();
    private final Collection<String> registeredAnnotationNames;
    private boolean alreadyInitialized;

    public static LombokProcessorProvider getInstance(@NotNull Project project) {
        if (project == null) {
            LombokProcessorProvider.$$$reportNull$$$0(0);
        }
        LombokProcessorProvider service = (LombokProcessorProvider)ServiceManager.getService((Project)project, LombokProcessorProvider.class);
        service.checkInitialized();
        return service;
    }

    public LombokProcessorProvider() {
        this.lombokTypeProcessors = new ConcurrentHashMap<Class, Collection<Processor>>();
        this.registeredAnnotationNames = ConcurrentHashMap.newKeySet();
    }

    public void dispose() {
    }

    private void checkInitialized() {
        if (!this.alreadyInitialized) {
            this.initProcessors();
            this.alreadyInitialized = true;
        }
    }

    public void initProcessors() {
        this.lombokProcessors.clear();
        this.lombokTypeProcessors.clear();
        this.registeredAnnotationNames.clear();
        for (Processor processor : LombokProcessorManager.getLombokProcessors()) {
            String[] annotationClasses;
            for (String annotationClass : annotationClasses = processor.getSupportedAnnotationClasses()) {
                this.putProcessor(this.lombokProcessors, annotationClass, processor);
                this.putProcessor(this.lombokProcessors, StringUtil.getShortName((String)annotationClass), processor);
            }
            this.putProcessor(this.lombokTypeProcessors, processor.getSupportedClass(), processor);
        }
        this.registeredAnnotationNames.addAll(this.lombokProcessors.keySet());
    }

    @NotNull
    Collection<Processor> getLombokProcessors(@NotNull Class supportedClass) {
        if (supportedClass == null) {
            LombokProcessorProvider.$$$reportNull$$$0(1);
        }
        Collection collection = this.lombokTypeProcessors.computeIfAbsent(supportedClass, k -> ConcurrentHashMap.newKeySet());
        if (collection == null) {
            LombokProcessorProvider.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Collection<Processor> getProcessors(@NotNull PsiAnnotation psiAnnotation) {
        String qualifiedName;
        if (psiAnnotation == null) {
            LombokProcessorProvider.$$$reportNull$$$0(3);
        }
        Collection<Processor> result = (qualifiedName = psiAnnotation.getQualifiedName()) == null ? null : this.lombokProcessors.get(qualifiedName);
        Collection<Object> collection = result == null ? Collections.emptySet() : result;
        if (collection == null) {
            LombokProcessorProvider.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    Collection<LombokProcessorData> getApplicableProcessors(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            LombokProcessorProvider.$$$reportNull$$$0(5);
        }
        List<LombokProcessorData> result = Collections.emptyList();
        if (this.verifyLombokAnnotationPresent(psiMember)) {
            result = new ArrayList();
            this.addApplicableProcessors(psiMember, result);
            PsiClass psiClass = psiMember.getContainingClass();
            if (null != psiClass) {
                this.addApplicableProcessors((PsiMember)psiClass, result);
            }
        }
        List<LombokProcessorData> list = result;
        if (list == null) {
            LombokProcessorProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    private <K, V> void putProcessor(Map<K, Collection<V>> map, K key, V value) {
        Collection valueList = map.computeIfAbsent(key, k -> ConcurrentHashMap.newKeySet());
        valueList.add(value);
    }

    private boolean verifyLombokAnnotationPresent(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LombokProcessorProvider.$$$reportNull$$$0(7);
        }
        if (PsiAnnotationSearchUtil.checkAnnotationsSimpleNameExistsIn((PsiModifierListOwner)psiClass, this.registeredAnnotationNames)) {
            return true;
        }
        Collection<PsiField> psiFields = PsiClassUtil.collectClassFieldsIntern(psiClass);
        for (PsiField psiField : psiFields) {
            if (!PsiAnnotationSearchUtil.checkAnnotationsSimpleNameExistsIn((PsiModifierListOwner)psiField, this.registeredAnnotationNames)) continue;
            return true;
        }
        Collection<PsiMethod> psiMethods = PsiClassUtil.collectClassMethodsIntern(psiClass);
        for (PsiMethod psiMethod : psiMethods) {
            if (!PsiAnnotationSearchUtil.checkAnnotationsSimpleNameExistsIn((PsiModifierListOwner)psiMethod, this.registeredAnnotationNames)) continue;
            return true;
        }
        PsiElement psiElement = psiClass.getParent();
        if (psiElement instanceof PsiClass) {
            return this.verifyLombokAnnotationPresent((PsiClass)psiElement);
        }
        return false;
    }

    private boolean verifyLombokAnnotationPresent(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            LombokProcessorProvider.$$$reportNull$$$0(8);
        }
        if (PsiAnnotationSearchUtil.checkAnnotationsSimpleNameExistsIn((PsiModifierListOwner)psiMember, this.registeredAnnotationNames)) {
            return true;
        }
        PsiClass psiClass = psiMember.getContainingClass();
        return null != psiClass && this.verifyLombokAnnotationPresent(psiClass);
    }

    private void addApplicableProcessors(@NotNull PsiMember psiMember, @NotNull Collection<LombokProcessorData> target) {
        PsiModifierList psiModifierList;
        if (psiMember == null) {
            LombokProcessorProvider.$$$reportNull$$$0(9);
        }
        if (target == null) {
            LombokProcessorProvider.$$$reportNull$$$0(10);
        }
        if (null != (psiModifierList = psiMember.getModifierList())) {
            for (PsiAnnotation psiAnnotation : psiModifierList.getAnnotations()) {
                for (Processor processor : this.getProcessors(psiAnnotation)) {
                    target.add(new LombokProcessorData(processor, psiAnnotation));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/provider/LombokProcessorProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/provider/LombokProcessorProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLombokProcessors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableProcessors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLombokProcessors";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProcessors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableProcessors";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "verifyLombokAnnotationPresent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addApplicableProcessors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

