/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAnnotationSearchUtil {
    @Nullable
    public static PsiAnnotation findAnnotation(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull String annotationFQN) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(0);
        }
        if (annotationFQN == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(1);
        }
        return psiModifierListOwner.getAnnotation(annotationFQN);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@NotNull PsiModifierListOwner psiModifierListOwner, String ... annotationFQNs) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(2);
        }
        if (annotationFQNs == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(3);
        }
        return Stream.of(annotationFQNs).map(arg_0 -> ((PsiModifierListOwner)psiModifierListOwner).getAnnotation(arg_0)).filter(Objects::nonNull).findAny().orElse(null);
    }

    public static boolean isAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull String annotationFQN) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(4);
        }
        if (annotationFQN == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(5);
        }
        return psiModifierListOwner.hasAnnotation(annotationFQN);
    }

    public static boolean isNotAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, String annotationTypeName) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(6);
        }
        return !PsiAnnotationSearchUtil.isAnnotatedWith(psiModifierListOwner, annotationTypeName);
    }

    public static boolean isAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, String ... annotationTypes) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(7);
        }
        if (annotationTypes == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(8);
        }
        return null != PsiAnnotationSearchUtil.findAnnotation(psiModifierListOwner, annotationTypes);
    }

    public static boolean isNotAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, String ... annotationTypes) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(9);
        }
        if (annotationTypes == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(10);
        }
        return !PsiAnnotationSearchUtil.isAnnotatedWith(psiModifierListOwner, annotationTypes);
    }

    @NotNull
    public static String getSimpleNameOf(@NotNull PsiAnnotation psiAnnotation) {
        PsiJavaCodeReferenceElement referenceElement;
        if (psiAnnotation == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(11);
        }
        String string = StringUtil.notNullize((String)(null == (referenceElement = psiAnnotation.getNameReferenceElement()) ? null : referenceElement.getReferenceName()));
        if (string == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static boolean checkAnnotationsSimpleNameExistsIn(@NotNull PsiModifierListOwner modifierListOwner, @NotNull Collection<String> annotationNames) {
        PsiModifierList modifierList;
        if (modifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(13);
        }
        if (annotationNames == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(14);
        }
        if (null != (modifierList = modifierListOwner.getModifierList())) {
            for (PsiAnnotation psiAnnotation : modifierList.getAnnotations()) {
                String simpleName = PsiAnnotationSearchUtil.getSimpleNameOf(psiAnnotation);
                if (!annotationNames.contains(simpleName)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQNs";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationTypes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/util/PsiAnnotationSearchUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/util/PsiAnnotationSearchUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleNameOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedWith";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNotAnnotatedWith";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleNameOf";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationsSimpleNameExistsIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

