/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.EmptyChangelistBuilder;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class GatheringChangelistBuilder
extends EmptyChangelistBuilder {
    private static final Logger LOG = Logger.getInstance(GatheringChangelistBuilder.class);
    @NotNull
    private final Set<VirtualFile> myCheckSet;
    @NotNull
    private final List<Change> myChanges;
    @NotNull
    private final UpdatedFilesReverseSide myFiles;
    @NotNull
    private final SvnVcs myVcs;

    public GatheringChangelistBuilder(@NotNull SvnVcs vcs, @NotNull UpdatedFilesReverseSide files) {
        if (vcs == null) {
            GatheringChangelistBuilder.$$$reportNull$$$0(0);
        }
        if (files == null) {
            GatheringChangelistBuilder.$$$reportNull$$$0(1);
        }
        this.myVcs = vcs;
        this.myFiles = files;
        this.myChanges = new ArrayList<Change>();
        this.myCheckSet = new HashSet<VirtualFile>();
    }

    public void processChange(Change change, VcsKey vcsKey) {
        this.addChange(change);
    }

    public void processChangeInList(Change change, @Nullable ChangeList changeList, VcsKey vcsKey) {
        this.addChange(change);
    }

    public void processChangeInList(Change change, String changeListName, VcsKey vcsKey) {
        this.addChange(change);
    }

    public void removeRegisteredChangeFor(FilePath path) {
        Iterator<Change> iterator = this.myChanges.iterator();
        while (iterator.hasNext()) {
            VirtualFile vf;
            Change change = iterator.next();
            if (!path.equals(ChangesUtil.getFilePath((Change)change)) || (vf = path.getVirtualFile()) == null) continue;
            this.myCheckSet.remove(vf);
            iterator.remove();
            return;
        }
    }

    private void addChange(Change change) {
        FilePath path = ChangesUtil.getFilePath((Change)change);
        VirtualFile vf = path.getVirtualFile();
        if ((this.mergeInfoChanged(path.getIOFile()) || vf != null && this.myFiles.containsFile(vf)) && !this.myCheckSet.contains(vf)) {
            this.myCheckSet.add(vf);
            this.myChanges.add(change);
        }
    }

    private boolean mergeInfoChanged(File file) {
        Target target = Target.on(file);
        try {
            PropertyValue current = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, Revision.WORKING);
            PropertyValue base = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, Revision.BASE);
            if (current != null) {
                return base == null || !Comparing.equal((Object)current, (Object)base);
            }
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        return false;
    }

    public boolean reportChangesOutsideProject() {
        return true;
    }

    @NotNull
    public List<Change> getChanges() {
        List<Change> list = this.myChanges;
        if (list == null) {
            GatheringChangelistBuilder.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/integrate/GatheringChangelistBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/integrate/GatheringChangelistBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

