/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.io.IdeUtilIoBundle;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J&\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010!\u001a\u00020\u00132\b\b\u0001\u0010\"\u001a\u00020\u00132\b\b\u0001\u0010#\u001a\u00020\u0013H\u0007J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130%2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0013H\u0003J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0013H\u0007J\u0010\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'H\u0007J\u0018\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u0010.\u001a\u00020/H\u0007J\u0018\u0010,\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u00100\u001a\u00020\u0013H\u0007J \u0010,\u001a\u00020-2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00130%2\b\u00102\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u00103\u001a\u0004\u0018\u00010\u00132\u0006\u0010&\u001a\u00020'H\u0007J\"\u00104\u001a\b\u0012\u0004\u0012\u00020\u00130%2\n\b\u0001\u00105\u001a\u0004\u0018\u00010\u00132\u0006\u00101\u001a\u00020\u0013H\u0007J\b\u00106\u001a\u00020\tH\u0007J.\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00132\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010<H\u0007J\u001c\u0010=\u001a\u0004\u0018\u00010\u00132\u0006\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010AH\u0007J\u0010\u0010B\u001a\u00020C2\u0006\u0010&\u001a\u00020'H\u0007J\u0010\u0010D\u001a\u00020C2\u0006\u0010&\u001a\u00020'H\u0007J\u001d\u0010E\u001a\u00020F2\u0006\u0010&\u001a\u00020'2\u000b\u0010G\u001a\u00070\u0013\u00a2\u0006\u0002\bHH\u0007J\u0018\u0010I\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u0010G\u001a\u00020\u0013H\u0007J\u001d\u0010J\u001a\u00020'2\u0006\u0010&\u001a\u00020'2\u000b\u0010G\u001a\u00070\u0013\u00a2\u0006\u0002\bHH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00138\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u00138GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u00138GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0002\u001a\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u00138FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006K"}, d2={"Lcom/intellij/execution/util/ExecUtil;", "", "()V", "hasGkSudo", "Lcom/intellij/openapi/util/io/PathExecLazyValue;", "hasGnomeTerminal", "hasKdeSudo", "hasKdeTerminal", "hasNice", "", "getHasNice", "()Z", "hasNice$delegate", "Lkotlin/Lazy;", "hasPkExec", "hasSetsid", "hasUrxvt", "hasXTerm", "nicePath", "", "openCommandPath", "getOpenCommandPath$annotations", "getOpenCommandPath", "()Ljava/lang/String;", "osascriptPath", "getOsascriptPath$annotations", "getOsascriptPath", "windowsShellName", "getWindowsShellName$annotations", "getWindowsShellName", "canRunLowPriority", "createTempExecutableScript", "Ljava/io/File;", "prefix", "suffix", "content", "envCommand", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "envCommandArgs", "escapeAppleScriptArgument", "arg", "escapeUnixShellArgument", "execAndGetOutput", "Lcom/intellij/execution/process/ProcessOutput;", "timeoutInMilliseconds", "", "stdin", "command", "workDir", "execAndReadLine", "getTerminalCommand", "title", "hasTerminalApp", "loadTemplate", "loader", "Ljava/lang/ClassLoader;", "templateName", "variables", "", "readFirstLine", "stream", "Ljava/io/InputStream;", "cs", "Ljava/nio/charset/Charset;", "setupLowPriorityExecution", "", "setupNoTtyExecution", "sudo", "Ljava/lang/Process;", "prompt", "Lorg/jetbrains/annotations/Nls;", "sudoAndGetOutput", "sudoCommand", "intellij.platform.ide.util.io"})
public final class ExecUtil {
    private static final PathExecLazyValue hasGkSudo;
    private static final PathExecLazyValue hasKdeSudo;
    private static final PathExecLazyValue hasPkExec;
    private static final PathExecLazyValue hasGnomeTerminal;
    private static final PathExecLazyValue hasKdeTerminal;
    private static final PathExecLazyValue hasUrxvt;
    private static final PathExecLazyValue hasXTerm;
    private static final PathExecLazyValue hasSetsid;
    @NlsSafe
    private static final String nicePath = "/usr/bin/nice";
    private static final Lazy hasNice$delegate;
    public static final ExecUtil INSTANCE;

    private final boolean getHasNice() {
        Lazy lazy = hasNice$delegate;
        ExecUtil execUtil = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getOsascriptPath$annotations() {
    }

    @NlsSafe
    @NotNull
    public static final String getOsascriptPath() {
        return "/usr/bin/osascript";
    }

    @JvmStatic
    public static /* synthetic */ void getOpenCommandPath$annotations() {
    }

    @NlsSafe
    @NotNull
    public static final String getOpenCommandPath() {
        return "/usr/bin/open";
    }

    @JvmStatic
    public static /* synthetic */ void getWindowsShellName$annotations() {
    }

    @NotNull
    public static final String getWindowsShellName() {
        String string = CommandLineUtil.getWinShellName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CommandLineUtil.getWinShellName()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String loadTemplate(@NotNull ClassLoader loader, @NotNull String templateName, @Nullable Map<String, String> variables) throws IOException {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        InputStream inputStream = loader.getResourceAsStream(templateName);
        if (inputStream == null) {
            throw (Throwable)new IOException("Template '" + templateName + "' not found by " + loader);
        }
        InputStream stream = inputStream;
        String string = FileUtil.loadTextAndClose((Reader)new InputStreamReader(stream, Charsets.UTF_8));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.loadTextAndClos\u2026(stream, Charsets.UTF_8))");
        String template = string;
        if (variables == null || variables.isEmpty()) {
            return template;
        }
        StringBuilder buffer = new StringBuilder(template);
        Object object = variables;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void name;
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            String value = entry2.getValue();
            int pos = buffer.indexOf((String)name);
            if (pos < 0) continue;
            buffer.replace(pos, pos + name.length(), value);
        }
        String string2 = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buffer.toString()");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final File createTempExecutableScript(@NlsSafe @NotNull String prefix, @NlsSafe @NotNull String suffix, @NlsSafe @NotNull String content) throws IOException, ExecutionException {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        File tempDir = new File(PathManager.getTempPath());
        File file = FileUtil.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\u2026efix, suffix, true, true)");
        File tempFile = file;
        String string = content;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        FileUtil.writeToFile((File)tempFile, (byte[])byArray);
        if (!tempFile.setExecutable(true, true)) {
            throw (Throwable)new ExecutionException(IdeUtilIoBundle.message("dialog.message.failed.to.make.temp.file.executable", tempFile));
        }
        return tempFile;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessHandler(commandLine).runProcess()");
        return processOutput;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine, int timeoutInMilliseconds) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess(timeoutInMilliseconds);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessHandler(\u2026ss(timeoutInMilliseconds)");
        return processOutput;
    }

    @JvmStatic
    @NotNull
    public static final String execAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String stdin) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)stdin, (String)"stdin");
        CapturingProcessHandler capturingProcessHandler = new CapturingProcessHandler(commandLine);
        boolean bl = false;
        boolean bl2 = false;
        CapturingProcessHandler processHandler = capturingProcessHandler;
        boolean bl3 = false;
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(processHandler, commandLine, stdin){
            final /* synthetic */ CapturingProcessHandler $processHandler;
            final /* synthetic */ GeneralCommandLine $commandLine$inlined;
            final /* synthetic */ String $stdin$inlined;
            {
                this.$processHandler = $captured_local_variable$1;
                this.$commandLine$inlined = generalCommandLine;
                this.$stdin$inlined = string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                OutputStream outputStream = this.$processHandler.getProcessInput();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"processHandler.processInput");
                Closeable closeable = outputStream;
                Charset charset = this.$commandLine$inlined.getCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"commandLine.charset");
                Charset charset2 = charset;
                boolean bl = false;
                closeable = new OutputStreamWriter((OutputStream)closeable, charset2);
                boolean bl2 = false;
                bl = false;
                Throwable throwable = null;
                try {
                    OutputStreamWriter it = (OutputStreamWriter)closeable;
                    boolean bl3 = false;
                    it.write(this.$stdin$inlined);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        });
        ProcessOutput processOutput = capturingProcessHandler.runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessHandler(\u2026    })\n    }.runProcess()");
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CapturingProcessHandler(\u2026    }.runProcess().stdout");
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String execAndReadLine(@NotNull GeneralCommandLine commandLine) {
        String string;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        try {
            Process process2 = commandLine.createProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"commandLine.createProcess()");
            InputStream inputStream = process2.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"commandLine.createProcess().inputStream");
            string = ExecUtil.readFirstLine(inputStream, commandLine.getCharset());
        }
        catch (ExecutionException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String readFirstLine(@NotNull InputStream stream, @Nullable Charset cs) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        try {
            String string;
            object = new BufferedReader(cs == null ? new InputStreamReader(stream) : new InputStreamReader(stream, cs));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl3 = false;
                string = it.readLine();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = string;
        }
        catch (IOException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            object = null;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final Process sudo(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Process process2 = ExecUtil.sudoCommand(commandLine, prompt).createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"sudoCommand(commandLine, prompt).createProcess()");
        return process2;
    }

    @JvmStatic
    @NotNull
    public static final GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        GeneralCommandLine.ParentEnvironmentType parentEnvironmentType;
        GeneralCommandLine generalCommandLine;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        if (SystemInfo.isUnix && Intrinsics.areEqual((Object)"root", (Object)System.getenv("USER"))) {
            return commandLine;
        }
        List command = CollectionsKt.mutableListOf((Object[])new String[]{commandLine.getExePath()});
        Collection collection = command;
        ParametersList parametersList = commandLine.getParametersList();
        Intrinsics.checkNotNullExpressionValue((Object)parametersList, (String)"commandLine.parametersList");
        List<String> list = parametersList.getList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"commandLine.parametersList.list");
        Iterable iterable = list;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        if (SystemInfo.isWinVistaOrNewer) {
            Path path = PathManager.findBinFileWithException((String)"launcher.exe");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PathManager.findBinFileW\u2026Exception(\"launcher.exe\")");
            Path launcherExe = path;
            Object[] objectArray = new String[2];
            objectArray[0] = ((Object)launcherExe).toString();
            String string = commandLine.getExePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandLine.exePath");
            objectArray[1] = string;
            Collection collection2 = CollectionsKt.listOf((Object[])objectArray);
            ParametersList parametersList2 = commandLine.getParametersList();
            Intrinsics.checkNotNullExpressionValue((Object)parametersList2, (String)"commandLine.parametersList");
            List<String> list2 = parametersList2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"commandLine.parametersList.parameters");
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)collection2, (Iterable)list2));
        } else {
            if (SystemInfo.isWindows) {
                throw (Throwable)new UnsupportedOperationException("Executing as Administrator is only available in Windows Vista or newer");
            }
            if (SystemInfo.isMac) {
                String string = StringUtil.join((Collection)command, (Function)sudoCommand.sudoCommandLine.escapedCommand.1.INSTANCE, (String)" & \" \" & ");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.join(command,\u2026ent(it) }, \" & \\\" \\\" & \")");
                String escapedCommand2 = string;
                String messageArg = SystemInfoRt.isMac ? " with prompt \"" + StringUtil.escapeQuotes((String)prompt) + '\"' : "";
                String escapedScript = "tell current application\n   activate\n" + "   do shell script " + escapedCommand2 + messageArg + " with administrator privileges without altering line endings\n" + "end tell";
                generalCommandLine = new GeneralCommandLine(ExecUtil.getOsascriptPath(), "-e", escapedScript);
            } else {
                Boolean bl2 = (Boolean)hasGkSudo.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"hasGkSudo.value");
                if (bl2.booleanValue()) {
                    generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"gksudo", "--message", prompt, "--"}), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
                } else {
                    Boolean bl3 = (Boolean)hasKdeSudo.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"hasKdeSudo.value");
                    if (bl3.booleanValue()) {
                        generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"kdesudo", "--comment", prompt, "--"}), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
                    } else {
                        Boolean bl4 = (Boolean)hasPkExec.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"hasPkExec.value");
                        if (bl4.booleanValue()) {
                            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"pkexec"), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
                        } else if (ExecUtil.hasTerminalApp()) {
                            String string = StringUtil.join((Collection)command, (Function)sudoCommand.sudoCommandLine.escapedCommandLine.1.INSTANCE, (String)" ");
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.join(command,\u2026ShellArgument(it) }, \" \")");
                            String escapedCommandLine2 = string;
                            List<String> args = INSTANCE.envCommandArgs(commandLine);
                            String escapedEnvCommand2 = Intrinsics.areEqual(args, (Object)CollectionsKt.emptyList()) ? "" : "env " + StringUtil.join((Collection)args, (Function)sudoCommand.sudoCommandLine.escapedEnvCommand.1.INSTANCE, (String)" ") + " ";
                            File script = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho " + ExecUtil.escapeUnixShellArgument(prompt) + "\n" + "echo\n" + "sudo -- " + escapedEnvCommand2 + escapedCommandLine2 + "\n" + "STATUS=$?\n" + "echo\n" + "read -p \"Press Enter to close this window...\" TEMP\n" + "exit $STATUS\n");
                            String string2 = IdeUtilIoBundle.message("terminal.title.install", new Object[0]);
                            String string3 = script.getAbsolutePath();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"script.absolutePath");
                            generalCommandLine = new GeneralCommandLine(ExecUtil.getTerminalCommand(string2, string3));
                        } else {
                            throw (Throwable)new UnsupportedOperationException("Cannot `sudo` on this system - no suitable utils found");
                        }
                    }
                }
            }
        }
        GeneralCommandLine sudoCommandLine2 = generalCommandLine;
        if (SystemInfo.isWinVistaOrNewer) {
            parentEnvironmentType = GeneralCommandLine.ParentEnvironmentType.NONE;
        } else {
            GeneralCommandLine.ParentEnvironmentType parentEnvironmentType2 = commandLine.getParentEnvironmentType();
            parentEnvironmentType = parentEnvironmentType2;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)parentEnvironmentType2), (String)"commandLine.parentEnvironmentType");
        }
        GeneralCommandLine.ParentEnvironmentType parentEnvType = parentEnvironmentType;
        GeneralCommandLine generalCommandLine2 = sudoCommandLine2.withWorkDirectory(commandLine.getWorkDirectory()).withEnvironment(commandLine.getEnvironment()).withParentEnvironmentType(parentEnvType).withRedirectErrorStream(commandLine.isRedirectErrorStream());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"sudoCommandLine\n      .w\u2026ne.isRedirectErrorStream)");
        return generalCommandLine2;
    }

    private final List<String> envCommand(GeneralCommandLine commandLine) {
        List<String> args = this.envCommandArgs(commandLine);
        return Intrinsics.areEqual(args, (Object)CollectionsKt.emptyList()) ? CollectionsKt.emptyList() : CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"env"), (Iterable)args);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> envCommandArgs(GeneralCommandLine commandLine) {
        List list;
        Map<String, String> map = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"commandLine.environment");
        Map<String, String> env = map;
        if (Intrinsics.areEqual(env, (Object)MapsKt.emptyMap())) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Map<String, String> $this$map$iv = env;
            boolean $i$f$map = false;
            Map<String, String> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var8_8 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var8_8.entrySet().iterator();
            while (iterator.hasNext()) {
                void entry;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = (String)entry.getKey() + '=' + (String)entry.getValue();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput sudoAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws IOException, ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return ExecUtil.execAndGetOutput(ExecUtil.sudoCommand(commandLine, prompt));
    }

    @NlsSafe
    private final String escapeAppleScriptArgument(String arg) {
        return "quoted form of \"" + StringsKt.replace$default((String)arg, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + '\"';
    }

    @JvmStatic
    @NotNull
    public static final String escapeUnixShellArgument(@NotNull String arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return '\'' + StringsKt.replace$default((String)arg, (String)"'", (String)"'\"'\"'", (boolean)false, (int)4, null) + '\'';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean hasTerminalApp() {
        if (SystemInfo.isWindows) return true;
        if (SystemInfo.isMac) return true;
        Boolean bl = (Boolean)hasKdeTerminal.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"hasKdeTerminal.value");
        if (bl != false) return true;
        Boolean bl2 = (Boolean)hasGnomeTerminal.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"hasGnomeTerminal.value");
        if (bl2 != false) return true;
        Boolean bl3 = (Boolean)hasUrxvt.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"hasUrxvt.value");
        if (bl3 != false) return true;
        Boolean bl4 = (Boolean)hasXTerm.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"hasXTerm.value");
        if (bl4 == false) return false;
        return true;
    }

    @JvmStatic
    @NlsSafe
    @NotNull
    public static final List<String> getTerminalCommand(@Nls(capitalization=Nls.Capitalization.Title) @Nullable String title, @NotNull String command) {
        List list;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (SystemInfo.isWindows) {
            Object[] objectArray = new String[5];
            objectArray[0] = ExecUtil.getWindowsShellName();
            objectArray[1] = "/c";
            objectArray[2] = "start";
            String string = title;
            if (string == null || (string = StringsKt.replace$default((String)string, (char)'\"', (char)'\'', (boolean)false, (int)4, null)) == null) {
                string = "";
            }
            String string2 = GeneralCommandLine.inescapableQuote(string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GeneralCommandLine.inesc\u2026replace('\"', '\\'') ?: \"\")");
            objectArray[3] = string2;
            objectArray[4] = command;
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (SystemInfo.isMac) {
            list = CollectionsKt.listOf((Object[])new String[]{ExecUtil.getOpenCommandPath(), "-a", "Terminal", command});
        } else {
            Boolean bl = (Boolean)hasKdeTerminal.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"hasKdeTerminal.value");
            if (bl.booleanValue()) {
                list = title != null ? CollectionsKt.listOf((Object[])new String[]{"konsole", "-p", "tabtitle=\"" + StringsKt.replace$default((String)title, (char)'\"', (char)'\'', (boolean)false, (int)4, null) + '\"', "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"konsole", "-e", command});
            } else {
                Boolean bl2 = (Boolean)hasGnomeTerminal.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"hasGnomeTerminal.value");
                if (bl2.booleanValue()) {
                    list = title != null ? CollectionsKt.listOf((Object[])new String[]{"gnome-terminal", "-t", title, "-x", command}) : CollectionsKt.listOf((Object[])new String[]{"gnome-terminal", "-x", command});
                } else {
                    Boolean bl3 = (Boolean)hasUrxvt.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"hasUrxvt.value");
                    if (bl3.booleanValue()) {
                        list = title != null ? CollectionsKt.listOf((Object[])new String[]{"urxvt", "-title", title, "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"urxvt", "-e", command});
                    } else {
                        Boolean bl4 = (Boolean)hasXTerm.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"hasXTerm.value");
                        if (bl4.booleanValue()) {
                            list = title != null ? CollectionsKt.listOf((Object[])new String[]{"xterm", "-T", title, "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"xterm", "-e", command});
                        } else {
                            throw (Throwable)new UnsupportedOperationException("Unsupported OS/desktop: " + SystemInfo.OS_NAME + '/' + System.getenv("XDG_CURRENT_DESKTOP"));
                        }
                    }
                }
            }
        }
        return list;
    }

    @JvmStatic
    public static final void setupLowPriorityExecution(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        if (INSTANCE.canRunLowPriority()) {
            String string = commandLine.getExePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandLine.exePath");
            String executablePath = string;
            if (SystemInfo.isWindows) {
                commandLine.setExePath(ExecUtil.getWindowsShellName());
                commandLine.getParametersList().prependAll("/c", "start", "/b", "/low", "/wait", GeneralCommandLine.inescapableQuote(""), executablePath);
            } else {
                commandLine.setExePath(nicePath);
                commandLine.getParametersList().prependAll("-n", "10", executablePath);
            }
        }
    }

    private final boolean canRunLowPriority() {
        return Registry.is((String)"ide.allow.low.priority.process") && (SystemInfo.isWindows || this.getHasNice());
    }

    @JvmStatic
    public static final void setupNoTtyExecution(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        if (SystemInfo.isLinux) {
            Boolean bl = (Boolean)hasSetsid.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"hasSetsid.value");
            if (bl.booleanValue()) {
                String string = commandLine.getExePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandLine.exePath");
                String executablePath = string;
                commandLine.setExePath("setsid");
                commandLine.getParametersList().prependAll(executablePath);
            }
        }
    }

    @Deprecated(message="use {@link #execAndGetOutput(GeneralCommandLine)} instead")
    @JvmStatic
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull List<String> command, @Nullable String workDir) throws ExecutionException {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(command).withWorkDirectory(workDir);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine(comma\u2026ithWorkDirectory(workDir)");
        GeneralCommandLine commandLine = generalCommandLine;
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessHandler(commandLine).runProcess()");
        return processOutput;
    }

    private ExecUtil() {
    }

    static {
        ExecUtil execUtil;
        INSTANCE = execUtil = new ExecUtil();
        hasGkSudo = new PathExecLazyValue("gksudo");
        hasKdeSudo = new PathExecLazyValue("kdesudo");
        hasPkExec = new PathExecLazyValue("pkexec");
        hasGnomeTerminal = new PathExecLazyValue("gnome-terminal");
        hasKdeTerminal = new PathExecLazyValue("konsole");
        hasUrxvt = new PathExecLazyValue("urxvt");
        hasXTerm = new PathExecLazyValue("xterm");
        hasSetsid = new PathExecLazyValue("setsid");
        hasNice$delegate = LazyKt.lazy((Function0)hasNice.2.INSTANCE);
    }

    public static final /* synthetic */ String access$escapeAppleScriptArgument(ExecUtil $this, String arg) {
        return $this.escapeAppleScriptArgument(arg);
    }
}

