/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.integratedBinaryPacking;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;

public final class IntBitPacker {
    public static int compressIntegrated(int[] in, int startIndex, int endIndex, int[] out, int initValue) {
        int mBits3;
        int initOffset3;
        int mBits2;
        int initOffset2;
        int mBits1;
        int tmpOutPos = 0;
        while (startIndex + 96 < endIndex) {
            mBits1 = IntBitPacker.maxDiffBits(initValue, in, startIndex);
            initOffset2 = in[startIndex + 31];
            mBits2 = IntBitPacker.maxDiffBits(initOffset2, in, startIndex + 32);
            initOffset3 = in[startIndex + 63];
            mBits3 = IntBitPacker.maxDiffBits(initOffset3, in, startIndex + 64);
            int initOffset4 = in[startIndex + 95];
            int mBits4 = IntBitPacker.maxDiffBits(initOffset4, in, startIndex + 96);
            out[tmpOutPos++] = mBits1 << 24 | mBits2 << 16 | mBits3 << 8 | mBits4;
            IntBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
            IntBitPacker.pack(initOffset2, in, startIndex + 32, out, tmpOutPos += mBits1, mBits2);
            IntBitPacker.pack(initOffset3, in, startIndex + 64, out, tmpOutPos += mBits2, mBits3);
            IntBitPacker.pack(initOffset4, in, startIndex + 96, out, tmpOutPos += mBits3, mBits4);
            tmpOutPos += mBits4;
            initValue = in[startIndex + 127];
            startIndex += 128;
        }
        switch (endIndex - startIndex) {
            case 32: {
                mBits1 = IntBitPacker.maxDiffBits(initValue, in, startIndex);
                out[tmpOutPos++] = mBits1;
                IntBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
                return tmpOutPos + mBits1;
            }
            case 64: {
                mBits1 = IntBitPacker.maxDiffBits(initValue, in, startIndex);
                initOffset2 = in[startIndex + 31];
                mBits2 = IntBitPacker.maxDiffBits(initOffset2, in, startIndex + 32);
                out[tmpOutPos++] = mBits1 << 8 | mBits2;
                IntBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
                IntBitPacker.pack(initOffset2, in, startIndex + 32, out, tmpOutPos += mBits1, mBits2);
                return tmpOutPos + mBits2;
            }
            case 96: {
                mBits1 = IntBitPacker.maxDiffBits(initValue, in, startIndex);
                initOffset2 = in[startIndex + 31];
                mBits2 = IntBitPacker.maxDiffBits(initOffset2, in, startIndex + 32);
                initOffset3 = in[startIndex + 63];
                mBits3 = IntBitPacker.maxDiffBits(initOffset3, in, startIndex + 64);
                out[tmpOutPos++] = mBits1 << 16 | mBits2 << 8 | mBits3;
                IntBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
                IntBitPacker.pack(initOffset2, in, startIndex + 32, out, tmpOutPos += mBits1, mBits2);
                IntBitPacker.pack(initOffset3, in, startIndex + 64, out, tmpOutPos += mBits2, mBits3);
                return tmpOutPos + mBits3;
            }
            case 0: {
                return tmpOutPos;
            }
        }
        throw new IllegalStateException();
    }

    public static void decompressIntegrated(int[] in, int startIndex, int[] out, int outPosition, int outEndIndex, int initValue) {
        int mBits3;
        int mBits2;
        int mBits1;
        assert (outEndIndex != 0);
        int index = startIndex;
        int s = outPosition;
        while (s + 127 < outEndIndex) {
            mBits1 = in[index] >>> 24;
            mBits2 = in[index] >>> 16 & 0xFF;
            mBits3 = in[index] >>> 8 & 0xFF;
            int mBits4 = in[index] & 0xFF;
            IntBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
            initValue = out[s + 31];
            IntBitPacker.unpack(initValue, in, index += mBits1, out, s + 32, mBits2);
            initValue = out[s + 63];
            IntBitPacker.unpack(initValue, in, index += mBits2, out, s + 64, mBits3);
            initValue = out[s + 95];
            IntBitPacker.unpack(initValue, in, index += mBits3, out, s + 96, mBits4);
            index += mBits4;
            initValue = out[s + 127];
            s += 128;
        }
        switch (outEndIndex - s) {
            case 32: {
                mBits1 = in[index] & 0xFF;
                IntBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
                break;
            }
            case 64: {
                mBits1 = in[index] >>> 8;
                mBits2 = in[index] & 0xFF;
                IntBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
                initValue = out[s + 31];
                IntBitPacker.unpack(initValue, in, index += mBits1, out, s + 32, mBits2);
                break;
            }
            case 96: {
                mBits1 = in[index] >>> 16;
                mBits2 = in[index] >>> 8 & 0xFF;
                mBits3 = in[index] & 0xFF;
                IntBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
                initValue = out[s + 31];
                IntBitPacker.unpack(initValue, in, index += mBits1, out, s + 32, mBits2);
                initValue = out[s + 63];
                IntBitPacker.unpack(initValue, in, index += mBits2, out, s + 64, mBits3);
            }
        }
    }

    public static void writeVar(ByteBuf buf, int value) {
        if (value >>> 7 == 0) {
            buf.writeByte((int)((byte)value));
        } else if (value >>> 14 == 0) {
            buf.writeByte((int)((byte)(value & 0x7F | 0x80)));
            buf.writeByte((int)((byte)(value >>> 7)));
        } else if (value >>> 21 == 0) {
            buf.writeByte((int)((byte)(value & 0x7F | 0x80)));
            buf.writeByte((int)((byte)(value >>> 7 | 0x80)));
            buf.writeByte((int)((byte)(value >>> 14)));
        } else if (value >>> 28 == 0) {
            buf.writeByte((int)((byte)(value & 0x7F | 0x80)));
            buf.writeByte((int)((byte)(value >>> 7 | 0x80)));
            buf.writeByte((int)((byte)(value >>> 14 | 0x80)));
            buf.writeByte((int)((byte)(value >>> 21)));
        } else {
            buf.writeByte((int)((byte)(value & 0x7F | 0x80)));
            buf.writeByte((int)((byte)(value >>> 7 | 0x80)));
            buf.writeByte((int)((byte)(value >>> 14 | 0x80)));
            buf.writeByte((int)((byte)(value >>> 21 | 0x80)));
            buf.writeByte((int)((byte)(value >>> 28)));
        }
    }

    public static int readVar(ByteBuf buf) {
        byte aByte = buf.readByte();
        int value = aByte & 0x7F;
        if ((aByte & 0x80) != 0) {
            aByte = buf.readByte();
            value |= (aByte & 0x7F) << 7;
            if ((aByte & 0x80) != 0) {
                aByte = buf.readByte();
                value |= (aByte & 0x7F) << 14;
                if ((aByte & 0x80) != 0) {
                    aByte = buf.readByte();
                    value |= (aByte & 0x7F) << 21;
                    if ((aByte & 0x80) != 0) {
                        value |= buf.readByte() << 28;
                    }
                }
            }
        }
        return value;
    }

    public static void compressVariable(int[] in, int startIndex, int endIndex, ByteBuf buf) {
        int initValue = 0;
        for (int index = startIndex; index < endIndex; ++index) {
            int value = in[index] - initValue;
            initValue = in[index];
            if (value >>> 7 == 0) {
                buf.writeByte((int)((byte)value));
                continue;
            }
            if (value >>> 14 == 0) {
                buf.writeByte((int)((byte)(value & 0x7F | 0x80)));
                buf.writeByte((int)((byte)(value >>> 7)));
                continue;
            }
            if (value >>> 21 == 0) {
                buf.writeByte((int)((byte)(value & 0x7F | 0x80)));
                buf.writeByte((int)((byte)(value >>> 7 | 0x80)));
                buf.writeByte((int)((byte)(value >>> 14)));
                continue;
            }
            if (value >>> 28 == 0) {
                buf.writeByte((int)((byte)(value & 0x7F | 0x80)));
                buf.writeByte((int)((byte)(value >>> 7 | 0x80)));
                buf.writeByte((int)((byte)(value >>> 14 | 0x80)));
                buf.writeByte((int)((byte)(value >>> 21)));
                continue;
            }
            buf.writeByte((int)((byte)(value & 0x7F | 0x80)));
            buf.writeByte((int)((byte)(value >>> 7 | 0x80)));
            buf.writeByte((int)((byte)(value >>> 14 | 0x80)));
            buf.writeByte((int)((byte)(value >>> 21 | 0x80)));
            buf.writeByte((int)((byte)(value >>> 28)));
        }
    }

    public static void decompressVariable(ByteBuf buf, int[] out, int endIndex) {
        int initValue = 0;
        int index = 0;
        while (index < endIndex) {
            byte aByte = buf.readByte();
            int value = aByte & 0x7F;
            if ((aByte & 0x80) != 0) {
                aByte = buf.readByte();
                value |= (aByte & 0x7F) << 7;
                if ((aByte & 0x80) != 0) {
                    aByte = buf.readByte();
                    value |= (aByte & 0x7F) << 14;
                    if ((aByte & 0x80) != 0) {
                        aByte = buf.readByte();
                        value |= (aByte & 0x7F) << 21;
                        if ((aByte & 0x80) != 0) {
                            value |= buf.readByte() << 28;
                        }
                    }
                }
            }
            out[index++] = initValue += value;
        }
    }

    private static int maxDiffBits(int initValue, int[] in, int position) {
        int mask = in[position] - initValue;
        for (int i = position + 1; i < position + 32; ++i) {
            mask |= in[i] - in[i - 1];
        }
        return 32 - Integer.numberOfLeadingZeros(mask);
    }

    private static void pack(int initValue, int[] in, int inPos, int[] out, int outPos, int bitCount) {
        switch ((byte)bitCount) {
            case 0: {
                break;
            }
            case 1: {
                IntBitPacker.pack1(initValue, in, inPos, out, outPos);
                break;
            }
            case 2: {
                IntBitPacker.pack2(initValue, in, inPos, out, outPos);
                break;
            }
            case 3: {
                IntBitPacker.pack3(initValue, in, inPos, out, outPos);
                break;
            }
            case 4: {
                IntBitPacker.pack4(initValue, in, inPos, out, outPos);
                break;
            }
            case 5: {
                IntBitPacker.pack5(initValue, in, inPos, out, outPos);
                break;
            }
            case 6: {
                IntBitPacker.pack6(initValue, in, inPos, out, outPos);
                break;
            }
            case 7: {
                IntBitPacker.pack7(initValue, in, inPos, out, outPos);
                break;
            }
            case 8: {
                IntBitPacker.pack8(initValue, in, inPos, out, outPos);
                break;
            }
            case 9: {
                IntBitPacker.pack9(initValue, in, inPos, out, outPos);
                break;
            }
            case 10: {
                IntBitPacker.pack10(initValue, in, inPos, out, outPos);
                break;
            }
            case 11: {
                IntBitPacker.pack11(initValue, in, inPos, out, outPos);
                break;
            }
            case 12: {
                IntBitPacker.pack12(initValue, in, inPos, out, outPos);
                break;
            }
            case 13: {
                IntBitPacker.pack13(initValue, in, inPos, out, outPos);
                break;
            }
            case 14: {
                IntBitPacker.pack14(initValue, in, inPos, out, outPos);
                break;
            }
            case 15: {
                IntBitPacker.pack15(initValue, in, inPos, out, outPos);
                break;
            }
            case 16: {
                IntBitPacker.pack16(initValue, in, inPos, out, outPos);
                break;
            }
            case 17: {
                IntBitPacker.pack17(initValue, in, inPos, out, outPos);
                break;
            }
            case 18: {
                IntBitPacker.pack18(initValue, in, inPos, out, outPos);
                break;
            }
            case 19: {
                IntBitPacker.pack19(initValue, in, inPos, out, outPos);
                break;
            }
            case 20: {
                IntBitPacker.pack20(initValue, in, inPos, out, outPos);
                break;
            }
            case 21: {
                IntBitPacker.pack21(initValue, in, inPos, out, outPos);
                break;
            }
            case 22: {
                IntBitPacker.pack22(initValue, in, inPos, out, outPos);
                break;
            }
            case 23: {
                IntBitPacker.pack23(initValue, in, inPos, out, outPos);
                break;
            }
            case 24: {
                IntBitPacker.pack24(initValue, in, inPos, out, outPos);
                break;
            }
            case 25: {
                IntBitPacker.pack25(initValue, in, inPos, out, outPos);
                break;
            }
            case 26: {
                IntBitPacker.pack26(initValue, in, inPos, out, outPos);
                break;
            }
            case 27: {
                IntBitPacker.pack27(initValue, in, inPos, out, outPos);
                break;
            }
            case 28: {
                IntBitPacker.pack28(initValue, in, inPos, out, outPos);
                break;
            }
            case 29: {
                IntBitPacker.pack29(initValue, in, inPos, out, outPos);
                break;
            }
            case 30: {
                IntBitPacker.pack30(initValue, in, inPos, out, outPos);
                break;
            }
            case 31: {
                IntBitPacker.pack31(initValue, in, inPos, out, outPos);
                break;
            }
            case 32: {
                System.arraycopy(in, inPos, out, outPos, 32);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported bit width: " + bitCount);
            }
        }
    }

    private static void unpack(int initValue, int[] in, int inPos, int[] out, int outPos, int bitCount) {
        switch ((byte)bitCount) {
            case 0: {
                Arrays.fill(out, outPos, outPos + 32, initValue);
                break;
            }
            case 1: {
                IntBitPacker.unpack1(initValue, in, inPos, out, outPos);
                break;
            }
            case 2: {
                IntBitPacker.unpack2(initValue, in, inPos, out, outPos);
                break;
            }
            case 3: {
                IntBitPacker.unpack3(initValue, in, inPos, out, outPos);
                break;
            }
            case 4: {
                IntBitPacker.unpack4(initValue, in, inPos, out, outPos);
                break;
            }
            case 5: {
                IntBitPacker.unpack5(initValue, in, inPos, out, outPos);
                break;
            }
            case 6: {
                IntBitPacker.unpack6(initValue, in, inPos, out, outPos);
                break;
            }
            case 7: {
                IntBitPacker.unpack7(initValue, in, inPos, out, outPos);
                break;
            }
            case 8: {
                IntBitPacker.unpack8(initValue, in, inPos, out, outPos);
                break;
            }
            case 9: {
                IntBitPacker.unpack9(initValue, in, inPos, out, outPos);
                break;
            }
            case 10: {
                IntBitPacker.unpack10(initValue, in, inPos, out, outPos);
                break;
            }
            case 11: {
                IntBitPacker.unpack11(initValue, in, inPos, out, outPos);
                break;
            }
            case 12: {
                IntBitPacker.unpack12(initValue, in, inPos, out, outPos);
                break;
            }
            case 13: {
                IntBitPacker.unpack13(initValue, in, inPos, out, outPos);
                break;
            }
            case 14: {
                IntBitPacker.unpack14(initValue, in, inPos, out, outPos);
                break;
            }
            case 15: {
                IntBitPacker.unpack15(initValue, in, inPos, out, outPos);
                break;
            }
            case 16: {
                IntBitPacker.unpack16(initValue, in, inPos, out, outPos);
                break;
            }
            case 17: {
                IntBitPacker.unpack17(initValue, in, inPos, out, outPos);
                break;
            }
            case 18: {
                IntBitPacker.unpack18(initValue, in, inPos, out, outPos);
                break;
            }
            case 19: {
                IntBitPacker.unpack19(initValue, in, inPos, out, outPos);
                break;
            }
            case 20: {
                IntBitPacker.unpack20(initValue, in, inPos, out, outPos);
                break;
            }
            case 21: {
                IntBitPacker.unpack21(initValue, in, inPos, out, outPos);
                break;
            }
            case 22: {
                IntBitPacker.unpack22(initValue, in, inPos, out, outPos);
                break;
            }
            case 23: {
                IntBitPacker.unpack23(initValue, in, inPos, out, outPos);
                break;
            }
            case 24: {
                IntBitPacker.unpack24(initValue, in, inPos, out, outPos);
                break;
            }
            case 25: {
                IntBitPacker.unpack25(initValue, in, inPos, out, outPos);
                break;
            }
            case 26: {
                IntBitPacker.unpack26(initValue, in, inPos, out, outPos);
                break;
            }
            case 27: {
                IntBitPacker.unpack27(initValue, in, inPos, out, outPos);
                break;
            }
            case 28: {
                IntBitPacker.unpack28(initValue, in, inPos, out, outPos);
                break;
            }
            case 29: {
                IntBitPacker.unpack29(initValue, in, inPos, out, outPos);
                break;
            }
            case 30: {
                IntBitPacker.unpack30(initValue, in, inPos, out, outPos);
                break;
            }
            case 31: {
                IntBitPacker.unpack31(initValue, in, inPos, out, outPos);
                break;
            }
            case 32: {
                System.arraycopy(in, inPos, out, outPos, 32);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported bit width: " + bitCount);
            }
        }
    }

    private static void pack1(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 1 | in[inPos + 2] - in[inPos + 1] << 2 | in[inPos + 3] - in[inPos + 2] << 3 | in[inPos + 4] - in[inPos + 3] << 4 | in[inPos + 5] - in[inPos + 4] << 5 | in[inPos + 6] - in[inPos + 5] << 6 | in[inPos + 7] - in[inPos + 6] << 7 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 9 | in[inPos + 10] - in[inPos + 9] << 10 | in[inPos + 11] - in[inPos + 10] << 11 | in[inPos + 12] - in[inPos + 11] << 12 | in[inPos + 13] - in[inPos + 12] << 13 | in[inPos + 14] - in[inPos + 13] << 14 | in[inPos + 15] - in[inPos + 14] << 15 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 17 | in[inPos + 18] - in[inPos + 17] << 18 | in[inPos + 19] - in[inPos + 18] << 19 | in[inPos + 20] - in[inPos + 19] << 20 | in[inPos + 21] - in[inPos + 20] << 21 | in[inPos + 22] - in[inPos + 21] << 22 | in[inPos + 23] - in[inPos + 22] << 23 | in[inPos + 24] - in[inPos + 23] << 24 | in[inPos + 25] - in[inPos + 24] << 25 | in[inPos + 26] - in[inPos + 25] << 26 | in[inPos + 27] - in[inPos + 26] << 27 | in[inPos + 28] - in[inPos + 27] << 28 | in[inPos + 29] - in[inPos + 28] << 29 | in[inPos + 30] - in[inPos + 29] << 30 | in[inPos + 31] - in[inPos + 30] << 31;
    }

    private static void unpack1(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 1) + initValue;
        out[outPos + 1] = (in[inPos] >>> 1 & 1) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 2 & 1) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 3 & 1) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 4 & 1) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 5 & 1) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 6 & 1) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 7 & 1) + out[outPos + 6];
        out[outPos + 8] = (in[inPos] >>> 8 & 1) + out[outPos + 7];
        out[outPos + 9] = (in[inPos] >>> 9 & 1) + out[outPos + 8];
        out[outPos + 10] = (in[inPos] >>> 10 & 1) + out[outPos + 9];
        out[outPos + 11] = (in[inPos] >>> 11 & 1) + out[outPos + 10];
        out[outPos + 12] = (in[inPos] >>> 12 & 1) + out[outPos + 11];
        out[outPos + 13] = (in[inPos] >>> 13 & 1) + out[outPos + 12];
        out[outPos + 14] = (in[inPos] >>> 14 & 1) + out[outPos + 13];
        out[outPos + 15] = (in[inPos] >>> 15 & 1) + out[outPos + 14];
        out[outPos + 16] = (in[inPos] >>> 16 & 1) + out[outPos + 15];
        out[outPos + 17] = (in[inPos] >>> 17 & 1) + out[outPos + 16];
        out[outPos + 18] = (in[inPos] >>> 18 & 1) + out[outPos + 17];
        out[outPos + 19] = (in[inPos] >>> 19 & 1) + out[outPos + 18];
        out[outPos + 20] = (in[inPos] >>> 20 & 1) + out[outPos + 19];
        out[outPos + 21] = (in[inPos] >>> 21 & 1) + out[outPos + 20];
        out[outPos + 22] = (in[inPos] >>> 22 & 1) + out[outPos + 21];
        out[outPos + 23] = (in[inPos] >>> 23 & 1) + out[outPos + 22];
        out[outPos + 24] = (in[inPos] >>> 24 & 1) + out[outPos + 23];
        out[outPos + 25] = (in[inPos] >>> 25 & 1) + out[outPos + 24];
        out[outPos + 26] = (in[inPos] >>> 26 & 1) + out[outPos + 25];
        out[outPos + 27] = (in[inPos] >>> 27 & 1) + out[outPos + 26];
        out[outPos + 28] = (in[inPos] >>> 28 & 1) + out[outPos + 27];
        out[outPos + 29] = (in[inPos] >>> 29 & 1) + out[outPos + 28];
        out[outPos + 30] = (in[inPos] >>> 30 & 1) + out[outPos + 29];
        out[outPos + 31] = (in[inPos] >>> 31) + out[outPos + 30];
    }

    private static void pack2(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 2 | in[inPos + 2] - in[inPos + 1] << 4 | in[inPos + 3] - in[inPos + 2] << 6 | in[inPos + 4] - in[inPos + 3] << 8 | in[inPos + 5] - in[inPos + 4] << 10 | in[inPos + 6] - in[inPos + 5] << 12 | in[inPos + 7] - in[inPos + 6] << 14 | in[inPos + 8] - in[inPos + 7] << 16 | in[inPos + 9] - in[inPos + 8] << 18 | in[inPos + 10] - in[inPos + 9] << 20 | in[inPos + 11] - in[inPos + 10] << 22 | in[inPos + 12] - in[inPos + 11] << 24 | in[inPos + 13] - in[inPos + 12] << 26 | in[inPos + 14] - in[inPos + 13] << 28 | in[inPos + 15] - in[inPos + 14] << 30;
        out[outPos + 1] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 2 | in[inPos + 18] - in[inPos + 17] << 4 | in[inPos + 19] - in[inPos + 18] << 6 | in[inPos + 20] - in[inPos + 19] << 8 | in[inPos + 21] - in[inPos + 20] << 10 | in[inPos + 22] - in[inPos + 21] << 12 | in[inPos + 23] - in[inPos + 22] << 14 | in[inPos + 24] - in[inPos + 23] << 16 | in[inPos + 25] - in[inPos + 24] << 18 | in[inPos + 26] - in[inPos + 25] << 20 | in[inPos + 27] - in[inPos + 26] << 22 | in[inPos + 28] - in[inPos + 27] << 24 | in[inPos + 29] - in[inPos + 28] << 26 | in[inPos + 30] - in[inPos + 29] << 28 | in[inPos + 31] - in[inPos + 30] << 30;
    }

    private static void unpack2(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 3) + initValue;
        out[outPos + 1] = (in[inPos] >>> 2 & 3) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 4 & 3) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 6 & 3) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 8 & 3) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 10 & 3) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 12 & 3) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 14 & 3) + out[outPos + 6];
        out[outPos + 8] = (in[inPos] >>> 16 & 3) + out[outPos + 7];
        out[outPos + 9] = (in[inPos] >>> 18 & 3) + out[outPos + 8];
        out[outPos + 10] = (in[inPos] >>> 20 & 3) + out[outPos + 9];
        out[outPos + 11] = (in[inPos] >>> 22 & 3) + out[outPos + 10];
        out[outPos + 12] = (in[inPos] >>> 24 & 3) + out[outPos + 11];
        out[outPos + 13] = (in[inPos] >>> 26 & 3) + out[outPos + 12];
        out[outPos + 14] = (in[inPos] >>> 28 & 3) + out[outPos + 13];
        out[outPos + 15] = (in[inPos] >>> 30) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 1] & 3) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 1] >>> 2 & 3) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 1] >>> 4 & 3) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 1] >>> 6 & 3) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 1] >>> 8 & 3) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 1] >>> 10 & 3) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 1] >>> 12 & 3) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 1] >>> 14 & 3) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 1] >>> 16 & 3) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 1] >>> 18 & 3) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 1] >>> 20 & 3) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 1] >>> 22 & 3) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 1] >>> 24 & 3) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 1] >>> 26 & 3) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 1] >>> 28 & 3) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 1] >>> 30) + out[outPos + 30];
    }

    private static void pack3(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 3 | in[inPos + 2] - in[inPos + 1] << 6 | in[inPos + 3] - in[inPos + 2] << 9 | in[inPos + 4] - in[inPos + 3] << 12 | in[inPos + 5] - in[inPos + 4] << 15 | in[inPos + 6] - in[inPos + 5] << 18 | in[inPos + 7] - in[inPos + 6] << 21 | in[inPos + 8] - in[inPos + 7] << 24 | in[inPos + 9] - in[inPos + 8] << 27 | in[inPos + 10] - in[inPos + 9] << 30;
        out[outPos + 1] = in[inPos + 10] - in[inPos + 9] >>> 2 | in[inPos + 11] - in[inPos + 10] << 1 | in[inPos + 12] - in[inPos + 11] << 4 | in[inPos + 13] - in[inPos + 12] << 7 | in[inPos + 14] - in[inPos + 13] << 10 | in[inPos + 15] - in[inPos + 14] << 13 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 19 | in[inPos + 18] - in[inPos + 17] << 22 | in[inPos + 19] - in[inPos + 18] << 25 | in[inPos + 20] - in[inPos + 19] << 28 | in[inPos + 21] - in[inPos + 20] << 31;
        out[outPos + 2] = in[inPos + 21] - in[inPos + 20] >>> 1 | in[inPos + 22] - in[inPos + 21] << 2 | in[inPos + 23] - in[inPos + 22] << 5 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 11 | in[inPos + 26] - in[inPos + 25] << 14 | in[inPos + 27] - in[inPos + 26] << 17 | in[inPos + 28] - in[inPos + 27] << 20 | in[inPos + 29] - in[inPos + 28] << 23 | in[inPos + 30] - in[inPos + 29] << 26 | in[inPos + 31] - in[inPos + 30] << 29;
    }

    private static void unpack3(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 7) + initValue;
        out[outPos + 1] = (in[inPos] >>> 3 & 7) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 6 & 7) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 9 & 7) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 12 & 7) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 15 & 7) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 18 & 7) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 21 & 7) + out[outPos + 6];
        out[outPos + 8] = (in[inPos] >>> 24 & 7) + out[outPos + 7];
        out[outPos + 9] = (in[inPos] >>> 27 & 7) + out[outPos + 8];
        out[outPos + 10] = (in[inPos] >>> 30 | (in[inPos + 1] & 1) << 2) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 1] >>> 1 & 7) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 1] >>> 4 & 7) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 1] >>> 7 & 7) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 1] >>> 10 & 7) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 1] >>> 13 & 7) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 1] >>> 16 & 7) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 1] >>> 19 & 7) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 1] >>> 22 & 7) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 1] >>> 25 & 7) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 1] >>> 28 & 7) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 1] >>> 31 | (in[inPos + 2] & 3) << 1) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 2] >>> 2 & 7) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 2] >>> 5 & 7) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 2] >>> 8 & 7) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 2] >>> 11 & 7) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 2] >>> 14 & 7) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 2] >>> 17 & 7) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 2] >>> 20 & 7) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 2] >>> 23 & 7) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 2] >>> 26 & 7) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 2] >>> 29) + out[outPos + 30];
    }

    private static void pack4(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 4 | in[inPos + 2] - in[inPos + 1] << 8 | in[inPos + 3] - in[inPos + 2] << 12 | in[inPos + 4] - in[inPos + 3] << 16 | in[inPos + 5] - in[inPos + 4] << 20 | in[inPos + 6] - in[inPos + 5] << 24 | in[inPos + 7] - in[inPos + 6] << 28;
        out[outPos + 1] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 4 | in[inPos + 10] - in[inPos + 9] << 8 | in[inPos + 11] - in[inPos + 10] << 12 | in[inPos + 12] - in[inPos + 11] << 16 | in[inPos + 13] - in[inPos + 12] << 20 | in[inPos + 14] - in[inPos + 13] << 24 | in[inPos + 15] - in[inPos + 14] << 28;
        out[outPos + 2] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 4 | in[inPos + 18] - in[inPos + 17] << 8 | in[inPos + 19] - in[inPos + 18] << 12 | in[inPos + 20] - in[inPos + 19] << 16 | in[inPos + 21] - in[inPos + 20] << 20 | in[inPos + 22] - in[inPos + 21] << 24 | in[inPos + 23] - in[inPos + 22] << 28;
        out[outPos + 3] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 4 | in[inPos + 26] - in[inPos + 25] << 8 | in[inPos + 27] - in[inPos + 26] << 12 | in[inPos + 28] - in[inPos + 27] << 16 | in[inPos + 29] - in[inPos + 28] << 20 | in[inPos + 30] - in[inPos + 29] << 24 | in[inPos + 31] - in[inPos + 30] << 28;
    }

    private static void unpack4(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 4 & 0xF) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 8 & 0xF) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 12 & 0xF) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 16 & 0xF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 20 & 0xF) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 24 & 0xF) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 28) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] & 0xF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 1] >>> 4 & 0xF) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 1] >>> 8 & 0xF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 1] >>> 12 & 0xF) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 1] >>> 16 & 0xF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 1] >>> 20 & 0xF) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 1] >>> 24 & 0xF) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 1] >>> 28) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 2] & 0xF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 2] >>> 4 & 0xF) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 2] >>> 8 & 0xF) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 2] >>> 12 & 0xF) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 2] >>> 16 & 0xF) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 2] >>> 20 & 0xF) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 2] >>> 24 & 0xF) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 2] >>> 28) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 3] & 0xF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 3] >>> 4 & 0xF) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 3] >>> 8 & 0xF) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 3] >>> 12 & 0xF) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 3] >>> 16 & 0xF) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 3] >>> 20 & 0xF) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 3] >>> 24 & 0xF) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 3] >>> 28) + out[outPos + 30];
    }

    private static void pack5(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 5 | in[inPos + 2] - in[inPos + 1] << 10 | in[inPos + 3] - in[inPos + 2] << 15 | in[inPos + 4] - in[inPos + 3] << 20 | in[inPos + 5] - in[inPos + 4] << 25 | in[inPos + 6] - in[inPos + 5] << 30;
        out[outPos + 1] = in[inPos + 6] - in[inPos + 5] >>> 2 | in[inPos + 7] - in[inPos + 6] << 3 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 13 | in[inPos + 10] - in[inPos + 9] << 18 | in[inPos + 11] - in[inPos + 10] << 23 | in[inPos + 12] - in[inPos + 11] << 28;
        out[outPos + 2] = in[inPos + 12] - in[inPos + 11] >>> 4 | in[inPos + 13] - in[inPos + 12] << 1 | in[inPos + 14] - in[inPos + 13] << 6 | in[inPos + 15] - in[inPos + 14] << 11 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 21 | in[inPos + 18] - in[inPos + 17] << 26 | in[inPos + 19] - in[inPos + 18] << 31;
        out[outPos + 3] = in[inPos + 19] - in[inPos + 18] >>> 1 | in[inPos + 20] - in[inPos + 19] << 4 | in[inPos + 21] - in[inPos + 20] << 9 | in[inPos + 22] - in[inPos + 21] << 14 | in[inPos + 23] - in[inPos + 22] << 19 | in[inPos + 24] - in[inPos + 23] << 24 | in[inPos + 25] - in[inPos + 24] << 29;
        out[outPos + 4] = in[inPos + 25] - in[inPos + 24] >>> 3 | in[inPos + 26] - in[inPos + 25] << 2 | in[inPos + 27] - in[inPos + 26] << 7 | in[inPos + 28] - in[inPos + 27] << 12 | in[inPos + 29] - in[inPos + 28] << 17 | in[inPos + 30] - in[inPos + 29] << 22 | in[inPos + 31] - in[inPos + 30] << 27;
    }

    private static void unpack5(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1F) + initValue;
        out[outPos + 1] = (in[inPos] >>> 5 & 0x1F) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 10 & 0x1F) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 15 & 0x1F) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 20 & 0x1F) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 25 & 0x1F) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 30 | (in[inPos + 1] & 7) << 2) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 3 & 0x1F) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] >>> 8 & 0x1F) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 1] >>> 13 & 0x1F) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 1] >>> 18 & 0x1F) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 1] >>> 23 & 0x1F) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 1] >>> 28 | (in[inPos + 2] & 1) << 4) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 2] >>> 1 & 0x1F) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 2] >>> 6 & 0x1F) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 2] >>> 11 & 0x1F) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 2] >>> 16 & 0x1F) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 2] >>> 21 & 0x1F) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 2] >>> 26 & 0x1F) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 2] >>> 31 | (in[inPos + 3] & 0xF) << 1) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 3] >>> 4 & 0x1F) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 3] >>> 9 & 0x1F) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 3] >>> 14 & 0x1F) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 3] >>> 19 & 0x1F) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 3] >>> 24 & 0x1F) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 3] >>> 29 | (in[inPos + 4] & 3) << 3) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 4] >>> 2 & 0x1F) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 4] >>> 7 & 0x1F) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 4] >>> 12 & 0x1F) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 4] >>> 17 & 0x1F) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 4] >>> 22 & 0x1F) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 4] >>> 27) + out[outPos + 30];
    }

    private static void pack6(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 6 | in[inPos + 2] - in[inPos + 1] << 12 | in[inPos + 3] - in[inPos + 2] << 18 | in[inPos + 4] - in[inPos + 3] << 24 | in[inPos + 5] - in[inPos + 4] << 30;
        out[outPos + 1] = in[inPos + 5] - in[inPos + 4] >>> 2 | in[inPos + 6] - in[inPos + 5] << 4 | in[inPos + 7] - in[inPos + 6] << 10 | in[inPos + 8] - in[inPos + 7] << 16 | in[inPos + 9] - in[inPos + 8] << 22 | in[inPos + 10] - in[inPos + 9] << 28;
        out[outPos + 2] = in[inPos + 10] - in[inPos + 9] >>> 4 | in[inPos + 11] - in[inPos + 10] << 2 | in[inPos + 12] - in[inPos + 11] << 8 | in[inPos + 13] - in[inPos + 12] << 14 | in[inPos + 14] - in[inPos + 13] << 20 | in[inPos + 15] - in[inPos + 14] << 26;
        out[outPos + 3] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 6 | in[inPos + 18] - in[inPos + 17] << 12 | in[inPos + 19] - in[inPos + 18] << 18 | in[inPos + 20] - in[inPos + 19] << 24 | in[inPos + 21] - in[inPos + 20] << 30;
        out[outPos + 4] = in[inPos + 21] - in[inPos + 20] >>> 2 | in[inPos + 22] - in[inPos + 21] << 4 | in[inPos + 23] - in[inPos + 22] << 10 | in[inPos + 24] - in[inPos + 23] << 16 | in[inPos + 25] - in[inPos + 24] << 22 | in[inPos + 26] - in[inPos + 25] << 28;
        out[outPos + 5] = in[inPos + 26] - in[inPos + 25] >>> 4 | in[inPos + 27] - in[inPos + 26] << 2 | in[inPos + 28] - in[inPos + 27] << 8 | in[inPos + 29] - in[inPos + 28] << 14 | in[inPos + 30] - in[inPos + 29] << 20 | in[inPos + 31] - in[inPos + 30] << 26;
    }

    private static void unpack6(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3F) + initValue;
        out[outPos + 1] = (in[inPos] >>> 6 & 0x3F) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 12 & 0x3F) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 18 & 0x3F) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 24 & 0x3F) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 30 | (in[inPos + 1] & 0xF) << 2) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 4 & 0x3F) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 10 & 0x3F) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] >>> 16 & 0x3F) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 1] >>> 22 & 0x3F) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 1] >>> 28 | (in[inPos + 2] & 3) << 4) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 2] >>> 2 & 0x3F) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 2] >>> 8 & 0x3F) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 2] >>> 14 & 0x3F) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 2] >>> 20 & 0x3F) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 2] >>> 26) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 3] & 0x3F) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 3] >>> 6 & 0x3F) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 3] >>> 12 & 0x3F) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 3] >>> 18 & 0x3F) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 3] >>> 24 & 0x3F) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 3] >>> 30 | (in[inPos + 4] & 0xF) << 2) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 4] >>> 4 & 0x3F) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 4] >>> 10 & 0x3F) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 4] >>> 16 & 0x3F) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 4] >>> 22 & 0x3F) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 4] >>> 28 | (in[inPos + 5] & 3) << 4) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 5] >>> 2 & 0x3F) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 5] >>> 8 & 0x3F) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 5] >>> 14 & 0x3F) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 5] >>> 20 & 0x3F) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 5] >>> 26) + out[outPos + 30];
    }

    private static void pack7(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 7 | in[inPos + 2] - in[inPos + 1] << 14 | in[inPos + 3] - in[inPos + 2] << 21 | in[inPos + 4] - in[inPos + 3] << 28;
        out[outPos + 1] = in[inPos + 4] - in[inPos + 3] >>> 4 | in[inPos + 5] - in[inPos + 4] << 3 | in[inPos + 6] - in[inPos + 5] << 10 | in[inPos + 7] - in[inPos + 6] << 17 | in[inPos + 8] - in[inPos + 7] << 24 | in[inPos + 9] - in[inPos + 8] << 31;
        out[outPos + 2] = in[inPos + 9] - in[inPos + 8] >>> 1 | in[inPos + 10] - in[inPos + 9] << 6 | in[inPos + 11] - in[inPos + 10] << 13 | in[inPos + 12] - in[inPos + 11] << 20 | in[inPos + 13] - in[inPos + 12] << 27;
        out[outPos + 3] = in[inPos + 13] - in[inPos + 12] >>> 5 | in[inPos + 14] - in[inPos + 13] << 2 | in[inPos + 15] - in[inPos + 14] << 9 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 23 | in[inPos + 18] - in[inPos + 17] << 30;
        out[outPos + 4] = in[inPos + 18] - in[inPos + 17] >>> 2 | in[inPos + 19] - in[inPos + 18] << 5 | in[inPos + 20] - in[inPos + 19] << 12 | in[inPos + 21] - in[inPos + 20] << 19 | in[inPos + 22] - in[inPos + 21] << 26;
        out[outPos + 5] = in[inPos + 22] - in[inPos + 21] >>> 6 | in[inPos + 23] - in[inPos + 22] << 1 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 15 | in[inPos + 26] - in[inPos + 25] << 22 | in[inPos + 27] - in[inPos + 26] << 29;
        out[outPos + 6] = in[inPos + 27] - in[inPos + 26] >>> 3 | in[inPos + 28] - in[inPos + 27] << 4 | in[inPos + 29] - in[inPos + 28] << 11 | in[inPos + 30] - in[inPos + 29] << 18 | in[inPos + 31] - in[inPos + 30] << 25;
    }

    private static void unpack7(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7F) + initValue;
        out[outPos + 1] = (in[inPos] >>> 7 & 0x7F) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 14 & 0x7F) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 21 & 0x7F) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 28 | (in[inPos + 1] & 7) << 4) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 3 & 0x7F) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 10 & 0x7F) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 17 & 0x7F) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] >>> 24 & 0x7F) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 1] >>> 31 | (in[inPos + 2] & 0x3F) << 1) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 2] >>> 6 & 0x7F) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 2] >>> 13 & 0x7F) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 2] >>> 20 & 0x7F) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 2] >>> 27 | (in[inPos + 3] & 3) << 5) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 3] >>> 2 & 0x7F) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 3] >>> 9 & 0x7F) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 3] >>> 16 & 0x7F) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 3] >>> 23 & 0x7F) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 3] >>> 30 | (in[inPos + 4] & 0x1F) << 2) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 4] >>> 5 & 0x7F) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 4] >>> 12 & 0x7F) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 4] >>> 19 & 0x7F) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 4] >>> 26 | (in[inPos + 5] & 1) << 6) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 5] >>> 1 & 0x7F) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 5] >>> 8 & 0x7F) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 5] >>> 15 & 0x7F) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 5] >>> 22 & 0x7F) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 5] >>> 29 | (in[inPos + 6] & 0xF) << 3) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 6] >>> 4 & 0x7F) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 6] >>> 11 & 0x7F) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 6] >>> 18 & 0x7F) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 6] >>> 25) + out[outPos + 30];
    }

    private static void pack8(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 8 | in[inPos + 2] - in[inPos + 1] << 16 | in[inPos + 3] - in[inPos + 2] << 24;
        out[outPos + 1] = in[inPos + 4] - in[inPos + 3] | in[inPos + 5] - in[inPos + 4] << 8 | in[inPos + 6] - in[inPos + 5] << 16 | in[inPos + 7] - in[inPos + 6] << 24;
        out[outPos + 2] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 8 | in[inPos + 10] - in[inPos + 9] << 16 | in[inPos + 11] - in[inPos + 10] << 24;
        out[outPos + 3] = in[inPos + 12] - in[inPos + 11] | in[inPos + 13] - in[inPos + 12] << 8 | in[inPos + 14] - in[inPos + 13] << 16 | in[inPos + 15] - in[inPos + 14] << 24;
        out[outPos + 4] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 8 | in[inPos + 18] - in[inPos + 17] << 16 | in[inPos + 19] - in[inPos + 18] << 24;
        out[outPos + 5] = in[inPos + 20] - in[inPos + 19] | in[inPos + 21] - in[inPos + 20] << 8 | in[inPos + 22] - in[inPos + 21] << 16 | in[inPos + 23] - in[inPos + 22] << 24;
        out[outPos + 6] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 8 | in[inPos + 26] - in[inPos + 25] << 16 | in[inPos + 27] - in[inPos + 26] << 24;
        out[outPos + 7] = in[inPos + 28] - in[inPos + 27] | in[inPos + 29] - in[inPos + 28] << 8 | in[inPos + 30] - in[inPos + 29] << 16 | in[inPos + 31] - in[inPos + 30] << 24;
    }

    private static void unpack8(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 8 & 0xFF) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 16 & 0xFF) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 24) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] & 0xFF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 8 & 0xFF) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 16 & 0xFF) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 24) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] & 0xFF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 2] >>> 8 & 0xFF) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 2] >>> 16 & 0xFF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 2] >>> 24) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 3] & 0xFF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 3] >>> 8 & 0xFF) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 3] >>> 16 & 0xFF) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 3] >>> 24) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 4] & 0xFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 4] >>> 8 & 0xFF) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 4] >>> 16 & 0xFF) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 4] >>> 24) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 5] & 0xFF) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 5] >>> 8 & 0xFF) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 5] >>> 16 & 0xFF) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 5] >>> 24) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 6] & 0xFF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 6] >>> 8 & 0xFF) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 6] >>> 16 & 0xFF) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 6] >>> 24) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 7] & 0xFF) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 7] >>> 8 & 0xFF) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 7] >>> 16 & 0xFF) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 7] >>> 24) + out[outPos + 30];
    }

    private static void pack9(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 9 | in[inPos + 2] - in[inPos + 1] << 18 | in[inPos + 3] - in[inPos + 2] << 27;
        out[outPos + 1] = in[inPos + 3] - in[inPos + 2] >>> 5 | in[inPos + 4] - in[inPos + 3] << 4 | in[inPos + 5] - in[inPos + 4] << 13 | in[inPos + 6] - in[inPos + 5] << 22 | in[inPos + 7] - in[inPos + 6] << 31;
        out[outPos + 2] = in[inPos + 7] - in[inPos + 6] >>> 1 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 17 | in[inPos + 10] - in[inPos + 9] << 26;
        out[outPos + 3] = in[inPos + 10] - in[inPos + 9] >>> 6 | in[inPos + 11] - in[inPos + 10] << 3 | in[inPos + 12] - in[inPos + 11] << 12 | in[inPos + 13] - in[inPos + 12] << 21 | in[inPos + 14] - in[inPos + 13] << 30;
        out[outPos + 4] = in[inPos + 14] - in[inPos + 13] >>> 2 | in[inPos + 15] - in[inPos + 14] << 7 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 25;
        out[outPos + 5] = in[inPos + 17] - in[inPos + 16] >>> 7 | in[inPos + 18] - in[inPos + 17] << 2 | in[inPos + 19] - in[inPos + 18] << 11 | in[inPos + 20] - in[inPos + 19] << 20 | in[inPos + 21] - in[inPos + 20] << 29;
        out[outPos + 6] = in[inPos + 21] - in[inPos + 20] >>> 3 | in[inPos + 22] - in[inPos + 21] << 6 | in[inPos + 23] - in[inPos + 22] << 15 | in[inPos + 24] - in[inPos + 23] << 24;
        out[outPos + 7] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 1 | in[inPos + 26] - in[inPos + 25] << 10 | in[inPos + 27] - in[inPos + 26] << 19 | in[inPos + 28] - in[inPos + 27] << 28;
        out[outPos + 8] = in[inPos + 28] - in[inPos + 27] >>> 4 | in[inPos + 29] - in[inPos + 28] << 5 | in[inPos + 30] - in[inPos + 29] << 14 | in[inPos + 31] - in[inPos + 30] << 23;
    }

    private static void unpack9(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 9 & 0x1FF) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 18 & 0x1FF) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 27 | (in[inPos + 1] & 0xF) << 5) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 4 & 0x1FF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 13 & 0x1FF) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 22 & 0x1FF) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 31 | (in[inPos + 2] & 0xFF) << 1) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] >>> 8 & 0x1FF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 2] >>> 17 & 0x1FF) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 2] >>> 26 | (in[inPos + 3] & 7) << 6) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 3] >>> 3 & 0x1FF) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 3] >>> 12 & 0x1FF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 3] >>> 21 & 0x1FF) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 3] >>> 30 | (in[inPos + 4] & 0x7F) << 2) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 4] >>> 7 & 0x1FF) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 4] >>> 16 & 0x1FF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 4] >>> 25 | (in[inPos + 5] & 3) << 7) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 5] >>> 2 & 0x1FF) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 5] >>> 11 & 0x1FF) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 5] >>> 20 & 0x1FF) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 5] >>> 29 | (in[inPos + 6] & 0x3F) << 3) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 6] >>> 6 & 0x1FF) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 6] >>> 15 & 0x1FF) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 6] >>> 24 | (in[inPos + 7] & 1) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 7] >>> 1 & 0x1FF) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 7] >>> 10 & 0x1FF) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 7] >>> 19 & 0x1FF) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 7] >>> 28 | (in[inPos + 8] & 0x1F) << 4) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 8] >>> 5 & 0x1FF) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 8] >>> 14 & 0x1FF) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 8] >>> 23) + out[outPos + 30];
    }

    private static void pack10(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 10 | in[inPos + 2] - in[inPos + 1] << 20 | in[inPos + 3] - in[inPos + 2] << 30;
        out[outPos + 1] = in[inPos + 3] - in[inPos + 2] >>> 2 | in[inPos + 4] - in[inPos + 3] << 8 | in[inPos + 5] - in[inPos + 4] << 18 | in[inPos + 6] - in[inPos + 5] << 28;
        out[outPos + 2] = in[inPos + 6] - in[inPos + 5] >>> 4 | in[inPos + 7] - in[inPos + 6] << 6 | in[inPos + 8] - in[inPos + 7] << 16 | in[inPos + 9] - in[inPos + 8] << 26;
        out[outPos + 3] = in[inPos + 9] - in[inPos + 8] >>> 6 | in[inPos + 10] - in[inPos + 9] << 4 | in[inPos + 11] - in[inPos + 10] << 14 | in[inPos + 12] - in[inPos + 11] << 24;
        out[outPos + 4] = in[inPos + 12] - in[inPos + 11] >>> 8 | in[inPos + 13] - in[inPos + 12] << 2 | in[inPos + 14] - in[inPos + 13] << 12 | in[inPos + 15] - in[inPos + 14] << 22;
        out[outPos + 5] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 10 | in[inPos + 18] - in[inPos + 17] << 20 | in[inPos + 19] - in[inPos + 18] << 30;
        out[outPos + 6] = in[inPos + 19] - in[inPos + 18] >>> 2 | in[inPos + 20] - in[inPos + 19] << 8 | in[inPos + 21] - in[inPos + 20] << 18 | in[inPos + 22] - in[inPos + 21] << 28;
        out[outPos + 7] = in[inPos + 22] - in[inPos + 21] >>> 4 | in[inPos + 23] - in[inPos + 22] << 6 | in[inPos + 24] - in[inPos + 23] << 16 | in[inPos + 25] - in[inPos + 24] << 26;
        out[outPos + 8] = in[inPos + 25] - in[inPos + 24] >>> 6 | in[inPos + 26] - in[inPos + 25] << 4 | in[inPos + 27] - in[inPos + 26] << 14 | in[inPos + 28] - in[inPos + 27] << 24;
        out[outPos + 9] = in[inPos + 28] - in[inPos + 27] >>> 8 | in[inPos + 29] - in[inPos + 28] << 2 | in[inPos + 30] - in[inPos + 29] << 12 | in[inPos + 31] - in[inPos + 30] << 22;
    }

    private static void unpack10(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 10 & 0x3FF) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 20 & 0x3FF) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 30 | (in[inPos + 1] & 0xFF) << 2) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 8 & 0x3FF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 18 & 0x3FF) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 28 | (in[inPos + 2] & 0x3F) << 4) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 6 & 0x3FF) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] >>> 16 & 0x3FF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 2] >>> 26 | (in[inPos + 3] & 0xF) << 6) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 3] >>> 4 & 0x3FF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 3] >>> 14 & 0x3FF) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 3] >>> 24 | (in[inPos + 4] & 3) << 8) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 4] >>> 2 & 0x3FF) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 4] >>> 12 & 0x3FF) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 4] >>> 22) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 5] & 0x3FF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 5] >>> 10 & 0x3FF) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 5] >>> 20 & 0x3FF) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 5] >>> 30 | (in[inPos + 6] & 0xFF) << 2) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 6] >>> 8 & 0x3FF) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 6] >>> 18 & 0x3FF) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 6] >>> 28 | (in[inPos + 7] & 0x3F) << 4) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 7] >>> 6 & 0x3FF) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 7] >>> 16 & 0x3FF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 7] >>> 26 | (in[inPos + 8] & 0xF) << 6) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 8] >>> 4 & 0x3FF) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 8] >>> 14 & 0x3FF) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 8] >>> 24 | (in[inPos + 9] & 3) << 8) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 9] >>> 2 & 0x3FF) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 9] >>> 12 & 0x3FF) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 9] >>> 22) + out[outPos + 30];
    }

    private static void pack11(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 11 | in[inPos + 2] - in[inPos + 1] << 22;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 10 | in[inPos + 3] - in[inPos + 2] << 1 | in[inPos + 4] - in[inPos + 3] << 12 | in[inPos + 5] - in[inPos + 4] << 23;
        out[outPos + 2] = in[inPos + 5] - in[inPos + 4] >>> 9 | in[inPos + 6] - in[inPos + 5] << 2 | in[inPos + 7] - in[inPos + 6] << 13 | in[inPos + 8] - in[inPos + 7] << 24;
        out[outPos + 3] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 3 | in[inPos + 10] - in[inPos + 9] << 14 | in[inPos + 11] - in[inPos + 10] << 25;
        out[outPos + 4] = in[inPos + 11] - in[inPos + 10] >>> 7 | in[inPos + 12] - in[inPos + 11] << 4 | in[inPos + 13] - in[inPos + 12] << 15 | in[inPos + 14] - in[inPos + 13] << 26;
        out[outPos + 5] = in[inPos + 14] - in[inPos + 13] >>> 6 | in[inPos + 15] - in[inPos + 14] << 5 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 27;
        out[outPos + 6] = in[inPos + 17] - in[inPos + 16] >>> 5 | in[inPos + 18] - in[inPos + 17] << 6 | in[inPos + 19] - in[inPos + 18] << 17 | in[inPos + 20] - in[inPos + 19] << 28;
        out[outPos + 7] = in[inPos + 20] - in[inPos + 19] >>> 4 | in[inPos + 21] - in[inPos + 20] << 7 | in[inPos + 22] - in[inPos + 21] << 18 | in[inPos + 23] - in[inPos + 22] << 29;
        out[outPos + 8] = in[inPos + 23] - in[inPos + 22] >>> 3 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 19 | in[inPos + 26] - in[inPos + 25] << 30;
        out[outPos + 9] = in[inPos + 26] - in[inPos + 25] >>> 2 | in[inPos + 27] - in[inPos + 26] << 9 | in[inPos + 28] - in[inPos + 27] << 20 | in[inPos + 29] - in[inPos + 28] << 31;
        out[outPos + 10] = in[inPos + 29] - in[inPos + 28] >>> 1 | in[inPos + 30] - in[inPos + 29] << 10 | in[inPos + 31] - in[inPos + 30] << 21;
    }

    private static void unpack11(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 11 & 0x7FF) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 22 | (in[inPos + 1] & 1) << 10) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 1 & 0x7FF) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 12 & 0x7FF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 23 | (in[inPos + 2] & 3) << 9) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 2 & 0x7FF) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 13 & 0x7FF) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] >>> 24 | (in[inPos + 3] & 7) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 3] >>> 3 & 0x7FF) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 3] >>> 14 & 0x7FF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 3] >>> 25 | (in[inPos + 4] & 0xF) << 7) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 4] >>> 4 & 0x7FF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 4] >>> 15 & 0x7FF) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 4] >>> 26 | (in[inPos + 5] & 0x1F) << 6) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 5] >>> 5 & 0x7FF) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 5] >>> 16 & 0x7FF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 5] >>> 27 | (in[inPos + 6] & 0x3F) << 5) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 6] >>> 6 & 0x7FF) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 6] >>> 17 & 0x7FF) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 6] >>> 28 | (in[inPos + 7] & 0x7F) << 4) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 7] >>> 7 & 0x7FF) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 7] >>> 18 & 0x7FF) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 7] >>> 29 | (in[inPos + 8] & 0xFF) << 3) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 8] >>> 8 & 0x7FF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 8] >>> 19 & 0x7FF) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 8] >>> 30 | (in[inPos + 9] & 0x1FF) << 2) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 9] >>> 9 & 0x7FF) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 9] >>> 20 & 0x7FF) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 9] >>> 31 | (in[inPos + 10] & 0x3FF) << 1) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 10] >>> 10 & 0x7FF) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 10] >>> 21) + out[outPos + 30];
    }

    private static void pack12(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 12 | in[inPos + 2] - in[inPos + 1] << 24;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 8 | in[inPos + 3] - in[inPos + 2] << 4 | in[inPos + 4] - in[inPos + 3] << 16 | in[inPos + 5] - in[inPos + 4] << 28;
        out[outPos + 2] = in[inPos + 5] - in[inPos + 4] >>> 4 | in[inPos + 6] - in[inPos + 5] << 8 | in[inPos + 7] - in[inPos + 6] << 20;
        out[outPos + 3] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 12 | in[inPos + 10] - in[inPos + 9] << 24;
        out[outPos + 4] = in[inPos + 10] - in[inPos + 9] >>> 8 | in[inPos + 11] - in[inPos + 10] << 4 | in[inPos + 12] - in[inPos + 11] << 16 | in[inPos + 13] - in[inPos + 12] << 28;
        out[outPos + 5] = in[inPos + 13] - in[inPos + 12] >>> 4 | in[inPos + 14] - in[inPos + 13] << 8 | in[inPos + 15] - in[inPos + 14] << 20;
        out[outPos + 6] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 12 | in[inPos + 18] - in[inPos + 17] << 24;
        out[outPos + 7] = in[inPos + 18] - in[inPos + 17] >>> 8 | in[inPos + 19] - in[inPos + 18] << 4 | in[inPos + 20] - in[inPos + 19] << 16 | in[inPos + 21] - in[inPos + 20] << 28;
        out[outPos + 8] = in[inPos + 21] - in[inPos + 20] >>> 4 | in[inPos + 22] - in[inPos + 21] << 8 | in[inPos + 23] - in[inPos + 22] << 20;
        out[outPos + 9] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 12 | in[inPos + 26] - in[inPos + 25] << 24;
        out[outPos + 10] = in[inPos + 26] - in[inPos + 25] >>> 8 | in[inPos + 27] - in[inPos + 26] << 4 | in[inPos + 28] - in[inPos + 27] << 16 | in[inPos + 29] - in[inPos + 28] << 28;
        out[outPos + 11] = in[inPos + 29] - in[inPos + 28] >>> 4 | in[inPos + 30] - in[inPos + 29] << 8 | in[inPos + 31] - in[inPos + 30] << 20;
    }

    private static void unpack12(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 12 & 0xFFF) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 24 | (in[inPos + 1] & 0xF) << 8) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 4 & 0xFFF) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 16 & 0xFFF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 28 | (in[inPos + 2] & 0xFF) << 4) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 8 & 0xFFF) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 20) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] & 0xFFF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 3] >>> 12 & 0xFFF) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 3] >>> 24 | (in[inPos + 4] & 0xF) << 8) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 4] >>> 4 & 0xFFF) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 4] >>> 16 & 0xFFF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 4] >>> 28 | (in[inPos + 5] & 0xFF) << 4) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 5] >>> 8 & 0xFFF) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 5] >>> 20) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 6] & 0xFFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 6] >>> 12 & 0xFFF) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 6] >>> 24 | (in[inPos + 7] & 0xF) << 8) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 7] >>> 4 & 0xFFF) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 7] >>> 16 & 0xFFF) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 7] >>> 28 | (in[inPos + 8] & 0xFF) << 4) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 8] >>> 8 & 0xFFF) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 8] >>> 20) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 9] & 0xFFF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 9] >>> 12 & 0xFFF) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 9] >>> 24 | (in[inPos + 10] & 0xF) << 8) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 10] >>> 4 & 0xFFF) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 10] >>> 16 & 0xFFF) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 10] >>> 28 | (in[inPos + 11] & 0xFF) << 4) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 11] >>> 8 & 0xFFF) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 11] >>> 20) + out[outPos + 30];
    }

    private static void pack13(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 13 | in[inPos + 2] - in[inPos + 1] << 26;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 6 | in[inPos + 3] - in[inPos + 2] << 7 | in[inPos + 4] - in[inPos + 3] << 20;
        out[outPos + 2] = in[inPos + 4] - in[inPos + 3] >>> 12 | in[inPos + 5] - in[inPos + 4] << 1 | in[inPos + 6] - in[inPos + 5] << 14 | in[inPos + 7] - in[inPos + 6] << 27;
        out[outPos + 3] = in[inPos + 7] - in[inPos + 6] >>> 5 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 21;
        out[outPos + 4] = in[inPos + 9] - in[inPos + 8] >>> 11 | in[inPos + 10] - in[inPos + 9] << 2 | in[inPos + 11] - in[inPos + 10] << 15 | in[inPos + 12] - in[inPos + 11] << 28;
        out[outPos + 5] = in[inPos + 12] - in[inPos + 11] >>> 4 | in[inPos + 13] - in[inPos + 12] << 9 | in[inPos + 14] - in[inPos + 13] << 22;
        out[outPos + 6] = in[inPos + 14] - in[inPos + 13] >>> 10 | in[inPos + 15] - in[inPos + 14] << 3 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 29;
        out[outPos + 7] = in[inPos + 17] - in[inPos + 16] >>> 3 | in[inPos + 18] - in[inPos + 17] << 10 | in[inPos + 19] - in[inPos + 18] << 23;
        out[outPos + 8] = in[inPos + 19] - in[inPos + 18] >>> 9 | in[inPos + 20] - in[inPos + 19] << 4 | in[inPos + 21] - in[inPos + 20] << 17 | in[inPos + 22] - in[inPos + 21] << 30;
        out[outPos + 9] = in[inPos + 22] - in[inPos + 21] >>> 2 | in[inPos + 23] - in[inPos + 22] << 11 | in[inPos + 24] - in[inPos + 23] << 24;
        out[outPos + 10] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 5 | in[inPos + 26] - in[inPos + 25] << 18 | in[inPos + 27] - in[inPos + 26] << 31;
        out[outPos + 11] = in[inPos + 27] - in[inPos + 26] >>> 1 | in[inPos + 28] - in[inPos + 27] << 12 | in[inPos + 29] - in[inPos + 28] << 25;
        out[outPos + 12] = in[inPos + 29] - in[inPos + 28] >>> 7 | in[inPos + 30] - in[inPos + 29] << 6 | in[inPos + 31] - in[inPos + 30] << 19;
    }

    private static void unpack13(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 13 & 0x1FFF) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 26 | (in[inPos + 1] & 0x7F) << 6) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 7 & 0x1FFF) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 20 | (in[inPos + 2] & 1) << 12) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 1 & 0x1FFF) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 14 & 0x1FFF) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 27 | (in[inPos + 3] & 0xFF) << 5) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] >>> 8 & 0x1FFF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 3] >>> 21 | (in[inPos + 4] & 3) << 11) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 4] >>> 2 & 0x1FFF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 4] >>> 15 & 0x1FFF) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 4] >>> 28 | (in[inPos + 5] & 0x1FF) << 4) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 5] >>> 9 & 0x1FFF) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 5] >>> 22 | (in[inPos + 6] & 7) << 10) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 6] >>> 3 & 0x1FFF) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 6] >>> 16 & 0x1FFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 6] >>> 29 | (in[inPos + 7] & 0x3FF) << 3) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 7] >>> 10 & 0x1FFF) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 7] >>> 23 | (in[inPos + 8] & 0xF) << 9) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 8] >>> 4 & 0x1FFF) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 8] >>> 17 & 0x1FFF) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 8] >>> 30 | (in[inPos + 9] & 0x7FF) << 2) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 9] >>> 11 & 0x1FFF) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 9] >>> 24 | (in[inPos + 10] & 0x1F) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 10] >>> 5 & 0x1FFF) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 10] >>> 18 & 0x1FFF) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 10] >>> 31 | (in[inPos + 11] & 0xFFF) << 1) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 11] >>> 12 & 0x1FFF) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 11] >>> 25 | (in[inPos + 12] & 0x3F) << 7) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 12] >>> 6 & 0x1FFF) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 12] >>> 19) + out[outPos + 30];
    }

    private static void pack14(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 14 | in[inPos + 2] - in[inPos + 1] << 28;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 4 | in[inPos + 3] - in[inPos + 2] << 10 | in[inPos + 4] - in[inPos + 3] << 24;
        out[outPos + 2] = in[inPos + 4] - in[inPos + 3] >>> 8 | in[inPos + 5] - in[inPos + 4] << 6 | in[inPos + 6] - in[inPos + 5] << 20;
        out[outPos + 3] = in[inPos + 6] - in[inPos + 5] >>> 12 | in[inPos + 7] - in[inPos + 6] << 2 | in[inPos + 8] - in[inPos + 7] << 16 | in[inPos + 9] - in[inPos + 8] << 30;
        out[outPos + 4] = in[inPos + 9] - in[inPos + 8] >>> 2 | in[inPos + 10] - in[inPos + 9] << 12 | in[inPos + 11] - in[inPos + 10] << 26;
        out[outPos + 5] = in[inPos + 11] - in[inPos + 10] >>> 6 | in[inPos + 12] - in[inPos + 11] << 8 | in[inPos + 13] - in[inPos + 12] << 22;
        out[outPos + 6] = in[inPos + 13] - in[inPos + 12] >>> 10 | in[inPos + 14] - in[inPos + 13] << 4 | in[inPos + 15] - in[inPos + 14] << 18;
        out[outPos + 7] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 14 | in[inPos + 18] - in[inPos + 17] << 28;
        out[outPos + 8] = in[inPos + 18] - in[inPos + 17] >>> 4 | in[inPos + 19] - in[inPos + 18] << 10 | in[inPos + 20] - in[inPos + 19] << 24;
        out[outPos + 9] = in[inPos + 20] - in[inPos + 19] >>> 8 | in[inPos + 21] - in[inPos + 20] << 6 | in[inPos + 22] - in[inPos + 21] << 20;
        out[outPos + 10] = in[inPos + 22] - in[inPos + 21] >>> 12 | in[inPos + 23] - in[inPos + 22] << 2 | in[inPos + 24] - in[inPos + 23] << 16 | in[inPos + 25] - in[inPos + 24] << 30;
        out[outPos + 11] = in[inPos + 25] - in[inPos + 24] >>> 2 | in[inPos + 26] - in[inPos + 25] << 12 | in[inPos + 27] - in[inPos + 26] << 26;
        out[outPos + 12] = in[inPos + 27] - in[inPos + 26] >>> 6 | in[inPos + 28] - in[inPos + 27] << 8 | in[inPos + 29] - in[inPos + 28] << 22;
        out[outPos + 13] = in[inPos + 29] - in[inPos + 28] >>> 10 | in[inPos + 30] - in[inPos + 29] << 4 | in[inPos + 31] - in[inPos + 30] << 18;
    }

    private static void unpack14(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 14 & 0x3FFF) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 28 | (in[inPos + 1] & 0x3FF) << 4) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 10 & 0x3FFF) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 24 | (in[inPos + 2] & 0x3F) << 8) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 6 & 0x3FFF) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 20 | (in[inPos + 3] & 3) << 12) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 2 & 0x3FFF) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] >>> 16 & 0x3FFF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 3] >>> 30 | (in[inPos + 4] & 0xFFF) << 2) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 4] >>> 12 & 0x3FFF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 4] >>> 26 | (in[inPos + 5] & 0xFF) << 6) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 5] >>> 8 & 0x3FFF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 5] >>> 22 | (in[inPos + 6] & 0xF) << 10) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 6] >>> 4 & 0x3FFF) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 6] >>> 18) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 7] & 0x3FFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 7] >>> 14 & 0x3FFF) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 7] >>> 28 | (in[inPos + 8] & 0x3FF) << 4) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 8] >>> 10 & 0x3FFF) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 8] >>> 24 | (in[inPos + 9] & 0x3F) << 8) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 9] >>> 6 & 0x3FFF) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 9] >>> 20 | (in[inPos + 10] & 3) << 12) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 10] >>> 2 & 0x3FFF) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 10] >>> 16 & 0x3FFF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 10] >>> 30 | (in[inPos + 11] & 0xFFF) << 2) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 11] >>> 12 & 0x3FFF) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 11] >>> 26 | (in[inPos + 12] & 0xFF) << 6) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 12] >>> 8 & 0x3FFF) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 12] >>> 22 | (in[inPos + 13] & 0xF) << 10) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 13] >>> 4 & 0x3FFF) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 13] >>> 18) + out[outPos + 30];
    }

    private static void pack15(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 15 | in[inPos + 2] - in[inPos + 1] << 30;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 2 | in[inPos + 3] - in[inPos + 2] << 13 | in[inPos + 4] - in[inPos + 3] << 28;
        out[outPos + 2] = in[inPos + 4] - in[inPos + 3] >>> 4 | in[inPos + 5] - in[inPos + 4] << 11 | in[inPos + 6] - in[inPos + 5] << 26;
        out[outPos + 3] = in[inPos + 6] - in[inPos + 5] >>> 6 | in[inPos + 7] - in[inPos + 6] << 9 | in[inPos + 8] - in[inPos + 7] << 24;
        out[outPos + 4] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 7 | in[inPos + 10] - in[inPos + 9] << 22;
        out[outPos + 5] = in[inPos + 10] - in[inPos + 9] >>> 10 | in[inPos + 11] - in[inPos + 10] << 5 | in[inPos + 12] - in[inPos + 11] << 20;
        out[outPos + 6] = in[inPos + 12] - in[inPos + 11] >>> 12 | in[inPos + 13] - in[inPos + 12] << 3 | in[inPos + 14] - in[inPos + 13] << 18;
        out[outPos + 7] = in[inPos + 14] - in[inPos + 13] >>> 14 | in[inPos + 15] - in[inPos + 14] << 1 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 31;
        out[outPos + 8] = in[inPos + 17] - in[inPos + 16] >>> 1 | in[inPos + 18] - in[inPos + 17] << 14 | in[inPos + 19] - in[inPos + 18] << 29;
        out[outPos + 9] = in[inPos + 19] - in[inPos + 18] >>> 3 | in[inPos + 20] - in[inPos + 19] << 12 | in[inPos + 21] - in[inPos + 20] << 27;
        out[outPos + 10] = in[inPos + 21] - in[inPos + 20] >>> 5 | in[inPos + 22] - in[inPos + 21] << 10 | in[inPos + 23] - in[inPos + 22] << 25;
        out[outPos + 11] = in[inPos + 23] - in[inPos + 22] >>> 7 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 23;
        out[outPos + 12] = in[inPos + 25] - in[inPos + 24] >>> 9 | in[inPos + 26] - in[inPos + 25] << 6 | in[inPos + 27] - in[inPos + 26] << 21;
        out[outPos + 13] = in[inPos + 27] - in[inPos + 26] >>> 11 | in[inPos + 28] - in[inPos + 27] << 4 | in[inPos + 29] - in[inPos + 28] << 19;
        out[outPos + 14] = in[inPos + 29] - in[inPos + 28] >>> 13 | in[inPos + 30] - in[inPos + 29] << 2 | in[inPos + 31] - in[inPos + 30] << 17;
    }

    private static void unpack15(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & Short.MAX_VALUE) + initValue;
        out[outPos + 1] = (in[inPos] >>> 15 & Short.MAX_VALUE) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 30 | (in[inPos + 1] & 0x1FFF) << 2) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 13 & Short.MAX_VALUE) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 28 | (in[inPos + 2] & 0x7FF) << 4) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 11 & Short.MAX_VALUE) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 26 | (in[inPos + 3] & 0x1FF) << 6) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 9 & Short.MAX_VALUE) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] >>> 24 | (in[inPos + 4] & 0x7F) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 4] >>> 7 & Short.MAX_VALUE) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 4] >>> 22 | (in[inPos + 5] & 0x1F) << 10) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 5] >>> 5 & Short.MAX_VALUE) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 5] >>> 20 | (in[inPos + 6] & 7) << 12) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 6] >>> 3 & Short.MAX_VALUE) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 6] >>> 18 | (in[inPos + 7] & 1) << 14) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 7] >>> 1 & Short.MAX_VALUE) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 7] >>> 16 & Short.MAX_VALUE) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 7] >>> 31 | (in[inPos + 8] & 0x3FFF) << 1) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 8] >>> 14 & Short.MAX_VALUE) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 8] >>> 29 | (in[inPos + 9] & 0xFFF) << 3) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 9] >>> 12 & Short.MAX_VALUE) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 9] >>> 27 | (in[inPos + 10] & 0x3FF) << 5) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 10] >>> 10 & Short.MAX_VALUE) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 10] >>> 25 | (in[inPos + 11] & 0xFF) << 7) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 11] >>> 8 & Short.MAX_VALUE) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 11] >>> 23 | (in[inPos + 12] & 0x3F) << 9) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 12] >>> 6 & Short.MAX_VALUE) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 12] >>> 21 | (in[inPos + 13] & 0xF) << 11) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 13] >>> 4 & Short.MAX_VALUE) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 13] >>> 19 | (in[inPos + 14] & 3) << 13) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 14] >>> 2 & Short.MAX_VALUE) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 14] >>> 17) + out[outPos + 30];
    }

    private static void pack16(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 16;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] | in[inPos + 3] - in[inPos + 2] << 16;
        out[outPos + 2] = in[inPos + 4] - in[inPos + 3] | in[inPos + 5] - in[inPos + 4] << 16;
        out[outPos + 3] = in[inPos + 6] - in[inPos + 5] | in[inPos + 7] - in[inPos + 6] << 16;
        out[outPos + 4] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 16;
        out[outPos + 5] = in[inPos + 10] - in[inPos + 9] | in[inPos + 11] - in[inPos + 10] << 16;
        out[outPos + 6] = in[inPos + 12] - in[inPos + 11] | in[inPos + 13] - in[inPos + 12] << 16;
        out[outPos + 7] = in[inPos + 14] - in[inPos + 13] | in[inPos + 15] - in[inPos + 14] << 16;
        out[outPos + 8] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 16;
        out[outPos + 9] = in[inPos + 18] - in[inPos + 17] | in[inPos + 19] - in[inPos + 18] << 16;
        out[outPos + 10] = in[inPos + 20] - in[inPos + 19] | in[inPos + 21] - in[inPos + 20] << 16;
        out[outPos + 11] = in[inPos + 22] - in[inPos + 21] | in[inPos + 23] - in[inPos + 22] << 16;
        out[outPos + 12] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 16;
        out[outPos + 13] = in[inPos + 26] - in[inPos + 25] | in[inPos + 27] - in[inPos + 26] << 16;
        out[outPos + 14] = in[inPos + 28] - in[inPos + 27] | in[inPos + 29] - in[inPos + 28] << 16;
        out[outPos + 15] = in[inPos + 30] - in[inPos + 29] | in[inPos + 31] - in[inPos + 30] << 16;
    }

    private static void unpack16(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 16) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] & 0xFFFF) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 16) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] & 0xFFFF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 16) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] & 0xFFFF) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 16) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] & 0xFFFF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 4] >>> 16) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 5] & 0xFFFF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 5] >>> 16) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 6] & 0xFFFF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 6] >>> 16) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 7] & 0xFFFF) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 7] >>> 16) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 8] & 0xFFFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 8] >>> 16) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 9] & 0xFFFF) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 9] >>> 16) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 10] & 0xFFFF) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 10] >>> 16) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 11] & 0xFFFF) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 11] >>> 16) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 12] & 0xFFFF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 12] >>> 16) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 13] & 0xFFFF) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 13] >>> 16) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 14] & 0xFFFF) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 14] >>> 16) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 15] & 0xFFFF) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 15] >>> 16) + out[outPos + 30];
    }

    private static void pack17(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 17;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 15 | in[inPos + 2] - in[inPos + 1] << 2 | in[inPos + 3] - in[inPos + 2] << 19;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 13 | in[inPos + 4] - in[inPos + 3] << 4 | in[inPos + 5] - in[inPos + 4] << 21;
        out[outPos + 3] = in[inPos + 5] - in[inPos + 4] >>> 11 | in[inPos + 6] - in[inPos + 5] << 6 | in[inPos + 7] - in[inPos + 6] << 23;
        out[outPos + 4] = in[inPos + 7] - in[inPos + 6] >>> 9 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 25;
        out[outPos + 5] = in[inPos + 9] - in[inPos + 8] >>> 7 | in[inPos + 10] - in[inPos + 9] << 10 | in[inPos + 11] - in[inPos + 10] << 27;
        out[outPos + 6] = in[inPos + 11] - in[inPos + 10] >>> 5 | in[inPos + 12] - in[inPos + 11] << 12 | in[inPos + 13] - in[inPos + 12] << 29;
        out[outPos + 7] = in[inPos + 13] - in[inPos + 12] >>> 3 | in[inPos + 14] - in[inPos + 13] << 14 | in[inPos + 15] - in[inPos + 14] << 31;
        out[outPos + 8] = in[inPos + 15] - in[inPos + 14] >>> 1 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 9] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 1 | in[inPos + 18] - in[inPos + 17] << 18;
        out[outPos + 10] = in[inPos + 18] - in[inPos + 17] >>> 14 | in[inPos + 19] - in[inPos + 18] << 3 | in[inPos + 20] - in[inPos + 19] << 20;
        out[outPos + 11] = in[inPos + 20] - in[inPos + 19] >>> 12 | in[inPos + 21] - in[inPos + 20] << 5 | in[inPos + 22] - in[inPos + 21] << 22;
        out[outPos + 12] = in[inPos + 22] - in[inPos + 21] >>> 10 | in[inPos + 23] - in[inPos + 22] << 7 | in[inPos + 24] - in[inPos + 23] << 24;
        out[outPos + 13] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 9 | in[inPos + 26] - in[inPos + 25] << 26;
        out[outPos + 14] = in[inPos + 26] - in[inPos + 25] >>> 6 | in[inPos + 27] - in[inPos + 26] << 11 | in[inPos + 28] - in[inPos + 27] << 28;
        out[outPos + 15] = in[inPos + 28] - in[inPos + 27] >>> 4 | in[inPos + 29] - in[inPos + 28] << 13 | in[inPos + 30] - in[inPos + 29] << 30;
        out[outPos + 16] = in[inPos + 30] - in[inPos + 29] >>> 2 | in[inPos + 31] - in[inPos + 30] << 15;
    }

    private static void unpack17(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 17 | (in[inPos + 1] & 3) << 15) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 2 & 0x1FFFF) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 19 | (in[inPos + 2] & 0xF) << 13) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 4 & 0x1FFFF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 21 | (in[inPos + 3] & 0x3F) << 11) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 6 & 0x1FFFF) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 23 | (in[inPos + 4] & 0xFF) << 9) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] >>> 8 & 0x1FFFF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 4] >>> 25 | (in[inPos + 5] & 0x3FF) << 7) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 5] >>> 10 & 0x1FFFF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 5] >>> 27 | (in[inPos + 6] & 0xFFF) << 5) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 6] >>> 12 & 0x1FFFF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 6] >>> 29 | (in[inPos + 7] & 0x3FFF) << 3) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 7] >>> 14 & 0x1FFFF) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 7] >>> 31 | (in[inPos + 8] & 0xFFFF) << 1) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 8] >>> 16 | (in[inPos + 9] & 1) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 9] >>> 1 & 0x1FFFF) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 9] >>> 18 | (in[inPos + 10] & 7) << 14) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 10] >>> 3 & 0x1FFFF) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 10] >>> 20 | (in[inPos + 11] & 0x1F) << 12) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 11] >>> 5 & 0x1FFFF) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 11] >>> 22 | (in[inPos + 12] & 0x7F) << 10) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 12] >>> 7 & 0x1FFFF) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 12] >>> 24 | (in[inPos + 13] & 0x1FF) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 13] >>> 9 & 0x1FFFF) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 13] >>> 26 | (in[inPos + 14] & 0x7FF) << 6) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 14] >>> 11 & 0x1FFFF) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 14] >>> 28 | (in[inPos + 15] & 0x1FFF) << 4) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 15] >>> 13 & 0x1FFFF) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 15] >>> 30 | (in[inPos + 16] & Short.MAX_VALUE) << 2) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 16] >>> 15) + out[outPos + 30];
    }

    private static void pack18(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 18;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 14 | in[inPos + 2] - in[inPos + 1] << 4 | in[inPos + 3] - in[inPos + 2] << 22;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 10 | in[inPos + 4] - in[inPos + 3] << 8 | in[inPos + 5] - in[inPos + 4] << 26;
        out[outPos + 3] = in[inPos + 5] - in[inPos + 4] >>> 6 | in[inPos + 6] - in[inPos + 5] << 12 | in[inPos + 7] - in[inPos + 6] << 30;
        out[outPos + 4] = in[inPos + 7] - in[inPos + 6] >>> 2 | in[inPos + 8] - in[inPos + 7] << 16;
        out[outPos + 5] = in[inPos + 8] - in[inPos + 7] >>> 16 | in[inPos + 9] - in[inPos + 8] << 2 | in[inPos + 10] - in[inPos + 9] << 20;
        out[outPos + 6] = in[inPos + 10] - in[inPos + 9] >>> 12 | in[inPos + 11] - in[inPos + 10] << 6 | in[inPos + 12] - in[inPos + 11] << 24;
        out[outPos + 7] = in[inPos + 12] - in[inPos + 11] >>> 8 | in[inPos + 13] - in[inPos + 12] << 10 | in[inPos + 14] - in[inPos + 13] << 28;
        out[outPos + 8] = in[inPos + 14] - in[inPos + 13] >>> 4 | in[inPos + 15] - in[inPos + 14] << 14;
        out[outPos + 9] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 18;
        out[outPos + 10] = in[inPos + 17] - in[inPos + 16] >>> 14 | in[inPos + 18] - in[inPos + 17] << 4 | in[inPos + 19] - in[inPos + 18] << 22;
        out[outPos + 11] = in[inPos + 19] - in[inPos + 18] >>> 10 | in[inPos + 20] - in[inPos + 19] << 8 | in[inPos + 21] - in[inPos + 20] << 26;
        out[outPos + 12] = in[inPos + 21] - in[inPos + 20] >>> 6 | in[inPos + 22] - in[inPos + 21] << 12 | in[inPos + 23] - in[inPos + 22] << 30;
        out[outPos + 13] = in[inPos + 23] - in[inPos + 22] >>> 2 | in[inPos + 24] - in[inPos + 23] << 16;
        out[outPos + 14] = in[inPos + 24] - in[inPos + 23] >>> 16 | in[inPos + 25] - in[inPos + 24] << 2 | in[inPos + 26] - in[inPos + 25] << 20;
        out[outPos + 15] = in[inPos + 26] - in[inPos + 25] >>> 12 | in[inPos + 27] - in[inPos + 26] << 6 | in[inPos + 28] - in[inPos + 27] << 24;
        out[outPos + 16] = in[inPos + 28] - in[inPos + 27] >>> 8 | in[inPos + 29] - in[inPos + 28] << 10 | in[inPos + 30] - in[inPos + 29] << 28;
        out[outPos + 17] = in[inPos + 30] - in[inPos + 29] >>> 4 | in[inPos + 31] - in[inPos + 30] << 14;
    }

    private static void unpack18(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 18 | (in[inPos + 1] & 0xF) << 14) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 4 & 0x3FFFF) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 22 | (in[inPos + 2] & 0xFF) << 10) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 8 & 0x3FFFF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 26 | (in[inPos + 3] & 0xFFF) << 6) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 12 & 0x3FFFF) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 30 | (in[inPos + 4] & 0xFFFF) << 2) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] >>> 16 | (in[inPos + 5] & 3) << 16) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 5] >>> 2 & 0x3FFFF) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 5] >>> 20 | (in[inPos + 6] & 0x3F) << 12) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 6] >>> 6 & 0x3FFFF) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 6] >>> 24 | (in[inPos + 7] & 0x3FF) << 8) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 7] >>> 10 & 0x3FFFF) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 7] >>> 28 | (in[inPos + 8] & 0x3FFF) << 4) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 8] >>> 14) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 9] & 0x3FFFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 9] >>> 18 | (in[inPos + 10] & 0xF) << 14) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 10] >>> 4 & 0x3FFFF) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 10] >>> 22 | (in[inPos + 11] & 0xFF) << 10) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 11] >>> 8 & 0x3FFFF) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 11] >>> 26 | (in[inPos + 12] & 0xFFF) << 6) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 12] >>> 12 & 0x3FFFF) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 12] >>> 30 | (in[inPos + 13] & 0xFFFF) << 2) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 13] >>> 16 | (in[inPos + 14] & 3) << 16) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 14] >>> 2 & 0x3FFFF) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 14] >>> 20 | (in[inPos + 15] & 0x3F) << 12) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 15] >>> 6 & 0x3FFFF) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 15] >>> 24 | (in[inPos + 16] & 0x3FF) << 8) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 16] >>> 10 & 0x3FFFF) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 16] >>> 28 | (in[inPos + 17] & 0x3FFF) << 4) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 17] >>> 14) + out[outPos + 30];
    }

    private static void pack19(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 19;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 13 | in[inPos + 2] - in[inPos + 1] << 6 | in[inPos + 3] - in[inPos + 2] << 25;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 7 | in[inPos + 4] - in[inPos + 3] << 12 | in[inPos + 5] - in[inPos + 4] << 31;
        out[outPos + 3] = in[inPos + 5] - in[inPos + 4] >>> 1 | in[inPos + 6] - in[inPos + 5] << 18;
        out[outPos + 4] = in[inPos + 6] - in[inPos + 5] >>> 14 | in[inPos + 7] - in[inPos + 6] << 5 | in[inPos + 8] - in[inPos + 7] << 24;
        out[outPos + 5] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 11 | in[inPos + 10] - in[inPos + 9] << 30;
        out[outPos + 6] = in[inPos + 10] - in[inPos + 9] >>> 2 | in[inPos + 11] - in[inPos + 10] << 17;
        out[outPos + 7] = in[inPos + 11] - in[inPos + 10] >>> 15 | in[inPos + 12] - in[inPos + 11] << 4 | in[inPos + 13] - in[inPos + 12] << 23;
        out[outPos + 8] = in[inPos + 13] - in[inPos + 12] >>> 9 | in[inPos + 14] - in[inPos + 13] << 10 | in[inPos + 15] - in[inPos + 14] << 29;
        out[outPos + 9] = in[inPos + 15] - in[inPos + 14] >>> 3 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 10] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 3 | in[inPos + 18] - in[inPos + 17] << 22;
        out[outPos + 11] = in[inPos + 18] - in[inPos + 17] >>> 10 | in[inPos + 19] - in[inPos + 18] << 9 | in[inPos + 20] - in[inPos + 19] << 28;
        out[outPos + 12] = in[inPos + 20] - in[inPos + 19] >>> 4 | in[inPos + 21] - in[inPos + 20] << 15;
        out[outPos + 13] = in[inPos + 21] - in[inPos + 20] >>> 17 | in[inPos + 22] - in[inPos + 21] << 2 | in[inPos + 23] - in[inPos + 22] << 21;
        out[outPos + 14] = in[inPos + 23] - in[inPos + 22] >>> 11 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 27;
        out[outPos + 15] = in[inPos + 25] - in[inPos + 24] >>> 5 | in[inPos + 26] - in[inPos + 25] << 14;
        out[outPos + 16] = in[inPos + 26] - in[inPos + 25] >>> 18 | in[inPos + 27] - in[inPos + 26] << 1 | in[inPos + 28] - in[inPos + 27] << 20;
        out[outPos + 17] = in[inPos + 28] - in[inPos + 27] >>> 12 | in[inPos + 29] - in[inPos + 28] << 7 | in[inPos + 30] - in[inPos + 29] << 26;
        out[outPos + 18] = in[inPos + 30] - in[inPos + 29] >>> 6 | in[inPos + 31] - in[inPos + 30] << 13;
    }

    private static void unpack19(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 19 | (in[inPos + 1] & 0x3F) << 13) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 6 & 0x7FFFF) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 25 | (in[inPos + 2] & 0xFFF) << 7) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 12 & 0x7FFFF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 31 | (in[inPos + 3] & 0x3FFFF) << 1) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 18 | (in[inPos + 4] & 0x1F) << 14) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 5 & 0x7FFFF) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] >>> 24 | (in[inPos + 5] & 0x7FF) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 5] >>> 11 & 0x7FFFF) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 5] >>> 30 | (in[inPos + 6] & 0x1FFFF) << 2) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 6] >>> 17 | (in[inPos + 7] & 0xF) << 15) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 7] >>> 4 & 0x7FFFF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 7] >>> 23 | (in[inPos + 8] & 0x3FF) << 9) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 8] >>> 10 & 0x7FFFF) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 8] >>> 29 | (in[inPos + 9] & 0xFFFF) << 3) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 9] >>> 16 | (in[inPos + 10] & 7) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 10] >>> 3 & 0x7FFFF) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 10] >>> 22 | (in[inPos + 11] & 0x1FF) << 10) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 11] >>> 9 & 0x7FFFF) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 11] >>> 28 | (in[inPos + 12] & Short.MAX_VALUE) << 4) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 12] >>> 15 | (in[inPos + 13] & 3) << 17) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 13] >>> 2 & 0x7FFFF) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 13] >>> 21 | (in[inPos + 14] & 0xFF) << 11) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 14] >>> 8 & 0x7FFFF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 14] >>> 27 | (in[inPos + 15] & 0x3FFF) << 5) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 15] >>> 14 | (in[inPos + 16] & 1) << 18) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 16] >>> 1 & 0x7FFFF) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 16] >>> 20 | (in[inPos + 17] & 0x7F) << 12) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 17] >>> 7 & 0x7FFFF) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 17] >>> 26 | (in[inPos + 18] & 0x1FFF) << 6) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 18] >>> 13) + out[outPos + 30];
    }

    private static void pack20(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 20;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 12 | in[inPos + 2] - in[inPos + 1] << 8 | in[inPos + 3] - in[inPos + 2] << 28;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 4 | in[inPos + 4] - in[inPos + 3] << 16;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 16 | in[inPos + 5] - in[inPos + 4] << 4 | in[inPos + 6] - in[inPos + 5] << 24;
        out[outPos + 4] = in[inPos + 6] - in[inPos + 5] >>> 8 | in[inPos + 7] - in[inPos + 6] << 12;
        out[outPos + 5] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 20;
        out[outPos + 6] = in[inPos + 9] - in[inPos + 8] >>> 12 | in[inPos + 10] - in[inPos + 9] << 8 | in[inPos + 11] - in[inPos + 10] << 28;
        out[outPos + 7] = in[inPos + 11] - in[inPos + 10] >>> 4 | in[inPos + 12] - in[inPos + 11] << 16;
        out[outPos + 8] = in[inPos + 12] - in[inPos + 11] >>> 16 | in[inPos + 13] - in[inPos + 12] << 4 | in[inPos + 14] - in[inPos + 13] << 24;
        out[outPos + 9] = in[inPos + 14] - in[inPos + 13] >>> 8 | in[inPos + 15] - in[inPos + 14] << 12;
        out[outPos + 10] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 20;
        out[outPos + 11] = in[inPos + 17] - in[inPos + 16] >>> 12 | in[inPos + 18] - in[inPos + 17] << 8 | in[inPos + 19] - in[inPos + 18] << 28;
        out[outPos + 12] = in[inPos + 19] - in[inPos + 18] >>> 4 | in[inPos + 20] - in[inPos + 19] << 16;
        out[outPos + 13] = in[inPos + 20] - in[inPos + 19] >>> 16 | in[inPos + 21] - in[inPos + 20] << 4 | in[inPos + 22] - in[inPos + 21] << 24;
        out[outPos + 14] = in[inPos + 22] - in[inPos + 21] >>> 8 | in[inPos + 23] - in[inPos + 22] << 12;
        out[outPos + 15] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 20;
        out[outPos + 16] = in[inPos + 25] - in[inPos + 24] >>> 12 | in[inPos + 26] - in[inPos + 25] << 8 | in[inPos + 27] - in[inPos + 26] << 28;
        out[outPos + 17] = in[inPos + 27] - in[inPos + 26] >>> 4 | in[inPos + 28] - in[inPos + 27] << 16;
        out[outPos + 18] = in[inPos + 28] - in[inPos + 27] >>> 16 | in[inPos + 29] - in[inPos + 28] << 4 | in[inPos + 30] - in[inPos + 29] << 24;
        out[outPos + 19] = in[inPos + 30] - in[inPos + 29] >>> 8 | in[inPos + 31] - in[inPos + 30] << 12;
    }

    private static void unpack20(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 20 | (in[inPos + 1] & 0xFF) << 12) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 8 & 0xFFFFF) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 28 | (in[inPos + 2] & 0xFFFF) << 4) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 16 | (in[inPos + 3] & 0xF) << 16) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 4 & 0xFFFFF) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 24 | (in[inPos + 4] & 0xFFF) << 8) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 12) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] & 0xFFFFF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 5] >>> 20 | (in[inPos + 6] & 0xFF) << 12) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 6] >>> 8 & 0xFFFFF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 6] >>> 28 | (in[inPos + 7] & 0xFFFF) << 4) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 7] >>> 16 | (in[inPos + 8] & 0xF) << 16) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 8] >>> 4 & 0xFFFFF) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 8] >>> 24 | (in[inPos + 9] & 0xFFF) << 8) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 9] >>> 12) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 10] & 0xFFFFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 10] >>> 20 | (in[inPos + 11] & 0xFF) << 12) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 11] >>> 8 & 0xFFFFF) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 11] >>> 28 | (in[inPos + 12] & 0xFFFF) << 4) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 12] >>> 16 | (in[inPos + 13] & 0xF) << 16) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 13] >>> 4 & 0xFFFFF) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 13] >>> 24 | (in[inPos + 14] & 0xFFF) << 8) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 14] >>> 12) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 15] & 0xFFFFF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 15] >>> 20 | (in[inPos + 16] & 0xFF) << 12) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 16] >>> 8 & 0xFFFFF) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 16] >>> 28 | (in[inPos + 17] & 0xFFFF) << 4) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 17] >>> 16 | (in[inPos + 18] & 0xF) << 16) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 18] >>> 4 & 0xFFFFF) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 18] >>> 24 | (in[inPos + 19] & 0xFFF) << 8) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 19] >>> 12) + out[outPos + 30];
    }

    private static void pack21(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 21;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 11 | in[inPos + 2] - in[inPos + 1] << 10 | in[inPos + 3] - in[inPos + 2] << 31;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 1 | in[inPos + 4] - in[inPos + 3] << 20;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 12 | in[inPos + 5] - in[inPos + 4] << 9 | in[inPos + 6] - in[inPos + 5] << 30;
        out[outPos + 4] = in[inPos + 6] - in[inPos + 5] >>> 2 | in[inPos + 7] - in[inPos + 6] << 19;
        out[outPos + 5] = in[inPos + 7] - in[inPos + 6] >>> 13 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 29;
        out[outPos + 6] = in[inPos + 9] - in[inPos + 8] >>> 3 | in[inPos + 10] - in[inPos + 9] << 18;
        out[outPos + 7] = in[inPos + 10] - in[inPos + 9] >>> 14 | in[inPos + 11] - in[inPos + 10] << 7 | in[inPos + 12] - in[inPos + 11] << 28;
        out[outPos + 8] = in[inPos + 12] - in[inPos + 11] >>> 4 | in[inPos + 13] - in[inPos + 12] << 17;
        out[outPos + 9] = in[inPos + 13] - in[inPos + 12] >>> 15 | in[inPos + 14] - in[inPos + 13] << 6 | in[inPos + 15] - in[inPos + 14] << 27;
        out[outPos + 10] = in[inPos + 15] - in[inPos + 14] >>> 5 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 11] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 5 | in[inPos + 18] - in[inPos + 17] << 26;
        out[outPos + 12] = in[inPos + 18] - in[inPos + 17] >>> 6 | in[inPos + 19] - in[inPos + 18] << 15;
        out[outPos + 13] = in[inPos + 19] - in[inPos + 18] >>> 17 | in[inPos + 20] - in[inPos + 19] << 4 | in[inPos + 21] - in[inPos + 20] << 25;
        out[outPos + 14] = in[inPos + 21] - in[inPos + 20] >>> 7 | in[inPos + 22] - in[inPos + 21] << 14;
        out[outPos + 15] = in[inPos + 22] - in[inPos + 21] >>> 18 | in[inPos + 23] - in[inPos + 22] << 3 | in[inPos + 24] - in[inPos + 23] << 24;
        out[outPos + 16] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 13;
        out[outPos + 17] = in[inPos + 25] - in[inPos + 24] >>> 19 | in[inPos + 26] - in[inPos + 25] << 2 | in[inPos + 27] - in[inPos + 26] << 23;
        out[outPos + 18] = in[inPos + 27] - in[inPos + 26] >>> 9 | in[inPos + 28] - in[inPos + 27] << 12;
        out[outPos + 19] = in[inPos + 28] - in[inPos + 27] >>> 20 | in[inPos + 29] - in[inPos + 28] << 1 | in[inPos + 30] - in[inPos + 29] << 22;
        out[outPos + 20] = in[inPos + 30] - in[inPos + 29] >>> 10 | in[inPos + 31] - in[inPos + 30] << 11;
    }

    private static void unpack21(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 21 | (in[inPos + 1] & 0x3FF) << 11) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 10 & 0x1FFFFF) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 31 | (in[inPos + 2] & 0xFFFFF) << 1) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 20 | (in[inPos + 3] & 0x1FF) << 12) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 9 & 0x1FFFFF) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 30 | (in[inPos + 4] & 0x7FFFF) << 2) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 19 | (in[inPos + 5] & 0xFF) << 13) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] >>> 8 & 0x1FFFFF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 5] >>> 29 | (in[inPos + 6] & 0x3FFFF) << 3) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 6] >>> 18 | (in[inPos + 7] & 0x7F) << 14) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 7] >>> 7 & 0x1FFFFF) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 7] >>> 28 | (in[inPos + 8] & 0x1FFFF) << 4) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 8] >>> 17 | (in[inPos + 9] & 0x3F) << 15) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 9] >>> 6 & 0x1FFFFF) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 9] >>> 27 | (in[inPos + 10] & 0xFFFF) << 5) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 10] >>> 16 | (in[inPos + 11] & 0x1F) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 11] >>> 5 & 0x1FFFFF) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 11] >>> 26 | (in[inPos + 12] & Short.MAX_VALUE) << 6) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 12] >>> 15 | (in[inPos + 13] & 0xF) << 17) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 13] >>> 4 & 0x1FFFFF) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 13] >>> 25 | (in[inPos + 14] & 0x3FFF) << 7) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 14] >>> 14 | (in[inPos + 15] & 7) << 18) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 15] >>> 3 & 0x1FFFFF) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 15] >>> 24 | (in[inPos + 16] & 0x1FFF) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 16] >>> 13 | (in[inPos + 17] & 3) << 19) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 17] >>> 2 & 0x1FFFFF) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 17] >>> 23 | (in[inPos + 18] & 0xFFF) << 9) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 18] >>> 12 | (in[inPos + 19] & 1) << 20) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 19] >>> 1 & 0x1FFFFF) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 19] >>> 22 | (in[inPos + 20] & 0x7FF) << 10) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 20] >>> 11) + out[outPos + 30];
    }

    private static void pack22(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 22;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 10 | in[inPos + 2] - in[inPos + 1] << 12;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 20 | in[inPos + 3] - in[inPos + 2] << 2 | in[inPos + 4] - in[inPos + 3] << 24;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 8 | in[inPos + 5] - in[inPos + 4] << 14;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 18 | in[inPos + 6] - in[inPos + 5] << 4 | in[inPos + 7] - in[inPos + 6] << 26;
        out[outPos + 5] = in[inPos + 7] - in[inPos + 6] >>> 6 | in[inPos + 8] - in[inPos + 7] << 16;
        out[outPos + 6] = in[inPos + 8] - in[inPos + 7] >>> 16 | in[inPos + 9] - in[inPos + 8] << 6 | in[inPos + 10] - in[inPos + 9] << 28;
        out[outPos + 7] = in[inPos + 10] - in[inPos + 9] >>> 4 | in[inPos + 11] - in[inPos + 10] << 18;
        out[outPos + 8] = in[inPos + 11] - in[inPos + 10] >>> 14 | in[inPos + 12] - in[inPos + 11] << 8 | in[inPos + 13] - in[inPos + 12] << 30;
        out[outPos + 9] = in[inPos + 13] - in[inPos + 12] >>> 2 | in[inPos + 14] - in[inPos + 13] << 20;
        out[outPos + 10] = in[inPos + 14] - in[inPos + 13] >>> 12 | in[inPos + 15] - in[inPos + 14] << 10;
        out[outPos + 11] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 22;
        out[outPos + 12] = in[inPos + 17] - in[inPos + 16] >>> 10 | in[inPos + 18] - in[inPos + 17] << 12;
        out[outPos + 13] = in[inPos + 18] - in[inPos + 17] >>> 20 | in[inPos + 19] - in[inPos + 18] << 2 | in[inPos + 20] - in[inPos + 19] << 24;
        out[outPos + 14] = in[inPos + 20] - in[inPos + 19] >>> 8 | in[inPos + 21] - in[inPos + 20] << 14;
        out[outPos + 15] = in[inPos + 21] - in[inPos + 20] >>> 18 | in[inPos + 22] - in[inPos + 21] << 4 | in[inPos + 23] - in[inPos + 22] << 26;
        out[outPos + 16] = in[inPos + 23] - in[inPos + 22] >>> 6 | in[inPos + 24] - in[inPos + 23] << 16;
        out[outPos + 17] = in[inPos + 24] - in[inPos + 23] >>> 16 | in[inPos + 25] - in[inPos + 24] << 6 | in[inPos + 26] - in[inPos + 25] << 28;
        out[outPos + 18] = in[inPos + 26] - in[inPos + 25] >>> 4 | in[inPos + 27] - in[inPos + 26] << 18;
        out[outPos + 19] = in[inPos + 27] - in[inPos + 26] >>> 14 | in[inPos + 28] - in[inPos + 27] << 8 | in[inPos + 29] - in[inPos + 28] << 30;
        out[outPos + 20] = in[inPos + 29] - in[inPos + 28] >>> 2 | in[inPos + 30] - in[inPos + 29] << 20;
        out[outPos + 21] = in[inPos + 30] - in[inPos + 29] >>> 12 | in[inPos + 31] - in[inPos + 30] << 10;
    }

    private static void unpack22(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 22 | (in[inPos + 1] & 0xFFF) << 10) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 12 | (in[inPos + 2] & 3) << 20) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 2 & 0x3FFFFF) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 24 | (in[inPos + 3] & 0x3FFF) << 8) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 14 | (in[inPos + 4] & 0xF) << 18) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 4 & 0x3FFFFF) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 26 | (in[inPos + 5] & 0xFFFF) << 6) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] >>> 16 | (in[inPos + 6] & 0x3F) << 16) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 6] >>> 6 & 0x3FFFFF) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 6] >>> 28 | (in[inPos + 7] & 0x3FFFF) << 4) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 7] >>> 18 | (in[inPos + 8] & 0xFF) << 14) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 8] >>> 8 & 0x3FFFFF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 8] >>> 30 | (in[inPos + 9] & 0xFFFFF) << 2) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 9] >>> 20 | (in[inPos + 10] & 0x3FF) << 12) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 10] >>> 10) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 11] & 0x3FFFFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 11] >>> 22 | (in[inPos + 12] & 0xFFF) << 10) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 12] >>> 12 | (in[inPos + 13] & 3) << 20) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 13] >>> 2 & 0x3FFFFF) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 13] >>> 24 | (in[inPos + 14] & 0x3FFF) << 8) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 14] >>> 14 | (in[inPos + 15] & 0xF) << 18) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 15] >>> 4 & 0x3FFFFF) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 15] >>> 26 | (in[inPos + 16] & 0xFFFF) << 6) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 16] >>> 16 | (in[inPos + 17] & 0x3F) << 16) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 17] >>> 6 & 0x3FFFFF) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 17] >>> 28 | (in[inPos + 18] & 0x3FFFF) << 4) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 18] >>> 18 | (in[inPos + 19] & 0xFF) << 14) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 19] >>> 8 & 0x3FFFFF) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 19] >>> 30 | (in[inPos + 20] & 0xFFFFF) << 2) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 20] >>> 20 | (in[inPos + 21] & 0x3FF) << 12) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 21] >>> 10) + out[outPos + 30];
    }

    private static void pack23(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 23;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 9 | in[inPos + 2] - in[inPos + 1] << 14;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 18 | in[inPos + 3] - in[inPos + 2] << 5 | in[inPos + 4] - in[inPos + 3] << 28;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 4 | in[inPos + 5] - in[inPos + 4] << 19;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 13 | in[inPos + 6] - in[inPos + 5] << 10;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 22 | in[inPos + 7] - in[inPos + 6] << 1 | in[inPos + 8] - in[inPos + 7] << 24;
        out[outPos + 6] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 15;
        out[outPos + 7] = in[inPos + 9] - in[inPos + 8] >>> 17 | in[inPos + 10] - in[inPos + 9] << 6 | in[inPos + 11] - in[inPos + 10] << 29;
        out[outPos + 8] = in[inPos + 11] - in[inPos + 10] >>> 3 | in[inPos + 12] - in[inPos + 11] << 20;
        out[outPos + 9] = in[inPos + 12] - in[inPos + 11] >>> 12 | in[inPos + 13] - in[inPos + 12] << 11;
        out[outPos + 10] = in[inPos + 13] - in[inPos + 12] >>> 21 | in[inPos + 14] - in[inPos + 13] << 2 | in[inPos + 15] - in[inPos + 14] << 25;
        out[outPos + 11] = in[inPos + 15] - in[inPos + 14] >>> 7 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 12] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 7 | in[inPos + 18] - in[inPos + 17] << 30;
        out[outPos + 13] = in[inPos + 18] - in[inPos + 17] >>> 2 | in[inPos + 19] - in[inPos + 18] << 21;
        out[outPos + 14] = in[inPos + 19] - in[inPos + 18] >>> 11 | in[inPos + 20] - in[inPos + 19] << 12;
        out[outPos + 15] = in[inPos + 20] - in[inPos + 19] >>> 20 | in[inPos + 21] - in[inPos + 20] << 3 | in[inPos + 22] - in[inPos + 21] << 26;
        out[outPos + 16] = in[inPos + 22] - in[inPos + 21] >>> 6 | in[inPos + 23] - in[inPos + 22] << 17;
        out[outPos + 17] = in[inPos + 23] - in[inPos + 22] >>> 15 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 31;
        out[outPos + 18] = in[inPos + 25] - in[inPos + 24] >>> 1 | in[inPos + 26] - in[inPos + 25] << 22;
        out[outPos + 19] = in[inPos + 26] - in[inPos + 25] >>> 10 | in[inPos + 27] - in[inPos + 26] << 13;
        out[outPos + 20] = in[inPos + 27] - in[inPos + 26] >>> 19 | in[inPos + 28] - in[inPos + 27] << 4 | in[inPos + 29] - in[inPos + 28] << 27;
        out[outPos + 21] = in[inPos + 29] - in[inPos + 28] >>> 5 | in[inPos + 30] - in[inPos + 29] << 18;
        out[outPos + 22] = in[inPos + 30] - in[inPos + 29] >>> 14 | in[inPos + 31] - in[inPos + 30] << 9;
    }

    private static void unpack23(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 23 | (in[inPos + 1] & 0x3FFF) << 9) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 14 | (in[inPos + 2] & 0x1F) << 18) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 5 & 0x7FFFFF) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 28 | (in[inPos + 3] & 0x7FFFF) << 4) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 19 | (in[inPos + 4] & 0x3FF) << 13) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 10 | (in[inPos + 5] & 1) << 22) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 1 & 0x7FFFFF) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] >>> 24 | (in[inPos + 6] & Short.MAX_VALUE) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 6] >>> 15 | (in[inPos + 7] & 0x3F) << 17) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 7] >>> 6 & 0x7FFFFF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 7] >>> 29 | (in[inPos + 8] & 0xFFFFF) << 3) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 8] >>> 20 | (in[inPos + 9] & 0x7FF) << 12) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 9] >>> 11 | (in[inPos + 10] & 3) << 21) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 10] >>> 2 & 0x7FFFFF) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 10] >>> 25 | (in[inPos + 11] & 0xFFFF) << 7) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 11] >>> 16 | (in[inPos + 12] & 0x7F) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 12] >>> 7 & 0x7FFFFF) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 12] >>> 30 | (in[inPos + 13] & 0x1FFFFF) << 2) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 13] >>> 21 | (in[inPos + 14] & 0xFFF) << 11) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 14] >>> 12 | (in[inPos + 15] & 7) << 20) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 15] >>> 3 & 0x7FFFFF) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 15] >>> 26 | (in[inPos + 16] & 0x1FFFF) << 6) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 16] >>> 17 | (in[inPos + 17] & 0xFF) << 15) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 17] >>> 8 & 0x7FFFFF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 17] >>> 31 | (in[inPos + 18] & 0x3FFFFF) << 1) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 18] >>> 22 | (in[inPos + 19] & 0x1FFF) << 10) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 19] >>> 13 | (in[inPos + 20] & 0xF) << 19) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 20] >>> 4 & 0x7FFFFF) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 20] >>> 27 | (in[inPos + 21] & 0x3FFFF) << 5) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 21] >>> 18 | (in[inPos + 22] & 0x1FF) << 14) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 22] >>> 9) + out[outPos + 30];
    }

    private static void pack24(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 24;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 8 | in[inPos + 2] - in[inPos + 1] << 16;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 16 | in[inPos + 3] - in[inPos + 2] << 8;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] | in[inPos + 5] - in[inPos + 4] << 24;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 8 | in[inPos + 6] - in[inPos + 5] << 16;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 16 | in[inPos + 7] - in[inPos + 6] << 8;
        out[outPos + 6] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 24;
        out[outPos + 7] = in[inPos + 9] - in[inPos + 8] >>> 8 | in[inPos + 10] - in[inPos + 9] << 16;
        out[outPos + 8] = in[inPos + 10] - in[inPos + 9] >>> 16 | in[inPos + 11] - in[inPos + 10] << 8;
        out[outPos + 9] = in[inPos + 12] - in[inPos + 11] | in[inPos + 13] - in[inPos + 12] << 24;
        out[outPos + 10] = in[inPos + 13] - in[inPos + 12] >>> 8 | in[inPos + 14] - in[inPos + 13] << 16;
        out[outPos + 11] = in[inPos + 14] - in[inPos + 13] >>> 16 | in[inPos + 15] - in[inPos + 14] << 8;
        out[outPos + 12] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 24;
        out[outPos + 13] = in[inPos + 17] - in[inPos + 16] >>> 8 | in[inPos + 18] - in[inPos + 17] << 16;
        out[outPos + 14] = in[inPos + 18] - in[inPos + 17] >>> 16 | in[inPos + 19] - in[inPos + 18] << 8;
        out[outPos + 15] = in[inPos + 20] - in[inPos + 19] | in[inPos + 21] - in[inPos + 20] << 24;
        out[outPos + 16] = in[inPos + 21] - in[inPos + 20] >>> 8 | in[inPos + 22] - in[inPos + 21] << 16;
        out[outPos + 17] = in[inPos + 22] - in[inPos + 21] >>> 16 | in[inPos + 23] - in[inPos + 22] << 8;
        out[outPos + 18] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 24;
        out[outPos + 19] = in[inPos + 25] - in[inPos + 24] >>> 8 | in[inPos + 26] - in[inPos + 25] << 16;
        out[outPos + 20] = in[inPos + 26] - in[inPos + 25] >>> 16 | in[inPos + 27] - in[inPos + 26] << 8;
        out[outPos + 21] = in[inPos + 28] - in[inPos + 27] | in[inPos + 29] - in[inPos + 28] << 24;
        out[outPos + 22] = in[inPos + 29] - in[inPos + 28] >>> 8 | in[inPos + 30] - in[inPos + 29] << 16;
        out[outPos + 23] = in[inPos + 30] - in[inPos + 29] >>> 16 | in[inPos + 31] - in[inPos + 30] << 8;
    }

    private static void unpack24(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 24 | (in[inPos + 1] & 0xFFFF) << 8) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 16 | (in[inPos + 2] & 0xFF) << 16) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 8) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] & 0xFFFFFF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 24 | (in[inPos + 4] & 0xFFFF) << 8) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 16 | (in[inPos + 5] & 0xFF) << 16) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 8) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] & 0xFFFFFF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 6] >>> 24 | (in[inPos + 7] & 0xFFFF) << 8) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 7] >>> 16 | (in[inPos + 8] & 0xFF) << 16) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 8] >>> 8) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 9] & 0xFFFFFF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 9] >>> 24 | (in[inPos + 10] & 0xFFFF) << 8) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 10] >>> 16 | (in[inPos + 11] & 0xFF) << 16) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 11] >>> 8) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 12] & 0xFFFFFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 12] >>> 24 | (in[inPos + 13] & 0xFFFF) << 8) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 13] >>> 16 | (in[inPos + 14] & 0xFF) << 16) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 14] >>> 8) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 15] & 0xFFFFFF) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 15] >>> 24 | (in[inPos + 16] & 0xFFFF) << 8) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 16] >>> 16 | (in[inPos + 17] & 0xFF) << 16) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 17] >>> 8) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 18] & 0xFFFFFF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 18] >>> 24 | (in[inPos + 19] & 0xFFFF) << 8) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 19] >>> 16 | (in[inPos + 20] & 0xFF) << 16) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 20] >>> 8) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 21] & 0xFFFFFF) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 21] >>> 24 | (in[inPos + 22] & 0xFFFF) << 8) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 22] >>> 16 | (in[inPos + 23] & 0xFF) << 16) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 23] >>> 8) + out[outPos + 30];
    }

    private static void pack25(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 25;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 7 | in[inPos + 2] - in[inPos + 1] << 18;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 14 | in[inPos + 3] - in[inPos + 2] << 11;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 21 | in[inPos + 4] - in[inPos + 3] << 4 | in[inPos + 5] - in[inPos + 4] << 29;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 3 | in[inPos + 6] - in[inPos + 5] << 22;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 10 | in[inPos + 7] - in[inPos + 6] << 15;
        out[outPos + 6] = in[inPos + 7] - in[inPos + 6] >>> 17 | in[inPos + 8] - in[inPos + 7] << 8;
        out[outPos + 7] = in[inPos + 8] - in[inPos + 7] >>> 24 | in[inPos + 9] - in[inPos + 8] << 1 | in[inPos + 10] - in[inPos + 9] << 26;
        out[outPos + 8] = in[inPos + 10] - in[inPos + 9] >>> 6 | in[inPos + 11] - in[inPos + 10] << 19;
        out[outPos + 9] = in[inPos + 11] - in[inPos + 10] >>> 13 | in[inPos + 12] - in[inPos + 11] << 12;
        out[outPos + 10] = in[inPos + 12] - in[inPos + 11] >>> 20 | in[inPos + 13] - in[inPos + 12] << 5 | in[inPos + 14] - in[inPos + 13] << 30;
        out[outPos + 11] = in[inPos + 14] - in[inPos + 13] >>> 2 | in[inPos + 15] - in[inPos + 14] << 23;
        out[outPos + 12] = in[inPos + 15] - in[inPos + 14] >>> 9 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 13] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 9;
        out[outPos + 14] = in[inPos + 17] - in[inPos + 16] >>> 23 | in[inPos + 18] - in[inPos + 17] << 2 | in[inPos + 19] - in[inPos + 18] << 27;
        out[outPos + 15] = in[inPos + 19] - in[inPos + 18] >>> 5 | in[inPos + 20] - in[inPos + 19] << 20;
        out[outPos + 16] = in[inPos + 20] - in[inPos + 19] >>> 12 | in[inPos + 21] - in[inPos + 20] << 13;
        out[outPos + 17] = in[inPos + 21] - in[inPos + 20] >>> 19 | in[inPos + 22] - in[inPos + 21] << 6 | in[inPos + 23] - in[inPos + 22] << 31;
        out[outPos + 18] = in[inPos + 23] - in[inPos + 22] >>> 1 | in[inPos + 24] - in[inPos + 23] << 24;
        out[outPos + 19] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 17;
        out[outPos + 20] = in[inPos + 25] - in[inPos + 24] >>> 15 | in[inPos + 26] - in[inPos + 25] << 10;
        out[outPos + 21] = in[inPos + 26] - in[inPos + 25] >>> 22 | in[inPos + 27] - in[inPos + 26] << 3 | in[inPos + 28] - in[inPos + 27] << 28;
        out[outPos + 22] = in[inPos + 28] - in[inPos + 27] >>> 4 | in[inPos + 29] - in[inPos + 28] << 21;
        out[outPos + 23] = in[inPos + 29] - in[inPos + 28] >>> 11 | in[inPos + 30] - in[inPos + 29] << 14;
        out[outPos + 24] = in[inPos + 30] - in[inPos + 29] >>> 18 | in[inPos + 31] - in[inPos + 30] << 7;
    }

    private static void unpack25(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 25 | (in[inPos + 1] & 0x3FFFF) << 7) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 18 | (in[inPos + 2] & 0x7FF) << 14) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 11 | (in[inPos + 3] & 0xF) << 21) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 4 & 0x1FFFFFF) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 29 | (in[inPos + 4] & 0x3FFFFF) << 3) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 22 | (in[inPos + 5] & Short.MAX_VALUE) << 10) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 15 | (in[inPos + 6] & 0xFF) << 17) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] >>> 8 | (in[inPos + 7] & 1) << 24) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 7] >>> 1 & 0x1FFFFFF) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 7] >>> 26 | (in[inPos + 8] & 0x7FFFF) << 6) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 8] >>> 19 | (in[inPos + 9] & 0xFFF) << 13) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 9] >>> 12 | (in[inPos + 10] & 0x1F) << 20) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 10] >>> 5 & 0x1FFFFFF) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 10] >>> 30 | (in[inPos + 11] & 0x7FFFFF) << 2) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 11] >>> 23 | (in[inPos + 12] & 0xFFFF) << 9) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 12] >>> 16 | (in[inPos + 13] & 0x1FF) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 13] >>> 9 | (in[inPos + 14] & 3) << 23) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 14] >>> 2 & 0x1FFFFFF) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 14] >>> 27 | (in[inPos + 15] & 0xFFFFF) << 5) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 15] >>> 20 | (in[inPos + 16] & 0x1FFF) << 12) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 16] >>> 13 | (in[inPos + 17] & 0x3F) << 19) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 17] >>> 6 & 0x1FFFFFF) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 17] >>> 31 | (in[inPos + 18] & 0xFFFFFF) << 1) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 18] >>> 24 | (in[inPos + 19] & 0x1FFFF) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 19] >>> 17 | (in[inPos + 20] & 0x3FF) << 15) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 20] >>> 10 | (in[inPos + 21] & 7) << 22) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 21] >>> 3 & 0x1FFFFFF) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 21] >>> 28 | (in[inPos + 22] & 0x1FFFFF) << 4) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 22] >>> 21 | (in[inPos + 23] & 0x3FFF) << 11) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 23] >>> 14 | (in[inPos + 24] & 0x7F) << 18) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 24] >>> 7) + out[outPos + 30];
    }

    private static void pack26(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 26;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 6 | in[inPos + 2] - in[inPos + 1] << 20;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 12 | in[inPos + 3] - in[inPos + 2] << 14;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 18 | in[inPos + 4] - in[inPos + 3] << 8;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 24 | in[inPos + 5] - in[inPos + 4] << 2 | in[inPos + 6] - in[inPos + 5] << 28;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 4 | in[inPos + 7] - in[inPos + 6] << 22;
        out[outPos + 6] = in[inPos + 7] - in[inPos + 6] >>> 10 | in[inPos + 8] - in[inPos + 7] << 16;
        out[outPos + 7] = in[inPos + 8] - in[inPos + 7] >>> 16 | in[inPos + 9] - in[inPos + 8] << 10;
        out[outPos + 8] = in[inPos + 9] - in[inPos + 8] >>> 22 | in[inPos + 10] - in[inPos + 9] << 4 | in[inPos + 11] - in[inPos + 10] << 30;
        out[outPos + 9] = in[inPos + 11] - in[inPos + 10] >>> 2 | in[inPos + 12] - in[inPos + 11] << 24;
        out[outPos + 10] = in[inPos + 12] - in[inPos + 11] >>> 8 | in[inPos + 13] - in[inPos + 12] << 18;
        out[outPos + 11] = in[inPos + 13] - in[inPos + 12] >>> 14 | in[inPos + 14] - in[inPos + 13] << 12;
        out[outPos + 12] = in[inPos + 14] - in[inPos + 13] >>> 20 | in[inPos + 15] - in[inPos + 14] << 6;
        out[outPos + 13] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 26;
        out[outPos + 14] = in[inPos + 17] - in[inPos + 16] >>> 6 | in[inPos + 18] - in[inPos + 17] << 20;
        out[outPos + 15] = in[inPos + 18] - in[inPos + 17] >>> 12 | in[inPos + 19] - in[inPos + 18] << 14;
        out[outPos + 16] = in[inPos + 19] - in[inPos + 18] >>> 18 | in[inPos + 20] - in[inPos + 19] << 8;
        out[outPos + 17] = in[inPos + 20] - in[inPos + 19] >>> 24 | in[inPos + 21] - in[inPos + 20] << 2 | in[inPos + 22] - in[inPos + 21] << 28;
        out[outPos + 18] = in[inPos + 22] - in[inPos + 21] >>> 4 | in[inPos + 23] - in[inPos + 22] << 22;
        out[outPos + 19] = in[inPos + 23] - in[inPos + 22] >>> 10 | in[inPos + 24] - in[inPos + 23] << 16;
        out[outPos + 20] = in[inPos + 24] - in[inPos + 23] >>> 16 | in[inPos + 25] - in[inPos + 24] << 10;
        out[outPos + 21] = in[inPos + 25] - in[inPos + 24] >>> 22 | in[inPos + 26] - in[inPos + 25] << 4 | in[inPos + 27] - in[inPos + 26] << 30;
        out[outPos + 22] = in[inPos + 27] - in[inPos + 26] >>> 2 | in[inPos + 28] - in[inPos + 27] << 24;
        out[outPos + 23] = in[inPos + 28] - in[inPos + 27] >>> 8 | in[inPos + 29] - in[inPos + 28] << 18;
        out[outPos + 24] = in[inPos + 29] - in[inPos + 28] >>> 14 | in[inPos + 30] - in[inPos + 29] << 12;
        out[outPos + 25] = in[inPos + 30] - in[inPos + 29] >>> 20 | in[inPos + 31] - in[inPos + 30] << 6;
    }

    private static void unpack26(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 26 | (in[inPos + 1] & 0xFFFFF) << 6) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 20 | (in[inPos + 2] & 0x3FFF) << 12) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 14 | (in[inPos + 3] & 0xFF) << 18) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 8 | (in[inPos + 4] & 3) << 24) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 2 & 0x3FFFFFF) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 28 | (in[inPos + 5] & 0x3FFFFF) << 4) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 22 | (in[inPos + 6] & 0xFFFF) << 10) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] >>> 16 | (in[inPos + 7] & 0x3FF) << 16) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 7] >>> 10 | (in[inPos + 8] & 0xF) << 22) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 8] >>> 4 & 0x3FFFFFF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 8] >>> 30 | (in[inPos + 9] & 0xFFFFFF) << 2) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 9] >>> 24 | (in[inPos + 10] & 0x3FFFF) << 8) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 10] >>> 18 | (in[inPos + 11] & 0xFFF) << 14) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 11] >>> 12 | (in[inPos + 12] & 0x3F) << 20) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 12] >>> 6) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 13] & 0x3FFFFFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 13] >>> 26 | (in[inPos + 14] & 0xFFFFF) << 6) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 14] >>> 20 | (in[inPos + 15] & 0x3FFF) << 12) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 15] >>> 14 | (in[inPos + 16] & 0xFF) << 18) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 16] >>> 8 | (in[inPos + 17] & 3) << 24) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 17] >>> 2 & 0x3FFFFFF) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 17] >>> 28 | (in[inPos + 18] & 0x3FFFFF) << 4) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 18] >>> 22 | (in[inPos + 19] & 0xFFFF) << 10) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 19] >>> 16 | (in[inPos + 20] & 0x3FF) << 16) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 20] >>> 10 | (in[inPos + 21] & 0xF) << 22) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 21] >>> 4 & 0x3FFFFFF) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 21] >>> 30 | (in[inPos + 22] & 0xFFFFFF) << 2) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 22] >>> 24 | (in[inPos + 23] & 0x3FFFF) << 8) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 23] >>> 18 | (in[inPos + 24] & 0xFFF) << 14) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 24] >>> 12 | (in[inPos + 25] & 0x3F) << 20) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 25] >>> 6) + out[outPos + 30];
    }

    private static void pack27(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 27;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 5 | in[inPos + 2] - in[inPos + 1] << 22;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 10 | in[inPos + 3] - in[inPos + 2] << 17;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 15 | in[inPos + 4] - in[inPos + 3] << 12;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 20 | in[inPos + 5] - in[inPos + 4] << 7;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 25 | in[inPos + 6] - in[inPos + 5] << 2 | in[inPos + 7] - in[inPos + 6] << 29;
        out[outPos + 6] = in[inPos + 7] - in[inPos + 6] >>> 3 | in[inPos + 8] - in[inPos + 7] << 24;
        out[outPos + 7] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 19;
        out[outPos + 8] = in[inPos + 9] - in[inPos + 8] >>> 13 | in[inPos + 10] - in[inPos + 9] << 14;
        out[outPos + 9] = in[inPos + 10] - in[inPos + 9] >>> 18 | in[inPos + 11] - in[inPos + 10] << 9;
        out[outPos + 10] = in[inPos + 11] - in[inPos + 10] >>> 23 | in[inPos + 12] - in[inPos + 11] << 4 | in[inPos + 13] - in[inPos + 12] << 31;
        out[outPos + 11] = in[inPos + 13] - in[inPos + 12] >>> 1 | in[inPos + 14] - in[inPos + 13] << 26;
        out[outPos + 12] = in[inPos + 14] - in[inPos + 13] >>> 6 | in[inPos + 15] - in[inPos + 14] << 21;
        out[outPos + 13] = in[inPos + 15] - in[inPos + 14] >>> 11 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 14] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 11;
        out[outPos + 15] = in[inPos + 17] - in[inPos + 16] >>> 21 | in[inPos + 18] - in[inPos + 17] << 6;
        out[outPos + 16] = in[inPos + 18] - in[inPos + 17] >>> 26 | in[inPos + 19] - in[inPos + 18] << 1 | in[inPos + 20] - in[inPos + 19] << 28;
        out[outPos + 17] = in[inPos + 20] - in[inPos + 19] >>> 4 | in[inPos + 21] - in[inPos + 20] << 23;
        out[outPos + 18] = in[inPos + 21] - in[inPos + 20] >>> 9 | in[inPos + 22] - in[inPos + 21] << 18;
        out[outPos + 19] = in[inPos + 22] - in[inPos + 21] >>> 14 | in[inPos + 23] - in[inPos + 22] << 13;
        out[outPos + 20] = in[inPos + 23] - in[inPos + 22] >>> 19 | in[inPos + 24] - in[inPos + 23] << 8;
        out[outPos + 21] = in[inPos + 24] - in[inPos + 23] >>> 24 | in[inPos + 25] - in[inPos + 24] << 3 | in[inPos + 26] - in[inPos + 25] << 30;
        out[outPos + 22] = in[inPos + 26] - in[inPos + 25] >>> 2 | in[inPos + 27] - in[inPos + 26] << 25;
        out[outPos + 23] = in[inPos + 27] - in[inPos + 26] >>> 7 | in[inPos + 28] - in[inPos + 27] << 20;
        out[outPos + 24] = in[inPos + 28] - in[inPos + 27] >>> 12 | in[inPos + 29] - in[inPos + 28] << 15;
        out[outPos + 25] = in[inPos + 29] - in[inPos + 28] >>> 17 | in[inPos + 30] - in[inPos + 29] << 10;
        out[outPos + 26] = in[inPos + 30] - in[inPos + 29] >>> 22 | in[inPos + 31] - in[inPos + 30] << 5;
    }

    private static void unpack27(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 27 | (in[inPos + 1] & 0x3FFFFF) << 5) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 22 | (in[inPos + 2] & 0x1FFFF) << 10) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 17 | (in[inPos + 3] & 0xFFF) << 15) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 12 | (in[inPos + 4] & 0x7F) << 20) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 7 | (in[inPos + 5] & 3) << 25) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 2 & 0x7FFFFFF) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 29 | (in[inPos + 6] & 0xFFFFFF) << 3) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] >>> 24 | (in[inPos + 7] & 0x7FFFF) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 7] >>> 19 | (in[inPos + 8] & 0x3FFF) << 13) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 8] >>> 14 | (in[inPos + 9] & 0x1FF) << 18) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 9] >>> 9 | (in[inPos + 10] & 0xF) << 23) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 10] >>> 4 & 0x7FFFFFF) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 10] >>> 31 | (in[inPos + 11] & 0x3FFFFFF) << 1) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 11] >>> 26 | (in[inPos + 12] & 0x1FFFFF) << 6) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 12] >>> 21 | (in[inPos + 13] & 0xFFFF) << 11) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 13] >>> 16 | (in[inPos + 14] & 0x7FF) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 14] >>> 11 | (in[inPos + 15] & 0x3F) << 21) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 15] >>> 6 | (in[inPos + 16] & 1) << 26) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 16] >>> 1 & 0x7FFFFFF) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 16] >>> 28 | (in[inPos + 17] & 0x7FFFFF) << 4) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 17] >>> 23 | (in[inPos + 18] & 0x3FFFF) << 9) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 18] >>> 18 | (in[inPos + 19] & 0x1FFF) << 14) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 19] >>> 13 | (in[inPos + 20] & 0xFF) << 19) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 20] >>> 8 | (in[inPos + 21] & 7) << 24) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 21] >>> 3 & 0x7FFFFFF) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 21] >>> 30 | (in[inPos + 22] & 0x1FFFFFF) << 2) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 22] >>> 25 | (in[inPos + 23] & 0xFFFFF) << 7) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 23] >>> 20 | (in[inPos + 24] & Short.MAX_VALUE) << 12) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 24] >>> 15 | (in[inPos + 25] & 0x3FF) << 17) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 25] >>> 10 | (in[inPos + 26] & 0x1F) << 22) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 26] >>> 5) + out[outPos + 30];
    }

    private static void pack28(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 28;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 4 | in[inPos + 2] - in[inPos + 1] << 24;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 8 | in[inPos + 3] - in[inPos + 2] << 20;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 12 | in[inPos + 4] - in[inPos + 3] << 16;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 16 | in[inPos + 5] - in[inPos + 4] << 12;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 20 | in[inPos + 6] - in[inPos + 5] << 8;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 24 | in[inPos + 7] - in[inPos + 6] << 4;
        out[outPos + 7] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 28;
        out[outPos + 8] = in[inPos + 9] - in[inPos + 8] >>> 4 | in[inPos + 10] - in[inPos + 9] << 24;
        out[outPos + 9] = in[inPos + 10] - in[inPos + 9] >>> 8 | in[inPos + 11] - in[inPos + 10] << 20;
        out[outPos + 10] = in[inPos + 11] - in[inPos + 10] >>> 12 | in[inPos + 12] - in[inPos + 11] << 16;
        out[outPos + 11] = in[inPos + 12] - in[inPos + 11] >>> 16 | in[inPos + 13] - in[inPos + 12] << 12;
        out[outPos + 12] = in[inPos + 13] - in[inPos + 12] >>> 20 | in[inPos + 14] - in[inPos + 13] << 8;
        out[outPos + 13] = in[inPos + 14] - in[inPos + 13] >>> 24 | in[inPos + 15] - in[inPos + 14] << 4;
        out[outPos + 14] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 28;
        out[outPos + 15] = in[inPos + 17] - in[inPos + 16] >>> 4 | in[inPos + 18] - in[inPos + 17] << 24;
        out[outPos + 16] = in[inPos + 18] - in[inPos + 17] >>> 8 | in[inPos + 19] - in[inPos + 18] << 20;
        out[outPos + 17] = in[inPos + 19] - in[inPos + 18] >>> 12 | in[inPos + 20] - in[inPos + 19] << 16;
        out[outPos + 18] = in[inPos + 20] - in[inPos + 19] >>> 16 | in[inPos + 21] - in[inPos + 20] << 12;
        out[outPos + 19] = in[inPos + 21] - in[inPos + 20] >>> 20 | in[inPos + 22] - in[inPos + 21] << 8;
        out[outPos + 20] = in[inPos + 22] - in[inPos + 21] >>> 24 | in[inPos + 23] - in[inPos + 22] << 4;
        out[outPos + 21] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 28;
        out[outPos + 22] = in[inPos + 25] - in[inPos + 24] >>> 4 | in[inPos + 26] - in[inPos + 25] << 24;
        out[outPos + 23] = in[inPos + 26] - in[inPos + 25] >>> 8 | in[inPos + 27] - in[inPos + 26] << 20;
        out[outPos + 24] = in[inPos + 27] - in[inPos + 26] >>> 12 | in[inPos + 28] - in[inPos + 27] << 16;
        out[outPos + 25] = in[inPos + 28] - in[inPos + 27] >>> 16 | in[inPos + 29] - in[inPos + 28] << 12;
        out[outPos + 26] = in[inPos + 29] - in[inPos + 28] >>> 20 | in[inPos + 30] - in[inPos + 29] << 8;
        out[outPos + 27] = in[inPos + 30] - in[inPos + 29] >>> 24 | in[inPos + 31] - in[inPos + 30] << 4;
    }

    private static void unpack28(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 28 | (in[inPos + 1] & 0xFFFFFF) << 4) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 24 | (in[inPos + 2] & 0xFFFFF) << 8) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 20 | (in[inPos + 3] & 0xFFFF) << 12) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 16 | (in[inPos + 4] & 0xFFF) << 16) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 12 | (in[inPos + 5] & 0xFF) << 20) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 8 | (in[inPos + 6] & 0xF) << 24) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 4) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] & 0xFFFFFFF) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 7] >>> 28 | (in[inPos + 8] & 0xFFFFFF) << 4) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 8] >>> 24 | (in[inPos + 9] & 0xFFFFF) << 8) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 9] >>> 20 | (in[inPos + 10] & 0xFFFF) << 12) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 10] >>> 16 | (in[inPos + 11] & 0xFFF) << 16) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 11] >>> 12 | (in[inPos + 12] & 0xFF) << 20) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 12] >>> 8 | (in[inPos + 13] & 0xF) << 24) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 13] >>> 4) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 14] & 0xFFFFFFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 14] >>> 28 | (in[inPos + 15] & 0xFFFFFF) << 4) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 15] >>> 24 | (in[inPos + 16] & 0xFFFFF) << 8) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 16] >>> 20 | (in[inPos + 17] & 0xFFFF) << 12) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 17] >>> 16 | (in[inPos + 18] & 0xFFF) << 16) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 18] >>> 12 | (in[inPos + 19] & 0xFF) << 20) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 19] >>> 8 | (in[inPos + 20] & 0xF) << 24) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 20] >>> 4) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 21] & 0xFFFFFFF) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 21] >>> 28 | (in[inPos + 22] & 0xFFFFFF) << 4) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 22] >>> 24 | (in[inPos + 23] & 0xFFFFF) << 8) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 23] >>> 20 | (in[inPos + 24] & 0xFFFF) << 12) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 24] >>> 16 | (in[inPos + 25] & 0xFFF) << 16) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 25] >>> 12 | (in[inPos + 26] & 0xFF) << 20) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 26] >>> 8 | (in[inPos + 27] & 0xF) << 24) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 27] >>> 4) + out[outPos + 30];
    }

    private static void pack29(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 29;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 3 | in[inPos + 2] - in[inPos + 1] << 26;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 6 | in[inPos + 3] - in[inPos + 2] << 23;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 9 | in[inPos + 4] - in[inPos + 3] << 20;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 12 | in[inPos + 5] - in[inPos + 4] << 17;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 15 | in[inPos + 6] - in[inPos + 5] << 14;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 18 | in[inPos + 7] - in[inPos + 6] << 11;
        out[outPos + 7] = in[inPos + 7] - in[inPos + 6] >>> 21 | in[inPos + 8] - in[inPos + 7] << 8;
        out[outPos + 8] = in[inPos + 8] - in[inPos + 7] >>> 24 | in[inPos + 9] - in[inPos + 8] << 5;
        out[outPos + 9] = in[inPos + 9] - in[inPos + 8] >>> 27 | in[inPos + 10] - in[inPos + 9] << 2 | in[inPos + 11] - in[inPos + 10] << 31;
        out[outPos + 10] = in[inPos + 11] - in[inPos + 10] >>> 1 | in[inPos + 12] - in[inPos + 11] << 28;
        out[outPos + 11] = in[inPos + 12] - in[inPos + 11] >>> 4 | in[inPos + 13] - in[inPos + 12] << 25;
        out[outPos + 12] = in[inPos + 13] - in[inPos + 12] >>> 7 | in[inPos + 14] - in[inPos + 13] << 22;
        out[outPos + 13] = in[inPos + 14] - in[inPos + 13] >>> 10 | in[inPos + 15] - in[inPos + 14] << 19;
        out[outPos + 14] = in[inPos + 15] - in[inPos + 14] >>> 13 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 15] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 13;
        out[outPos + 16] = in[inPos + 17] - in[inPos + 16] >>> 19 | in[inPos + 18] - in[inPos + 17] << 10;
        out[outPos + 17] = in[inPos + 18] - in[inPos + 17] >>> 22 | in[inPos + 19] - in[inPos + 18] << 7;
        out[outPos + 18] = in[inPos + 19] - in[inPos + 18] >>> 25 | in[inPos + 20] - in[inPos + 19] << 4;
        out[outPos + 19] = in[inPos + 20] - in[inPos + 19] >>> 28 | in[inPos + 21] - in[inPos + 20] << 1 | in[inPos + 22] - in[inPos + 21] << 30;
        out[outPos + 20] = in[inPos + 22] - in[inPos + 21] >>> 2 | in[inPos + 23] - in[inPos + 22] << 27;
        out[outPos + 21] = in[inPos + 23] - in[inPos + 22] >>> 5 | in[inPos + 24] - in[inPos + 23] << 24;
        out[outPos + 22] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 21;
        out[outPos + 23] = in[inPos + 25] - in[inPos + 24] >>> 11 | in[inPos + 26] - in[inPos + 25] << 18;
        out[outPos + 24] = in[inPos + 26] - in[inPos + 25] >>> 14 | in[inPos + 27] - in[inPos + 26] << 15;
        out[outPos + 25] = in[inPos + 27] - in[inPos + 26] >>> 17 | in[inPos + 28] - in[inPos + 27] << 12;
        out[outPos + 26] = in[inPos + 28] - in[inPos + 27] >>> 20 | in[inPos + 29] - in[inPos + 28] << 9;
        out[outPos + 27] = in[inPos + 29] - in[inPos + 28] >>> 23 | in[inPos + 30] - in[inPos + 29] << 6;
        out[outPos + 28] = in[inPos + 30] - in[inPos + 29] >>> 26 | in[inPos + 31] - in[inPos + 30] << 3;
    }

    private static void unpack29(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 29 | (in[inPos + 1] & 0x3FFFFFF) << 3) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 26 | (in[inPos + 2] & 0x7FFFFF) << 6) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 23 | (in[inPos + 3] & 0xFFFFF) << 9) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 20 | (in[inPos + 4] & 0x1FFFF) << 12) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 17 | (in[inPos + 5] & 0x3FFF) << 15) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 14 | (in[inPos + 6] & 0x7FF) << 18) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 11 | (in[inPos + 7] & 0xFF) << 21) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] >>> 8 | (in[inPos + 8] & 0x1F) << 24) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 8] >>> 5 | (in[inPos + 9] & 3) << 27) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 9] >>> 2 & 0x1FFFFFFF) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 9] >>> 31 | (in[inPos + 10] & 0xFFFFFFF) << 1) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 10] >>> 28 | (in[inPos + 11] & 0x1FFFFFF) << 4) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 11] >>> 25 | (in[inPos + 12] & 0x3FFFFF) << 7) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 12] >>> 22 | (in[inPos + 13] & 0x7FFFF) << 10) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 13] >>> 19 | (in[inPos + 14] & 0xFFFF) << 13) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 14] >>> 16 | (in[inPos + 15] & 0x1FFF) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 15] >>> 13 | (in[inPos + 16] & 0x3FF) << 19) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 16] >>> 10 | (in[inPos + 17] & 0x7F) << 22) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 17] >>> 7 | (in[inPos + 18] & 0xF) << 25) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 18] >>> 4 | (in[inPos + 19] & 1) << 28) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 19] >>> 1 & 0x1FFFFFFF) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 19] >>> 30 | (in[inPos + 20] & 0x7FFFFFF) << 2) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 20] >>> 27 | (in[inPos + 21] & 0xFFFFFF) << 5) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 21] >>> 24 | (in[inPos + 22] & 0x1FFFFF) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 22] >>> 21 | (in[inPos + 23] & 0x3FFFF) << 11) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 23] >>> 18 | (in[inPos + 24] & Short.MAX_VALUE) << 14) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 24] >>> 15 | (in[inPos + 25] & 0xFFF) << 17) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 25] >>> 12 | (in[inPos + 26] & 0x1FF) << 20) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 26] >>> 9 | (in[inPos + 27] & 0x3F) << 23) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 27] >>> 6 | (in[inPos + 28] & 7) << 26) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 28] >>> 3) + out[outPos + 30];
    }

    private static void pack30(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 30;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 2 | in[inPos + 2] - in[inPos + 1] << 28;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 4 | in[inPos + 3] - in[inPos + 2] << 26;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 6 | in[inPos + 4] - in[inPos + 3] << 24;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 8 | in[inPos + 5] - in[inPos + 4] << 22;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 10 | in[inPos + 6] - in[inPos + 5] << 20;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 12 | in[inPos + 7] - in[inPos + 6] << 18;
        out[outPos + 7] = in[inPos + 7] - in[inPos + 6] >>> 14 | in[inPos + 8] - in[inPos + 7] << 16;
        out[outPos + 8] = in[inPos + 8] - in[inPos + 7] >>> 16 | in[inPos + 9] - in[inPos + 8] << 14;
        out[outPos + 9] = in[inPos + 9] - in[inPos + 8] >>> 18 | in[inPos + 10] - in[inPos + 9] << 12;
        out[outPos + 10] = in[inPos + 10] - in[inPos + 9] >>> 20 | in[inPos + 11] - in[inPos + 10] << 10;
        out[outPos + 11] = in[inPos + 11] - in[inPos + 10] >>> 22 | in[inPos + 12] - in[inPos + 11] << 8;
        out[outPos + 12] = in[inPos + 12] - in[inPos + 11] >>> 24 | in[inPos + 13] - in[inPos + 12] << 6;
        out[outPos + 13] = in[inPos + 13] - in[inPos + 12] >>> 26 | in[inPos + 14] - in[inPos + 13] << 4;
        out[outPos + 14] = in[inPos + 14] - in[inPos + 13] >>> 28 | in[inPos + 15] - in[inPos + 14] << 2;
        out[outPos + 15] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 30;
        out[outPos + 16] = in[inPos + 17] - in[inPos + 16] >>> 2 | in[inPos + 18] - in[inPos + 17] << 28;
        out[outPos + 17] = in[inPos + 18] - in[inPos + 17] >>> 4 | in[inPos + 19] - in[inPos + 18] << 26;
        out[outPos + 18] = in[inPos + 19] - in[inPos + 18] >>> 6 | in[inPos + 20] - in[inPos + 19] << 24;
        out[outPos + 19] = in[inPos + 20] - in[inPos + 19] >>> 8 | in[inPos + 21] - in[inPos + 20] << 22;
        out[outPos + 20] = in[inPos + 21] - in[inPos + 20] >>> 10 | in[inPos + 22] - in[inPos + 21] << 20;
        out[outPos + 21] = in[inPos + 22] - in[inPos + 21] >>> 12 | in[inPos + 23] - in[inPos + 22] << 18;
        out[outPos + 22] = in[inPos + 23] - in[inPos + 22] >>> 14 | in[inPos + 24] - in[inPos + 23] << 16;
        out[outPos + 23] = in[inPos + 24] - in[inPos + 23] >>> 16 | in[inPos + 25] - in[inPos + 24] << 14;
        out[outPos + 24] = in[inPos + 25] - in[inPos + 24] >>> 18 | in[inPos + 26] - in[inPos + 25] << 12;
        out[outPos + 25] = in[inPos + 26] - in[inPos + 25] >>> 20 | in[inPos + 27] - in[inPos + 26] << 10;
        out[outPos + 26] = in[inPos + 27] - in[inPos + 26] >>> 22 | in[inPos + 28] - in[inPos + 27] << 8;
        out[outPos + 27] = in[inPos + 28] - in[inPos + 27] >>> 24 | in[inPos + 29] - in[inPos + 28] << 6;
        out[outPos + 28] = in[inPos + 29] - in[inPos + 28] >>> 26 | in[inPos + 30] - in[inPos + 29] << 4;
        out[outPos + 29] = in[inPos + 30] - in[inPos + 29] >>> 28 | in[inPos + 31] - in[inPos + 30] << 2;
    }

    private static void unpack30(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFFF) + initValue;
        out[outPos + 1] = (in[inPos] >>> 30 | (in[inPos + 1] & 0xFFFFFFF) << 2) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 28 | (in[inPos + 2] & 0x3FFFFFF) << 4) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 26 | (in[inPos + 3] & 0xFFFFFF) << 6) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 24 | (in[inPos + 4] & 0x3FFFFF) << 8) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 22 | (in[inPos + 5] & 0xFFFFF) << 10) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 20 | (in[inPos + 6] & 0x3FFFF) << 12) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 18 | (in[inPos + 7] & 0xFFFF) << 14) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] >>> 16 | (in[inPos + 8] & 0x3FFF) << 16) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 8] >>> 14 | (in[inPos + 9] & 0xFFF) << 18) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 9] >>> 12 | (in[inPos + 10] & 0x3FF) << 20) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 10] >>> 10 | (in[inPos + 11] & 0xFF) << 22) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 11] >>> 8 | (in[inPos + 12] & 0x3F) << 24) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 12] >>> 6 | (in[inPos + 13] & 0xF) << 26) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 13] >>> 4 | (in[inPos + 14] & 3) << 28) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 14] >>> 2) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 15] & 0x3FFFFFFF) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 15] >>> 30 | (in[inPos + 16] & 0xFFFFFFF) << 2) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 16] >>> 28 | (in[inPos + 17] & 0x3FFFFFF) << 4) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 17] >>> 26 | (in[inPos + 18] & 0xFFFFFF) << 6) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 18] >>> 24 | (in[inPos + 19] & 0x3FFFFF) << 8) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 19] >>> 22 | (in[inPos + 20] & 0xFFFFF) << 10) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 20] >>> 20 | (in[inPos + 21] & 0x3FFFF) << 12) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 21] >>> 18 | (in[inPos + 22] & 0xFFFF) << 14) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 22] >>> 16 | (in[inPos + 23] & 0x3FFF) << 16) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 23] >>> 14 | (in[inPos + 24] & 0xFFF) << 18) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 24] >>> 12 | (in[inPos + 25] & 0x3FF) << 20) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 25] >>> 10 | (in[inPos + 26] & 0xFF) << 22) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 26] >>> 8 | (in[inPos + 27] & 0x3F) << 24) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 27] >>> 6 | (in[inPos + 28] & 0xF) << 26) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 28] >>> 4 | (in[inPos + 29] & 3) << 28) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 29] >>> 2) + out[outPos + 30];
    }

    private static void pack31(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 31;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 1 | in[inPos + 2] - in[inPos + 1] << 30;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 2 | in[inPos + 3] - in[inPos + 2] << 29;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 3 | in[inPos + 4] - in[inPos + 3] << 28;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 4 | in[inPos + 5] - in[inPos + 4] << 27;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 5 | in[inPos + 6] - in[inPos + 5] << 26;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 6 | in[inPos + 7] - in[inPos + 6] << 25;
        out[outPos + 7] = in[inPos + 7] - in[inPos + 6] >>> 7 | in[inPos + 8] - in[inPos + 7] << 24;
        out[outPos + 8] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 23;
        out[outPos + 9] = in[inPos + 9] - in[inPos + 8] >>> 9 | in[inPos + 10] - in[inPos + 9] << 22;
        out[outPos + 10] = in[inPos + 10] - in[inPos + 9] >>> 10 | in[inPos + 11] - in[inPos + 10] << 21;
        out[outPos + 11] = in[inPos + 11] - in[inPos + 10] >>> 11 | in[inPos + 12] - in[inPos + 11] << 20;
        out[outPos + 12] = in[inPos + 12] - in[inPos + 11] >>> 12 | in[inPos + 13] - in[inPos + 12] << 19;
        out[outPos + 13] = in[inPos + 13] - in[inPos + 12] >>> 13 | in[inPos + 14] - in[inPos + 13] << 18;
        out[outPos + 14] = in[inPos + 14] - in[inPos + 13] >>> 14 | in[inPos + 15] - in[inPos + 14] << 17;
        out[outPos + 15] = in[inPos + 15] - in[inPos + 14] >>> 15 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 16] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 15;
        out[outPos + 17] = in[inPos + 17] - in[inPos + 16] >>> 17 | in[inPos + 18] - in[inPos + 17] << 14;
        out[outPos + 18] = in[inPos + 18] - in[inPos + 17] >>> 18 | in[inPos + 19] - in[inPos + 18] << 13;
        out[outPos + 19] = in[inPos + 19] - in[inPos + 18] >>> 19 | in[inPos + 20] - in[inPos + 19] << 12;
        out[outPos + 20] = in[inPos + 20] - in[inPos + 19] >>> 20 | in[inPos + 21] - in[inPos + 20] << 11;
        out[outPos + 21] = in[inPos + 21] - in[inPos + 20] >>> 21 | in[inPos + 22] - in[inPos + 21] << 10;
        out[outPos + 22] = in[inPos + 22] - in[inPos + 21] >>> 22 | in[inPos + 23] - in[inPos + 22] << 9;
        out[outPos + 23] = in[inPos + 23] - in[inPos + 22] >>> 23 | in[inPos + 24] - in[inPos + 23] << 8;
        out[outPos + 24] = in[inPos + 24] - in[inPos + 23] >>> 24 | in[inPos + 25] - in[inPos + 24] << 7;
        out[outPos + 25] = in[inPos + 25] - in[inPos + 24] >>> 25 | in[inPos + 26] - in[inPos + 25] << 6;
        out[outPos + 26] = in[inPos + 26] - in[inPos + 25] >>> 26 | in[inPos + 27] - in[inPos + 26] << 5;
        out[outPos + 27] = in[inPos + 27] - in[inPos + 26] >>> 27 | in[inPos + 28] - in[inPos + 27] << 4;
        out[outPos + 28] = in[inPos + 28] - in[inPos + 27] >>> 28 | in[inPos + 29] - in[inPos + 28] << 3;
        out[outPos + 29] = in[inPos + 29] - in[inPos + 28] >>> 29 | in[inPos + 30] - in[inPos + 29] << 2;
        out[outPos + 30] = in[inPos + 30] - in[inPos + 29] >>> 30 | in[inPos + 31] - in[inPos + 30] << 1;
    }

    private static void unpack31(int initValue, int[] in, int inPos, int[] out, int outPos) {
        out[outPos] = (in[inPos] & Integer.MAX_VALUE) + initValue;
        out[outPos + 1] = (in[inPos] >>> 31 | (in[inPos + 1] & 0x3FFFFFFF) << 1) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 30 | (in[inPos + 2] & 0x1FFFFFFF) << 2) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 29 | (in[inPos + 3] & 0xFFFFFFF) << 3) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 28 | (in[inPos + 4] & 0x7FFFFFF) << 4) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 27 | (in[inPos + 5] & 0x3FFFFFF) << 5) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 26 | (in[inPos + 6] & 0x1FFFFFF) << 6) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 25 | (in[inPos + 7] & 0xFFFFFF) << 7) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] >>> 24 | (in[inPos + 8] & 0x7FFFFF) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 8] >>> 23 | (in[inPos + 9] & 0x3FFFFF) << 9) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 9] >>> 22 | (in[inPos + 10] & 0x1FFFFF) << 10) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 10] >>> 21 | (in[inPos + 11] & 0xFFFFF) << 11) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 11] >>> 20 | (in[inPos + 12] & 0x7FFFF) << 12) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 12] >>> 19 | (in[inPos + 13] & 0x3FFFF) << 13) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 13] >>> 18 | (in[inPos + 14] & 0x1FFFF) << 14) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 14] >>> 17 | (in[inPos + 15] & 0xFFFF) << 15) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 15] >>> 16 | (in[inPos + 16] & Short.MAX_VALUE) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 16] >>> 15 | (in[inPos + 17] & 0x3FFF) << 17) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 17] >>> 14 | (in[inPos + 18] & 0x1FFF) << 18) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 18] >>> 13 | (in[inPos + 19] & 0xFFF) << 19) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 19] >>> 12 | (in[inPos + 20] & 0x7FF) << 20) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 20] >>> 11 | (in[inPos + 21] & 0x3FF) << 21) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 21] >>> 10 | (in[inPos + 22] & 0x1FF) << 22) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 22] >>> 9 | (in[inPos + 23] & 0xFF) << 23) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 23] >>> 8 | (in[inPos + 24] & 0x7F) << 24) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 24] >>> 7 | (in[inPos + 25] & 0x3F) << 25) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 25] >>> 6 | (in[inPos + 26] & 0x1F) << 26) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 26] >>> 5 | (in[inPos + 27] & 0xF) << 27) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 27] >>> 4 | (in[inPos + 28] & 7) << 28) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 28] >>> 3 | (in[inPos + 29] & 3) << 29) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 29] >>> 2 | (in[inPos + 30] & 1) << 30) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 30] >>> 1) + out[outPos + 30];
    }
}

