/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a-\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\n\b\u0000\u0010\u0016\u0018\u0001*\u00020\u0017*\u00020\u0004H\u0086\b\u0082\u0002\n\n\b\b\u0002\u001a\u0004\u0010\u0000(\u0000\u00a2\u0006\u0002\u0010\u0019\u001a\u001e\u0010\u001a\u001a\u0002H\u0016\"\n\b\u0000\u0010\u0016\u0018\u0001*\u00020\u0017*\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0019\u001a\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c*\b\u0012\u0004\u0012\u00020\n0\u001c\u001a\u001c\u0010\u001d\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0002\u001a\u0010\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"*\u00020#\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005\"\u0015\u0010\u0007\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\"\u0015\u0010\b\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0005\"\u0015\u0010\t\u001a\u00020\u0003*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0015\u0010\f\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005\"\u0015\u0010\r\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005\"\u0015\u0010\u000e\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0005\"\u0015\u0010\u000f\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00f2\u0001\u0004\n\u00020\u0018\u00a8\u0006$"}, d2={"EXTENSION_FUNCTION_ANNOTATION", "", "isAny", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Z", "isArrayType", "isBoolean", "isEnum", "isExtensionFunctionAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)Z", "isNothing", "isNullableAny", "isNullableNothing", "isUnit", "parametersCount", "", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "getParametersCount", "(Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;)I", "coneTypeSafe", "T", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "coneTypeUnsafe", "dropExtensionFunctionAnnotation", "", "isBuiltinType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "isNullable", "toConstKind", "Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "tree"})
public final class FirTypeUtilsKt {
    @NotNull
    public static final String EXTENSION_FUNCTION_ANNOTATION = "kotlin/ExtensionFunctionType";

    @NotNull
    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeUnsafe(@NotNull FirTypeRef $this$coneTypeUnsafe) {
        int $i$f$coneTypeUnsafe = 0;
        Intrinsics.checkNotNullParameter((Object)$this$coneTypeUnsafe, (String)"$this$coneTypeUnsafe");
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe).getType();
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)coneKotlinType;
    }

    @Nullable
    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeSafe(@NotNull FirTypeRef $this$coneTypeSafe) {
        int $i$f$coneTypeSafe = 0;
        Intrinsics.checkNotNullParameter((Object)$this$coneTypeSafe, (String)"$this$coneTypeSafe");
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)coneKotlinType;
    }

    public static final boolean isAny(@NotNull FirTypeRef $this$isAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isAny, (String)"$this$isAny");
        return FirTypeUtilsKt.isBuiltinType($this$isAny, StandardClassIds.INSTANCE.getAny(), false);
    }

    public static final boolean isNullableAny(@NotNull FirTypeRef $this$isNullableAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableAny, (String)"$this$isNullableAny");
        return FirTypeUtilsKt.isBuiltinType($this$isNullableAny, StandardClassIds.INSTANCE.getAny(), true);
    }

    public static final boolean isNothing(@NotNull FirTypeRef $this$isNothing) {
        Intrinsics.checkNotNullParameter((Object)$this$isNothing, (String)"$this$isNothing");
        return FirTypeUtilsKt.isBuiltinType($this$isNothing, StandardClassIds.INSTANCE.getNothing(), false);
    }

    public static final boolean isNullableNothing(@NotNull FirTypeRef $this$isNullableNothing) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableNothing, (String)"$this$isNullableNothing");
        return FirTypeUtilsKt.isBuiltinType($this$isNullableNothing, StandardClassIds.INSTANCE.getNothing(), true);
    }

    public static final boolean isUnit(@NotNull FirTypeRef $this$isUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnit, (String)"$this$isUnit");
        return FirTypeUtilsKt.isBuiltinType($this$isUnit, StandardClassIds.INSTANCE.getUnit(), false);
    }

    public static final boolean isBoolean(@NotNull FirTypeRef $this$isBoolean) {
        Intrinsics.checkNotNullParameter((Object)$this$isBoolean, (String)"$this$isBoolean");
        return FirTypeUtilsKt.isBuiltinType($this$isBoolean, StandardClassIds.INSTANCE.getBoolean(), false);
    }

    public static final boolean isEnum(@NotNull FirTypeRef $this$isEnum) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnum, (String)"$this$isEnum");
        return FirTypeUtilsKt.isBuiltinType($this$isEnum, StandardClassIds.INSTANCE.getEnum(), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isArrayType(@NotNull FirTypeRef $this$isArrayType) {
        ClassId it;
        Intrinsics.checkNotNullParameter((Object)$this$isArrayType, (String)"$this$isArrayType");
        if (FirTypeUtilsKt.isBuiltinType($this$isArrayType, StandardClassIds.INSTANCE.getArray(), false)) return true;
        Iterable $this$any$iv = StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ClassId)element$iv;
            boolean bl = false;
        } while (!FirTypeUtilsKt.isBuiltinType($this$isArrayType, it, false));
        return true;
    }

    private static final boolean isBuiltinType(FirTypeRef $this$isBuiltinType, ClassId classId, boolean isNullable2) {
        ConeClassLikeType coneClassLikeType;
        FirTypeRef firTypeRef = $this$isBuiltinType;
        if (firTypeRef instanceof FirImplicitBuiltinTypeRef) {
            coneClassLikeType = ((FirImplicitBuiltinTypeRef)$this$isBuiltinType).getType();
        } else if (firTypeRef instanceof FirResolvedTypeRef) {
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$isBuiltinType).getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((coneClassLikeType = (ConeClassLikeType)coneKotlinType) == null) {
                return false;
            }
        } else {
            return false;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        return Intrinsics.areEqual((Object)type2.getLookupTag().getClassId(), (Object)classId) && ConeTypeUtilsKt.isNullable(type2) == isNullable2;
    }

    public static final int getParametersCount(@NotNull FirFunctionTypeRef $this$parametersCount) {
        Intrinsics.checkNotNullParameter((Object)$this$parametersCount, (String)"$this$parametersCount");
        return $this$parametersCount.getReceiverTypeRef() != null ? $this$parametersCount.getValueParameters().size() + 1 : $this$parametersCount.getValueParameters().size();
    }

    public static final boolean isExtensionFunctionAnnotationCall(@NotNull FirAnnotationCall $this$isExtensionFunctionAnnotationCall) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isExtensionFunctionAnnotationCall, (String)"$this$isExtensionFunctionAnnotationCall");
        FirAnnotationCall firAnnotationCall = $this$isExtensionFunctionAnnotationCall;
        if (firAnnotationCall != null) {
            FirAnnotationCall firAnnotationCall2 = firAnnotationCall;
            boolean bl2 = false;
            boolean bl3 = false;
            FirAnnotationCall it = firAnnotationCall2;
            boolean bl4 = false;
            FirTypeRef firTypeRef = it.getAnnotationTypeRef();
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
            if (firResolvedTypeRef != null) {
                FirResolvedTypeRef firResolvedTypeRef2 = firResolvedTypeRef;
                boolean bl5 = false;
                boolean bl6 = false;
                FirResolvedTypeRef it2 = firResolvedTypeRef2;
                boolean bl7 = false;
                ConeKotlinType coneKotlinType = it2.getType();
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
                if (coneClassLikeType != null) {
                    ConeClassLikeType coneClassLikeType2 = coneClassLikeType;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    ConeClassLikeType it3 = coneClassLikeType2;
                    boolean bl10 = false;
                    bl = Intrinsics.areEqual((Object)it3.getLookupTag().getClassId().asString(), (Object)EXTENSION_FUNCTION_ANNOTATION);
                } else {
                    bl = null;
                }
            } else {
                bl = null;
            }
        } else {
            bl = null;
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnnotationCall> dropExtensionFunctionAnnotation(@NotNull List<? extends FirAnnotationCall> $this$dropExtensionFunctionAnnotation) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$dropExtensionFunctionAnnotation, (String)"$this$dropExtensionFunctionAnnotation");
        Iterable $this$filterNot$iv = $this$dropExtensionFunctionAnnotation;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
            boolean bl = false;
            if (FirTypeUtilsKt.isExtensionFunctionAnnotationCall(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final FirConstKind<?> toConstKind(@NotNull ConeClassLikeType $this$toConstKind) {
        Intrinsics.checkNotNullParameter((Object)$this$toConstKind, (String)"$this$toConstKind");
        ClassId classId = $this$toConstKind.getLookupTag().getClassId();
        return Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getByte()) ? (FirConstKind)FirConstKind.Byte.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getShort()) ? (FirConstKind)FirConstKind.Short.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getInt()) ? (FirConstKind)FirConstKind.Int.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getLong()) ? (FirConstKind)FirConstKind.Long.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getUInt()) ? (FirConstKind)FirConstKind.UnsignedInt.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getULong()) ? (FirConstKind)FirConstKind.UnsignedLong.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getUShort()) ? (FirConstKind)FirConstKind.UnsignedShort.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getUByte()) ? (FirConstKind)FirConstKind.UnsignedByte.INSTANCE : null)))))));
    }
}

