/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

final class Utf8 {
    public static final int COMPLETE = 0;
    public static final int MALFORMED = -1;

    private Utf8() {
    }

    public static boolean isValidUtf8(byte[] bytes2) {
        return Utf8.isValidUtf8(bytes2, 0, bytes2.length);
    }

    public static boolean isValidUtf8(byte[] bytes2, int index2, int limit) {
        return Utf8.partialIsValidUtf8(bytes2, index2, limit) == 0;
    }

    public static int partialIsValidUtf8(int state, byte[] bytes2, int index2, int limit) {
        if (state != 0) {
            if (index2 >= limit) {
                return state;
            }
            byte byte1 = (byte)state;
            if (byte1 < -32) {
                if (byte1 < -62 || bytes2[index2++] > -65) {
                    return -1;
                }
            } else if (byte1 < -16) {
                byte byte2 = (byte)(~(state >> 8));
                if (byte2 == 0) {
                    byte2 = bytes2[index2++];
                    if (index2 >= limit) {
                        return Utf8.incompleteStateFor(byte1, byte2);
                    }
                }
                if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || bytes2[index2++] > -65) {
                    return -1;
                }
            } else {
                byte byte2 = (byte)(~(state >> 8));
                byte byte3 = 0;
                if (byte2 == 0) {
                    byte2 = bytes2[index2++];
                    if (index2 >= limit) {
                        return Utf8.incompleteStateFor(byte1, byte2);
                    }
                } else {
                    byte3 = (byte)(state >> 16);
                }
                if (byte3 == 0) {
                    byte3 = bytes2[index2++];
                    if (index2 >= limit) {
                        return Utf8.incompleteStateFor(byte1, (int)byte2, (int)byte3);
                    }
                }
                if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || bytes2[index2++] > -65) {
                    return -1;
                }
            }
        }
        return Utf8.partialIsValidUtf8(bytes2, index2, limit);
    }

    public static int partialIsValidUtf8(byte[] bytes2, int index2, int limit) {
        while (index2 < limit && bytes2[index2] >= 0) {
            ++index2;
        }
        return index2 >= limit ? 0 : Utf8.partialIsValidUtf8NonAscii(bytes2, index2, limit);
    }

    private static int partialIsValidUtf8NonAscii(byte[] bytes2, int index2, int limit) {
        while (true) {
            byte byte2;
            byte byte1;
            if (index2 >= limit) {
                return 0;
            }
            if ((byte1 = bytes2[index2++]) >= 0) continue;
            if (byte1 < -32) {
                if (index2 >= limit) {
                    return byte1;
                }
                if (byte1 >= -62 && bytes2[index2++] <= -65) continue;
                return -1;
            }
            if (byte1 < -16) {
                if (index2 >= limit - 1) {
                    return Utf8.incompleteStateFor(bytes2, index2, limit);
                }
                if (!((byte2 = bytes2[index2++]) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && bytes2[index2++] <= -65) continue;
                return -1;
            }
            if (index2 >= limit - 2) {
                return Utf8.incompleteStateFor(bytes2, index2, limit);
            }
            if ((byte2 = bytes2[index2++]) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || bytes2[index2++] > -65 || bytes2[index2++] > -65) break;
        }
        return -1;
    }

    private static int incompleteStateFor(int byte1) {
        return byte1 > -12 ? -1 : byte1;
    }

    private static int incompleteStateFor(int byte1, int byte2) {
        return byte1 > -12 || byte2 > -65 ? -1 : byte1 ^ byte2 << 8;
    }

    private static int incompleteStateFor(int byte1, int byte2, int byte3) {
        return byte1 > -12 || byte2 > -65 || byte3 > -65 ? -1 : byte1 ^ byte2 << 8 ^ byte3 << 16;
    }

    private static int incompleteStateFor(byte[] bytes2, int index2, int limit) {
        byte byte1 = bytes2[index2 - 1];
        switch (limit - index2) {
            case 0: {
                return Utf8.incompleteStateFor(byte1);
            }
            case 1: {
                return Utf8.incompleteStateFor(byte1, bytes2[index2]);
            }
            case 2: {
                return Utf8.incompleteStateFor(byte1, (int)bytes2[index2], (int)bytes2[index2 + 1]);
            }
        }
        throw new AssertionError();
    }
}

