/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.typesApproximation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.types.typesApproximation.ApproximationBounds;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt$WhenMappings;
import org.jetbrains.kotlin.types.typesApproximation.TypeArgument;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\r\u001a\u00020\u0002*\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\n*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0005*\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"approximateCapturedTypes", "Lorg/jetbrains/kotlin/types/typesApproximation/ApproximationBounds;", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "approximateCapturedTypesIfNecessary", "Lorg/jetbrains/kotlin/types/TypeProjection;", "typeProjection", "approximateContravariant", "", "approximateProjection", "Lorg/jetbrains/kotlin/types/typesApproximation/TypeArgument;", "typeArgument", "substituteCapturedTypesWithProjections", "replaceTypeArguments", "newTypeArguments", "", "toTypeArgument", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "toTypeProjection", "descriptors"})
public final class CapturedTypeApproximationKt {
    private static final TypeProjection toTypeProjection(TypeArgument $this$toTypeProjection) {
        boolean bl = $this$toTypeProjection.isConsistent();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            DescriptorRenderer descriptorRenderer2 = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)toTypeProjection.1.descriptorRenderer.1.INSTANCE));
            String string2 = "Only consistent enhanced type projection can be converted to type projection, but " + '[' + descriptorRenderer2.render($this$toTypeProjection.getTypeParameter()) + ": <" + descriptorRenderer2.renderType($this$toTypeProjection.getInProjection()) + ", " + descriptorRenderer2.renderType($this$toTypeProjection.getOutProjection()) + ">]" + " was found";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Function1<Variance, Variance> $fun$removeProjectionIfRedundant$2 = new Function1<Variance, Variance>($this$toTypeProjection){
            final /* synthetic */ TypeArgument $this_toTypeProjection;

            @NotNull
            public final Variance invoke(@NotNull Variance variance) {
                Intrinsics.checkNotNullParameter((Object)((Object)variance), (String)"variance");
                return variance == this.$this_toTypeProjection.getTypeParameter().getVariance() ? Variance.INVARIANT : variance;
            }
            {
                this.$this_toTypeProjection = typeArgument;
                super(1);
            }
        };
        return Intrinsics.areEqual((Object)$this$toTypeProjection.getInProjection(), (Object)$this$toTypeProjection.getOutProjection()) ? new TypeProjectionImpl($this$toTypeProjection.getInProjection()) : (KotlinBuiltIns.isNothing($this$toTypeProjection.getInProjection()) && $this$toTypeProjection.getTypeParameter().getVariance() != Variance.IN_VARIANCE ? new TypeProjectionImpl($fun$removeProjectionIfRedundant$2.invoke(Variance.OUT_VARIANCE), $this$toTypeProjection.getOutProjection()) : (KotlinBuiltIns.isNullableAny($this$toTypeProjection.getOutProjection()) ? new TypeProjectionImpl($fun$removeProjectionIfRedundant$2.invoke(Variance.IN_VARIANCE), $this$toTypeProjection.getInProjection()) : new TypeProjectionImpl($fun$removeProjectionIfRedundant$2.invoke(Variance.OUT_VARIANCE), $this$toTypeProjection.getOutProjection())));
    }

    private static final TypeArgument toTypeArgument(TypeProjection $this$toTypeArgument, TypeParameterDescriptor typeParameter) {
        TypeArgument typeArgument;
        switch (CapturedTypeApproximationKt$WhenMappings.$EnumSwitchMapping$0[TypeSubstitutor.combine(typeParameter.getVariance(), $this$toTypeArgument).ordinal()]) {
            case 1: {
                KotlinType kotlinType = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
                KotlinType kotlinType2 = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"type");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType2);
                break;
            }
            case 2: {
                KotlinType kotlinType = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
                SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns(typeParameter).getNullableAnyType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"typeParameter.builtIns.nullableAnyType");
                typeArgument = new TypeArgument(typeParameter, kotlinType, simpleType2);
                break;
            }
            case 3: {
                SimpleType simpleType3 = DescriptorUtilsKt.getBuiltIns(typeParameter).getNothingType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"typeParameter.builtIns.nothingType");
                KotlinType kotlinType = simpleType3;
                KotlinType kotlinType3 = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"type");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeArgument;
    }

    @Nullable
    public static final TypeProjection approximateCapturedTypesIfNecessary(@Nullable TypeProjection typeProjection, boolean approximateContravariant) {
        if (typeProjection == null) {
            return null;
        }
        if (typeProjection.isStarProjection()) {
            return typeProjection;
        }
        KotlinType kotlinType = typeProjection.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"typeProjection.type");
        KotlinType type2 = kotlinType;
        if (!TypeUtils.contains(type2, (Function1<UnwrappedType, Boolean>)((Function1)approximateCapturedTypesIfNecessary.1.INSTANCE))) {
            return typeProjection;
        }
        Variance variance = typeProjection.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"typeProjection.projectionKind");
        Variance howThisTypeIsUsed = variance;
        if (howThisTypeIsUsed == Variance.OUT_VARIANCE) {
            ApproximationBounds<KotlinType> approximation = CapturedTypeApproximationKt.approximateCapturedTypes(type2);
            return new TypeProjectionImpl(howThisTypeIsUsed, approximation.getUpper());
        }
        if (approximateContravariant) {
            KotlinType approximation = CapturedTypeApproximationKt.approximateCapturedTypes(type2).getLower();
            return new TypeProjectionImpl(howThisTypeIsUsed, approximation);
        }
        return CapturedTypeApproximationKt.substituteCapturedTypesWithProjections(typeProjection);
    }

    private static final TypeProjection substituteCapturedTypesWithProjections(TypeProjection typeProjection) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(){

            @Nullable
            public TypeProjection get(@NotNull TypeConstructor key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                TypeConstructor typeConstructor2 = key;
                if (!(typeConstructor2 instanceof CapturedTypeConstructor)) {
                    typeConstructor2 = null;
                }
                CapturedTypeConstructor capturedTypeConstructor = (CapturedTypeConstructor)typeConstructor2;
                if (capturedTypeConstructor == null) {
                    return null;
                }
                CapturedTypeConstructor capturedTypeConstructor2 = capturedTypeConstructor;
                if (capturedTypeConstructor2.getProjection().isStarProjection()) {
                    return new TypeProjectionImpl(Variance.OUT_VARIANCE, capturedTypeConstructor2.getProjection().getType());
                }
                return capturedTypeConstructor2.getProjection();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"TypeSubstitutor.create(o\u2026ojection\n        }\n    })");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        return typeSubstitutor3.substituteWithoutApproximation(typeProjection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApproximationBounds<KotlinType> approximateCapturedTypes(@NotNull KotlinType type2) {
        KotlinType kotlinType;
        boolean lowerBoundIsTrivial;
        ArrayList<TypeArgument> upperBoundArguments;
        ArrayList<Object> lowerBoundArguments;
        block15: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            if (FlexibleTypesKt.isFlexible(type2)) {
                ApproximationBounds<KotlinType> boundsForFlexibleLower = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.lowerIfFlexible(type2));
                ApproximationBounds<KotlinType> boundsForFlexibleUpper = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.upperIfFlexible(type2));
                return new ApproximationBounds<KotlinType>(TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(boundsForFlexibleLower.getLower()), FlexibleTypesKt.upperIfFlexible(boundsForFlexibleUpper.getLower())), type2), TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(boundsForFlexibleLower.getUpper()), FlexibleTypesKt.upperIfFlexible(boundsForFlexibleUpper.getUpper())), type2));
            }
            TypeConstructor typeConstructor2 = type2.getConstructor();
            if (CapturedTypeConstructorKt.isCaptured(type2)) {
                ApproximationBounds<KotlinType> approximationBounds;
                TypeConstructor typeConstructor3 = typeConstructor2;
                if (typeConstructor3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor");
                }
                TypeProjection typeProjection = ((CapturedTypeConstructor)typeConstructor3).getProjection();
                Function1<KotlinType, KotlinType> $fun$makeNullableIfNeeded$1 = new Function1<KotlinType, KotlinType>(type2){
                    final /* synthetic */ KotlinType $type;

                    @NotNull
                    public final KotlinType invoke(@NotNull KotlinType $this$makeNullableIfNeeded) {
                        Intrinsics.checkNotNullParameter((Object)$this$makeNullableIfNeeded, (String)"$this$makeNullableIfNeeded");
                        KotlinType kotlinType = TypeUtils.makeNullableIfNeeded($this$makeNullableIfNeeded, this.$type.isMarkedNullable());
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"TypeUtils.makeNullableIf\u2026s, type.isMarkedNullable)");
                        return kotlinType;
                    }
                    {
                        this.$type = kotlinType;
                        super(1);
                    }
                };
                KotlinType kotlinType2 = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"typeProjection.type");
                KotlinType bound = $fun$makeNullableIfNeeded$1.invoke(kotlinType2);
                switch (CapturedTypeApproximationKt$WhenMappings.$EnumSwitchMapping$1[typeProjection.getProjectionKind().ordinal()]) {
                    case 1: {
                        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(type2).getNullableAnyType();
                        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"type.builtIns.nullableAnyType");
                        approximationBounds = new ApproximationBounds<KotlinType>(bound, simpleType2);
                        break;
                    }
                    case 2: {
                        SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(type2).getNothingType();
                        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"type.builtIns.nothingType");
                        approximationBounds = new ApproximationBounds<KotlinType>($fun$makeNullableIfNeeded$1.invoke((KotlinType)simpleType3), bound);
                        break;
                    }
                    default: {
                        throw (Throwable)((Object)new AssertionError((Object)("Only nontrivial projections should have been captured, not: " + typeProjection)));
                    }
                }
                return approximationBounds;
            }
            if (type2.getArguments().isEmpty() || type2.getArguments().size() != typeConstructor2.getParameters().size()) {
                return new ApproximationBounds<KotlinType>(type2, type2);
            }
            lowerBoundArguments = new ArrayList<Object>();
            upperBoundArguments = new ArrayList<TypeArgument>();
            Iterable iterable = type2.getArguments();
            List<TypeParameterDescriptor> list2 = typeConstructor2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"typeConstructor.parameters");
            for (Pair bound : CollectionsKt.zip((Iterable)iterable, (Iterable)list2)) {
                void lower2;
                void typeProjection;
                TypeParameterDescriptor typeParameter;
                TypeProjection typeProjection2 = (TypeProjection)bound.component1();
                TypeParameterDescriptor typeParameterDescriptor = typeParameter = (TypeParameterDescriptor)bound.component2();
                Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"typeParameter");
                TypeArgument typeArgument = CapturedTypeApproximationKt.toTypeArgument((TypeProjection)typeProjection, typeParameterDescriptor);
                if (typeProjection.isStarProjection()) {
                    lowerBoundArguments.add(typeArgument);
                    upperBoundArguments.add(typeArgument);
                    continue;
                }
                ApproximationBounds<TypeArgument> approximationBounds = CapturedTypeApproximationKt.approximateProjection(typeArgument);
                TypeArgument typeArgument2 = approximationBounds.component1();
                TypeArgument upper = approximationBounds.component2();
                lowerBoundArguments.add(lower2);
                upperBoundArguments.add(upper);
            }
            Iterable $this$any$iv = lowerBoundArguments;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeArgument it = (TypeArgument)element$iv;
                    boolean bl2 = false;
                    if (!(!it.isConsistent())) continue;
                    bl = true;
                    break block15;
                }
                bl = lowerBoundIsTrivial = false;
            }
        }
        if (lowerBoundIsTrivial) {
            SimpleType simpleType4 = TypeUtilsKt.getBuiltIns(type2).getNothingType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType4, (String)"type.builtIns.nothingType");
            kotlinType = simpleType4;
        } else {
            kotlinType = CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<TypeArgument>)lowerBoundArguments);
        }
        return new ApproximationBounds<KotlinType>(kotlinType, CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<TypeArgument>)upperBoundArguments));
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinType replaceTypeArguments(KotlinType $this$replaceTypeArguments, List<TypeArgument> newTypeArguments) {
        Collection<TypeProjection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl = $this$replaceTypeArguments.getArguments().size() == newTypeArguments.size();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22 = false;
            String $i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22 = "Incorrect type arguments " + newTypeArguments;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22));
        }
        Iterable iterable = newTypeArguments;
        KotlinType kotlinType = $this$replaceTypeArguments;
        boolean $i$f$map = false;
        void $i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeArgument typeArgument = (TypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            TypeProjection typeProjection = CapturedTypeApproximationKt.toTypeProjection((TypeArgument)it);
            collection.add(typeProjection);
        }
        collection = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default(kotlinType, (List)collection, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final ApproximationBounds<TypeArgument> approximateProjection(TypeArgument typeArgument) {
        void inLower;
        void outLower;
        Object object = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getInProjection());
        KotlinType kotlinType = ((ApproximationBounds)object).component1();
        KotlinType inUpper = ((ApproximationBounds)object).component2();
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getOutProjection());
        object = approximationBounds.component1();
        KotlinType outUpper = approximationBounds.component2();
        return new ApproximationBounds<TypeArgument>(new TypeArgument(typeArgument.getTypeParameter(), inUpper, (KotlinType)outLower), new TypeArgument(typeArgument.getTypeParameter(), (KotlinType)inLower, outUpper));
    }
}

