/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.flags.Flag;
import com.android.flags.FlagGroup;
import com.android.flags.FlagOverrides;
import com.android.flags.Flags;
import com.android.flags.ImmutableFlagOverrides;
import com.android.flags.overrides.DefaultFlagOverrides;
import com.android.flags.overrides.PropertyOverrides;
import com.android.tools.idea.flags.StudioFlagSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;

public final class StudioFlags {
    private static final Flags FLAGS = StudioFlags.createFlags();
    private static final FlagGroup NPW = new FlagGroup(FLAGS, "npw", "New Project Wizard");
    public static final Flag<Boolean> NPW_DUMP_TEMPLATE_VARS = Flag.create((FlagGroup)NPW, (String)"dump.template.vars", (String)"Dump template variables to a scratch file", (String)"Dump the variables used in creating a template to a scrach file that is opened after creating the project.", (boolean)false);
    public static final Flag<Boolean> NPW_FIRST_RUN_WIZARD = Flag.create((FlagGroup)NPW, (String)"first.run.wizard", (String)"Show new Welcome Wizard", (String)"Show new version of the Welcome Wizard when Studio starts", (boolean)false);
    public static final Flag<Boolean> NPW_FIRST_RUN_SHOW = Flag.create((FlagGroup)NPW, (String)"first.run.wizard.show", (String)"Show Welcome Wizard always", (String)"Show the Welcome Wizard when Studio starts", (boolean)false);
    public static final Flag<Boolean> NPW_SHOW_JDK_STEP = Flag.create((FlagGroup)NPW, (String)"first.run.jdk.step", (String)"Show JDK setup step", (String)"Show JDK Setup Step in Welcome Wizard", (boolean)true);
    public static final Flag<Boolean> NPW_NEW_MODULE_TEMPLATES = Flag.create((FlagGroup)NPW, (String)"new.module.templates", (String)"Use new module templates", (String)"Use the new Kotlin-based template system for module templates over the old Freemarker system when it is available.", (boolean)true);
    public static final Flag<Boolean> NPW_NEW_ACTIVITY_TEMPLATES = Flag.create((FlagGroup)NPW, (String)"new.activity.templates", (String)"Use new activity templates", (String)"Use the new Kotlin-based template system for activity templates over the old Freemarker system when it is available .", (boolean)true);
    public static final Flag<Boolean> NPW_SHOW_FRAGMENT_GALLERY = Flag.create((FlagGroup)NPW, (String)"show.fragment.gallery", (String)"Show fragment gallery", (String)"Show fragment gallery which contains fragment based templates", (boolean)true);
    private static final FlagGroup PROFILER = new FlagGroup(FLAGS, "profiler", "Android Profiler");
    public static final Flag<Boolean> PROFILER_CPU_CAPTURE_STAGE = Flag.create((FlagGroup)PROFILER, (String)"cpu.capture.stage", (String)"Enable new capture stage", (String)"With the new System Trace design we have a cpu capture stage. This flag uses that flow instead of the legacy CpuProfilerStageView flow.", (boolean)true);
    public static final Flag<Boolean> PROFILER_UNIFIED_PIPELINE = Flag.create((FlagGroup)PROFILER, (String)"unified.pipeline", (String)"Enables new event pipeline to be used for core components.", (String)"Toggles usage of gRPC apis to fetch data from perfd and the datastore.", (boolean)true);
    public static final Flag<Boolean> PROFILER_ENERGY_PROFILER_ENABLED = Flag.create((FlagGroup)PROFILER, (String)"energy", (String)"Enable Energy profiling", (String)"Enable the new energy profiler. It monitors battery usage of the selected app.", (boolean)true);
    public static final Flag<Boolean> PROFILER_STARTUP_CPU_PROFILING = Flag.create((FlagGroup)PROFILER, (String)"startup.cpu.profiling", (String)"Enable startup CPU Profiling", (String)"Record a method trace on startup by enabling it in the Profiler tab of Run/Debug configuration.", (boolean)true);
    public static final Flag<Boolean> PROFILER_CPU_API_TRACING = Flag.create((FlagGroup)PROFILER, (String)"cpu.api.tracing", (String)"Enable CPU API Tracing", (String)"Support method tracing through APIs from android.os.Debug.", (boolean)true);
    public static final Flag<Boolean> PROFILER_USE_LIVE_ALLOCATIONS = Flag.create((FlagGroup)PROFILER, (String)"livealloc", (String)"Enable JVMTI-based live allocation tracking", (String)"For Android O or newer, allocations are tracked all the time while inside the Memory Profiler.", (boolean)true);
    public static final Flag<Boolean> PROFILER_MEMORY_SNAPSHOT = Flag.create((FlagGroup)PROFILER, (String)"memory.livealloc.snapshot", (String)"Enable Memory Class Histogram Display", (String)"For Android O or newer, supports single-point selection which shows a snapshot of the heap at the specific time.", (boolean)true);
    public static final Flag<Boolean> PROFILER_SAMPLE_LIVE_ALLOCATIONS = Flag.create((FlagGroup)PROFILER, (String)"memory.livealloc.sampled", (String)"Enable Sampled Live Allocation Tracking", (String)"For Android O or newer, allows users to configure the sampling mode of live allocation tracking", (boolean)true);
    public static final Flag<Boolean> PROFILER_USE_PERFETTO = Flag.create((FlagGroup)PROFILER, (String)"perfetto", (String)"Allows importing and recording of perfetto traces.", (String)"Toggles if we check for perfetto traces when importing. This also sets a flag on the agent config to toggle perfettobased recording on device.", (boolean)true);
    public static final Flag<Boolean> PROFILER_TRACK_JNI_REFS = Flag.create((FlagGroup)PROFILER, (String)"jni", (String)"Enable JVMTI-based JNI reference tracking.", (String)"For Android O or newer, JNI references are tracked in Memory Profiler and shown in JNI heap.", (boolean)true);
    public static final Flag<Boolean> PROFILER_PERFORMANCE_MONITORING = Flag.create((FlagGroup)PROFILER, (String)"performance.monitoring", (String)"Enable Profiler Performance Monitoring Options", (String)"Toggles if profiler performance metrics options are enabled.", (boolean)false);
    public static final Flag<Boolean> PROFILER_CPU_NEW_RECORDING_WORKFLOW = Flag.create((FlagGroup)PROFILER, (String)"cpu.new.recording.workflow", (String)"Enable new CPU recording workflow", (String)"Shows recording options and status of the ongoing recording in the method trace pane.", (boolean)true);
    public static final Flag<Boolean> PROFILER_AUDITS = Flag.create((FlagGroup)PROFILER, (String)"audits", (String)"Enable profiler audits", (String)"When enabled, profiler workflows such as capturing CPU atrace captures will generate audits", (boolean)false);
    public static final Flag<Boolean> PROFILER_CUSTOM_EVENT_VISUALIZATION = Flag.create((FlagGroup)PROFILER, (String)"custom.event.visualization", (String)"Enable Profiler Custom Event Visualization", (String)"When enabled, profiler will track and display events defined through developer APIs", (boolean)false);
    private static final FlagGroup MLKIT = new FlagGroup(FLAGS, "mlkit", "ML Kit");
    public static final Flag<Boolean> MLKIT_TFLITE_MODEL_FILE_TYPE = Flag.create((FlagGroup)MLKIT, (String)"modelfiletype", (String)"Enable TFLite model file type", (String)"When enabled, TFLite model file can be recognized as a particular type and has its own viewer.", (boolean)false);
    public static final Flag<Boolean> MLKIT_LIGHT_CLASSES = Flag.create((FlagGroup)MLKIT, (String)"lightclasses", (String)"Enable light model classes generation", (String)"When enabled, light model classes will be generated for each recognized TFLite model file.", (boolean)false);
    private static final FlagGroup NELE = new FlagGroup(FLAGS, "nele", "Layout Editor");
    public static final Flag<Boolean> NELE_ANIMATIONS_PREVIEW = Flag.create((FlagGroup)NELE, (String)"animated.preview", (String)"Show preview animations toolbar", (String)"Show an animations bar that allows playback of vector drawable animations.", (boolean)false);
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_ANIMATIONS = Flag.create((FlagGroup)NELE, (String)"animated.motion.layout", (String)"Show preview animations toolbar for MotionLayout", (String)"Show an animations bar that allows playback of MotionLayout animations.", (boolean)false);
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_EDITOR = Flag.create((FlagGroup)NELE, (String)"animated.motion.editor", (String)"Show motion editor for MotionLayout", (String)"Show the motion editor UI for MotionLayout.", (boolean)true);
    public static final Flag<Boolean> NELE_CONSTRAINT_SELECTOR = Flag.create((FlagGroup)NELE, (String)"constraint.selection", (String)"Allow selection of Constraints", (String)"Allow the selection of constraints.", (boolean)true);
    public static final Flag<Boolean> NELE_MOTION_HORIZONTAL = Flag.create((FlagGroup)NELE, (String)"animated.motion.horizontal", (String)"Display motion editor horizontally", (String)"Controls the placement of the motion editor (horizontal versus vertical).", (boolean)false);
    public static final Flag<Boolean> NELE_MOCKUP_EDITOR = Flag.create((FlagGroup)NELE, (String)"mockup.editor", (String)"Enable the Mockup Editor", (String)"Enable the Mockup Editor to ease the creation of Layouts from a design file.", (boolean)false);
    public static final Flag<Boolean> NELE_DEFAULT_LIVE_RENDER = Flag.create((FlagGroup)NELE, (String)"live.render", (String)"Enable the Live Render by default", (String)"Enable the continuous rendering of the surface when moving/resizing components unless the user disables it.", (boolean)true);
    public static final Flag<Boolean> NELE_CONVERT_VIEW = Flag.create((FlagGroup)NELE, (String)"convert.view", (String)"Enable the Convert View action", (String)"Enable the Convert View Action when right clicking on a component", (boolean)true);
    public static final Flag<Boolean> NELE_RENDER_DIAGNOSTICS = Flag.create((FlagGroup)NELE, (String)"diagnostics", (String)"Enable rendering on-screen stats", (String)"If enabled, the surface displays some debug information to diagnose performance", (boolean)false);
    public static final Flag<Boolean> NELE_SPLIT_EDITOR = Flag.create((FlagGroup)NELE, (String)"split.layout.editor", (String)"Enable design editors and XML side-by-side view.", (String)"Enable this flag to display the design editors side-by-side with their text representation.", (boolean)true);
    public static final Flag<Boolean> NELE_RESOURCE_POPUP_PICKER = Flag.create((FlagGroup)NELE, (String)"show.resource.popup.picker", (String)"Enable popup  resource picker in layout editor.", (String)"Show the popup picker for resource picking or attribute customization in layout editor.", (boolean)true);
    public static final Flag<Boolean> NELE_LOG_ANDROID_FRAMEWORK = Flag.create((FlagGroup)NELE, (String)"log.android.framework", (String)"Log messages coming from Layoutlib Native.", (String)"Log in the IDEA log the messages coming from Java and native code of Layoutlib Native.", (boolean)false);
    private static final FlagGroup ASSISTANT = new FlagGroup(FLAGS, "assistant", "Assistants");
    public static final Flag<Boolean> CONNECTION_ASSISTANT_ENABLED = Flag.create((FlagGroup)ASSISTANT, (String)"connection.enabled", (String)"Enable the connection assistant", (String)"If enabled, user can access the Connection Assistant under \"Tools\" and \"Deploy Target Dialog\"", (boolean)true);
    public static final Flag<Boolean> NELE_CONSTRAINT_LAYOUT_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.constraintlayout", (String)"Display Help for Constraint Layout", (String)"If enabled, the assistant panel will display helpful guide on using Constraint Layout.", (boolean)true);
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.motionlayout", (String)"Display Help for Motion Layout", (String)"If enabled, the assistant panel will display helpful guide on using Motion Layout.", (boolean)true);
    public static final Flag<Boolean> NELE_NAV_EDITOR_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.naveditor", (String)"Display Help for Navigation Editor", (String)"If enabled, the assistant panel will display helpful guide on using the Navigation Editor.", (boolean)false);
    public static final Flag<Boolean> NELE_NEW_PROPERTY_PANEL = Flag.create((FlagGroup)NELE, (String)"new.property", (String)"Enable the new Property Panel", (String)"Enable the new Property Panel", (boolean)true);
    public static final Flag<Boolean> NELE_DRAG_PLACEHOLDER = Flag.create((FlagGroup)NELE, (String)"drag.placeholder", (String)"Dragging widgets with Placeholders", (String)"New architecture for dragging widgets in Layout Editor", (boolean)true);
    public static final Flag<Boolean> NELE_RENDER_HIGH_QUALITY_SHADOW = Flag.create((FlagGroup)NELE, (String)"high.quality.shadow", (String)"Enable the high quality shadows", (String)"Enable the high quality shadow rendering in Layout Editor", (boolean)true);
    public static final Flag<Boolean> NELE_ENABLE_SHADOW = Flag.create((FlagGroup)NELE, (String)"enable.shadow", (String)"Enable shadows", (String)"Enable the shadow rendering in Layout Editor", (boolean)true);
    public static final Flag<Boolean> NELE_PROPERTY_PANEL_ACTIONBAR = Flag.create((FlagGroup)NELE, (String)"property.panel.actionbar", (String)"Property Panel Actionbar", (String)"Support Actionbar in property panel", (boolean)false);
    public static final Flag<Boolean> NELE_DESIGN_SURFACE_ZOOM = Flag.create((FlagGroup)NELE, (String)"design.surface.zoom", (String)"Zoom panel in Design Surface", (String)"Enable zoom controls in the design surface, substitutes any zoom controls on the top toolbar of the editor.", (boolean)true);
    public static final Flag<Boolean> NELE_VISUALIZATION = Flag.create((FlagGroup)NELE, (String)"visualisation", (String)"Layout Visualisation Tool", (String)"Enable Visualisation Tool to preview layout in multiple devices at the same time", (boolean)true);
    public static final Flag<Boolean> NELE_COLOR_BLIND_MODE = Flag.create((FlagGroup)NELE, (String)"color.blind.mode", (String)"Color Blind Mode", (String)"Enable Visualisation Tool to preview layouts in multiple color blind modes at the same time", (boolean)true);
    public static final Flag<Boolean> NELE_LARGE_FONT_MODE = Flag.create((FlagGroup)NELE, (String)"large.font.mode", (String)"Large Font Mode", (String)"Enable Visualisation Tool to preview layouts in multiple font sizes at the same time", (boolean)true);
    public static final Flag<Boolean> NELE_NEW_INTERACTION_INTERFACE = Flag.create((FlagGroup)NELE, (String)"new.interaction.interface", (String)"New Interaction Interface", (String)"Enable new interaction interface in design surface.", (boolean)true);
    public static final Flag<Boolean> NELE_SOURCE_CODE_EDITOR = Flag.create((FlagGroup)NELE, (String)"show.source.code.editor", (String)"New Source Code Editor", (String)"Enable new source code editor with preview(s) coming as a substitute to Compose and Custom View editors.", (boolean)false);
    public static final Flag<Boolean> NELE_TOGGLE_TOOLS_ATTRIBUTES_IN_PREVIEW = Flag.create((FlagGroup)NELE, (String)"toggle.tools.attributes.preview", (String)"New Toggle for Tools namespaces attributes", (String)"Enable the new toggle in the Layout Editor. Allows toggling tools attributes in the Layout preview.", (boolean)false);
    private static final FlagGroup NAV_EDITOR = new FlagGroup(FLAGS, "nav", "Navigation Editor");
    public static final Flag<Boolean> NAV_NEW_PROPERTY_PANEL = Flag.create((FlagGroup)NAV_EDITOR, (String)"new.property", (String)"Enable the new Property Panel", (String)"Enable the new Property Panel", (boolean)true);
    public static final Flag<Boolean> NAV_NEW_COMPONENT_TREE = Flag.create((FlagGroup)NAV_EDITOR, (String)"new.component", (String)"Enable the new Component Tree", (String)"Enable the new Component Tree", (boolean)false);
    public static final Flag<Boolean> NAV_DYNAMIC_SUPPORT = Flag.create((FlagGroup)NAV_EDITOR, (String)"dynamic.support", (String)"Support for Dynamic Feature Modules", (String)"Support for Dynamic Feature Modules", (boolean)true);
    private static final FlagGroup RES_MANAGER = new FlagGroup(FLAGS, "res.manager", "Resource Manager");
    public static final Flag<Boolean> EXTENDED_TYPE_FILTERS = Flag.create((FlagGroup)RES_MANAGER, (String)"extended.filters", (String)"Enable extended filters for resources", (String)"Adds more filter options for resources based on the selected ResourceType. Includes options to filter by resource XML tag or File extension.", (boolean)true);
    private static final FlagGroup RUNDEBUG = new FlagGroup(FLAGS, "rundebug", "Run/Debug");
    public static final Flag<Boolean> RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"logcat.console.output.enabled", (String)"Show logcat process output in Run/Debug console window", (String)"When running or debugging an Android process, output the logcat output of the process in the console window.", (boolean)true);
    public static final Flag<Boolean> RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"android.bundle.build.enabled", (String)"Enable the Build Bundle action", (String)"If enabled, the \"Build Bundle(s)\" menu item is enabled. Changing the value of this flag requires restarting Android Studio.", (boolean)true);
    public static final Flag<Boolean> DELTA_INSTALL = Flag.create((FlagGroup)RUNDEBUG, (String)"deltainstall", (String)"Delta install", (String)"Upon installing, if application is already on device, only send parts of the apks which have changed (the delta).", (boolean)true);
    public static final Flag<Boolean> SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"select.device.snapshot.combo.box.snapshots.enabled", (String)"Enable Select Device/Snapshot combo box snapshots", (String)"So the new Instant Run can use the combo box", (boolean)false);
    public static final Flag<DefaultActivityLocatorStrategy> DEFAULT_ACTIVITY_LOCATOR_STRATEGY = Flag.create((FlagGroup)RUNDEBUG, (String)"default.activity.locator.strategy", (String)"Choose a strategy for selecting the default activity to launch from the merged manifest.", (String)"This can be \"BLOCK\" to unconditionally block on a fresh merged manifest, \"STALE\" to use a potentially stale manifest, or \"INDEX\" to use the custom Android Manifest index (only select this option if manifest indexing is enabled).", (Enum)DefaultActivityLocatorStrategy.INDEX);
    public static final Flag<Boolean> SUPPORT_FEATURE_ON_FEATURE_DEPS = Flag.create((FlagGroup)RUNDEBUG, (String)"feature.on.feature", (String)"Enable feature-on-feature dependencies", (String)"Enables Studio to understand feature-on-feature dependencies when launching dynamic apps.", (boolean)false);
    private static final FlagGroup GRADLE_IDE = new FlagGroup(FLAGS, "gradle.ide", "Gradle Project System");
    public static final Flag<Boolean> FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.run.configuration.fix.enabled", (String)"Check Android Run Configurations contains the \"Gradle-aware Make\" task and fix them", (String)"When a project is loaded, automatically add a \"Gradle-aware Make\" task to each Run Configuration if the task is missing", (boolean)true);
    public static final Flag<Boolean> NEW_PSD_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"new.psd", (String)"Enable new \"Project Structure\" dialog", (String)"Turns on the new \"Project Structure\" dialog.", (boolean)true);
    public static final Flag<Boolean> SINGLE_VARIANT_SYNC_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"single.variant.sync", (String)"Enable new \"Single-Variant Sync\"", (String)"Turns on Single-Variant Sync.", (boolean)false);
    public static final Flag<Boolean> USE_DEVELOPMENT_OFFLINE_REPOS = Flag.create((FlagGroup)GRADLE_IDE, (String)"development.offline.repos", (String)"Enable development offline repositories", (String)"Makes Gradle use development offline repositories such as /out/repo", (boolean)StudioFlags.isDevBuild());
    public static final Flag<Boolean> BUILD_ATTRIBUTION_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.attribution", (String)"Enable build attribution", (String)"Enable build attribution.", (boolean)true);
    public static final Flag<Boolean> KOTLIN_DSL_PARSING = Flag.create((FlagGroup)GRADLE_IDE, (String)"kotlin.dsl", (String)"Enable parsing for Kotlin build files", (String)"Enables parsing for Gradle build files written using Kotlin (.gradle.kts)", (boolean)true);
    public static final Flag<Boolean> DISABLE_FORCED_UPGRADES = Flag.create((FlagGroup)GRADLE_IDE, (String)"forced.agp.update", (String)"Disable forced Android Gradle plugin upgrades", (String)"This option is only respected when running Android Studio internally.", (boolean)false);
    public static final Flag<Boolean> L4_DEPENDENCY_MODEL = Flag.create((FlagGroup)GRADLE_IDE, (String)"level4.dependency.model", (String)"Use L4 DependencyGraph Model", (String)"Use level4 DependencyGraph model.", (boolean)false);
    public static final Flag<Boolean> ALLOW_DIFFERENT_JDK_VERSION = Flag.create((FlagGroup)GRADLE_IDE, (String)"jdk.allow.different", (String)"Allow different Gradle JDK", (String)"Allow usage of a different JDK version when running Gradle.", (boolean)true);
    private static final FlagGroup DATABASE_INSPECTOR = new FlagGroup(FLAGS, "database.inspector", "Database Inspector");
    public static final Flag<Boolean> DATABASE_INSPECTOR_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"enabled", (String)"Enable Database Inspector", (String)"If enabled the Database Inspector tool window will appear. SQLite files opened from the Device Explorer will be opened in the inspector.", (boolean)false);
    public static final Flag<Boolean> SQLITE_APP_INSPECTOR_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"sqlite.app.inspector", (String)"Enable experimental SQLite inspector", (String)"SQLite inspector runs and executes all operations in app process", (boolean)false);
    private static final FlagGroup LAYOUT_INSPECTOR = new FlagGroup(FLAGS, "layout.inspector", "Layout Inspector");
    public static final Flag<Boolean> LAYOUT_INSPECTOR_LOAD_OVERLAY_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"load.overlay", (String)"Enable the Load Overlay feature", (String)"If enabled, show actions to let user choose overlay image on preview.", (boolean)true);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_SUB_VIEW_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"sub.view", (String)"Enable the sub view feature", (String)"If enabled, changes the preview to focus on a component.", (boolean)true);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_V2_PROTOCOL_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"capture.v2", (String)"Enable using V2 protocol to capture view data", (String)"If enabled, uses V2 protocol to capture view information from device.", (boolean)false);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_EDITING_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"ui.editing", (String)"Enable editing ViewNode properties in the properties table.", (String)"If enabled, users can edit properties in the properties table.", (boolean)false);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector", (String)"Enable dynamic layout inspector", (String)"Turns on the dynamic layout inspector.", (boolean)true);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_EDITING_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.editor", (String)"Enable dynamic layout editor", (String)"If enabled, users can edit layout properties with live updates on a device while the dynamic layout inspector is running.", (boolean)false);
    private static final FlagGroup REFACTORINGS = new FlagGroup(FLAGS, "refactor", "Refactor menu");
    public static final Flag<Boolean> MIGRATE_TO_RESOURCE_NAMESPACES_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.resourcenamespaces.enabled", (String)"Enable the Migrate to Resource Namespaces refactoring", (String)"If enabled, show the action in the refactoring menu", (boolean)false);
    private static final FlagGroup IOT = new FlagGroup(FLAGS, "iot", "IoT features");
    public static final Flag<Boolean> UNINSTALL_LAUNCHER_APPS_ENABLED = Flag.create((FlagGroup)IOT, (String)"iot.uninstalllauncherapps.enabled", (String)"Enable the Uninstall of IoT launcher apps feature", (String)"If enabled, uninstall IoT launcher apps when installing a new one", (boolean)false);
    private static final FlagGroup NDK = new FlagGroup(FLAGS, "ndk", "Native code features");
    public static final Flag<Boolean> CMAKE_ENABLE_FEATURES_FROM_CLION = Flag.create((FlagGroup)NDK, (String)"cmakeclionfeatures", (String)"Enable CMake language support from CLion", (String)"If enabled, language support features (e.g. syntax highlighting) currently present in CLion will be turned on.", (boolean)true);
    public static final Flag<Boolean> LLDB_ASSEMBLY_DEBUGGING = Flag.create((FlagGroup)NDK, (String)"debugging.assembly", (String)"Enable assembly debugging", (String)"If enabled, frames without sources will show the assembly of the function and allow breakpoints to be set there", (boolean)false);
    public static final Flag<Boolean> ENABLE_ENHANCED_NATIVE_HEADER_SUPPORT = Flag.create((FlagGroup)NDK, (String)"enhancednativeheadersupport", (String)"Enable enhanced native header support", (String)"If enabled, project system view will show a new include node with organized header files", (boolean)true);
    public static final Flag<Boolean> ENABLE_CLANG_TIDY_INSPECTIONS = Flag.create((FlagGroup)NDK, (String)"clangtidyinspections", (String)"Enable clang-tidy inspections", (String)"If enabled, show inspections derived from clang-tidy.", (boolean)true);
    public static final Flag<Boolean> APK_DEBUG_BUILD_ID_CHECK = Flag.create((FlagGroup)NDK, (String)"apkdebugbuildidcheck", (String)"Enable build ID check in APK debugging", (String)"If enabled, the build ID of user-provided symbol files are compared against the binaries inside the APK.", (boolean)true);
    public static final Flag<Boolean> APK_DEBUG_RELOAD = Flag.create((FlagGroup)NDK, (String)"apkdebugreload", (String)"Enable APK reloading feature", (String)"If enabled, the user will be provided with an option to reload the APK inside an APK debugging project", (boolean)true);
    private static final FlagGroup NDK_SIDE_BY_SIDE = new FlagGroup(FLAGS, "ndk.sxs", "NDK Side by Side");
    public static final Flag<Boolean> NDK_SIDE_BY_SIDE_ENABLED = Flag.create((FlagGroup)NDK_SIDE_BY_SIDE, (String)"ndk.sxs.enabled", (String)"Enable side by side NDK support", (String)"If enabled, C/C++ projects will have NDK side by side support", (boolean)true);
    private static final FlagGroup EDITOR = new FlagGroup(FLAGS, "editor", "Editor features");
    public static final Flag<Boolean> COLLAPSE_ANDROID_NAMESPACE = Flag.create((FlagGroup)EDITOR, (String)"collapse.android.namespace", (String)"Collapse the android namespace in XML code completion", (String)"If enabled, XML code completion doesn't include resources from the android namespace. Instead a fake completion item is used to offer just the namespace prefix.", (boolean)true);
    public static final Flag<Boolean> RESOLVE_USING_REPOS = Flag.create((FlagGroup)EDITOR, (String)"resolve.using.repos", (String)"Resolve references using resource repositories", (String)"Use ResourceRepository to resolve references, not ResourceManager.", (boolean)false);
    public static final Flag<Boolean> RUN_DOM_EXTENDER = Flag.create((FlagGroup)EDITOR, (String)"run.dom.extender", (String)"Run DOM extender", (String)"When disabled AndroidDomExtender does nothing, simulating a situation where DOM extensions have not been computed yet.", (boolean)true);
    public static final Flag<Boolean> MULTI_DEX_KEEP_FILE_SUPPORT_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"multidexkeepfile.support.enabled", (String)"Enable support for MultiDexKeepFile format", (String)"If enabled, it offers support (such as code completion) for the MultiDexKeepFile format.", (boolean)false);
    public static final Flag<Boolean> ADVANCED_JNI_ASSISTANCE = Flag.create((FlagGroup)EDITOR, (String)"advanced.jni.assistance", (String)"Enable advanced JNI assistance", (String)"If enabled, additional inspection, completion, and refactoring supports are provided related to JNI. If disabled, some inspections related to JNI may stop working.", (boolean)true);
    public static final Flag<Boolean> CUSTOM_JAVA_NEW_CLASS_DIALOG = Flag.create((FlagGroup)EDITOR, (String)"custom.new.class.dialog", (String)"Enable custom New Class dialog", (String)"If enabled, our custom UI for creating a new Java class is used. Otherwise the platform default is used.", (boolean)false);
    public static final Flag<Boolean> INCREMENTAL_RESOURCE_REPOSITORIES = Flag.create((FlagGroup)EDITOR, (String)"incremental.resource.repositories", (String)"Handle PSI events incrementally in ResourceFolderRepository", (String)"If enabled, ResourceFolderRepository will handle PSI events synchronously, rather than rescanning the whole file.", (boolean)true);
    public static final Flag<Boolean> R8_SUPPORT_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"r8.support.enabled", (String)"Enable support for R8 in editor", (String)"If enabled, it offers support (such as code completion) for the R8 format.", (boolean)true);
    public static final Flag<Boolean> TWEAK_COLOR_SCHEME = Flag.create((FlagGroup)EDITOR, (String)"tweak.color.scheme", (String)"Change the default color scheme", (String)"If enabled, we modify the default color scheme slightly.", (boolean)true);
    private static final FlagGroup ANALYZER = new FlagGroup(FLAGS, "analyzer", "Apk/Bundle Analyzer");
    public static final Flag<Boolean> ENABLE_APP_SIZE_OPTIMIZER = Flag.create((FlagGroup)ANALYZER, (String)"enable.app.size.optimizer", (String)"Enable size optimization suggestions in apk analyzer", (String)"If enabled, it will enable the apk analyzer tool to display suggestions for reducing application size", (boolean)false);
    private static final FlagGroup UAB = new FlagGroup(FLAGS, "uab", "Unified App Bundle");
    public static final Flag<Boolean> UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS = Flag.create((FlagGroup)UAB, (String)"enable.ia.run.configs", (String)"Enable new instant app run configuration options", (String)"If enabled, shows the new instant app deploy checkbox in the run configuration dialog and allows new instant app deploy workflow.", (boolean)true);
    private static final FlagGroup PROJECT_UPGRADE = new FlagGroup(FLAGS, "project.upgrade", "Project Upgrade");
    private static final FlagGroup TESTING = new FlagGroup(FLAGS, "testing", "Testing support");
    public static final Flag<Boolean> PRINT_INSTRUMENTATION_STATUS = Flag.create((FlagGroup)TESTING, (String)"print.instrumentation.status", (String)"Print instrumentation status information when testing", (String)"If enabled, instrumentation output keys (from calling Instrumentation#sendStatus) that begin with 'android.studio.display.' will have their values printed after a test has finished running.", (boolean)true);
    public static final Flag<Boolean> KOTLIN_INCORRECT_SCOPE_CHECK_IN_TESTS = Flag.create((FlagGroup)TESTING, (String)"kotlin.incorrect.scope.check", (String)"Checks the scope of classes being used in kotlin test files", (String)"If enabled, an inspection will run that shows an error when a class is used in a kotlin test file that is not is scope.", (boolean)false);
    public static final Flag<Boolean> NITROGEN = Flag.create((FlagGroup)TESTING, (String)"nitrogen", (String)"Enables Nitrogen test runner features", (String)"If enabled, Nitrogen test runner configuration becomes available in addition to traditional test runner configurations.", (boolean)false);
    public static final Flag<Boolean> MULTIDEVICE_INSTRUMENTATION_TESTS = Flag.create((FlagGroup)TESTING, (String)"multidevice.instrumentation.tests", (String)"Allow running instrumentation tests on multiple devices at a time.", (String)"If enabled, you can choose run-on-selected-devices for android instrumentation test run configurations.", (boolean)false);
    private static final FlagGroup TRANSLATIONS_EDITOR = new FlagGroup(FLAGS, "translations.editor", "Translations Editor");
    public static final Flag<Boolean> TRANSLATIONS_EDITOR_USE_LOGICAL_FONT = Flag.create((FlagGroup)TRANSLATIONS_EDITOR, (String)"translations.editor.use.logical.font", (String)"Use a logical font", (String)"Use a logical font to display translations. See https://docs.oracle.com/javase/tutorial/2d/text/fonts.html#logical-fonts", (boolean)true);
    private static final FlagGroup MEMORY_SETTINGS = new FlagGroup(FLAGS, "memory.settings", "Memory Settings");
    public static final Flag<Boolean> LOW_IDE_XMX_CAP = Flag.create((FlagGroup)MEMORY_SETTINGS, (String)"low.ide.xmx.cap", (String)"Set low IDE Xmx cap in memory settings", (String)"If set, IDE Xmx is capped at 4GB in the configuration dialog. Otherwise, the cap is 8GB", (boolean)true);
    private static final FlagGroup SYSTEM_HEALTH = new FlagGroup(FLAGS, "system.health", "System Health");
    public static final Flag<Boolean> WINDOWS_UCRT_CHECK_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"windows.ucrt.check.enabled", (String)"Enable Universal C Runtime system health check", (String)"If enabled, a notification will be shown if the Universal C Runtime in Windows is not installed", (boolean)false);
    public static final Flag<Boolean> ANTIVIRUS_NOTIFICATION_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.notification.enabled", (String)"Enable antivirus system health check", (String)"If enabled, a notification will be shown if antivirus realtime scanning is enabled and directories relevant to build performance aren't excluded", (boolean)true);
    public static final Flag<Boolean> ANTIVIRUS_METRICS_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.metrics.enabled", (String)"Enable antivirus metrics collection", (String)"If enabled, metrics about the status of antivirus realtime scanning and excluded directories will be collected", (boolean)true);
    public static final Flag<Boolean> ANTIVIRUS_CHECK_USE_REGISTRY = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.check.registry", (String)"Use registry instead of PowerShell for checking antivirus status", (String)"If enabled, the antivirus status checker will use the Windows registry instead of PowerShell commands", (boolean)true);
    private static final FlagGroup COMPOSE = new FlagGroup(FLAGS, "compose", "Compose");
    public static final Flag<Boolean> COMPOSE_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.enabled", (String)"Enable the Compose preview", (String)"If enabled, a visual preview will be available for Compose.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_PREVIEW_ONLY_KOTLIN_BUILD = Flag.create((FlagGroup)COMPOSE, (String)"preview.fast.build.enabled", (String)"Enable the use of \"compileDebugKotlin\" for the preview refresh", (String)"If enabled, the refresh button will only trigger the \"compileDebugKotlin\" task as opposed to others like\"generateDebugSources\" or \"compileJava\".", (boolean)true);
    public static final Flag<Boolean> COMPOSE_PREVIEW_AUTO_BUILD = Flag.create((FlagGroup)COMPOSE, (String)"preview.auto.build.enabled", (String)"Enable the compose auto-build", (String)"If enabled, the preview will automatically trigger a build after the user finishes typing.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_EDITOR_SUPPORT = Flag.create((FlagGroup)COMPOSE, (String)"editor", (String)"Compose-specific support in the code editor", (String)"Controls whether Compose-specific editor features, like completion tweaks, are enabled. This flag has priority over all flags in the `compose.editor.*` namespace.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_COMPLETION_PRESENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.presentation", (String)"Custom presentation for code completion items for composable functions", (String)"If enabled, code completion items for composable functions use a custom presentation (icon, text).", (boolean)false);
    public static final Flag<Boolean> COMPOSE_COMPLETION_WEIGHER = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.weigher", (String)"Custom weigher for Compose", (String)"If enabled, code completion puts composable functions above other completion suggestions.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_COMPLETION_INSERT_HANDLER = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.insert.handler", (String)"Custom insert handler for composable functions", (String)"If enabled, code completion for composable functions uses a custom InsertHandler that inserts required parameter names.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_AUTO_DOCUMENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.auto.documentation", (String)"Show quick documentation automatically for Compose", (String)"If enabled, during code completion popup with documentation shows automatically", (boolean)false);
    public static final Flag<Boolean> COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.render.sample", (String)"Render samples of compose elements inside documentation", (String)"If enabled, adds rendered image of sample for compose element if such exists", (boolean)false);
    public static final Flag<Boolean> COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION_SLOW = Flag.create((FlagGroup)COMPOSE, (String)"editor.render.sample.slow", (String)"Slow down rendering of samples of compose elements inside documentation", (String)"If enabled, slow down rendering of samples of compose elements inside documentation, this flag is used for demonstration of non-blocking behavior", (boolean)false);
    public static final Flag<Boolean> COMPOSE_SURROUND_WITH_WIDGET = Flag.create((FlagGroup)COMPOSE, (String)"editor.surround.with.widget.action", (String)"Enables \"Surround with widget\" intention and template", (String)"Enables \"Surround with widget\" intention inside composable functions and adds \"Surround with widget\" live template", (boolean)false);
    public static final Flag<Boolean> COMPOSE_WIZARD_TEMPLATES = Flag.create((FlagGroup)COMPOSE, (String)"wizard.templates", (String)"Show Compose Wizards", (String)"If enabled, allows adding new Compose Projects/Modules/Activities through the wizards", (boolean)false);
    private static final FlagGroup MANIFESTS = new FlagGroup(FLAGS, "manifests", "Android Manifests");
    public static final Flag<Boolean> ANDROID_MANIFEST_INDEX_ENABLED = Flag.create((FlagGroup)MANIFESTS, (String)"index.enabled", (String)"Enable Android Manifest Indexing", (String)"Enables a custom index for pre-parsing your project's AndroidManifest.xml files", (boolean)true);
    private static final FlagGroup APP_INSPECTION = new FlagGroup(FLAGS, "appinspection", "App Inspection");
    public static final Flag<Boolean> ENABLE_APP_INSPECTION_TOOL_WINDOW = Flag.create((FlagGroup)APP_INSPECTION, (String)"enable.tool.window", (String)"Enable App Inspection Tool Window", (String)"Enables the top-level App Inspection tool window, which will contain tabs to various feature inspectors", (boolean)false);

    @NotNull
    private static Flags createFlags() {
        Application app = ApplicationManager.getApplication();
        Object userOverrides = app != null && !app.isUnitTestMode() ? StudioFlagSettings.getInstance() : new DefaultFlagOverrides();
        return new Flags((FlagOverrides)userOverrides, new ImmutableFlagOverrides[]{new PropertyOverrides()});
    }

    private static boolean isDevBuild() {
        if (ApplicationManager.getApplication() == null) {
            return true;
        }
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        return applicationInfo == null || applicationInfo.getStrictVersion().equals("0.0.0.0");
    }

    private StudioFlags() {
    }

    public static enum DefaultActivityLocatorStrategy {
        BLOCK,
        INDEX,
        STALE;

    }
}

