/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io;

import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.android.tools.idea.io.BufferingFolderWrapper;
import com.google.common.base.MoreObjects;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BufferingFileWrapper
implements IAbstractFile {
    private final File myFile;

    public BufferingFileWrapper(@NotNull File file) {
        if (file == null) {
            BufferingFileWrapper.$$$reportNull$$$0(0);
        }
        this.myFile = file;
    }

    public InputStream getContents() throws StreamException {
        try {
            byte[] content = this.readFile();
            return new ByteArrayInputStream(content);
        }
        catch (IOException e) {
            throw new StreamException((Exception)e, (IAbstractFile)this);
        }
    }

    private byte[] readFile() throws IOException {
        try (DataInputStream is = new DataInputStream(new FileInputStream(this.myFile));){
            byte[] data = new byte[(int)this.myFile.length()];
            is.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            BufferingFileWrapper.$$$reportNull$$$0(1);
        }
        return file;
    }

    public void setContents(InputStream source) {
        throw new UnsupportedOperationException();
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }

    public IAbstractFile.PreferredWriteMode getPreferredWriteMode() {
        throw new UnsupportedOperationException();
    }

    public long getModificationStamp() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.myFile.getName();
    }

    public String getOsLocation() {
        return this.myFile.getAbsolutePath();
    }

    public String getPath() {
        return this.myFile.getPath();
    }

    public boolean exists() {
        return this.myFile.isFile();
    }

    @Nullable
    public IAbstractFolder getParentFolder() {
        File parentFile = this.myFile.getParentFile();
        return parentFile != null ? new BufferingFolderWrapper(parentFile) : null;
    }

    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferingFileWrapper wrapper = (BufferingFileWrapper)o;
        return FileUtil.filesEqual((File)this.myFile, (File)wrapper.myFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myFile);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("file", (Object)this.myFile).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/io/BufferingFileWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/io/BufferingFileWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

