/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.chart.hchart.DefaultHRenderer;
import com.android.tools.adtui.chart.hchart.Method;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JavaMethodHRenderer
extends DefaultHRenderer<Method> {
    private static final Pattern dotPattern = Pattern.compile("\\.");

    protected boolean isMethodPlatform(@NotNull Method method) {
        if (method == null) {
            JavaMethodHRenderer.$$$reportNull$$$0(0);
        }
        return method.getNameSpace().startsWith("android.");
    }

    protected boolean isMethodVendor(@NotNull Method method) {
        if (method == null) {
            JavaMethodHRenderer.$$$reportNull$$$0(1);
        }
        return method.getNameSpace().startsWith("java.") || method.getNameSpace().startsWith("sun.") || method.getNameSpace().startsWith("javax.") || method.getNameSpace().startsWith("apple.") || method.getNameSpace().startsWith("com.apple.");
    }

    @Override
    protected Color getFillColor(@NotNull Method m) {
        if (m == null) {
            JavaMethodHRenderer.$$$reportNull$$$0(2);
        }
        if (this.isMethodVendor(m)) {
            return fillVendorColor;
        }
        if (this.isMethodPlatform(m)) {
            return fillPlatformColor;
        }
        return fillAppColor;
    }

    @Override
    protected String generateFittingText(@NotNull Method m, @NotNull Rectangle2D rect, @NotNull FontMetrics fontMetrics) {
        String fullyQualified;
        if (m == null) {
            JavaMethodHRenderer.$$$reportNull$$$0(3);
        }
        if (rect == null) {
            JavaMethodHRenderer.$$$reportNull$$$0(4);
        }
        if (fontMetrics == null) {
            JavaMethodHRenderer.$$$reportNull$$$0(5);
        }
        if ((double)fontMetrics.stringWidth(fullyQualified = m.getNameSpace() + "." + m.getName()) < rect.getWidth()) {
            return fullyQualified;
        }
        String abbrevPackage = this.getShortPackageName(m.getNameSpace()) + "." + m.getName();
        if ((double)fontMetrics.stringWidth(abbrevPackage) < rect.getWidth()) {
            return abbrevPackage;
        }
        if ((double)fontMetrics.stringWidth(m.getName()) < rect.getWidth()) {
            return m.getName();
        }
        return "";
    }

    protected String getShortPackageName(String nameSpace) {
        if (nameSpace == null || nameSpace.equals("")) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        String[] elements = dotPattern.split(nameSpace);
        String separator = "";
        for (int i = 0; i < elements.length; ++i) {
            b.append(separator);
            b.append(elements[i].charAt(0));
            separator = ".";
        }
        return b.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/chart/hchart/JavaMethodHRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodPlatform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodVendor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFillColor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "generateFittingText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

