/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class DefaultDataSeries<E>
implements DataSeries<E> {
    @NotNull
    protected final List<SeriesData<E>> mSeriesList = new ArrayList<SeriesData<E>>();

    @NotNull
    private List<SeriesData<E>> getDataSubList(int fromIndex, int toIndex) {
        List<SeriesData<E>> list = IntStream.range(fromIndex, toIndex).mapToObj(index -> this.mSeriesList.get(index)).collect(Collectors.toList());
        if (list == null) {
            DefaultDataSeries.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public List<SeriesData<E>> getDataForRange(Range range) {
        if (this.size() == 0 || range.isEmpty()) {
            return this.getDataSubList(0, 0);
        }
        int fromIndex = this.getNearestXIndex((long)range.getMin());
        int toIndex = this.getNearestXIndex((long)range.getMax()) + 1;
        return this.getDataSubList(fromIndex, toIndex);
    }

    public List<SeriesData<E>> getAllData() {
        return this.getDataSubList(0, this.size());
    }

    public void add(long x, E y) {
        this.mSeriesList.add(new SeriesData<E>(x, y));
    }

    public int size() {
        return this.mSeriesList.size();
    }

    public long getX(int index) {
        return this.mSeriesList.get((int)index).x;
    }

    public E getY(int index) {
        return (E)this.mSeriesList.get((int)index).value;
    }

    public int getNearestXIndex(long x) {
        int index = Collections.binarySearch(this.mSeriesList.stream().map(data -> data.x).collect(Collectors.toList()), x);
        if (index < 0) {
            index = -index - 2;
        }
        return Math.max(0, Math.min(index, this.size() - 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/model/DefaultDataSeries", "getDataSubList"));
    }
}

