/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.trackgroup;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public final class Track {
    private static final int DEFAULT_TITLE_COL_PX = 150;
    public static final String COL_SIZES = "150px,*";
    private static final int SELECTION_BORDER_PX = 2;
    private static final Icon COLLAPSE_ICON = AllIcons.General.ArrowRight;
    private static final Icon EXPAND_ICON = AllIcons.General.ArrowDown;
    private static final Border TITLE_BORDER_DEFAULT = JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)0, (int)0, (int)1), (Border)JBUI.Borders.empty((int)2, (int)2, (int)2, (int)0), (boolean)false);
    private static final Border TITLE_BORDER_SELECTED = JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)0, (int)0, (int)1), (Border)JBUI.Borders.customLine((Color)StudioColorsKt.getSelectionBackground(), (int)2, (int)2, (int)2, (int)0), (boolean)false);
    private static final Border CONTENT_BORDER_DEFAULT = JBUI.Borders.customLine((Color)StudioColorsKt.getPrimaryContentBackground(), (int)2, (int)0, (int)2, (int)0);
    private static final Border CONTENT_BORDER_SELECTED = JBUI.Borders.customLine((Color)StudioColorsKt.getSelectionBackground(), (int)2, (int)0, (int)2, (int)0);
    @NotNull
    private final JPanel myComponent;
    @NotNull
    private final JPanel myTitleBackPanel;
    @NotNull
    private final JPanel myTitleFrontPanel;
    @NotNull
    private final JLabel myTitleLabel;
    @NotNull
    private final JComponent myTrackContent;

    private Track(final @NotNull TrackModel trackModel, @NotNull JComponent trackContent) {
        if (trackModel == null) {
            Track.$$$reportNull$$$0(0);
        }
        if (trackContent == null) {
            Track.$$$reportNull$$$0(1);
        }
        this.myTrackContent = trackContent;
        this.myTitleLabel = new JLabel(trackModel.getTitle());
        this.myTitleLabel.setVerticalAlignment(1);
        this.myTitleLabel.setToolTipText(trackModel.getTitleTooltip());
        if (trackModel.isCollapsible()) {
            this.myTitleLabel.setIcon(trackModel.isCollapsed() ? COLLAPSE_ICON : EXPAND_ICON);
            this.myTitleLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Track.this.myTitleLabel.contains(e.getPoint()) && e.getClickCount() == 2) {
                        trackModel.setCollapsed(!trackModel.isCollapsed());
                        Track.this.myTitleLabel.setIcon(trackModel.isCollapsed() ? COLLAPSE_ICON : EXPAND_ICON);
                    }
                }
            });
        }
        int iconOffset = this.myTitleLabel.getIcon() == null ? 0 : this.myTitleLabel.getIcon().getIconWidth() + this.myTitleLabel.getIconTextGap();
        this.myTitleLabel.setBorder((Border)JBUI.Borders.empty((int)4, (int)(34 - iconOffset), (int)4, (int)0));
        this.myTitleFrontPanel = new JPanel(new BorderLayout());
        this.myTitleFrontPanel.add(this.myTitleLabel);
        this.myTitleBackPanel = new JPanel(new BorderLayout());
        this.myTitleBackPanel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        this.myTitleBackPanel.add(this.myTitleFrontPanel);
        this.myComponent = new JPanel(new TabularLayout(COL_SIZES, "Fit"));
        if (trackModel.getHideHeader()) {
            this.myComponent.add((Component)trackContent, new TabularLayout.Constraint(0, 0, 2));
            TrackMouseEventHandler adapter = new TrackMouseEventHandler(trackContent, 0, -2);
            this.myComponent.addMouseListener((MouseListener)((Object)adapter));
            this.myComponent.addMouseMotionListener((MouseMotionListener)((Object)adapter));
        } else {
            this.myComponent.add((Component)this.myTitleBackPanel, new TabularLayout.Constraint(0, 0));
            this.myComponent.add((Component)trackContent, new TabularLayout.Constraint(0, 1));
            TrackMouseEventHandler titleAdapter = new TrackMouseEventHandler(this.myTitleLabel, 0, -2);
            this.myComponent.addMouseListener((MouseListener)((Object)titleAdapter));
            this.myComponent.addMouseMotionListener((MouseMotionListener)((Object)titleAdapter));
            TrackMouseEventHandler adapter = new TrackMouseEventHandler(trackContent, -150, -2);
            this.myComponent.addMouseListener((MouseListener)((Object)adapter));
            this.myComponent.addMouseMotionListener((MouseMotionListener)((Object)adapter));
        }
    }

    @NotNull
    public static <M, R extends Enum> Track create(@NotNull TrackModel<M, R> trackModel, @NotNull TrackRenderer<M, R> trackRenderer) {
        if (trackModel == null) {
            Track.$$$reportNull$$$0(2);
        }
        if (trackRenderer == null) {
            Track.$$$reportNull$$$0(3);
        }
        return new Track(trackModel, trackRenderer.render(trackModel));
    }

    @NotNull
    public Track updateSelected(boolean selected) {
        this.myTitleFrontPanel.setBackground((Color)(selected ? StudioColorsKt.getContentSelectionBackground() : null));
        this.myTitleBackPanel.setBorder(selected ? TITLE_BORDER_SELECTED : TITLE_BORDER_DEFAULT);
        this.myTrackContent.setBorder(selected ? CONTENT_BORDER_SELECTED : CONTENT_BORDER_DEFAULT);
        Track track = this;
        if (track == null) {
            Track.$$$reportNull$$$0(4);
        }
        return track;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            Track.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @VisibleForTesting
    @NotNull
    JLabel getTitleLabel() {
        JLabel jLabel = this.myTitleLabel;
        if (jLabel == null) {
            Track.$$$reportNull$$$0(6);
        }
        return jLabel;
    }

    @VisibleForTesting
    @NotNull
    JPanel getTitleFrontPanel() {
        JPanel jPanel = this.myTitleFrontPanel;
        if (jPanel == null) {
            Track.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackContent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackRenderer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/trackgroup/Track";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/trackgroup/Track";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateSelected";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleLabel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleFrontPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrackMouseEventHandler
    extends MouseEventHandler {
        @NotNull
        private final JComponent myTrackContent;
        private final int myXOffset;
        private final int myYOffset;

        TrackMouseEventHandler(@NotNull JComponent trackContent, int XOffset, int yOffset) {
            if (trackContent == null) {
                TrackMouseEventHandler.$$$reportNull$$$0(0);
            }
            this.myTrackContent = trackContent;
            this.myXOffset = XOffset;
            this.myYOffset = yOffset;
        }

        protected void handle(MouseEvent event) {
            event.translatePoint(this.myXOffset, this.myYOffset);
            this.myTrackContent.dispatchEvent(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackContent", "com/android/tools/adtui/trackgroup/Track$TrackMouseEventHandler", "<init>"));
        }
    }
}

