/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.trackgroup;

import com.android.tools.adtui.DragAndDropList;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.stdui.CommonAction;
import com.android.tools.adtui.model.trackgroup.TrackGroupModel;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.menu.CommonDropDownButton;
import com.android.tools.adtui.trackgroup.Track;
import com.android.tools.adtui.trackgroup.TrackGroupMover;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.adtui.trackgroup.TrackRendererFactory;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackGroup
extends AspectObserver {
    private static final Icon EXPAND_ICON = AllIcons.Actions.FindAndShowNextMatches;
    private static final Icon COLLAPSE_ICON = AllIcons.Actions.FindAndShowPrevMatches;
    private static final Font TITLE_FONT = AdtUiUtils.DEFAULT_FONT.biggerOn(5.0f);
    private static final String TOGGLE_EXPAND_COLLAPSE_TRACK_KEY = "TOGGLE_EXPAND_COLLAPSE_KEY";
    private final TrackGroupModel myModel;
    private final JPanel myComponent;
    private final JLabel myTitleLabel;
    private final JLabel myTitleInfoIcon;
    private final DragAndDropList<TrackModel> myTrackList;
    private final CommonDropDownButton myActionsDropdown;
    private final FlatSeparator mySeparator;
    private final CommonButton myCollapseButton;
    private final Map<Integer, Track> myTrackMap;
    private final AspectObserver myObserver;

    public TrackGroup(final @NotNull TrackGroupModel groupModel, final @NotNull TrackRendererFactory rendererFactory) {
        if (groupModel == null) {
            TrackGroup.$$$reportNull$$$0(0);
        }
        if (rendererFactory == null) {
            TrackGroup.$$$reportNull$$$0(1);
        }
        this.mySeparator = new FlatSeparator();
        this.myObserver = new AspectObserver();
        this.myModel = groupModel;
        this.myTrackMap = new HashMap<Integer, Track>();
        this.myTrackList = new DragAndDropList<TrackModel>(groupModel);
        this.myTrackList.setCellRenderer(new ListCellRenderer<TrackModel>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends TrackModel> list, TrackModel value, int index, boolean isSelected, boolean cellHasFocus) {
                return TrackGroup.this.myTrackMap.computeIfAbsent(value.getId(), id -> {
                    TrackRenderer renderer = rendererFactory.createRenderer(value.getRendererType());
                    value.getAspectModel().addDependency(TrackGroup.this.myObserver).onChange(TrackModel.Aspect.COLLAPSE_CHANGE, () -> TrackGroup.this.myTrackMap.put((Integer)id, Track.create(value, renderer)));
                    return Track.create(value, renderer);
                }).updateSelected(groupModel.isTrackSelectable() && isSelected).getComponent();
            }
        });
        this.myActionsDropdown = new CommonDropDownButton(new CommonAction("", AllIcons.Actions.More));
        this.myActionsDropdown.setToolTipText("More actions");
        this.initShowMoreDropdown();
        this.myCollapseButton = new CommonButton(COLLAPSE_ICON);
        this.myCollapseButton.setHorizontalTextPosition(2);
        this.myCollapseButton.addActionListener(actionEvent -> this.setCollapsed(this.myTrackList.isVisible()));
        this.setCollapsed(groupModel.isCollapsedInitially());
        JPanel toolbarPanel = new JPanel(new GridBagLayout());
        toolbarPanel.setBorder((Border)JBUI.Borders.emptyRight((int)16));
        toolbarPanel.add(this.myActionsDropdown);
        toolbarPanel.add(this.mySeparator);
        toolbarPanel.add(this.myCollapseButton);
        this.myTitleLabel = new JLabel(groupModel.getTitle());
        this.myTitleLabel.setFont(TITLE_FONT);
        this.myTitleLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        this.myTitleInfoIcon = new JLabel(StudioIcons.Common.INFO);
        this.myTitleInfoIcon.setVisible(groupModel.getTitleInfo() != null);
        this.myTitleInfoIcon.setToolTipText(groupModel.getTitleInfo());
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)1, (int)0, (int)1, (int)0));
        if (!groupModel.getHideHeader()) {
            JPanel westTitlePanel = new JPanel();
            westTitlePanel.add(this.myTitleLabel);
            westTitlePanel.add(this.myTitleInfoIcon);
            titlePanel.add((Component)westTitlePanel, "West");
        }
        titlePanel.add((Component)toolbarPanel, "East");
        this.myComponent = new JPanel(new BorderLayout());
        this.myComponent.add((Component)titlePanel, "North");
        this.myComponent.add(this.myTrackList, "Center");
        this.initKeyBindings(this.myTrackList);
    }

    @NotNull
    public TrackGroupModel getModel() {
        TrackGroupModel trackGroupModel = this.myModel;
        if (trackGroupModel == null) {
            TrackGroup.$$$reportNull$$$0(2);
        }
        return trackGroupModel;
    }

    public void setCollapsed(boolean collapsed) {
        if (collapsed) {
            this.myTrackList.setVisible(false);
            this.mySeparator.setVisible(false);
            this.myActionsDropdown.setVisible(false);
            this.myCollapseButton.setText("Expand Section");
            this.myCollapseButton.setIcon(EXPAND_ICON);
        } else {
            this.myTrackList.setVisible(true);
            this.mySeparator.setVisible(false);
            this.myActionsDropdown.setVisible(true);
            this.myCollapseButton.setText(null);
            this.myCollapseButton.setIcon(COLLAPSE_ICON);
        }
    }

    public TrackGroup setMover(@Nullable TrackGroupMover mover) {
        this.initShowMoreDropdown();
        if (mover != null) {
            this.myActionsDropdown.getAction().addChildrenActions(new CommonAction("Move Up", null, () -> mover.moveTrackGroupUp(this)));
            this.myActionsDropdown.getAction().addChildrenActions(new CommonAction("Move Down", null, () -> mover.moveTrackGroupDown(this)));
        }
        return this;
    }

    @NotNull
    public DragAndDropList<TrackModel> getTrackList() {
        DragAndDropList<TrackModel> dragAndDropList = this.myTrackList;
        if (dragAndDropList == null) {
            TrackGroup.$$$reportNull$$$0(3);
        }
        return dragAndDropList;
    }

    public boolean isEmpty() {
        return this.myTrackList.getModel().getSize() == 0;
    }

    public TrackModel getTrackModelAt(int index) {
        return (TrackModel)this.myTrackList.getModel().getElementAt(index);
    }

    @NotNull
    public Map<Integer, Track> getTrackMap() {
        Map<Integer, Track> map = this.myTrackMap;
        if (map == null) {
            TrackGroup.$$$reportNull$$$0(4);
        }
        return map;
    }

    private void initShowMoreDropdown() {
        this.myActionsDropdown.getAction().clear();
    }

    private void initKeyBindings(final @NotNull JList list) {
        if (list == null) {
            TrackGroup.$$$reportNull$$$0(5);
        }
        list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), TOGGLE_EXPAND_COLLAPSE_TRACK_KEY);
        list.getActionMap().put(TOGGLE_EXPAND_COLLAPSE_TRACK_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int selectedIndex : list.getSelectedIndices()) {
                    TrackModel model2 = (TrackModel)TrackGroup.this.myModel.get(selectedIndex);
                    if (!model2.isCollapsible()) continue;
                    model2.setCollapsed(!model2.isCollapsed());
                }
            }
        });
    }

    @VisibleForTesting
    JLabel getTitleLabel() {
        return this.myTitleLabel;
    }

    @VisibleForTesting
    JLabel getTitleInfoIcon() {
        return this.myTitleInfoIcon;
    }

    @VisibleForTesting
    CommonDropDownButton getActionsDropdown() {
        return this.myActionsDropdown;
    }

    @VisibleForTesting
    FlatSeparator getSeparator() {
        return this.mySeparator;
    }

    @VisibleForTesting
    CommonButton getCollapseButton() {
        return this.myCollapseButton;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            TrackGroup.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererFactory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/trackgroup/TrackGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/trackgroup/TrackGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initKeyBindings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

